/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import java.net.URI;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import javax.swing.SwingUtilities;
import pcgen.core.PObject;
import pcgen.gui.SourceLoadProgressDialog;
import pcgen.util.Logging;

public class PersistenceObserver
implements Observer {
    int totalFileCount = 0;
    int currentFileCount = 0;
    SourceLoadProgressDialog dialog = new SourceLoadProgressDialog(null, false);
    private LoadHandler handler = null;

    public PersistenceObserver() {
        this.dialog.pack();
        this.dialog.setVisible(true);
    }

    public void update(Observable observable, Object object) {
        if (object instanceof URI) {
            this.setCurrentFileCount(this.getCurrentFileCount() + 1);
            final URI uRI = (URI)object;
            Runnable runnable = new Runnable(){

                public void run() {
                    PersistenceObserver.this.dialog.setCurrentFile(uRI.toString());
                }
            };
            SwingUtilities.invokeLater(runnable);
        } else if (!(object instanceof PObject)) {
            if (object instanceof Exception) {
                final Exception exception = (Exception)object;
                Runnable runnable = new Runnable(){

                    public void run() {
                        PersistenceObserver.this.dialog.addMessage(exception.getMessage());
                        PersistenceObserver.this.dialog.setErrorState(true);
                    }
                };
                SwingUtilities.invokeLater(runnable);
            } else if (object instanceof Integer) {
                int n = (Integer)object;
                this.setTotalFileCount(n);
            } else if (object instanceof String && object.equals("DONE")) {
                this.setCurrentFileCount(this.getTotalFileCount());
                Runnable runnable = new Runnable(){

                    public void run() {
                        PersistenceObserver.this.dialog.addMessage("All Done");
                        PersistenceObserver.this.end();
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        }
    }

    protected int getTotalFileCount() {
        return this.totalFileCount;
    }

    protected void setTotalFileCount(final int n) {
        this.totalFileCount = n;
        Runnable runnable = new Runnable(){

            public void run() {
                PersistenceObserver.this.dialog.setTotalFileCount(n);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    protected int getCurrentFileCount() {
        return this.currentFileCount;
    }

    protected void setCurrentFileCount(final int n) {
        this.currentFileCount = n;
        Runnable runnable = new Runnable(){

            public void run() {
                PersistenceObserver.this.dialog.setCurrentFileCount(n);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void end() {
        if (!this.dialog.getErrorState()) {
            this.dialog.setVisible(false);
        }
    }

    public LoadHandler getHandler() {
        if (this.handler == null) {
            this.handler = new LoadHandler();
        }
        return this.handler;
    }

    private class LoadHandler
    extends Handler {
        public LoadHandler() {
            this.setLevel(Logging.LST_WARNING);
        }

        public void close() throws SecurityException {
        }

        public void flush() {
        }

        public void publish(final LogRecord logRecord) {
            Runnable runnable = new Runnable(){

                public void run() {
                    PersistenceObserver.this.dialog.addMessage(logRecord.getLevel() + " " + logRecord.getMessage());
                    PersistenceObserver.this.dialog.setErrorState(true);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }
}

