/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import pcgen.core.PObject;
import pcgen.core.SettingsHandler;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.utils.JComboBoxEditor;
import pcgen.gui.utils.JComboBoxRenderer;
import pcgen.gui.utils.TableSorter;
import pcgen.io.PCGFile;
import pcgen.util.Logging;

final class LstConverter
extends JFrame {
    static final long serialVersionUID = 4822388828239441708L;
    private static final String[] typeTypes = new String[]{"UNKNOWN", "RACE", "CLASS", "SPELL", "DEITY", "DOMAIN", "SKILL", "FEAT", "TEMPLATE"};
    private static final int LST_TYPE_UNKNOWN = 0;
    private static final int LST_TYPE_RACE = 1;
    private static final int LST_TYPE_CLASS = 2;
    private static final int LST_TYPE_SPELL = 3;
    private static final int LST_TYPE_DEITY = 4;
    private static final int LST_TYPE_DOMAIN = 5;
    private static final int LST_TYPE_SKILL = 6;
    private static final int LST_TYPE_FEAT = 7;
    private static final int LST_TYPE_TEMPLATE = 8;
    private static final String[] okTypes = new String[]{"NO", "YES"};
    private List<Integer> doneList = new ArrayList<Integer>();
    private List<String> lstNameList = new ArrayList<String>();
    private List<String> lstPathList = new ArrayList<String>();
    private List<Integer> lstTypeList = new ArrayList<Integer>();
    private List<Integer> okList = new ArrayList<Integer>();
    private String basePath = "";
    private TableSorter sorter = new TableSorter();

    LstConverter(String string) {
        this.enableEvents(64L);
        this.setDefaultCloseOperation(0);
        this.setTitle("Convert Required fields to tagged format");
        this.basePath = string;
        try {
            this.loadLSTFilesInDirectory(this.basePath);
            this.jbInit();
        }
        catch (Exception exception) {
            Logging.errorPrint("Error while initing form", exception);
        }
    }

    public String getBasePath() {
        return this.basePath;
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        super.processWindowEvent(windowEvent);
        if (windowEvent.getID() == 201) {
            this.handleQuit();
        }
    }

    private static String getFormulaFor(int n, String string) {
        String string2 = string;
        if (n == 0) {
            if ("G".equals(string)) {
                string2 = "CL";
            }
            if ("M".equals(string)) {
                string2 = "3*CL/4";
            }
            if ("B".equals(string)) {
                string2 = "CL/2";
            }
        } else {
            if ("G".equals(string)) {
                string2 = "(CL/2)+2";
            }
            if ("M".equals(string)) {
                string2 = "1+((CL/5).INTVAL)+(((CL+3)/5).INTVAL)";
            }
            if ("B".equals(string)) {
                string2 = "CL/3";
            }
        }
        if (string2.equals(string)) {
            Logging.errorPrint("bad formula String:" + string);
        }
        return string2;
    }

    private void go() {
        for (int i = 0; i < this.okList.size(); ++i) {
            if (this.okList.get(i) == 0) continue;
            int n = this.lstTypeList.get(i);
            if (n == 0) {
                Logging.errorPrint(this.lstNameList.get(i) + " is UNKNOWN - not converting");
            }
            File file = new File(this.lstPathList.get(i) + File.separatorChar + this.lstNameList.get(i));
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                int n2 = (int)file.length();
                char[] cArray = new char[n2];
                bufferedReader.read(cArray, 0, n2);
                bufferedReader.close();
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
                String string = new String(cArray);
                StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n", true);
                while (stringTokenizer.hasMoreTokens()) {
                    String string2;
                    String string3 = stringTokenizer.nextToken();
                    if ("\r".equals(string3) || "\n".equals(string3) || string3.trim().length() == 0 || string3.length() > 0 && string3.charAt(0) == '#') {
                        bufferedWriter.write(string3);
                        continue;
                    }
                    StringTokenizer stringTokenizer2 = new StringTokenizer(string3, "\t", false);
                    boolean bl = false;
                    stringTokenizer2.nextToken();
                    if (stringTokenizer2.hasMoreTokens() && (string2 = stringTokenizer2.nextToken()).indexOf(":") == -1) {
                        bl = true;
                    }
                    stringTokenizer2 = new StringTokenizer(string3, "\t", true);
                    int n3 = 0;
                    if (!bl) {
                        n3 = 100;
                    }
                    block19: while (stringTokenizer2.hasMoreTokens()) {
                        String string4;
                        Object object;
                        List<PObject> list;
                        String string5;
                        block109: {
                            string5 = stringTokenizer2.nextToken();
                            if ("\t".equals(string5)) {
                                bufferedWriter.write(string5);
                                continue;
                            }
                            if (n3++ == 0) {
                                bufferedWriter.write(string5);
                                continue;
                            }
                            list = SettingsHandler.getGame().getUnmodifiableCheckList();
                            if (string5.startsWith("PREFORT:")) {
                                bufferedWriter.write("PRECHECK:1," + list.get(0).toString().toUpperCase() + "=" + string5.substring(8));
                                continue;
                            }
                            if (string5.startsWith("PREREFLEX:")) {
                                bufferedWriter.write("PRECHECK:1," + list.get(1).toString().toUpperCase() + "=" + string5.substring(10));
                                continue;
                            }
                            if (string5.startsWith("PREWILL:")) {
                                bufferedWriter.write("PRECHECK:1," + list.get(2).toString().toUpperCase() + "=" + string5.substring(8));
                                continue;
                            }
                            if (string5.startsWith("PREFORTBASE:")) {
                                bufferedWriter.write("PRECHECKBASE:1," + list.get(0).toString().toUpperCase() + "=" + string5.substring(12));
                                continue;
                            }
                            if (string5.startsWith("PREREFLEXBASE:")) {
                                bufferedWriter.write("PRECHECKBASE:1," + list.get(1).toString().toUpperCase() + "=" + string5.substring(14));
                                continue;
                            }
                            if (string5.startsWith("PREWILLBASE:")) {
                                bufferedWriter.write("PRECHECKBASE:1," + list.get(2).toString().toUpperCase() + "=" + string5.substring(12));
                                continue;
                            }
                            if (string5.startsWith("PRESTAT:") && string5.indexOf(",") == -1) {
                                bufferedWriter.write("PRESTAT:1," + string5.substring(8));
                                continue;
                            }
                            if (string5.startsWith("PRECLASS:")) {
                                object = new StringTokenizer(string5.substring(9), ",", false);
                                string4 = ((StringTokenizer)object).nextToken();
                                try {
                                    Integer.parseInt(string4);
                                    break block109;
                                }
                                catch (Exception exception) {
                                    bufferedWriter.write("PRECLASS:1," + string5.substring(9));
                                    continue;
                                }
                            }
                            if (string5.startsWith("!PRECLASS:")) {
                                StringTokenizer stringTokenizer3 = new StringTokenizer(string5.substring(10), ",", false);
                                string4 = stringTokenizer3.nextToken();
                                try {
                                    Integer.parseInt(string4);
                                    break block109;
                                }
                                catch (Exception exception) {
                                    bufferedWriter.write("!PRECLASS:1," + string5.substring(10));
                                    continue;
                                }
                            }
                            if (string5.startsWith("PREWEAPONPROF:")) {
                                StringTokenizer stringTokenizer4 = new StringTokenizer(string5.substring(14), ",", false);
                                string4 = stringTokenizer4.nextToken();
                                try {
                                    Integer.parseInt(string4);
                                }
                                catch (Exception exception) {
                                    bufferedWriter.write("PREWEAPONPROF:" + Integer.toString(stringTokenizer4.countTokens() + 1) + "," + string5.substring(14));
                                    continue;
                                }
                            }
                        }
                        switch (n) {
                            case 1: {
                                if (!bl && string5.startsWith("STATADJ") || n3 > 1 && n3 < 8) {
                                    int n4 = n3 - 2;
                                    if (!bl) {
                                        n4 = Integer.parseInt(string5.substring(7, 8));
                                        string5 = string5.substring(9);
                                    }
                                    if ("0".equals(string5)) continue block19;
                                    string5 = "BONUS:STAT|" + SettingsHandler.getGame().getUnmodifiableStatList().get(n4).getAbb() + "|" + string5;
                                    bufferedWriter.write(string5);
                                    break;
                                }
                                if (n3 == 8) {
                                    string5 = "FAVCLASS:" + string5;
                                    bufferedWriter.write(string5);
                                    break;
                                }
                                if (n3 == 9) {
                                    if ("0".equals(string5)) continue block19;
                                    string5 = "XTRASKILLPTSPERLVL:" + string5;
                                    bufferedWriter.write(string5);
                                    break;
                                }
                                if (n3 == 10) {
                                    if ("0".equals(string5)) continue block19;
                                    string5 = "STARTFEATS:" + string5;
                                    bufferedWriter.write(string5);
                                    break;
                                }
                                bufferedWriter.write(string5);
                                break;
                            }
                            case 2: {
                                if (string5.startsWith("INTMODTOSKILLS")) {
                                    string5 = string5.substring(3);
                                } else if (string5.startsWith("GOLD:") || string5.startsWith("AGESET:")) {
                                    string5 = "";
                                } else {
                                    if (n3 == 2) continue block19;
                                    if (n3 == 3) {
                                        string5 = "HD:" + string5;
                                    } else if (n3 == 4) {
                                        string5 = "STARTSKILLPTS:" + string5;
                                    } else if (n3 == 5) {
                                        string5 = "XTRAFEATS:" + string5;
                                    } else if (n3 == 6) {
                                        string5 = "SPELLSTAT:" + string5;
                                    } else if (n3 == 7) {
                                        string5 = "SPELLTYPE:" + string5;
                                    } else if (n3 == 8 || string5.startsWith("BAB:")) {
                                        if (string5.startsWith("BAB:")) {
                                            string5 = string5.substring(4);
                                        }
                                        string5 = LstConverter.getFormulaFor(0, string5);
                                        string5 = "BONUS:COMBAT|BAB|" + string5;
                                    } else if (n3 == 9 || !bl && string5.startsWith("FORTITUDECHECK:") || !bl && string5.startsWith("CHECK1:")) {
                                        if (string5.startsWith("FORT")) {
                                            string5 = string5.substring(15);
                                        }
                                        if (string5.startsWith("CHECK1")) {
                                            string5 = string5.substring(7);
                                        }
                                        string5 = LstConverter.getFormulaFor(1, string5);
                                        string5 = "BONUS:CHECKS|BASE." + list.get(0).toString().toUpperCase() + "|" + string5;
                                    } else if (n3 == 10 || !bl && string5.startsWith("REFLEXCHECK:") || !bl && string5.startsWith("CHECK2:")) {
                                        if (!bl) {
                                            string5 = string5.substring(12);
                                        }
                                        if (string5.startsWith("CHECK2")) {
                                            string5 = string5.substring(7);
                                        }
                                        string5 = LstConverter.getFormulaFor(1, string5);
                                        string5 = "BONUS:CHECKS|BASE." + list.get(1).toString().toUpperCase() + "|" + string5;
                                    } else if (n3 == 11 || !bl && string5.startsWith("WILLPOWERCHECK:") || !bl && string5.startsWith("CHECK3:")) {
                                        if (!bl) {
                                            string5 = string5.substring(15);
                                        }
                                        if (string5.startsWith("CHECK3")) {
                                            string5 = string5.substring(7);
                                        }
                                        string5 = LstConverter.getFormulaFor(1, string5);
                                        string5 = "BONUS:CHECKS|BASE." + list.get(2).toString().toUpperCase() + "|" + string5;
                                    }
                                }
                                bufferedWriter.write(string5);
                                break;
                            }
                            case 3: {
                                if (string5.startsWith("EFFECTS:")) {
                                    string5 = "DESC:" + string5.substring(8);
                                } else if (string5.startsWith("EFFECTTYPE:")) {
                                    string5 = "TARGETAREA:" + string5.substring(11);
                                } else if (n3 == 2) {
                                    string5 = "SCHOOL:" + string5;
                                } else if (n3 == 3) {
                                    string5 = "SUBSCHOOL:" + string5;
                                } else if (n3 == 4) {
                                    string5 = "COMPS:" + string5;
                                } else if (n3 == 5) {
                                    string5 = "CASTTIME:" + string5;
                                } else if (n3 == 6) {
                                    string5 = "RANGE:" + string5;
                                } else if (n3 == 7) {
                                    string5 = "DESC:" + string5;
                                } else if (n3 == 8) {
                                    string5 = "TARGETAREA:" + string5;
                                } else if (n3 == 9) {
                                    string5 = "DURATION:" + string5;
                                } else if (n3 == 10) {
                                    string5 = "SAVEINFO:" + string5;
                                } else if (n3 == 11) {
                                    string5 = "SPELLRES:" + string5;
                                }
                                bufferedWriter.write(string5);
                                break;
                            }
                            case 4: {
                                if (n3 == 2) {
                                    string5 = "DOMAINS:" + string5;
                                } else if (n3 == 3) {
                                    string5 = "FOLLOWERALIGN:" + string5;
                                } else if (n3 == 4) {
                                    string5 = "DESC:" + string5;
                                } else if (n3 == 5) {
                                    string5 = "SYMBOL:" + string5;
                                } else if (n3 == 6) {
                                    string5 = "DEITYWEAP:" + string5;
                                }
                                bufferedWriter.write(string5);
                                break;
                            }
                            case 5: {
                                if (n3 == 2) {
                                    string5 = "DESC:" + string5;
                                }
                                bufferedWriter.write(string5);
                                break;
                            }
                            case 6: {
                                if (n3 == 2) {
                                    string5 = "KEYSTAT:" + string5;
                                } else if (n3 == 3) {
                                    string5 = "EXCLUSIVE:" + string5;
                                } else if (n3 == 4) {
                                    string5 = "USEUNTRAINED:" + string5;
                                } else if (string5.startsWith("SYNERGY:")) {
                                    object = string3.substring(0, string3.indexOf("\t"));
                                    string4 = string5.substring(8, string5.indexOf("="));
                                    String string6 = string5.substring(string5.indexOf("=") + 1, string5.lastIndexOf("="));
                                    String string7 = string5.substring(string5.lastIndexOf("=") + 1);
                                    string5 = "BONUS:SKILL|" + (String)object + "|" + string7 + "|PRESKILL:1," + string4 + "=" + string6 + "|TYPE=Synergy.STACK";
                                }
                                bufferedWriter.write(string5);
                                break;
                            }
                            case 7: 
                            case 8: {
                                bufferedWriter.write(string5);
                                break;
                            }
                            default: {
                                Logging.errorPrint("In LstConverter.go the type " + n + " is not handled.");
                            }
                        }
                    }
                }
                this.okList.set(i, 0);
                this.doneList.set(i, 1);
                bufferedWriter.close();
                continue;
            }
            catch (Exception exception) {
                Logging.errorPrint("", exception);
            }
        }
    }

    private void handleQuit() {
        this.dispose();
    }

    private void jbInit() throws Exception {
        JScrollPane jScrollPane = new JScrollPane();
        final LstTable lstTable = new LstTable();
        LstTableModel lstTableModel = new LstTableModel();
        this.sorter.setModel(lstTableModel);
        this.sorter.addMouseListenerToHeaderInTable(lstTable);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jScrollPane, "Center");
        this.setSize(new Dimension(700, 500));
        lstTable.setModel(this.sorter);
        lstTable.getColumnModel().getColumn(0).setPreferredWidth(150);
        lstTable.getColumnModel().getColumn(1).setPreferredWidth(160);
        lstTable.getColumnModel().getColumn(2).setCellRenderer(new TypeRenderer(typeTypes));
        lstTable.getColumnModel().getColumn(2).setCellEditor(new TypeEditor(typeTypes));
        lstTable.getColumnModel().getColumn(3).setCellRenderer(new OkRenderer(okTypes));
        lstTable.getColumnModel().getColumn(3).setCellEditor(new OkEditor(okTypes));
        lstTable.getColumnModel().getColumn(4).setCellRenderer(new DoneRenderer(okTypes));
        lstTable.getColumnModel().getColumn(4).setCellEditor(new DoneEditor(okTypes));
        lstTable.setRowHeight(new OkRenderer((String[])LstConverter.okTypes).getMinimumSize().height);
        lstTable.setAutoResizeMode(0);
        lstTable.setSelectionMode(0);
        jScrollPane.setViewportView(lstTable);
        JPanel jPanel = new JPanel();
        this.getContentPane().add((Component)jPanel, "South");
        final JButton jButton = new JButton("Race");
        final JButton jButton2 = new JButton("Class");
        final JButton jButton3 = new JButton("Spell");
        final JButton jButton4 = new JButton("Deity");
        final JButton jButton5 = new JButton("Domain");
        final JButton jButton6 = new JButton("Skill");
        final JButton jButton7 = new JButton("Feat");
        final JButton jButton8 = new JButton("Template");
        final JButton jButton9 = new JButton("All");
        final JButton jButton10 = new JButton("Run!");
        jPanel.add(jButton10);
        jPanel.add(new JLabel("Toggle:"));
        jPanel.add(jButton9);
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.add(jButton3);
        jPanel.add(jButton4);
        jPanel.add(jButton5);
        jPanel.add(jButton6);
        jPanel.add(jButton7);
        jPanel.add(jButton8);
        jButton9.setToolTipText("Toggle convert-me status of all known file types");
        jButton.setToolTipText("Toggle convert-me status of all race files");
        jButton2.setToolTipText("Toggle convert-me status of all class files");
        jButton3.setToolTipText("Toggle convert-me status of all spell/power files");
        jButton4.setToolTipText("Toggle convert-me status of all deity files");
        jButton5.setToolTipText("Toggle convert-me status of all domain files");
        jButton6.setToolTipText("Toggle convert-me status of all skill files");
        jButton7.setToolTipText("Toggle convert-me status of all feat files");
        jButton8.setToolTipText("Toggle convert-me status of all template files");
        jButton10.setToolTipText("Convert files from using required fields to use tagged format");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == jButton10) {
                    LstConverter.this.go();
                    lstTable.updateUI();
                }
                if (actionEvent.getSource() == jButton) {
                    LstConverter.this.toggleType(1);
                    lstTable.updateUI();
                }
                if (actionEvent.getSource() == jButton2) {
                    LstConverter.this.toggleType(2);
                    lstTable.updateUI();
                }
                if (actionEvent.getSource() == jButton3) {
                    LstConverter.this.toggleType(3);
                    lstTable.updateUI();
                }
                if (actionEvent.getSource() == jButton4) {
                    LstConverter.this.toggleType(4);
                    lstTable.updateUI();
                }
                if (actionEvent.getSource() == jButton5) {
                    LstConverter.this.toggleType(5);
                    lstTable.updateUI();
                }
                if (actionEvent.getSource() == jButton6) {
                    LstConverter.this.toggleType(6);
                    lstTable.updateUI();
                }
                if (actionEvent.getSource() == jButton7) {
                    LstConverter.this.toggleType(7);
                    lstTable.updateUI();
                }
                if (actionEvent.getSource() == jButton8) {
                    LstConverter.this.toggleType(8);
                    lstTable.updateUI();
                }
                if (actionEvent.getSource() == jButton9) {
                    for (int i = 1; i < 9; ++i) {
                        LstConverter.this.toggleType(i);
                    }
                    lstTable.updateUI();
                }
            }
        };
        jButton.addActionListener(actionListener);
        jButton2.addActionListener(actionListener);
        jButton3.addActionListener(actionListener);
        jButton4.addActionListener(actionListener);
        jButton5.addActionListener(actionListener);
        jButton6.addActionListener(actionListener);
        jButton7.addActionListener(actionListener);
        jButton8.addActionListener(actionListener);
        jButton9.addActionListener(actionListener);
        jButton10.addActionListener(actionListener);
    }

    private boolean loadLSTFilesInDirectory(String string) {
        new File(string).list(new FilenameFilter(){

            public boolean accept(File file, String string) {
                try {
                    string = string.toLowerCase();
                    if (PCGFile.isPCGenListFile(new File(string))) {
                        LstConverter.this.lstNameList.add(string);
                        LstConverter.this.lstPathList.add(file.getPath());
                        int n = 1;
                        if (string.endsWith("race.lst") || string.endsWith("races.lst")) {
                            LstConverter.this.lstTypeList.add(1);
                        } else if (string.endsWith("class.lst") || string.endsWith("classes.lst")) {
                            LstConverter.this.lstTypeList.add(2);
                        } else if ((string.endsWith("spell.lst") || string.endsWith("spells.lst") || string.endsWith("power.lst") || string.endsWith("powers.lst")) && string.indexOf("classspell") == -1 && string.indexOf("classpowers") == -1) {
                            LstConverter.this.lstTypeList.add(3);
                        } else if (string.endsWith("deity.lst") || string.endsWith("deities.lst")) {
                            LstConverter.this.lstTypeList.add(4);
                        } else if (string.endsWith("domain.lst") || string.endsWith("domains.lst")) {
                            LstConverter.this.lstTypeList.add(5);
                        } else if ((string.endsWith("skill.lst") || string.endsWith("skills.lst")) && string.indexOf("classskill") == -1) {
                            LstConverter.this.lstTypeList.add(6);
                        } else if (string.endsWith("feat.lst") || string.endsWith("feats.lst")) {
                            LstConverter.this.lstTypeList.add(7);
                        } else if (string.endsWith("template.lst") || string.endsWith("templates.lst")) {
                            LstConverter.this.lstTypeList.add(8);
                        } else {
                            n = 0;
                            LstConverter.this.lstTypeList.add(0);
                        }
                        if (n > 0) {
                            LstConverter.this.okList.add(1);
                        } else {
                            LstConverter.this.okList.add(0);
                        }
                        LstConverter.this.doneList.add(0);
                    } else if (file.isDirectory()) {
                        LstConverter.this.loadLSTFilesInDirectory(file.getPath() + File.separator + string);
                    }
                }
                catch (Exception exception) {
                    Logging.errorPrint("LstConverter", exception);
                }
                return false;
            }
        });
        return false;
    }

    private void toggleType(int n) {
        for (int i = 0; i < this.okList.size(); ++i) {
            int n2 = this.lstTypeList.get(i);
            if (n != n2) continue;
            n2 = this.okList.get(i);
            if (n2 == 0) {
                this.okList.set(i, 1);
                continue;
            }
            this.okList.set(i, 0);
        }
    }

    private static final class TypeRenderer
    extends JComboBoxRenderer {
        private TypeRenderer(String[] stringArray) {
            super(stringArray);
        }
    }

    private static final class TypeEditor
    extends JComboBoxEditor {
        private TypeEditor(String[] stringArray) {
            super(stringArray);
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TypeEditor.this.stopCellEditing();
                }
            });
        }
    }

    private static final class OkRenderer
    extends JComboBoxRenderer {
        private OkRenderer(String[] stringArray) {
            super(stringArray);
        }
    }

    private static final class OkEditor
    extends JComboBoxEditor {
        private OkEditor(String[] stringArray) {
            super(stringArray);
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    OkEditor.this.stopCellEditing();
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class LstTableModel
    extends AbstractTableModel {
        private LstTableModel() {
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 2 || n2 == 3;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "File Name";
                }
                case 1: {
                    return "Path";
                }
                case 2: {
                    return "Type";
                }
                case 3: {
                    return "Convert Me";
                }
                case 4: {
                    return "Converted";
                }
            }
            Logging.errorPrint("In LstConverter.LstTableModel.getColumnName the column " + n + " is not handled.");
            return "Out Of Bounds";
        }

        @Override
        public int getRowCount() {
            return LstConverter.this.lstNameList.size();
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (object == null || n2 < 1 || n2 > 4) {
                return;
            }
            Integer n3 = Integer.valueOf(object.toString());
            switch (n2) {
                case 2: {
                    LstConverter.this.lstTypeList.set(n, n3);
                    if (n3 != 0) break;
                    LstConverter.this.okList.set(n, n3);
                    break;
                }
                case 3: {
                    int n4;
                    if (n3 == 1 && (n4 = ((Integer)LstConverter.this.lstTypeList.get(n)).intValue()) == 0) {
                        ShowMessageDelegate.showMessageDialog("Set type to a known type before marking it to be converted.", "Oops!", MessageType.ERROR);
                        return;
                    }
                    LstConverter.this.okList.set(n, n3);
                    break;
                }
                default: {
                    Logging.errorPrint("In LstConverter.LstTableModel.setValueAt the column " + n2 + " is not handled.");
                }
            }
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (LstConverter.this.lstNameList.size() <= n || n2 > 4) {
                return "Out of Bounds";
            }
            switch (n2) {
                case 0: {
                    return LstConverter.this.lstNameList.get(n);
                }
                case 1: {
                    return LstConverter.this.lstPathList.get(n);
                }
                case 2: {
                    int n3 = (Integer)LstConverter.this.lstTypeList.get(n);
                    return n3;
                }
                case 3: {
                    int n4 = (Integer)LstConverter.this.okList.get(n);
                    return n4;
                }
                case 4: {
                    int n5 = (Integer)LstConverter.this.doneList.get(n);
                    return n5;
                }
            }
            Logging.errorPrint("In LstConverter.LstTableModel.getValueAt the column " + n2 + " is not handled.");
            return null;
        }

        @Override
        public void fireTableDataChanged() {
            super.fireTableDataChanged();
        }
    }

    private final class LstTable
    extends JTable {
        private LstTable() {
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            int n = this.rowAtPoint(point);
            int n2 = this.columnAtPoint(point);
            int n3 = this.convertColumnIndexToModel(n2);
            if (n3 <= 2) {
                return String.valueOf(this.getValueAt(n, n2));
            }
            return super.getToolTipText(mouseEvent);
        }
    }

    private static final class DoneRenderer
    extends JComboBoxRenderer {
        private DoneRenderer(String[] stringArray) {
            super(stringArray);
        }
    }

    private static final class DoneEditor
    extends JComboBoxEditor {
        private DoneEditor(String[] stringArray) {
            super(stringArray);
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DoneEditor.this.stopCellEditing();
                }
            });
        }
    }
}

