/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.UIManager;
import pcgen.core.PlayerCharacter;
import pcgen.io.PCGFile;
import pcgen.io.PCGIOHandler;
import pcgen.util.PropertyFactory;

public class ImagePreview
extends JPanel
implements PropertyChangeListener {
    private static final int SIZE = 200;
    private static String in_notAnImage = PropertyFactory.getString("in_ImagePreview_notAnImage");
    private static String in_noCharacterPortrait = PropertyFactory.getString("in_ImagePreview_noCharacterPortrait");
    private final JFileChooser jfc;
    private PlayerCharacter aPC;
    private Image image;

    public ImagePreview(JFileChooser jFileChooser) {
        this.jfc = jFileChooser;
        jFileChooser.addPropertyChangeListener(this);
        jFileChooser.setAccessory(this);
        this.setPreferredSize(new Dimension(200, 200));
    }

    public static JFileChooser decorateWithImagePreview(JFileChooser jFileChooser) {
        new ImagePreview(jFileChooser);
        return jFileChooser;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        try {
            this.updateImage(this.jfc.getSelectedFile());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void updateImage(File file) throws IOException {
        if (null == file || !file.exists()) {
            this.image = null;
            return;
        }
        if (PCGFile.isPCGenCharacterFile(file)) {
            this.aPC = new PlayerCharacter();
            new PCGIOHandler().readForPreview(this.aPC, file.getAbsolutePath());
            String string = this.aPC.getPortraitPath();
            this.image = ImagePreview.isNullOrEmpty(string) ? null : ImageIO.read(new File(string));
        } else {
            this.aPC = null;
            this.image = ImageIO.read(file);
        }
        this.repaint();
    }

    protected void paintComponent(Graphics graphics) {
        graphics.setColor(UIManager.getColor("Panel.background"));
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        int n = ImagePreview.getFontHeightHint(graphics);
        int n2 = 200 - ImagePreview.getFontHeightHint(graphics);
        if (null != this.image) {
            int n3 = this.image.getWidth(null);
            int n4 = this.image.getHeight(null);
            int n5 = Math.max(n3, n4);
            double d = 200.0 / (double)n5;
            graphics.drawImage(this.image, 0, 0, (int)(d * (double)n3), (int)(d * (double)n4), null);
            String string = n3 + " x " + n4;
            graphics.setColor(Color.black);
            graphics.drawString(string, n, n2);
            graphics.setColor(Color.white);
            graphics.drawString(string, n - 1, n - 1);
        } else {
            graphics.setColor(UIManager.getColor("Panel.foreground"));
            graphics.drawString(this.aPC == null ? in_notAnImage : in_noCharacterPortrait, n, n2);
        }
    }

    private static boolean isNullOrEmpty(String string) {
        return null == string || "".equals(string);
    }

    private static int getFontHeightHint(Graphics graphics) {
        return graphics.getFontMetrics().getHeight();
    }
}

