/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import pcgen.base.formula.Formula;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.Constants;
import pcgen.cdom.enumeration.FormulaKey;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.StringKey;
import pcgen.cdom.enumeration.Type;
import pcgen.core.Equipment;
import pcgen.core.EquipmentModifier;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.SizeAdjustment;
import pcgen.core.SpecialProperty;
import pcgen.core.analysis.EqModSpellInfo;
import pcgen.core.prereq.PrerequisiteUtilities;
import pcgen.core.spell.Spell;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.ChooseSpellDialog;
import pcgen.gui.EQFrame;
import pcgen.gui.NewWeaponInfoDialog;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.panes.FlippingSplitPane;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.gui.utils.JTableEx;
import pcgen.gui.utils.TableSorter;
import pcgen.gui.utils.Utility;
import pcgen.util.Delta;
import pcgen.util.InputFactory;
import pcgen.util.InputInterface;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

final class EqBuilder
extends JPanel {
    public static final int EQTYPE_NONE = -1;
    public static final int EQTYPE_POTION = 0;
    public static final int EQTYPE_SCROLL = 1;
    public static final int EQTYPE_WAND = 2;
    public static final int EQTYPE_RING = 3;
    static final long serialVersionUID = -369105812700996734L;
    private static TableSorter sorter;
    static String[] validEqTypes;
    private DefaultListModel listModel1;
    private DefaultListModel listModel2;
    private Equipment aNewEq = null;
    private Equipment baseEquipment = null;
    private EquipmentModModel dataModel;
    private EQFrame parentFrame = null;
    private FlippingSplitPane jSplitPane2;
    private FlippingSplitPane jSplitPane3;
    private JButton jButtonAdd1;
    private JButton jButtonAdd2;
    private JButton jButtonCancel;
    private JButton jButtonCost;
    private JButton jButtonName;
    private JButton jButtonOk;
    private JButton jButtonPurchase;
    private JButton jButtonRemove1;
    private JButton jButtonRemove2;
    private JButton jButtonSProp;
    private JButton jButtonWeight;
    private JButton jButtonDamage;
    private JComboBoxEx jComboBoxSize;
    private JLabel jLabelSize;
    private JList jListSelected1;
    private JList jListSelected2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel20;
    private JPanel jPanel21;
    private JPanel jPanel22;
    private JPanel jPanel23;
    private JPanel jPanel3;
    private JPanel jPanel5;
    private JPanel jPanelAvailables;
    private JPanel jPanelButtons1;
    private JPanel jPanelButtons2;
    private JPanel jPanelModifiers;
    private JPanel jPanelOkCancel;
    private JPanel jPanelSelected1;
    private JPanel jPanelSelected2;
    private JPanel jPanelSelections;
    private JScrollPane jScrollPane2;
    private JScrollPane jScroll_ListAvailable;
    private JScrollPane jScroll_ListSelected1;
    private JScrollPane jScroll_ListSelected2;
    private JTableEx jListAvailable;
    private JTextPane jItemDesc;
    private String customName = "";
    private List[] newTypeList = new List[]{null, null};
    private int eqType = -1;
    private int iListCount = 0;
    private PlayerCharacter aPC;

    EqBuilder(PlayerCharacter playerCharacter) {
        this.aPC = playerCharacter;
        this.initComponents();
    }

    public void setParentWindow(EQFrame eQFrame) {
        this.parentFrame = eQFrame;
        Globals.setCurrentFrame(this.parentFrame);
    }

    public boolean setEquipment(Equipment equipment) {
        this.dataModel = equipment.isWeapon() && equipment.isDouble() ? new EquipmentModModelDouble() : new EquipmentModModelSingle();
        sorter.setModel(this.dataModel);
        return this.setEquipment(equipment, false);
    }

    public void toFront() {
        block0 : switch (this.eqType) {
            case 0: 
            case 1: 
            case 2: {
                for (int i = 0; i < this.dataModel.getDisplayModifiers().size(); ++i) {
                    EquipmentModifier equipmentModifier = this.dataModel.getDisplayModifiers().get(i);
                    if (!equipmentModifier.getKeyName().startsWith("SE_") || equipmentModifier.getSafeSizeOfListFor(ListKey.TYPE) != 1) continue;
                    i = sorter.translateRow(i);
                    this.jListAvailable.setRowSelectionInterval(i, i);
                    this.jButtonAdd1ActionPerformed();
                    break block0;
                }
                break;
            }
        }
    }

    private static void setGuiTextInfo(Object object, String string) {
        Utility.setGuiTextInfo(object, "in_EqBuilder_" + string);
    }

    private boolean setEquipment(Equipment equipment, boolean bl) {
        boolean bl2;
        this.listModel1.clear();
        this.listModel2.clear();
        String string = equipment.getBaseItemName();
        if (!bl) {
            this.customName = "";
            this.baseEquipment = !string.equals(equipment.getName()) ? Globals.getContext().ref.silentlyGetConstructedCDOMObject(Equipment.class, string) : equipment;
        }
        this.eqType = -1;
        for (bl2 = false; bl2 < validEqTypes.length; bl2 += 1) {
            if (!equipment.isType(validEqTypes[bl2])) continue;
            this.eqType = bl2;
            break;
        }
        if (equipment.getEqModifierList(true).size() == 0 && equipment.getEqModifierList(false).size() == 0) {
            for (EquipmentModifier equipmentModifier : Globals.getContext().ref.getConstructedCDOMObjects(EquipmentModifier.class)) {
                if (!equipmentModifier.getDisplayName().startsWith("EXCLUDEEQ")) continue;
                for (String string2 : equipmentModifier.getSafeListFor(ListKey.ITEM_TYPES)) {
                    if (!equipment.isEitherType(string2.toUpperCase())) continue;
                    this.errorDialog("This item already has type: " + string2 + ". Select the base item and modify it instead.");
                    return false;
                }
            }
        }
        if (this.baseEquipment == null) {
            Logging.errorPrint("No base equipment found: " + equipment.getName() + ", aborting EqBuilder:" + string);
            return false;
        }
        this.iListCount = bl ? (equipment.isWeapon() && equipment.isDouble() ? 2 : 1) : (this.baseEquipment.isWeapon() && this.baseEquipment.isDouble() ? 2 : 1);
        this.jListSelected1.setSelectionMode(0);
        this.jListSelected1.setModel(this.listModel1);
        this.jPanelButtons1.setVisible(true);
        if (bl) {
            this.dataModel.setFilter(equipment, this.iListCount);
        } else {
            this.dataModel.setFilter(this.baseEquipment, this.iListCount);
        }
        bl2 = Globals.canResizeHaveEffect(this.aPC, equipment, equipment.typeList());
        this.jLabelSize.setVisible(bl2);
        this.jComboBoxSize.setVisible(bl2);
        this.jButtonDamage.setVisible(equipment.isWeapon());
        this.setItemSize(equipment.getSafe(ObjectKey.SIZE).getDisplayName());
        if (!bl) {
            this.aNewEq = equipment.clone();
        }
        this.jPanelSelected2.setVisible(this.iListCount > 1);
        this.loadScreenInfo();
        this.updateDisplay(true);
        this.updateDisplay(false);
        return true;
    }

    private void setItemSize(String string) {
        for (int i = 0; i < this.jComboBoxSize.getItemCount(); ++i) {
            String string2 = (String)this.jComboBoxSize.getItemAt(i);
            if (!string2.equalsIgnoreCase(string)) continue;
            this.jComboBoxSize.setSelectedIndex(i);
            return;
        }
    }

    private int getItemSize() {
        int n = this.jComboBoxSize.getSelectedIndex();
        if (n >= 0) {
            String string = (String)this.jComboBoxSize.getItemAt(n);
            for (int i = 0; i <= SettingsHandler.getGame().getSizeAdjustmentListSize() - 1; ++i) {
                if (!SettingsHandler.getGame().getSizeAdjustmentAtIndex(i).getDisplayName().equalsIgnoreCase(string)) continue;
                return i;
            }
        }
        return -1;
    }

    private void addButton(boolean bl) {
        this.jButtonAdd1.setEnabled(false);
        this.jButtonAdd2.setEnabled(false);
        Globals.setCurrentFrame(this.parentFrame);
        this.aNewEq.setCostMod("0");
        ListSelectionModel listSelectionModel = this.jListAvailable.getSelectionModel();
        int n = listSelectionModel.getMinSelectionIndex();
        if (n >= 0 && (n = sorter.getRowTranslated(n)) >= 0) {
            EquipmentModifier equipmentModifier = this.dataModel.getDisplayModifiers().get(n);
            if (equipmentModifier.getSafe(StringKey.CHOICE_STRING).startsWith("EQBUILDER.SPELL")) {
                this.jButtonSpellActionPerformed(equipmentModifier, equipmentModifier.getSafe(StringKey.CHOICE_STRING).substring(15));
                return;
            }
            this.aNewEq.addEqModifier(equipmentModifier, bl, this.aPC);
            this.setEquipment(this.aNewEq, true);
            this.updateDisplay(bl);
            if (this.aNewEq.isDouble() && equipmentModifier.getSafe(ObjectKey.ASSIGN_TO_ALL).booleanValue()) {
                this.aNewEq.addEqModifier(equipmentModifier, !bl, this.aPC);
                this.updateDisplay(!bl);
            }
            ((EQFrame)this.getRootPane().getParent()).setVisible(true);
            ((EQFrame)this.getRootPane().getParent()).toFront();
            Globals.getCurrentFrame().requestFocus();
        }
    }

    private void doCleanUp() {
        this.aNewEq = null;
        this.newTypeList[0] = null;
        this.newTypeList[1] = null;
        this.saveScreenInfo();
    }

    private void initComponents() {
        this.listModel1 = new DefaultListModel();
        this.listModel2 = new DefaultListModel();
        this.jPanel1 = new JPanel();
        this.jPanelOkCancel = new JPanel();
        this.jPanel3 = new JPanel();
        JPanel jPanel = new JPanel();
        this.jLabelSize = new JLabel();
        this.jButtonName = new JButton();
        this.jButtonSProp = new JButton();
        this.jButtonCost = new JButton();
        this.jButtonWeight = new JButton();
        this.jButtonDamage = new JButton();
        this.jComboBoxSize = new JComboBoxEx();
        JPanel jPanel2 = new JPanel();
        this.jButtonCancel = new JButton();
        this.jButtonOk = new JButton();
        this.jButtonPurchase = new JButton();
        this.jSplitPane2 = new FlippingSplitPane();
        this.jPanel2 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jItemDesc = new JTextPane();
        this.jPanelModifiers = new JPanel();
        this.jSplitPane3 = new FlippingSplitPane();
        this.jPanelAvailables = new JPanel();
        this.jScroll_ListAvailable = new JScrollPane();
        JPanel jPanel3 = new JPanel();
        EqBuilder.setGuiTextInfo(this.jLabelSize, "Size");
        sorter = new TableSorter();
        this.jListAvailable = new JTableEx(sorter);
        this.jListAvailable.setAutoResizeMode(0);
        sorter.addMouseListenerToHeaderInTable(this.jListAvailable);
        this.jPanel5 = new JPanel();
        this.jPanelSelections = new JPanel();
        this.jPanelSelected1 = new JPanel();
        this.jPanel20 = new JPanel();
        this.jPanelButtons1 = new JPanel();
        this.jButtonAdd1 = new JButton();
        this.jButtonRemove1 = new JButton();
        this.jPanel21 = new JPanel();
        this.jScroll_ListSelected1 = new JScrollPane();
        this.jListSelected1 = new JList(this.listModel1);
        this.jPanelSelected2 = new JPanel();
        this.jPanel22 = new JPanel();
        this.jPanelButtons2 = new JPanel();
        this.jButtonAdd2 = new JButton();
        this.jButtonRemove2 = new JButton();
        this.jPanel23 = new JPanel();
        this.jScroll_ListSelected2 = new JScrollPane();
        this.jListSelected2 = new JList(this.listModel2);
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(640, 480));
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel1.setPreferredSize(new Dimension(640, 480));
        this.jPanelOkCancel.setLayout(new BoxLayout(this.jPanelOkCancel, 0));
        this.jPanel3.setLayout(new GridBagLayout());
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        EqBuilder.setGuiTextInfo(this.jButtonName, "Name");
        this.jButtonName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EqBuilder.this.jButtonNameActionPerformed();
            }
        });
        this.jButtonName.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                EqBuilder.this.jButtonNameActionPerformed();
            }
        });
        jPanel.add(this.jButtonName);
        EqBuilder.setGuiTextInfo(this.jButtonSProp, "SProp");
        this.jButtonSProp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EqBuilder.this.jButtonSPropActionPerformed();
            }
        });
        this.jButtonSProp.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                EqBuilder.this.jButtonSPropActionPerformed();
            }
        });
        jPanel.add(this.jButtonSProp);
        EqBuilder.setGuiTextInfo(this.jButtonCost, "Cost");
        this.jButtonCost.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EqBuilder.this.jButtonCostActionPerformed();
            }
        });
        this.jButtonCost.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                EqBuilder.this.jButtonCostActionPerformed();
            }
        });
        jPanel.add(this.jButtonCost);
        EqBuilder.setGuiTextInfo(this.jButtonWeight, "Weight");
        this.jButtonWeight.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EqBuilder.this.jButtonWeightActionPerformed();
            }
        });
        this.jButtonWeight.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                EqBuilder.this.jButtonWeightActionPerformed();
            }
        });
        jPanel.add(this.jButtonWeight);
        EqBuilder.setGuiTextInfo(this.jButtonDamage, "Damage");
        this.jButtonDamage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EqBuilder.this.jButtonDamageActionPerformed();
            }
        });
        this.jButtonDamage.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                EqBuilder.this.jButtonDamageActionPerformed();
            }
        });
        jPanel.add(this.jButtonDamage);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanel3.add((Component)jPanel, gridBagConstraints);
        this.jPanelOkCancel.add(this.jPanel3);
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        EqBuilder.setGuiTextInfo(this.jButtonCancel, "Cancel");
        this.jButtonCancel.setPreferredSize(new Dimension(81, 27));
        this.jButtonCancel.setMaximumSize(new Dimension(81, 27));
        this.jButtonCancel.setMinimumSize(new Dimension(81, 27));
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EqBuilder.this.jButtonCancelActionPerformed();
            }
        });
        this.jButtonCancel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                EqBuilder.this.jButtonCancelActionPerformed();
            }
        });
        jPanel2.add(this.jButtonCancel);
        EqBuilder.setGuiTextInfo(this.jButtonOk, "Ok");
        this.jButtonOk.setPreferredSize(new Dimension(81, 27));
        this.jButtonOk.setMaximumSize(new Dimension(81, 27));
        this.jButtonOk.setMinimumSize(new Dimension(81, 27));
        this.jButtonOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EqBuilder.this.jButtonOkActionPerformed(false);
            }
        });
        this.jButtonOk.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                EqBuilder.this.jButtonOkActionPerformed(false);
            }
        });
        jPanel2.add(this.jButtonOk);
        EqBuilder.setGuiTextInfo(this.jButtonPurchase, "Purchase");
        this.jButtonPurchase.setPreferredSize(new Dimension(81, 27));
        this.jButtonPurchase.setMaximumSize(new Dimension(81, 27));
        this.jButtonPurchase.setMinimumSize(new Dimension(81, 27));
        this.jButtonPurchase.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EqBuilder.this.jButtonOkActionPerformed(true);
            }
        });
        this.jButtonPurchase.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                EqBuilder.this.jButtonOkActionPerformed(true);
            }
        });
        jPanel2.add(this.jButtonPurchase);
        this.jPanelOkCancel.add(jPanel2);
        this.jPanel1.add((Component)this.jPanelOkCancel, "South");
        this.jSplitPane2.setDividerSize(5);
        this.jSplitPane2.setOrientation(0);
        this.jPanel2.setLayout(new BorderLayout());
        this.jPanel2.setPreferredSize(new Dimension(44, 70));
        this.jItemDesc.setEditable(false);
        this.jItemDesc.setBackground(this.jPanel1.getBackground());
        this.jScrollPane2.setViewportView(this.jItemDesc);
        this.jPanel2.add((Component)this.jScrollPane2, "Center");
        this.jSplitPane2.setLeftComponent(this.jPanel2);
        this.jPanelModifiers.setLayout(new BoxLayout(this.jPanelModifiers, 0));
        this.jPanelModifiers.setPreferredSize(new Dimension(640, 300));
        this.jSplitPane3.setDividerSize(5);
        this.jSplitPane3.setPreferredSize(new Dimension(640, 407));
        this.jPanelAvailables.setLayout(new BorderLayout());
        this.jPanelAvailables.setPreferredSize(new Dimension(340, 403));
        this.jListAvailable.setSelectionMode(0);
        this.jListAvailable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                EqBuilder.this.jListAvailableMouseClicked(mouseEvent);
            }
        });
        this.jScroll_ListAvailable.setViewportView(this.jListAvailable);
        this.jPanelAvailables.add((Component)this.jScroll_ListAvailable, "Center");
        this.jSplitPane3.setLeftComponent(this.jPanelAvailables);
        this.jPanel5.setLayout(new BoxLayout(this.jPanel5, 1));
        this.jPanel5.setPreferredSize(new Dimension(200, 400));
        this.jPanelSelections.setLayout(new BoxLayout(this.jPanelSelections, 1));
        this.jPanelSelected1.setLayout(new BoxLayout(this.jPanelSelected1, 0));
        this.jPanelButtons1.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.anchor = 18;
        JLabel jLabel = new JLabel(" ");
        this.jPanelButtons1.add((Component)new Box.Filler(jLabel.getMinimumSize(), jLabel.getPreferredSize(), jLabel.getMaximumSize()), gridBagConstraints2);
        EqBuilder.setGuiTextInfo(this.jButtonAdd1, "Add1");
        this.jButtonAdd1.setPreferredSize(new Dimension(81, 27));
        this.jButtonAdd1.setMaximumSize(new Dimension(81, 27));
        this.jButtonAdd1.setMinimumSize(new Dimension(81, 27));
        this.jButtonAdd1.setEnabled(false);
        this.jButtonAdd1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EqBuilder.this.jButtonAdd1ActionPerformed();
            }
        });
        this.jButtonAdd1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                EqBuilder.this.jButtonAdd1ActionPerformed();
            }
        });
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.anchor = 18;
        this.jPanelButtons1.add((Component)this.jButtonAdd1, gridBagConstraints2);
        EqBuilder.setGuiTextInfo(this.jButtonRemove1, "Remove1");
        this.jButtonRemove1.setPreferredSize(new Dimension(81, 27));
        this.jButtonRemove1.setEnabled(false);
        this.jButtonRemove1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EqBuilder.this.jButtonRemove1ActionPerformed();
            }
        });
        this.jButtonRemove1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                EqBuilder.this.jButtonRemove1ActionPerformed();
            }
        });
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        this.jPanelButtons1.add((Component)this.jButtonRemove1, gridBagConstraints2);
        this.jPanelButtons1.setAlignmentY(0.5f);
        this.jPanel20.add(this.jPanelButtons1);
        this.jPanelSelected1.add(this.jPanel20);
        jPanel3.add(this.jLabelSize);
        this.jComboBoxSize.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                EqBuilder.this.jComboBoxSizeActionPerformed();
            }
        });
        jPanel3.add(this.jComboBoxSize);
        this.jPanelSelections.add(jPanel3);
        this.jPanel21.setLayout(new BorderLayout());
        this.jListSelected1.setSelectionMode(0);
        this.jListSelected1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                EqBuilder.this.jListSelected1MouseClicked(mouseEvent);
            }
        });
        this.jListSelected1.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (EqBuilder.this.jListSelected1.getSelectedIndex() >= 0) {
                    EqBuilder.this.jListSelected1.ensureIndexIsVisible(EqBuilder.this.jListSelected1.getSelectedIndex());
                }
            }
        });
        this.jScroll_ListSelected1.setViewportView(this.jListSelected1);
        this.jPanel21.add((Component)new JLabel(PropertyFactory.getString("in_EqBuilder_Sel1"), 0), "North");
        this.jPanel21.add((Component)this.jScroll_ListSelected1, "Center");
        this.jPanelSelected1.add(this.jPanel21);
        this.jPanelSelections.add(this.jPanelSelected1);
        this.jPanelSelected2.setLayout(new BoxLayout(this.jPanelSelected2, 0));
        this.jPanelButtons2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.anchor = 18;
        gridBagConstraints3.gridy = 0;
        this.jPanelButtons2.add((Component)new Box.Filler(jLabel.getMinimumSize(), jLabel.getPreferredSize(), jLabel.getMaximumSize()), gridBagConstraints3);
        EqBuilder.setGuiTextInfo(this.jButtonAdd2, "Add2");
        this.jButtonAdd2.setPreferredSize(new Dimension(81, 27));
        this.jButtonAdd2.setMaximumSize(new Dimension(81, 27));
        this.jButtonAdd2.setMinimumSize(new Dimension(81, 27));
        this.jButtonAdd2.setEnabled(false);
        this.jButtonAdd2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EqBuilder.this.jButtonAdd2ActionPerformed();
            }
        });
        this.jButtonAdd2.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                EqBuilder.this.jButtonAdd2ActionPerformed();
            }
        });
        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.anchor = 18;
        gridBagConstraints3.gridy = 1;
        this.jPanelButtons2.add((Component)this.jButtonAdd2, gridBagConstraints3);
        EqBuilder.setGuiTextInfo(this.jButtonRemove2, "Remove2");
        this.jButtonRemove2.setPreferredSize(new Dimension(81, 27));
        this.jButtonRemove2.setEnabled(false);
        this.jButtonRemove2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EqBuilder.this.jButtonRemove2ActionPerformed();
            }
        });
        this.jButtonRemove2.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                EqBuilder.this.jButtonRemove2ActionPerformed();
            }
        });
        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridy = 2;
        this.jPanelButtons2.add((Component)this.jButtonRemove2, gridBagConstraints3);
        this.jPanel22.add(this.jPanelButtons2);
        this.jPanelSelected2.add(this.jPanel22);
        this.jPanel23.setLayout(new BorderLayout());
        this.jListSelected2.setSelectionMode(0);
        this.jListSelected2.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                EqBuilder.this.jListSelected2MouseClicked(mouseEvent);
            }
        });
        this.jListSelected2.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (EqBuilder.this.jListSelected2.getSelectedIndex() >= 0) {
                    EqBuilder.this.jListSelected2.ensureIndexIsVisible(EqBuilder.this.jListSelected2.getSelectedIndex());
                }
            }
        });
        this.jScroll_ListSelected2.setViewportView(this.jListSelected2);
        this.jPanel23.add((Component)new JLabel(PropertyFactory.getString("in_EqBuilder_Sel2"), 0), "North");
        this.jPanel23.add((Component)this.jScroll_ListSelected2, "Center");
        this.jPanelSelected2.add(this.jPanel23);
        this.jPanelSelections.add(this.jPanelSelected2);
        this.jPanel5.add(this.jPanelSelections);
        this.jSplitPane3.setRightComponent(this.jPanel5);
        this.jPanelModifiers.add(this.jSplitPane3);
        this.jSplitPane2.setRightComponent(this.jPanelModifiers);
        this.jPanel1.add((Component)this.jSplitPane2, "Center");
        this.add((Component)this.jPanel1, "Center");
        this.jComboBoxSize.setModel(new DefaultComboBoxModel<String>(EqBuilder.populateSizeModel()));
        this.jSplitPane2.setDividerLocation(SettingsHandler.getCustomizerSplit1());
        this.jSplitPane3.setDividerLocation(SettingsHandler.getCustomizerSplit2());
        this.jScroll_ListAvailable.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                Dimension dimension = EqBuilder.this.jScroll_ListAvailable.getSize();
                Dimension dimension2 = EqBuilder.this.jListAvailable.getSize();
                if (dimension2.getWidth() < dimension.getWidth()) {
                    EqBuilder.this.jListAvailable.setSize((int)dimension.getWidth(), (int)dimension2.getHeight());
                    int[] nArray = new int[]{EqBuilder.this.jListAvailable.getColumnCount() - 1};
                    EqBuilder.this.jListAvailable.setOptimalColumnWidths(nArray);
                }
            }
        });
    }

    private static String[] populateSizeModel() {
        String[] stringArray = new String[SettingsHandler.getGame().getSizeAdjustmentListSize()];
        for (int i = 0; i < SettingsHandler.getGame().getSizeAdjustmentListSize(); ++i) {
            stringArray[i] = SettingsHandler.getGame().getSizeAdjustmentAtIndex(i).getDisplayName();
        }
        return stringArray;
    }

    private void jButtonAdd1ActionPerformed() {
        this.addButton(true);
    }

    private void jButtonAdd2ActionPerformed() {
        this.addButton(false);
    }

    private void jButtonCancelActionPerformed() {
        this.doCleanUp();
        ((EQFrame)this.getRootPane().getParent()).exitItem_actionPerformed(true);
    }

    private void jButtonCostActionPerformed() {
        InputInterface inputInterface = InputFactory.getInputInstance();
        Object object = inputInterface.showInputDialog(null, "Enter Item's New Cost", "PCGen", MessageType.INFORMATION, null, this.aNewEq.getCost(this.aPC).toString());
        if (object != null) {
            String string = ((String)object).trim();
            try {
                BigDecimal bigDecimal = new BigDecimal(string);
                if (bigDecimal.doubleValue() < 0.0) {
                    this.errorDialog("Cost cannot be negative!");
                    return;
                }
                this.aNewEq.setCostMod("0");
                this.aNewEq.setCostMod(bigDecimal.subtract(this.aNewEq.getCost(this.aPC)));
                this.showItemInfo(this.aPC);
            }
            catch (Exception exception) {
                this.errorDialog("Invalid number!");
            }
        }
    }

    private void jButtonNameActionPerformed() {
        InputInterface inputInterface;
        Object object;
        String string = this.customName;
        if (string.length() == 0) {
            string = this.aNewEq.getItemNameFromModifiers();
        }
        if ((object = (inputInterface = InputFactory.getInputInstance()).showInputDialog(null, "Enter the new name", "PCGen", MessageType.INFORMATION, null, string)) != null) {
            String string2 = ((String)object).trim();
            if (string2.indexOf(124) >= 0 || string2.indexOf(58) >= 0 || string2.indexOf(59) >= 0) {
                this.errorDialog("Invalid character in string! You cannot use '|', ':' or ';' in this entry");
            } else {
                this.customName = string2;
                StringBuffer stringBuffer = new StringBuffer("(").append(this.aNewEq.getItemNameFromModifiers()).append(")");
                block3: for (int i = 0; i < stringBuffer.length(); ++i) {
                    switch (stringBuffer.charAt(i)) {
                        case ':': 
                        case ';': 
                        case '|': {
                            stringBuffer.setCharAt(i, '@');
                            continue block3;
                        }
                    }
                }
                if (!stringBuffer.toString().toUpperCase().startsWith("Generic Item".toUpperCase())) {
                    this.aNewEq.addToListFor(ListKey.SPECIAL_PROPERTIES, SpecialProperty.createFromLst(stringBuffer.toString()));
                }
                SizeAdjustment sizeAdjustment = SettingsHandler.getGame().getSizeAdjustmentAtIndex(this.getItemSize());
                this.aNewEq.resizeItem(this.aPC, sizeAdjustment);
                this.showItemInfo(this.aPC);
            }
        }
    }

    private void jButtonOkActionPerformed(boolean bl) {
        String string = this.aNewEq.getKeyName();
        if (this.customName.length() != 0) {
            string = this.customName;
        }
        if (this.aNewEq.isWeapon() && !this.aNewEq.isMelee() && !this.aNewEq.isRanged()) {
            this.informationDialog("Weapons must either be Melee or Ranged");
            return;
        }
        if (string.toUpperCase().startsWith("Generic Item".toUpperCase())) {
            this.informationDialog("You must rename this item!");
            return;
        }
        if (Globals.getContext().ref.silentlyGetConstructedCDOMObject(Equipment.class, string) != null) {
            this.informationDialog("There is already an existing item: " + string);
            return;
        }
        this.aNewEq.setName(string);
        this.aNewEq.put(StringKey.OUTPUT_NAME, string);
        this.aNewEq.removeType(Type.AUTO_GEN);
        this.aNewEq.removeType(Type.STANDARD);
        if (!this.aNewEq.isType("Custom")) {
            this.aNewEq.addType(Type.CUSTOM);
        }
        if (this.aNewEq.getSafe(ObjectKey.MOD_CONTROL).getModifiersRequired() && this.aNewEq.getEqModifierList(true).size() == 0 && this.aNewEq.getEqModifierList(false).size() == 0) {
            this.errorDialog("You must add at least 1 modifier to this item first.");
            return;
        }
        if (this.aNewEq.getBaseItemName().toUpperCase().startsWith("Generic Item".toUpperCase())) {
            this.aNewEq.remove(ObjectKey.BASE_ITEM);
        }
        Globals.getContext().ref.importObject(this.aNewEq);
        PCGen_Frame1.getInst().eqList_Changed(this.aNewEq, bl);
        this.doCleanUp();
        ((EQFrame)this.getRootPane().getParent()).exitItem_actionPerformed(false);
    }

    private void jButtonRemove1ActionPerformed() {
        this.jButtonRemove1.setEnabled(false);
        this.removeButton(this.listModel1, this.jListSelected1.getSelectedIndex(), true);
    }

    private void jButtonRemove2ActionPerformed() {
        this.jButtonRemove2.setEnabled(false);
        this.removeButton(this.listModel2, this.jListSelected2.getSelectedIndex(), false);
    }

    private void jButtonSPropActionPerformed() {
        String string;
        InputInterface inputInterface = InputFactory.getInputInstance();
        Object object = inputInterface.showInputDialog(null, "Enter Special Property", "PCGen", MessageType.INFORMATION, null, this.aNewEq.getRawSpecialProperties());
        if (object == null) {
            object = new String("");
        }
        if ((string = ((String)object).trim()).indexOf(124) >= 0 || string.indexOf(58) >= 0 || string.indexOf(59) >= 0) {
            this.errorDialog("Invalid character in string! You cannot use '|', ':' or ';' in this entry");
        } else {
            this.aNewEq.removeListFor(ListKey.SPECIAL_PROPERTIES);
            if (!string.equals("")) {
                this.aNewEq.addToListFor(ListKey.SPECIAL_PROPERTIES, SpecialProperty.createFromLst(string));
            }
            SizeAdjustment sizeAdjustment = SettingsHandler.getGame().getSizeAdjustmentAtIndex(this.getItemSize());
            this.aNewEq.resizeItem(this.aPC, sizeAdjustment);
            this.showItemInfo(this.aPC);
        }
    }

    private void jButtonSpellActionPerformed(EquipmentModifier equipmentModifier, String string) {
        Object object;
        Object object2;
        ArrayList<String> arrayList = null;
        ArrayList<String> arrayList2 = null;
        boolean bl = true;
        int n = 0;
        if (string.length() != 0) {
            object2 = new StringTokenizer(string, "|", false);
            block6: while (((StringTokenizer)object2).hasMoreTokens()) {
                object = ((StringTokenizer)object2).nextToken();
                if (((String)object).startsWith("CLASS=")) {
                    if (arrayList == null) {
                        arrayList = new ArrayList<String>();
                    }
                    arrayList.add(((String)object).substring(6));
                    continue;
                }
                if (((String)object).startsWith("LEVEL=")) {
                    if (arrayList2 == null) {
                        arrayList2 = new ArrayList<String>();
                    }
                    arrayList2.add(((String)object).substring(6));
                    continue;
                }
                if (((String)object).startsWith("SPELLBOOKS=")) {
                    switch (((String)object).charAt(11)) {
                        case 'Y': {
                            n = 1;
                            continue block6;
                        }
                        case 'N': {
                            n = -1;
                            continue block6;
                        }
                    }
                    n = 0;
                    continue;
                }
                if (!((String)object).equals("METAMAGIC=N")) continue;
                bl = false;
            }
        }
        object2 = new ChooseSpellDialog((JFrame)Utility.getParentNamed(this.getParent(), EQFrame.class.getName()), this.aPC, this.eqType, bl, arrayList, arrayList2, n, equipmentModifier.getSafe(StringKey.CHOICE_STRING));
        ((Dialog)object2).setVisible(true);
        if (!((ChooseSpellDialog)object2).getWasCancelled()) {
            Comparable<Integer> comparable;
            object = ((ChooseSpellDialog)object2).getCastingClass();
            Spell spell = ((ChooseSpellDialog)object2).getSpell();
            String string2 = ((ChooseSpellDialog)object2).getVariant();
            String string3 = ((ChooseSpellDialog)object2).getSpellType();
            int n2 = ((ChooseSpellDialog)object2).getBaseSpellLevel();
            int n3 = ((ChooseSpellDialog)object2).getCasterLevel();
            Object[] objectArray = ((ChooseSpellDialog)object2).getMetamagicFeats();
            int n4 = -1;
            Integer n5 = equipmentModifier.get(IntegerKey.MIN_CHARGES);
            if (n5 != null && n5 > 0) {
                comparable = equipmentModifier.get(IntegerKey.MAX_CHARGES);
                while (true) {
                    String string4;
                    InputInterface inputInterface;
                    Object object3;
                    if ((object3 = (inputInterface = InputFactory.getInputInstance()).showInputDialog(null, string4 = "Enter Number of Charges (" + Integer.toString(n5) + "-" + Integer.toString((Integer)comparable) + ")", "PCGen", MessageType.INFORMATION, null, Integer.toString((Integer)comparable))) == null) {
                        continue;
                    }
                    try {
                        String string5 = ((String)object3).trim();
                        n4 = Integer.parseInt(string5);
                        if (n4 < n5) continue;
                        if (n4 <= (Integer)comparable) break;
                    }
                    catch (Exception exception) {}
                }
            }
            if ((comparable = this.aNewEq.getEqModifierKeyed(equipmentModifier.getKeyName(), true)) == null) {
                this.aNewEq.addEqModifier(equipmentModifier, true, this.aPC);
            }
            comparable = this.aNewEq.getEqModifierKeyed(equipmentModifier.getKeyName(), true);
            EqModSpellInfo.setSpellInfo(this.aNewEq, comparable, (PObject)object, spell, string2, string3, n2, n3, objectArray, n4);
            this.updateDisplay(true);
        }
    }

    private void jButtonWeightActionPerformed() {
        InputInterface inputInterface = InputFactory.getInputInstance();
        Object object = inputInterface.showInputDialog(null, "Enter Item's New Weight", "PCGen", MessageType.INFORMATION, null, this.aNewEq.getWeight(this.aPC).toString());
        if (object != null) {
            String string = ((String)object).trim();
            try {
                BigDecimal bigDecimal = new BigDecimal(Globals.getGameModeUnitSet().convertWeightFromUnitSet(new Double(string)));
                if (bigDecimal.doubleValue() < 0.0) {
                    this.errorDialog("Weight cannot be negative!");
                    return;
                }
                this.aNewEq.put(ObjectKey.WEIGHT_MOD, BigDecimal.ZERO);
                this.aNewEq.put(ObjectKey.WEIGHT_MOD, bigDecimal.subtract(new BigDecimal(this.aNewEq.getWeightAsDouble(this.aPC))));
                this.showItemInfo(this.aPC);
            }
            catch (Exception exception) {
                this.errorDialog("Invalid number!");
            }
        }
    }

    private void jButtonDamageActionPerformed() {
        InputInterface inputInterface = InputFactory.getInputInstance();
        Object object = inputInterface.showInputDialog(null, "Select the new damage for this weapon", "PCGen", MessageType.INFORMATION, null, this.aNewEq.getDamage(this.aPC));
        if (object != null) {
            String string = ((String)object).trim();
            this.aNewEq.put(StringKey.DAMAGE_OVERRIDE, string);
            this.showItemInfo(this.aPC);
        }
    }

    private void jComboBoxSizeActionPerformed() {
        if (this.jComboBoxSize.getSelectedIndex() >= 0 && this.aNewEq != null) {
            SizeAdjustment sizeAdjustment = SettingsHandler.getGame().getSizeAdjustmentAtIndex(this.getItemSize());
            this.aNewEq.resizeItem(this.aPC, sizeAdjustment);
            this.showItemInfo(this.aPC);
        }
    }

    private void jListAvailableMouseClicked(MouseEvent mouseEvent) {
        ListSelectionModel listSelectionModel = this.jListAvailable.getSelectionModel();
        int n = listSelectionModel.getMinSelectionIndex();
        if (n >= 0) {
            this.jButtonAdd1.setEnabled(sorter.getValueAt(n, 0).equals("Y"));
            this.jButtonAdd2.setEnabled(sorter.getValueAt(n, 1).equals("Y"));
            if (mouseEvent.getClickCount() == 2) {
                if (this.jButtonAdd1.isEnabled() && !this.jButtonAdd2.isEnabled()) {
                    this.jButtonAdd1ActionPerformed();
                } else if (!this.jButtonAdd1.isEnabled() && this.jButtonAdd2.isEnabled()) {
                    this.jButtonAdd2ActionPerformed();
                }
            }
        }
    }

    private void jListSelected1MouseClicked(MouseEvent mouseEvent) {
        if (this.jListSelected1.getSelectedIndex() != -1) {
            this.jButtonRemove1.setEnabled(true);
            if (mouseEvent.getClickCount() == 2) {
                this.jButtonRemove1ActionPerformed();
            }
        }
    }

    private void jListSelected2MouseClicked(MouseEvent mouseEvent) {
        if (this.jListSelected2.getSelectedIndex() != -1) {
            this.jButtonRemove2.setEnabled(true);
            if (mouseEvent.getClickCount() == 2) {
                this.jButtonRemove2ActionPerformed();
            }
        }
    }

    private void loadScreenInfo() {
        Object object;
        int n;
        String string = "EqBuilder";
        string = this.dataModel instanceof EquipmentModModelDouble ? string + "A" : string + "C";
        int n2 = 0;
        for (n = this.jListAvailable.getColumnCount(); n > 0; --n) {
            object = this.jListAvailable.getColumnModel().getColumn(n - 1);
            n2 = Globals.getCustColumnWidth(string, n - 1);
            if (n2 == 0) break;
            ((TableColumn)object).setPreferredWidth(n2);
        }
        if (n2 == 0) {
            object = new int[n];
            for (n = this.jListAvailable.getColumnCount(); n > 0; --n) {
                object[n - 1] = n - 1;
            }
            this.jListAvailable.setOptimalColumnWidths((int[])object);
        }
    }

    private boolean needRebuild(boolean bl) {
        boolean bl2 = false;
        int n = bl ? 0 : 1;
        List<String> list = null;
        List list2 = this.newTypeList[n];
        EquipmentModifier equipmentModifier = this.aNewEq.getEqModifierKeyed("ADDTYPE", bl);
        if (equipmentModifier != null) {
            list = this.aNewEq.getAssociationList(equipmentModifier);
        }
        if (list2 == null && equipmentModifier != null || list2 != null && equipmentModifier == null) {
            bl2 = true;
        } else if (list2 != null && list != null) {
            if (list2.size() != list.size()) {
                bl2 = true;
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    if (list2.contains(list.get(i))) continue;
                    bl2 = true;
                    break;
                }
            }
        }
        this.newTypeList[n] = list;
        return bl2;
    }

    private void removeAddedType(String string) {
        EquipmentModifier equipmentModifier = this.aNewEq.getEqModifierKeyed("ADDTYPE", true);
        if (equipmentModifier != null) {
            this.aNewEq.removeAssociation((CDOMObject)equipmentModifier, string);
            if (!this.aNewEq.hasAssociations(equipmentModifier)) {
                this.aNewEq.removeEqModifier(equipmentModifier, true, this.aPC);
            }
        }
    }

    private void removeButton(DefaultListModel defaultListModel, int n, boolean bl) {
        this.removeElement(defaultListModel, n, bl);
    }

    private void removeElement(DefaultListModel defaultListModel, int n, boolean bl) {
        if (n >= 0 && n < defaultListModel.size()) {
            EquipmentModifier equipmentModifier = (EquipmentModifier)defaultListModel.elementAt(n);
            if (this.baseEquipment.getEqModifierList(bl).contains(equipmentModifier)) {
                this.errorDialog("That modifier is part of the base item. You cannot remove it.");
                return;
            }
            this.aNewEq.setCostMod("0");
            this.aNewEq.removeEqModifier(equipmentModifier, bl, this.aPC);
            this.setEquipment(this.aNewEq, true);
            this.updateDisplay(bl);
            if (this.aNewEq.isDouble() && equipmentModifier.getSafe(ObjectKey.ASSIGN_TO_ALL).booleanValue()) {
                this.aNewEq.removeEqModifier(equipmentModifier, !bl, this.aPC);
                this.updateDisplay(!bl);
            }
            ((EQFrame)this.getRootPane().getParent()).setVisible(true);
            ((EQFrame)this.getRootPane().getParent()).toFront();
        }
    }

    private void saveScreenInfo() {
        String string = "EqBuilder";
        string = this.dataModel instanceof EquipmentModModelDouble ? string + "A" : string + "C";
        SettingsHandler.setCustomizerSplit1(this.jSplitPane2.getDividerLocation());
        SettingsHandler.setCustomizerSplit2(this.jSplitPane3.getDividerLocation());
        for (int i = this.jListAvailable.getColumnCount(); i > 0; --i) {
            TableColumn tableColumn = this.jListAvailable.getColumnModel().getColumn(i - 1);
            Globals.setCustColumnWidth(string, i - 1, tableColumn.getWidth());
        }
    }

    private void showItemInfo(PlayerCharacter playerCharacter) {
        StringBuffer stringBuffer = new StringBuffer(140);
        stringBuffer.append("Base Item: ").append(this.baseEquipment.getName()).append(Constants.s_LINE_SEP);
        if (this.customName.length() != 0) {
            stringBuffer.append("Name: ").append(this.customName).append(Constants.s_LINE_SEP);
        }
        String string = "";
        if (this.needRebuild(true) || this.needRebuild(false)) {
            Object object;
            if (this.aNewEq.isContainer()) {
                // empty if block
            }
            if (this.aNewEq.isWeapon() && this.aNewEq.getDamage(playerCharacter).length() == 0) {
                NewWeaponInfoDialog newWeaponInfoDialog = new NewWeaponInfoDialog((JFrame)Utility.getParentNamed(this.getParent(), EQFrame.class.getName()));
                newWeaponInfoDialog.setVisible(true);
                if (!newWeaponInfoDialog.getWasCancelled()) {
                    object = new StringBuffer("PCGENi_WEAPON");
                    ((StringBuffer)object).append("|DAMAGE=").append(newWeaponInfoDialog.getDamage());
                    ((StringBuffer)object).append("|CRITRANGE=").append(newWeaponInfoDialog.getCritRange());
                    ((StringBuffer)object).append("|CRITMULT=").append(newWeaponInfoDialog.getCritMultiplier());
                    this.aNewEq.addEqModifiers(((StringBuffer)object).toString(), true);
                } else {
                    this.removeAddedType("WEAPON");
                }
            }
            if (this.aNewEq.isWeapon() && this.aNewEq.isRanged()) {
                while (this.aNewEq.getRange(playerCharacter) == 0) {
                    object = InputFactory.getInputInstance();
                    Object object2 = object.showInputDialog(null, "Enter the range", "PCGen", MessageType.INFORMATION, null, null);
                    if (object2 != null) {
                        String string2 = ((String)object2).trim();
                        if (Delta.decode(string2) <= 0) continue;
                        this.aNewEq.removeEqModifiers("PCGENi_WEAPON|RANGE=", true, this.aPC);
                        this.aNewEq.addEqModifiers("PCGENi_WEAPON|RANGE=" + string2, true);
                        continue;
                    }
                    this.removeAddedType("RANGED");
                    break;
                }
            }
            if (!this.aNewEq.isWeapon() || !this.aNewEq.isRanged()) {
                this.removeAddedType("RANGED");
                this.aNewEq.removeEqModifiers("PCGENi_WEAPON|RANGE=", true, this.aPC);
            }
            if (!this.aNewEq.isArmor() || this.aNewEq.getMaxDex(playerCharacter).intValue() == Constants.MAX_MAXDEX.intValue()) {
                // empty if block
            }
            if (this.aNewEq.getBaseItemName().toUpperCase().startsWith("Generic Item".toUpperCase())) {
                this.aNewEq.remove(ObjectKey.BASE_ITEM);
            }
            this.setEquipment(this.aNewEq, true);
            return;
        }
        try {
            if (this.aNewEq != null) {
                int n = this.aNewEq.calcPlusForCosting();
                stringBuffer.append("New Item: ");
                stringBuffer.append(this.aNewEq.nameItemFromModifiers(playerCharacter));
                stringBuffer.append(Constants.s_LINE_SEP);
                stringBuffer.append("Cost: ");
                stringBuffer.append(this.aNewEq.getCost(playerCharacter).toString());
                if (n != 0) {
                    stringBuffer.append(" (plus: ").append(n).append(')');
                }
                double d = this.aNewEq.getWeight(playerCharacter).doubleValue();
                stringBuffer.append(", Weight: ");
                stringBuffer.append(Globals.getGameModeUnitSet().displayWeightInUnitSet(d));
                stringBuffer.append(Globals.getGameModeUnitSet().getWeightUnit());
                if (this.aNewEq.isArmor() || this.aNewEq.isShield()) {
                    stringBuffer.append(", AC: ").append(this.aNewEq.getACMod(playerCharacter).toString());
                    stringBuffer.append(", ACCheck: ").append(this.aNewEq.acCheck(playerCharacter).toString());
                    stringBuffer.append(", Fail: ").append(this.aNewEq.spellFailure(playerCharacter).toString());
                    stringBuffer.append(", Max Dex: ").append(this.aNewEq.getMaxDex(playerCharacter).toString());
                }
                if (this.aNewEq.isWeapon()) {
                    String string3;
                    stringBuffer.append(", Damage: ").append(this.aNewEq.getDamage(playerCharacter));
                    int n2 = this.aNewEq.getBonusToDamage(playerCharacter, true);
                    if (n2 != 0) {
                        stringBuffer.append(Delta.toString(n2));
                    }
                    if ((n2 = this.aNewEq.getBonusToHit(playerCharacter, true)) != 0) {
                        stringBuffer.append(" (").append(Delta.toString(n2)).append(" to hit)");
                    }
                    if (this.aNewEq.isDouble() && (string3 = this.aNewEq.getAltDamage(playerCharacter)).length() != 0) {
                        stringBuffer.append('/').append(string3);
                        n2 = this.aNewEq.getBonusToDamage(playerCharacter, false);
                        if (n2 != 0) {
                            stringBuffer.append(Delta.toString(n2));
                        }
                        if ((n2 = this.aNewEq.getBonusToHit(playerCharacter, false)) != 0) {
                            stringBuffer.append(" (").append(Delta.toString(n2)).append(" to hit)");
                        }
                    }
                    int n3 = 21 - playerCharacter.getCritRange(this.aNewEq, true);
                    stringBuffer.append(" (").append(String.valueOf(n3));
                    if (n3 < 20) {
                        stringBuffer.append("-20");
                    }
                    stringBuffer.append(' ').append(this.aNewEq.getCritMult());
                    if (this.aNewEq.isDouble()) {
                        stringBuffer.append('/');
                        int n4 = 21 - playerCharacter.getCritRange(this.aNewEq, false);
                        if (n4 != n3) {
                            stringBuffer.append(String.valueOf(n4));
                            if (n4 < 20) {
                                stringBuffer.append("-20");
                            }
                            stringBuffer.append(' ');
                        }
                        stringBuffer.append(this.aNewEq.getAltCritMult());
                    }
                    stringBuffer.append(')');
                    if (this.aNewEq.isRanged()) {
                        stringBuffer.append(", Range: ").append(this.aNewEq.getRange(playerCharacter).toString());
                    }
                }
                if ((string = this.aNewEq.getSpecialProperties(playerCharacter)).length() != 0) {
                    stringBuffer.append(Constants.s_LINE_SEP).append("SPROP: ").append(string);
                }
            }
            this.jItemDesc.setText(stringBuffer.toString());
        }
        catch (Exception exception) {
            this.errorDialog("ERROR: Exception type:" + exception.getClass().getName() + Constants.s_LINE_SEP + "Message:" + exception.getMessage());
            Logging.errorPrint(stringBuffer.toString(), exception);
        }
    }

    private void updateDisplay(boolean bl) {
        this.updateDisplay(bl, true);
    }

    private void updateDisplay(boolean bl, boolean bl2) {
        List<EquipmentModifier> list = this.aNewEq.getEqModifierList(bl);
        DefaultListModel defaultListModel = bl ? this.listModel1 : this.listModel2;
        defaultListModel.clear();
        for (EquipmentModifier equipmentModifier : list) {
            defaultListModel.addElement(equipmentModifier);
        }
        if (bl2) {
            this.dataModel.fireTableDataChanged();
            this.showItemInfo(this.aPC);
        }
        ((EQFrame)this.getRootPane().getParent()).setVisible(true);
        ((EQFrame)this.getRootPane().getParent()).toFront();
    }

    private void errorDialog(String string) {
        ShowMessageDelegate.showMessageDialog(string, "PCGen", MessageType.ERROR, this);
    }

    private void informationDialog(String string) {
        ShowMessageDelegate.showMessageDialog(string, "PCGen", MessageType.INFORMATION, this);
    }

    static {
        validEqTypes = new String[]{"potion", "scroll", "wand", "ring"};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class EquipmentModModelDouble
    extends EquipmentModModel {
        private static final int COL_Q1 = 0;
        private static final int COL_Q2 = 1;
        private static final int COL_NAME = 2;
        private static final int COL_SA = 3;
        private static final int COL_COST = 4;
        private static final int COL_PREREQ = 5;
        private static final int COL_SOURCE = 6;
        private static final int COL_COUNT = 7;

        @Override
        protected Object getEqModTableValueAt(PlayerCharacter playerCharacter, int n, int n2) {
            EquipmentModifier equipmentModifier;
            try {
                equipmentModifier = this.getDisplayModifiers().get(n);
            }
            catch (Exception exception) {
                return null;
            }
            switch (n2) {
                case 0: {
                    return this.getHead1QualifiesValue(equipmentModifier);
                }
                case 1: {
                    return this.getHead2QualifiesValue(equipmentModifier);
                }
                case 2: {
                    return this.getNameValue(equipmentModifier);
                }
                case 5: {
                    return this.getPrereqValue(playerCharacter, equipmentModifier);
                }
                case 4: {
                    return this.getCostValue(equipmentModifier);
                }
                case 3: {
                    return this.getSaValue(equipmentModifier);
                }
                case 6: {
                    return this.getSourceValue(equipmentModifier);
                }
            }
            Logging.errorPrint("In EqBuilder.getEqModTableValueAt the column " + n2 + " is not handled.");
            return "";
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return 7;
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "Q1";
                }
                case 1: {
                    return "Q2";
                }
                case 2: {
                    return "Name";
                }
                case 5: {
                    return "Prereqs";
                }
                case 4: {
                    return "Cost";
                }
                case 3: {
                    return "Special Properties";
                }
                case 6: {
                    return "Source";
                }
            }
            return "";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class EquipmentModModelSingle
    extends EquipmentModModel {
        private static final int COL_Q1 = 0;
        private static final int COL_NAME = 1;
        private static final int COL_SA = 2;
        private static final int COL_COST = 3;
        private static final int COL_PREREQ = 4;
        private static final int COL_SOURCE = 5;
        private static final int COL_COUNT = 6;

        @Override
        protected Object getEqModTableValueAt(PlayerCharacter playerCharacter, int n, int n2) {
            EquipmentModifier equipmentModifier;
            try {
                equipmentModifier = this.getDisplayModifiers().get(n);
            }
            catch (Exception exception) {
                return null;
            }
            switch (n2) {
                case 0: {
                    return this.getHead1QualifiesValue(equipmentModifier);
                }
                case 1: {
                    return this.getNameValue(equipmentModifier);
                }
                case 4: {
                    return this.getPrereqValue(playerCharacter, equipmentModifier);
                }
                case 3: {
                    return this.getCostValue(equipmentModifier);
                }
                case 2: {
                    return this.getSaValue(equipmentModifier);
                }
                case 5: {
                    return this.getSourceValue(equipmentModifier);
                }
            }
            Logging.errorPrint("In EqBuilder.getEqModTableValueAt the column " + n2 + " is not handled.");
            return "";
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return String.class;
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "Q";
                }
                case 1: {
                    return "Name";
                }
                case 4: {
                    return "Prereqs";
                }
                case 3: {
                    return "Cost";
                }
                case 2: {
                    return "Special Properties";
                }
                case 5: {
                    return "Source";
                }
            }
            return "";
        }

        @Override
        public int getColumnCount() {
            return 6;
        }

        public String toString() {
            return "EquipmentModModelSingle";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class EquipmentModModel
    extends AbstractTableModel {
        static final long serialVersionUID = -369105812700996734L;
        private Object[] lastColValue = new Object[6];
        private int lastRow = -1;
        private List<EquipmentModifier> displayModifiers = new ArrayList<EquipmentModifier>();

        private EquipmentModModel() {
        }

        @Override
        public int getRowCount() {
            return this.displayModifiers.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 < 0 || n2 >= this.getColumnCount()) {
                return "Out of Bounds";
            }
            if (n >= this.getRowCount()) {
                return null;
            }
            if (n != this.lastRow) {
                this.lastColValue = new String[this.getColumnCount()];
                this.lastRow = n;
            } else if (this.lastColValue[n2] != null) {
                return this.lastColValue[n2];
            }
            Object object = this.getEqModTableValueAt(EqBuilder.this.aPC, n, n2);
            try {
                this.lastColValue[n2] = object;
            }
            catch (Exception exception) {
                // empty catch block
            }
            return object;
        }

        protected abstract Object getEqModTableValueAt(PlayerCharacter var1, int var2, int var3);

        protected Object getSourceValue(EquipmentModifier equipmentModifier) {
            String string = equipmentModifier.getDefaultSourceString();
            return string;
        }

        protected Object getSaValue(EquipmentModifier equipmentModifier) {
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = true;
            for (SpecialProperty specialProperty : equipmentModifier.getSafeListFor(ListKey.SPECIAL_PROPERTIES)) {
                if (!bl) {
                    stringBuilder.append(", ");
                }
                bl = false;
                stringBuilder.append(specialProperty.getDisplayName());
            }
            return stringBuilder.toString();
        }

        protected Object getCostValue(EquipmentModifier equipmentModifier) {
            Formula formula;
            Formula formula2;
            int n = equipmentModifier.getSafe(IntegerKey.PLUS);
            StringBuffer stringBuffer = new StringBuffer(20);
            if (n != 0) {
                stringBuffer.append("Plus:").append(n);
            }
            if (!"0".equals((formula2 = equipmentModifier.getSafe(FormulaKey.BASECOST)).toString())) {
                if (stringBuffer.length() != 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append("Precost:").append(formula2);
            }
            if (!"0".equals((formula = equipmentModifier.getSafe(FormulaKey.BASECOST)).toString())) {
                if (stringBuffer.length() != 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append("Cost:").append(formula);
            }
            String string = stringBuffer.toString();
            return string;
        }

        protected Object getPrereqValue(PlayerCharacter playerCharacter, EquipmentModifier equipmentModifier) {
            String string = PrerequisiteUtilities.preReqHTMLStringsForList(playerCharacter, EqBuilder.this.aNewEq, equipmentModifier.getPrerequisiteList(), true);
            return string;
        }

        protected Object getNameValue(EquipmentModifier equipmentModifier) {
            String string = equipmentModifier.getDisplayName();
            if (equipmentModifier.isType("BaseMaterial")) {
                string = "*" + string;
            }
            return string;
        }

        protected Object getHead2QualifiesValue(EquipmentModifier equipmentModifier) {
            String string = EqBuilder.this.aNewEq != null && EqBuilder.this.aNewEq.canAddModifier(equipmentModifier, false) ? "Y" : "N";
            return string;
        }

        protected Object getHead1QualifiesValue(EquipmentModifier equipmentModifier) {
            String string = EqBuilder.this.aNewEq != null && EqBuilder.this.aNewEq.canAddModifier(equipmentModifier, true) ? "Y" : "N";
            return string;
        }

        private void setFilter(Equipment equipment, int n) {
            List<String> list = equipment.typeList();
            int n2 = this.getRowCount();
            this.displayModifiers.clear();
            if (n2 > 0) {
                this.fireTableRowsDeleted(0, n2 - 1);
            }
            block0: for (EquipmentModifier equipmentModifier : Globals.getContext().ref.getConstructedCDOMObjects(EquipmentModifier.class)) {
                if (!equipment.isVisible(equipmentModifier)) continue;
                if (equipmentModifier.isType("ALL")) {
                    this.displayModifiers.add(equipmentModifier);
                    continue;
                }
                for (String string : list) {
                    if (!equipmentModifier.isType(string)) continue;
                    this.displayModifiers.add(equipmentModifier);
                    continue block0;
                }
            }
            Globals.sortPObjectListByName(this.displayModifiers);
            this.lastRow = -1;
            this.fireTableStructureChanged();
        }

        public List<EquipmentModifier> getDisplayModifiers() {
            return this.displayModifiers;
        }
    }
}

