/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.term;

import java.util.regex.Pattern;
import pcgen.core.PlayerCharacter;
import pcgen.core.spell.Spell;
import pcgen.core.term.BasePCTermEvaluator;
import pcgen.core.term.TermEvaluator;
import pcgen.io.exporttoken.EqTypeToken;
import pcgen.io.exporttoken.Token;

public class PCEqTypeTermEvaluator
extends BasePCTermEvaluator
implements TermEvaluator {
    private final String Digits = "(\\p{Digit}+)";
    private final String HexDigits = "(\\p{XDigit}+)";
    private final String Exp = "[eE][+-]?(\\p{Digit}+)";
    private final String fpRegex = "[\\x00-\\x20]*[+-]?(NaN|Infinity|((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?)|(((0[xX](\\p{XDigit}+)(\\.)?)|(0[xX](\\p{XDigit}+)?(\\.)(\\p{XDigit}+)))[pP][+-]?(\\p{Digit}+)))[fFdD]?))[\\x00-\\x20]*";

    public PCEqTypeTermEvaluator(String string) {
        this.originalText = string;
    }

    public Float resolve(PlayerCharacter playerCharacter) {
        String string = this.evaluate(playerCharacter);
        if (Pattern.matches("[\\x00-\\x20]*[+-]?(NaN|Infinity|((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?)|(((0[xX](\\p{XDigit}+)(\\.)?)|(0[xX](\\p{XDigit}+)?(\\.)(\\p{XDigit}+)))[pP][+-]?(\\p{Digit}+)))[fFdD]?))[\\x00-\\x20]*", string)) {
            return this.convertToFloat(this.originalText, string);
        }
        return Float.valueOf(0.0f);
    }

    public String evaluate(PlayerCharacter playerCharacter) {
        EqTypeToken eqTypeToken = new EqTypeToken();
        return ((Token)eqTypeToken).getToken(this.originalText, playerCharacter, null);
    }

    public String evaluate(PlayerCharacter playerCharacter, Spell spell) {
        return this.evaluate(playerCharacter);
    }

    public boolean isSourceDependant() {
        return false;
    }

    public boolean isStatic() {
        return false;
    }
}

