/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.system;

import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class LoadInfo {
    private SortedMap<Integer, Float> loadScoreList = new TreeMap<Integer, Float>();
    private Float loadScoreMultiplier = new Float(0.0f);
    private int loadMultStep = 10;
    private Map<String, Float> sizeAdjustmentMap = new HashMap<String, Float>();
    private Map<String, LoadMapEntry> loadMultiplierMap = new HashMap<String, LoadMapEntry>();
    private int minScore = 0;
    private int maxScore = 0;
    private String modifyFormula = "";

    public void setLoadScoreMultiplier(Float f) {
        this.loadScoreMultiplier = f;
    }

    public void addLoadScoreValue(int n, Float f) {
        this.loadScoreList.put(n, f);
        if (n > this.maxScore) {
            this.maxScore = n;
        }
        if (n < this.minScore) {
            this.minScore = n;
        }
    }

    public Float getLoadScoreValue(int n) {
        if (n < this.minScore) {
            return new Float(0.0f);
        }
        if (n > this.maxScore) {
            if (this.getLoadMultiplierCount() == 1) {
                return this.getLoadScoreValue(this.minScore);
            }
            return new Float(this.loadScoreMultiplier.doubleValue() * this.getLoadScoreValue(n - this.loadMultStep).doubleValue());
        }
        Float f = (Float)this.loadScoreList.get(n);
        if (f == null) {
            SortedMap<Integer, Float> sortedMap = this.loadScoreList.headMap(n);
            return (Float)this.loadScoreList.get(sortedMap.lastKey());
        }
        return f;
    }

    public void addSizeAdjustment(String string, Float f) {
        this.sizeAdjustmentMap.put(string, f);
    }

    public Float getSizeAdjustment(String string) {
        if (this.sizeAdjustmentMap.containsKey(string)) {
            return this.sizeAdjustmentMap.get(string);
        }
        return null;
    }

    public void addLoadMultiplier(String string, Float f, String string2, Integer n) {
        LoadMapEntry loadMapEntry = new LoadMapEntry(f, string2, n);
        this.loadMultiplierMap.put(string, loadMapEntry);
    }

    public Float getLoadMultiplier(String string) {
        if (this.loadMultiplierMap.containsKey(string)) {
            return this.loadMultiplierMap.get(string).getMuliplier();
        }
        return null;
    }

    public String getLoadMoveFormula(String string) {
        if (this.loadMultiplierMap.containsKey(string)) {
            return this.loadMultiplierMap.get(string).getFormula();
        }
        return "";
    }

    public int getLoadCheckPenalty(String string) {
        if (this.loadMultiplierMap.containsKey(string)) {
            return this.loadMultiplierMap.get(string).getCheckPenalty();
        }
        return 0;
    }

    public void setLoadModifierFormula(String string) {
        this.modifyFormula = string;
    }

    public String getLoadModifierFormula() {
        return this.modifyFormula;
    }

    public int getLoadMultiplierCount() {
        return this.loadMultiplierMap.size();
    }

    public void setLoadMultStep(int n) {
        this.loadMultStep = n;
    }

    private static class LoadMapEntry {
        private Float multiplier;
        private String moveFormula;
        private Integer checkPenalty;

        public LoadMapEntry(Float f, String string, Integer n) {
            this.multiplier = f;
            this.moveFormula = string;
            this.checkPenalty = n;
        }

        public Float getMuliplier() {
            return this.multiplier;
        }

        public String getFormula() {
            return this.moveFormula;
        }

        public int getCheckPenalty() {
            return this.checkPenalty;
        }
    }
}

