/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.npcgen;

import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import pcgen.core.GameMode;
import pcgen.core.SystemCollections;
import pcgen.core.npcgen.AlignGeneratorOption;
import pcgen.core.npcgen.ClassGeneratorOption;
import pcgen.core.npcgen.GenderGeneratorOption;
import pcgen.core.npcgen.GeneratorOption;
import pcgen.core.npcgen.LevelGeneratorOption;
import pcgen.core.npcgen.RaceGeneratorOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OptionHandler
extends DefaultHandler {
    private List<GeneratorOption> theList;
    private GameMode theGameMode = null;
    private boolean theValidFlag = false;
    private GeneratorOption theCurrentOption = null;

    public OptionHandler(GameMode gameMode, List<GeneratorOption> list) {
        this.theGameMode = gameMode;
        this.theList = list;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if ("npcgen_options".equals(string3)) {
            if (attributes != null) {
                String string4 = attributes.getValue("game_mode");
                if (!SystemCollections.getGameModeNamed(string4).equals(this.theGameMode)) {
                    throw new IllegalArgumentException("Incorrect game mode");
                }
                this.theValidFlag = true;
            }
            return;
        }
        if (!this.theValidFlag) {
            throw new SAXException("NPCGen.Options.InvalidFileFormat");
        }
        if ("align".equals(string3)) {
            this.theCurrentOption = new AlignGeneratorOption();
        } else if ("race".equals(string3)) {
            this.theCurrentOption = new RaceGeneratorOption();
        } else if ("gender".equals(string3)) {
            this.theCurrentOption = new GenderGeneratorOption();
        } else if ("class".equals(string3)) {
            this.theCurrentOption = new ClassGeneratorOption();
        } else if ("level".equals(string3)) {
            this.theCurrentOption = new LevelGeneratorOption();
        } else if ("choice".equals(string3)) {
            int n = 1;
            String string5 = attributes.getValue("weight");
            if (string5 != null) {
                n = Integer.parseInt(string5);
            }
            this.theCurrentOption.addChoice(n, attributes.getValue("value"));
        }
        if (!"choice".equals(string3)) {
            this.theCurrentOption.setName(attributes.getValue("name"));
            this.theList.add(this.theCurrentOption);
        }
    }
}

