/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.kit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.Globals;
import pcgen.core.Kit;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.WeaponProf;
import pcgen.core.kit.BaseKit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class KitProf
extends BaseKit {
    private Integer choiceCount;
    private final List<CDOMSingleRef<WeaponProf>> profList = new ArrayList<CDOMSingleRef<WeaponProf>>();
    private Boolean racialProf;
    private transient PObject thePObject = null;
    private transient List<WeaponProf> weaponProfs = null;

    public boolean isRacial() {
        return this.racialProf != null && this.racialProf != false;
    }

    public void setRacialProf(Boolean bl) {
        this.racialProf = bl;
    }

    public String toString() {
        int n = this.profList.size();
        StringBuffer stringBuffer = new StringBuffer(n * 10);
        if (this.getSafeCount() != 1 || n != 1) {
            stringBuffer.append(this.getSafeCount()).append(" of ");
        }
        stringBuffer.append(StringUtil.join(this.profList, ", "));
        return stringBuffer.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean testApply(Kit kit, PlayerCharacter playerCharacter, List<String> list) {
        void var8_15;
        Cloneable cloneable;
        this.thePObject = null;
        this.weaponProfs = null;
        ListKey<String> listKey = ListKey.SELECTED_WEAPON_PROF_BONUS;
        Collection collection = null;
        if (this.isRacial()) {
            cloneable = playerCharacter.getRace();
            if (cloneable == null) {
                list.add("PROF: PC has no race");
                return false;
            }
            if (((CDOMObject)cloneable).getSafeSizeOfListFor(listKey) != 0) {
                list.add("PROF: Race has already selected bonus weapon proficiency");
                return false;
            }
            this.thePObject = cloneable;
            collection = ((CDOMObject)cloneable).getListMods(WeaponProf.STARTING_LIST);
        } else {
            cloneable = playerCharacter.getClassList();
            if (cloneable == null || cloneable.size() == 0) {
                list.add("PROF: No owning class found.");
                return false;
            }
            Object object = null;
            Iterator list22 = cloneable.iterator();
            while (list22.hasNext() && ((collection = ((CDOMObject)(object = (PCClass)list22.next())).getListMods(WeaponProf.STARTING_LIST)) == null || collection.size() <= 0)) {
            }
            this.thePObject = object;
            if (((CDOMObject)object).getSafeSizeOfListFor(listKey) != 0) {
                list.add("PROF: Class has already selected bonus weapon proficiency");
                return false;
            }
        }
        if (collection == null || collection.size() == 0) {
            list.add("PROF: No optional weapon proficiencies");
            return false;
        }
        cloneable = new ArrayList();
        for (CDOMSingleRef cDOMSingleRef : this.profList) {
            WeaponProf weaponProf = (WeaponProf)cDOMSingleRef.resolvesTo();
            boolean bl = false;
            for (CDOMReference cDOMReference : collection) {
                if (!cDOMReference.contains(weaponProf)) continue;
                bl = true;
                cloneable.add(weaponProf.getKeyName());
                break;
            }
            if (bl) continue;
            list.add("PROF: Weapon proficiency \"" + weaponProf.getKeyName() + "\" is not in list of choices");
        }
        int n = this.getSafeCount();
        if (n > cloneable.size()) {
            n = cloneable.size();
        }
        if (n == 0) {
            return false;
        }
        if (n == cloneable.size()) {
            Cloneable cloneable2 = cloneable;
        } else {
            List<String> list2;
            while ((list2 = Globals.getChoiceFromList("Choose Proficiencies", cloneable, new ArrayList(), n)).size() == 0) {
            }
        }
        for (String string : var8_15) {
            WeaponProf weaponProf = Globals.getContext().ref.silentlyGetConstructedCDOMObject(WeaponProf.class, string);
            if (weaponProf == null) continue;
            if (this.weaponProfs == null) {
                this.weaponProfs = new ArrayList<WeaponProf>();
            }
            this.weaponProfs.add(weaponProf);
        }
        return false;
    }

    @Override
    public void apply(PlayerCharacter playerCharacter) {
        for (WeaponProf weaponProf : this.weaponProfs) {
            this.thePObject.addSelectedWeaponProfBonus(weaponProf.getKeyName());
        }
    }

    @Override
    public String getObjectName() {
        return "Proficiencies";
    }

    public void setCount(Integer n) {
        this.choiceCount = n;
    }

    public Integer getCount() {
        return this.choiceCount;
    }

    public int getSafeCount() {
        return this.choiceCount == null ? 1 : this.choiceCount;
    }

    public void addProficiency(CDOMSingleRef<WeaponProf> cDOMSingleRef) {
        this.profList.add(cDOMSingleRef);
    }

    public Collection<CDOMSingleRef<WeaponProf>> getProficiencies() {
        return this.profList;
    }

    public Boolean getRacialProf() {
        return this.racialProf;
    }
}

