/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.chooser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.Ability;
import pcgen.core.AbilityUtilities;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.chooser.AbstractBasicStringChoiceManager;
import pcgen.core.chooser.ChooserUtilities;
import pcgen.core.prereq.PrereqHandler;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatAddChoiceManager
extends AbstractBasicStringChoiceManager {
    public FeatAddChoiceManager(PObject pObject, String string, PlayerCharacter playerCharacter) {
        super(pObject, string, playerCharacter);
        this.setTitle("Add a Feat");
    }

    @Override
    public void getChoices(PlayerCharacter playerCharacter, List<String> list, List<String> list2) {
        for (String string : this.getChoiceList()) {
            Object object;
            Object object2;
            if (string.startsWith("TYPE=") || string.startsWith("TYPE.")) {
                object2 = string.substring(5);
                object = Globals.getAbilityKeyIterator("FEAT");
                while (object.hasNext()) {
                    Ability ability = (Ability)object.next();
                    if (!ability.isType((String)object2) || !playerCharacter.canSelectAbility(ability) || list.contains(ability.toString())) continue;
                    list.add(ability.toString());
                }
                continue;
            }
            object2 = new StringTokenizer(string, ",");
            while (((StringTokenizer)object2).hasMoreElements()) {
                object = (String)((StringTokenizer)object2).nextElement();
                this.addChoiceToAvailable(playerCharacter, list, ((String)object).trim());
            }
        }
        list2.addAll(playerCharacter.getAssociationList(this.pobject));
        this.setPreChooserChoices(list2.size());
    }

    private void addChoiceToAvailable(PlayerCharacter playerCharacter, List<String> list, String string) {
        String string2 = "";
        Ability ability = Globals.getAbilityKeyed("FEAT", string);
        if (ability == null) {
            Logging.errorPrint("Feat not found: " + string);
            return;
        }
        if (!string.equalsIgnoreCase(ability.getKeyName())) {
            string2 = string.substring(ability.getKeyName().length());
            string = ability.getKeyName();
            int n = string2.indexOf(40);
            if (n > -1) {
                string2 = string2.substring(n + 1);
            }
        }
        if (PrereqHandler.passesAll(ability.getPrerequisiteList(), playerCharacter, ability)) {
            if (ability.getSafe(ObjectKey.MULTIPLE_ALLOWED).booleanValue()) {
                int n;
                int n2;
                Ability ability2 = playerCharacter.getFeatKeyed(string);
                if (ability2 != null) {
                    ability = ability2;
                }
                if ((n2 = string2.indexOf(37)) > -1) {
                    string2 = string2.substring(0, n2);
                } else if (string2.length() != 0 && (n = string2.lastIndexOf(41)) > -1) {
                    string2 = string2.substring(0, n);
                }
                ArrayList arrayList = new ArrayList();
                ArrayList arrayList2 = new ArrayList();
                ChooserUtilities.modChoices(ability, arrayList, arrayList2, false, playerCharacter, true, null);
                ArrayList<String> arrayList3 = new ArrayList<String>();
                ArrayList<String> arrayList4 = new ArrayList<String>();
                ChooserUtilities.convertChoiceListToStringList(arrayList, arrayList3);
                ChooserUtilities.convertChoiceListToStringList(arrayList2, arrayList4);
                if (string2.length() != 0) {
                    for (int i = arrayList3.size() - 1; i >= 0; --i) {
                        String string3 = (String)arrayList3.get(i);
                        if (string3.startsWith(string2)) continue;
                        arrayList3.remove(i);
                    }
                    if (n2 == -1 && arrayList3.size() == 0) {
                        arrayList3.add(string2);
                    }
                }
                if (!ability.getSafe(ObjectKey.STACKS).booleanValue()) {
                    Iterator iterator = arrayList4.iterator();
                    while (iterator.hasNext()) {
                        int n3 = arrayList3.indexOf(iterator.next());
                        if (n3 <= -1) continue;
                        arrayList3.remove(n3);
                    }
                }
                Iterator iterator = arrayList3.iterator();
                while (iterator.hasNext()) {
                    list.add(string + "(" + (String)iterator.next() + ")");
                }
            } else if (!playerCharacter.hasRealFeat(Globals.getAbilityKeyed("FEAT", string)) && !playerCharacter.hasFeatAutomatic(string)) {
                list.add(string);
            }
        }
    }

    @Override
    protected void associateChoice(PlayerCharacter playerCharacter, String string) {
        boolean bl;
        super.associateChoice(playerCharacter, string);
        boolean bl2 = bl = !playerCharacter.hasRealFeatNamed(string);
        if (bl) {
            playerCharacter.adjustFeats(1.0);
        }
        if (0 == AbilityUtilities.modFeat(playerCharacter, null, string, true, false) && bl) {
            playerCharacter.adjustFeats(-1.0);
        }
    }
}

