/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.chooser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.chooser.AbstractBasicStringChoiceManager;
import pcgen.core.chooser.ChooserUtilities;
import pcgen.core.prereq.PrereqHandler;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbilityChoiceManager
extends AbstractBasicStringChoiceManager {
    public AbilityChoiceManager(PObject pObject, String string, PlayerCharacter playerCharacter) {
        super(pObject, string, playerCharacter);
        this.setTitle("Ability Choice");
        List<String> list = this.getChoiceList();
        if (list == null || list.size() < 2) {
            throw new IllegalArgumentException("Choice List for AbilityChoiceManager must be at least 2 items");
        }
    }

    @Override
    public void getChoices(PlayerCharacter playerCharacter, List<String> list, List<String> list2) {
        String string = null;
        for (String string2 : this.getChoiceList()) {
            Object object;
            Object object2;
            if (string == null) {
                string = string2;
                continue;
            }
            if (string2.startsWith("TYPE=") || string2.startsWith("TYPE.")) {
                object2 = string2.substring(5);
                object = Globals.getAbilityKeyIterator(string);
                while (object.hasNext()) {
                    Ability ability = (Ability)object.next();
                    if (!ability.isType((String)object2) || !playerCharacter.canSelectAbility(ability) || list.contains(ability.toString())) continue;
                    list.add(ability.toString());
                }
                continue;
            }
            object2 = new StringTokenizer(string2, ",");
            while (((StringTokenizer)object2).hasMoreElements()) {
                object = (String)((StringTokenizer)object2).nextElement();
                this.addChoiceToAvailable(playerCharacter, list, string, ((String)object).trim());
            }
        }
        list2.addAll(playerCharacter.getAssociationList(this.pobject));
        this.setPreChooserChoices(list2.size());
    }

    private void addChoiceToAvailable(PlayerCharacter playerCharacter, List<String> list, String string, String string2) {
        String string3 = "";
        Ability ability = Globals.getAbilityKeyed(string, string2);
        AbilityCategory abilityCategory = SettingsHandler.getGame().getAbilityCategory(string);
        if (ability == null) {
            Logging.errorPrint("Feat not found: " + string2);
            return;
        }
        if (!string2.equalsIgnoreCase(ability.getKeyName())) {
            string3 = string2.substring(ability.getKeyName().length());
            string2 = ability.getKeyName();
            int n = string3.indexOf(40);
            if (n > -1) {
                string3 = string3.substring(n + 1);
            }
        }
        if (PrereqHandler.passesAll(ability.getPrerequisiteList(), playerCharacter, ability)) {
            if (ability.getSafe(ObjectKey.MULTIPLE_ALLOWED).booleanValue()) {
                int n;
                int n2;
                Ability ability2 = playerCharacter.getAbilityKeyed(abilityCategory, string2);
                if (ability2 != null) {
                    ability = ability2;
                }
                if ((n2 = string3.indexOf(37)) > -1) {
                    string3 = string3.substring(0, n2);
                } else if (string3.length() != 0 && (n = string3.lastIndexOf(41)) > -1) {
                    string3 = string3.substring(0, n);
                }
                ArrayList arrayList = new ArrayList();
                ArrayList arrayList2 = new ArrayList();
                ChooserUtilities.modChoices(ability, arrayList, arrayList2, false, playerCharacter, true, null);
                ArrayList<String> arrayList3 = new ArrayList<String>();
                ArrayList<String> arrayList4 = new ArrayList<String>();
                ChooserUtilities.convertChoiceListToStringList(arrayList, arrayList3);
                ChooserUtilities.convertChoiceListToStringList(arrayList2, arrayList4);
                if (string3.length() != 0) {
                    for (int i = arrayList3.size() - 1; i >= 0; --i) {
                        String string4 = (String)arrayList3.get(i);
                        if (string4.startsWith(string3)) continue;
                        arrayList3.remove(i);
                    }
                    if (n2 == -1 && arrayList3.size() == 0) {
                        arrayList3.add(string3);
                    }
                }
                if (!ability.getSafe(ObjectKey.STACKS).booleanValue()) {
                    Iterator iterator = arrayList4.iterator();
                    while (iterator.hasNext()) {
                        int n3 = arrayList3.indexOf(iterator.next());
                        if (n3 <= -1) continue;
                        arrayList3.remove(n3);
                    }
                }
                Iterator iterator = arrayList3.iterator();
                while (iterator.hasNext()) {
                    list.add(string2 + "(" + (String)iterator.next() + ")");
                }
            } else {
                Ability ability3 = Globals.getAbilityKeyed(string, string2);
                if (!playerCharacter.hasRealAbility(abilityCategory, ability3) && !playerCharacter.hasAutomaticAbility(abilityCategory, ability3)) {
                    list.add(string2);
                }
            }
        }
    }
}

