/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.analysis;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.helper.PointCost;
import pcgen.core.PlayerCharacter;
import pcgen.core.bonus.BonusObj;
import pcgen.core.bonus.util.SpellPointCostInfo;
import pcgen.core.spell.Spell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpellPoint {
    public static String getSpellPointCostPartValue(Spell spell, int n) {
        Map<String, Integer> map = SpellPoint.getSpellPointCostActualParts(spell);
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.addAll(map.keySet());
        String[] stringArray = (String[])treeSet.toArray();
        int n2 = treeSet.size();
        if (n < n2) {
            return map.get(stringArray[n]).toString();
        }
        return "";
    }

    public static String getSpellPointCostPartName(Spell spell, int n) {
        Map<String, Integer> map = SpellPoint.getSpellPointCostActualParts(spell);
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.addAll(map.keySet());
        String[] stringArray = (String[])treeSet.toArray();
        int n2 = treeSet.size();
        if (n < n2) {
            return stringArray[n];
        }
        return "";
    }

    public static int getSpellPointCostActual(PlayerCharacter playerCharacter, Spell spell) {
        int n = 0;
        Map<String, Integer> map = SpellPoint.getSpellPointCostActualParts(spell);
        for (String object : map.keySet()) {
            n += map.get(object).intValue();
        }
        if (!playerCharacter.hasSpellInSpellbook(spell, playerCharacter.getSpellBookNameToAutoAddKnown())) {
            return n;
        }
        for (BonusObj bonusObj : playerCharacter.getActiveBonusList()) {
            if (!bonusObj.toString().contains("SPELLPOINTCOST")) continue;
            try {
                List<?> list = bonusObj.getBonusInfoList();
                for (SpellPointCostInfo spellPointCostInfo : list) {
                    if (spellPointCostInfo.isVirtual()) continue;
                    boolean bl = false;
                    if (spellPointCostInfo.getSpellPointPartFilter() == SpellPointCostInfo.SpellPointFilterType.SCHOOL) {
                        for (String string : spell.getSafeListFor(ListKey.SPELL_SCHOOL)) {
                            if (!spellPointCostInfo.getSpellPointPartFilterValue().equalsIgnoreCase(string)) continue;
                            bl = true;
                        }
                    } else if (spellPointCostInfo.getSpellPointPartFilter() == SpellPointCostInfo.SpellPointFilterType.SUBSCHOOL) {
                        for (String string : spell.getSafeListFor(ListKey.SPELL_SUBSCHOOL)) {
                            if (!spellPointCostInfo.getSpellPointPartFilterValue().equalsIgnoreCase(string)) continue;
                            bl = true;
                        }
                    } else if (spellPointCostInfo.getSpellPointPartFilter() == SpellPointCostInfo.SpellPointFilterType.SPELL && spell.getDisplayName().equalsIgnoreCase(spellPointCostInfo.getSpellPointPartFilterValue().toUpperCase())) {
                        bl = true;
                    }
                    if (!bl) continue;
                    n += bonusObj.resolve(playerCharacter, "").intValue();
                }
            }
            catch (Exception exception) {
            }
        }
        return n;
    }

    public static int getSpellPointCostActual(Spell spell) {
        int n = 0;
        Map<String, Integer> map = SpellPoint.getSpellPointCostActualParts(spell);
        for (String string : map.keySet()) {
            n += map.get(string).intValue();
        }
        return n;
    }

    public static int getBonusForSpellPointCostComponent(PlayerCharacter playerCharacter, Spell spell, String string) {
        int n = 0;
        for (String string2 : spell.getSafeListFor(ListKey.SPELL_SCHOOL)) {
            n += (int)playerCharacter.getTotalBonusTo("SPELLPOINTCOST", "SCHOOL." + string2.toUpperCase() + ";" + string.toUpperCase());
        }
        for (String string2 : spell.getSafeListFor(ListKey.SPELL_SUBSCHOOL)) {
            n += (int)playerCharacter.getTotalBonusTo("SPELLPOINTCOST", "SUBSCHOOL." + string2.toUpperCase() + ";" + string.toUpperCase());
        }
        return n += (int)playerCharacter.getTotalBonusTo("SPELLPOINTCOST", "SPELL." + spell.getKeyName() + ";" + string.toUpperCase());
    }

    public static String getSPCostStrings(PlayerCharacter playerCharacter, Spell spell) {
        Map<String, Integer> map = SpellPoint.getSpellPointCostActualParts(spell);
        int n = SpellPoint.getSpellPointCostActual(playerCharacter, spell);
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        int n2 = 0;
        int n3 = 0;
        n3 = SpellPoint.getBonusForSpellPointCostComponent(playerCharacter, spell, "TOTAL");
        if (map.size() == 0) {
            stringBuffer.append(n + n2);
            return stringBuffer.toString();
        }
        if (map.size() == 1 && map.containsKey("TOTAL")) {
            stringBuffer.append(n + n2);
            return stringBuffer.toString();
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.addAll(map.keySet());
        for (String string : treeSet) {
            if (string.equalsIgnoreCase("Range")) {
                n2 = SpellPoint.getBonusForSpellPointCostComponent(playerCharacter, spell, string);
                stringBuffer2.append(string);
                stringBuffer2.append(" ");
                stringBuffer2.append(map.get(string) + n2);
                stringBuffer2.append("/");
            } else if (string.equalsIgnoreCase("Area of Effect")) {
                n2 = SpellPoint.getBonusForSpellPointCostComponent(playerCharacter, spell, string);
                stringBuffer2.append(string);
                stringBuffer2.append(" ");
                stringBuffer2.append(map.get(string) + n2);
                stringBuffer2.append("/");
            } else if (string.equalsIgnoreCase("Duration")) {
                n2 = SpellPoint.getBonusForSpellPointCostComponent(playerCharacter, spell, string);
                stringBuffer2.append(string);
                stringBuffer2.append(" ");
                stringBuffer2.append(map.get(string) + n2);
                stringBuffer2.append("/");
            } else {
                n2 = SpellPoint.getBonusForSpellPointCostComponent(playerCharacter, spell, string);
                stringBuffer3.append(string);
                stringBuffer3.append(" ");
                stringBuffer3.append(map.get(string) + n2);
                stringBuffer3.append("/");
            }
            n2 = 0;
        }
        int n4 = n + n3;
        if (stringBuffer2.length() < 1) {
            stringBuffer.replace(stringBuffer.length() - 1, stringBuffer.length(), "");
        }
        stringBuffer2.replace(stringBuffer2.length() - 1, stringBuffer2.length(), "");
        stringBuffer.append(n4);
        stringBuffer.append(" [");
        stringBuffer.append(stringBuffer3.toString());
        stringBuffer.append(stringBuffer2.toString());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static String getSPCostStrings(Spell spell) {
        Map<String, Integer> map = SpellPoint.getSpellPointCostActualParts(spell);
        int n = SpellPoint.getSpellPointCostActual(spell);
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("");
        stringBuffer.append(n);
        if (map.size() == 0) {
            return stringBuffer.toString();
        }
        if (map.size() == 1 && map.containsKey("TOTAL")) {
            return stringBuffer.toString();
        }
        stringBuffer.append(" [");
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.addAll(map.keySet());
        for (String string : treeSet) {
            if (string.equalsIgnoreCase("Range")) {
                stringBuffer2.append(string);
                stringBuffer2.append(" ");
                stringBuffer2.append(map.get(string));
                stringBuffer2.append("/");
                continue;
            }
            if (string.equalsIgnoreCase("Area of Effect")) {
                stringBuffer2.append(string);
                stringBuffer2.append(" ");
                stringBuffer2.append(map.get(string));
                stringBuffer2.append("/");
                continue;
            }
            if (string.equalsIgnoreCase("Duration")) {
                stringBuffer2.append(string);
                stringBuffer2.append(" ");
                stringBuffer2.append(map.get(string));
                stringBuffer2.append("/");
                continue;
            }
            stringBuffer.append(string);
            stringBuffer.append(" ");
            stringBuffer.append(map.get(string));
            stringBuffer.append("/");
        }
        if (stringBuffer2.length() < 1) {
            stringBuffer.replace(stringBuffer.length() - 1, stringBuffer.length(), "");
        }
        stringBuffer2.replace(stringBuffer2.length() - 1, stringBuffer2.length(), "");
        stringBuffer.append(stringBuffer2.toString());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static Map<String, Integer> getSpellPointCostActualParts(Spell spell) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (PointCost pointCost : spell.getSafeListFor(ListKey.SPELL_POINT_COST)) {
            hashMap.put(pointCost.getType(), pointCost.getCost());
        }
        return hashMap;
    }
}

