/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.analysis;

import java.util.List;
import pcgen.base.lang.StringUtil;
import pcgen.base.util.NamedValue;
import pcgen.cdom.enumeration.AssociationListKey;
import pcgen.cdom.enumeration.SkillCost;
import pcgen.cdom.enumeration.StringKey;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.Skill;
import pcgen.core.analysis.SkillLanguage;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.utils.CoreUtility;
import pcgen.util.Logging;

public class SkillRankControl {
    public static Float getRank(PlayerCharacter playerCharacter, Skill skill) {
        double d = 0.0;
        List<NamedValue> list = playerCharacter.getAssocList(skill, AssociationListKey.SKILL_RANK);
        if (list != null) {
            for (NamedValue namedValue : list) {
                d += namedValue.getWeight();
            }
        }
        return new Float(d);
    }

    public static Float getTotalRank(PlayerCharacter playerCharacter, Skill skill) {
        double d = SkillRankControl.getRank(playerCharacter, skill).doubleValue();
        double d2 = d + (playerCharacter == null ? 0.0 : skill.getSkillRankBonusTo(playerCharacter));
        if (!Globals.checkRule("SKILLMAX") && playerCharacter.getClassList().size() > 0) {
            double d3 = playerCharacter.getMaxRank(skill.getKeyName(), playerCharacter.getClassList().get(0)).doubleValue();
            d3 = Math.max(d3, d);
            d2 = Math.min(d3, d2);
        }
        return new Float(d2);
    }

    public static void setZeroRanks(PCClass pCClass, PlayerCharacter playerCharacter, Skill skill) {
        if (pCClass == null) {
            return;
        }
        String string = pCClass.getKeyName();
        List<NamedValue> list = playerCharacter.getAssocList(skill, AssociationListKey.SKILL_RANK);
        if (list == null) {
            return;
        }
        for (NamedValue namedValue : list) {
            if (!namedValue.name.equals(string)) continue;
            playerCharacter.removeAssoc(skill, AssociationListKey.SKILL_RANK, namedValue);
            double d = namedValue.getWeight();
            String string2 = SkillRankControl.modRanks(-d, pCClass, false, playerCharacter, skill);
            if (string2.length() == 0) break;
            Logging.debugPrint(string2);
            break;
        }
    }

    public static String modRanks(double d, PCClass pCClass, boolean bl, PlayerCharacter playerCharacter, Skill skill) {
        double d2;
        double d3;
        Object object;
        int n = 0;
        if (!bl) {
            if (pCClass == null) {
                return "You must be at least level one before you can purchase skills.";
            }
            if (d > 0.0 && !PrereqHandler.passesAll(skill.getPrerequisiteList(), playerCharacter, skill)) {
                return "You do not meet the prerequisites required to take this skill.";
            }
            object = playerCharacter.getSkillCostForClass(skill, pCClass);
            if (object.equals((Object)SkillCost.EXCLUSIVE)) {
                return "You cannot purchase this exclusive skill.";
            }
            n = object.getCost();
            if (d > 0.0 && (double)pCClass.getSkillPool(playerCharacter) < d * (double)n) {
                return "You do not have enough skill points.";
            }
            d3 = playerCharacter.getMaxRank(skill.getKeyName(), pCClass).doubleValue();
            if (!Globals.checkRule("SKILLMAX") && d > 0.0) {
                d2 = SkillRankControl.getTotalRank(playerCharacter, skill).doubleValue();
                if (d2 >= d3) {
                    return "Skill rank at maximum (" + d3 + ") for your level.";
                }
                if (d2 + d > d3) {
                    return "Raising skill would make it above maximum (" + d3 + ") for your level.";
                }
            }
        }
        if (SkillRankControl.getRank(playerCharacter, skill).doubleValue() + d < 0.0) {
            return "Cannot lower rank below 0";
        }
        object = "None";
        if (pCClass != null) {
            object = pCClass.getKeyName();
        }
        d3 = 0.0;
        d2 = 0.0;
        NamedValue namedValue = null;
        List<NamedValue> list = playerCharacter.getAssocList(skill, AssociationListKey.SKILL_RANK);
        if (list != null) {
            for (NamedValue namedValue2 : list) {
                if (namedValue2.name.equals(object)) {
                    d3 = namedValue2.getWeight();
                    namedValue = namedValue2;
                    break;
                }
                if (!namedValue2.name.equals("None")) continue;
                d2 = namedValue2.getWeight();
            }
        }
        if (d3 <= 0.0) {
            d3 = d2;
        }
        if (CoreUtility.doublesEqual(d3, 0.0) && d < 0.0) {
            return "No more ranks found for class: " + (String)object + ". Try a different one.";
        }
        d = SkillRankControl.modRanks2(d, d3, namedValue, (String)object, playerCharacter, skill);
        if (!bl) {
            if (pCClass != null) {
                pCClass.setSkillPool(pCClass.getSkillPool(playerCharacter) - (int)((double)n * d));
            }
            playerCharacter.setSkillPoints(playerCharacter.getSkillPoints() - (int)((double)n * d));
        }
        return "";
    }

    public static void replaceClassRank(PlayerCharacter playerCharacter, Skill skill, String string, String string2) {
        List<NamedValue> list = playerCharacter.getAssocList(skill, AssociationListKey.SKILL_RANK);
        if (list != null) {
            for (NamedValue namedValue : list) {
                if (!namedValue.name.equals(string)) continue;
                playerCharacter.removeAssoc(skill, AssociationListKey.SKILL_RANK, namedValue);
                playerCharacter.addAssoc(skill, AssociationListKey.SKILL_RANK, new NamedValue(string2, namedValue.getWeight()));
                break;
            }
        }
    }

    private static double modRanks2(double d, double d2, NamedValue namedValue, String string, PlayerCharacter playerCharacter, Skill skill) {
        String string2;
        double d3 = d2 + d;
        if (!playerCharacter.isImporting() && (string2 = skill.getSafe(StringKey.CHOICE_STRING)).length() > 0 && !CoreUtility.doublesEqual(d, 0.0) && !CoreUtility.doublesEqual(d2, (int)d3) && string2.startsWith("Language")) {
            if (namedValue != null) {
                namedValue.addWeight(d);
            }
            if (!SkillLanguage.chooseLanguageForSkill(playerCharacter, skill)) {
                d3 = d2;
            } else {
                int n;
                int n2 = playerCharacter.getSelectCorrectedAssociationCount(skill);
                if (n2 > (n = SkillRankControl.getTotalRank(playerCharacter, skill).intValue())) {
                    d3 = d2;
                }
            }
            if (namedValue != null) {
                namedValue.removeWeight(d);
            }
            d = d3 - d2;
        }
        if (CoreUtility.doublesEqual(d3, 0.0)) {
            playerCharacter.removeAssoc(skill, AssociationListKey.SKILL_RANK, namedValue);
        } else if (namedValue != null) {
            namedValue.addWeight(d);
        } else {
            playerCharacter.addAssoc(skill, AssociationListKey.SKILL_RANK, new NamedValue(string, d));
        }
        playerCharacter.calcActiveBonuses();
        return d;
    }

    public static String getRanksExplanation(PlayerCharacter playerCharacter, Skill skill) {
        return StringUtil.join(playerCharacter.getAssocList(skill, AssociationListKey.SKILL_RANK), ", ");
    }
}

