/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.analysis;

import java.util.List;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.core.Ability;
import pcgen.core.Equipment;
import pcgen.core.EquipmentModifier;
import pcgen.core.PObject;
import pcgen.core.spell.Spell;
import pcgen.util.Delta;

public class EqModSpellInfo {
    private static final String s_CHARGES = "CHARGES";

    public static String getSpellInfoString(String string, String string2) {
        int n = string.indexOf(string2 + "[");
        int n2 = string.indexOf(93, n + 1);
        if (n >= 0 && n2 > n) {
            return string.substring(n + string2.length() + 1, n2);
        }
        return "";
    }

    public static int getSpellInfo(String string, String string2) {
        int n = 0;
        String string3 = EqModSpellInfo.getSpellInfoString(string, string2);
        if (string3.length() > 0) {
            try {
                n = Delta.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    public static void setRemainingCharges(Equipment equipment, EquipmentModifier equipmentModifier, int n) {
        if (equipment.hasAssociations(equipmentModifier)) {
            List<String> list = equipment.removeAllAssociations(equipmentModifier);
            String string = list.get(0);
            String string2 = EqModSpellInfo.getSpellInfoString(string, s_CHARGES);
            if (string2.length() != 0) {
                string2 = "CHARGES[" + string2 + ']';
                int n2 = string.indexOf(string2);
                string = string.substring(0, n2) + string.substring(n2 + string2.length());
                string = string + "CHARGES[" + Integer.toString(n) + ']';
                list.set(0, string);
            }
            for (String string3 : list) {
                equipment.addAssociation((CDOMObject)equipmentModifier, string3);
            }
        }
    }

    public static int getRemainingCharges(Equipment equipment, EquipmentModifier equipmentModifier) {
        if (equipment.hasAssociations(equipmentModifier)) {
            return EqModSpellInfo.getSpellInfo(equipment.getFirstAssociation(equipmentModifier), s_CHARGES);
        }
        return 0;
    }

    public static int getUsedCharges(Equipment equipment, EquipmentModifier equipmentModifier) {
        return equipmentModifier.get(IntegerKey.MAX_CHARGES) - EqModSpellInfo.getRemainingCharges(equipment, equipmentModifier);
    }

    public static void setSpellInfo(Equipment equipment, EquipmentModifier equipmentModifier, PObject pObject, Spell spell, String string, String string2, int n, int n2, Object[] objectArray, int n3) {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("SPELLNAME[").append(spell.getKeyName()).append("] ");
        stringBuffer.append("CASTER[").append(pObject.getKeyName()).append("] ");
        if (string.length() != 0) {
            stringBuffer.append("VARIANT[").append(string).append("] ");
        }
        stringBuffer.append("SPELLTYPE[").append(string2).append("] ");
        stringBuffer.append("SPELLLEVEL[").append(n).append("] ");
        stringBuffer.append("CASTERLEVEL[").append(n2).append("] ");
        if (n3 > 0) {
            stringBuffer.append(s_CHARGES).append('[').append(n3).append("] ");
        }
        if (objectArray != null && objectArray.length > 0) {
            stringBuffer.append("METAFEATS[");
            for (int i = 0; i < objectArray.length; ++i) {
                Ability ability = (Ability)objectArray[i];
                if (i != 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(ability.getKeyName());
            }
            stringBuffer.append("] ");
        }
        equipment.addAssociation((CDOMObject)equipmentModifier, stringBuffer.toString());
    }
}

