/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.analysis;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.StringTokenizer;
import pcgen.cdom.enumeration.FormulaKey;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.StringKey;
import pcgen.core.Equipment;
import pcgen.core.EquipmentModifier;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.analysis.EqModSpellInfo;
import pcgen.core.bonus.BonusObj;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.spell.Spell;
import pcgen.util.Delta;

public class EqModCost {
    private static final String s_CHARGES = "CHARGES";

    public static BigDecimal addItemCosts(EquipmentModifier equipmentModifier, PlayerCharacter playerCharacter, String string, int n, Equipment equipment) {
        double d = 0.0;
        HashSet<String> hashSet = new HashSet<String>();
        for (BonusObj object : equipmentModifier.getBonusList(equipment)) {
            String string2;
            boolean bl = true;
            if (!object.getBonusName().equals(string)) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(object.toString().substring(string.length()), "|", false);
            String string3 = stringTokenizer.nextToken();
            stringTokenizer = new StringTokenizer(string3.substring(5), ".", false);
            String string4 = "TYPE";
            while (stringTokenizer.hasMoreTokens() && (bl = equipment.isType(string2 = stringTokenizer.nextToken()))) {
                string4 = string4 + "." + string2;
            }
            if (!bl) continue;
            hashSet.add(string4);
        }
        for (String string5 : hashSet) {
            d += equipmentModifier.bonusTo(playerCharacter, string, string5, equipment);
        }
        return new BigDecimal(d * (double)n);
    }

    public static boolean getCostDouble(EquipmentModifier equipmentModifier) {
        Boolean bl = equipmentModifier.get(ObjectKey.COST_DOUBLE);
        if (bl == null) {
            if (equipmentModifier.isType("MagicalEnhancement") || equipmentModifier.isType("BaseMaterial")) {
                return false;
            }
            if (equipmentModifier.isIType("MAGIC")) {
                return true;
            }
            for (Prerequisite prerequisite : equipmentModifier.getPrerequisiteList()) {
                if (!"TYPE".equalsIgnoreCase(prerequisite.getKind()) || !prerequisite.getKey().equalsIgnoreCase("EQMODTYPE=MagicalEnhancement") && !prerequisite.getKey().equalsIgnoreCase("EQMODTYPE.MagicalEnhancement")) continue;
                return true;
            }
            return false;
        }
        return bl;
    }

    public static String getCost(EquipmentModifier equipmentModifier, String string) {
        String string2 = equipmentModifier.getSafe(FormulaKey.COST).toString();
        String string3 = "";
        while (string2.indexOf("%SPELLLEVEL") >= 0) {
            int n = string2.indexOf("%SPELLLEVEL");
            if (string3.length() == 0) {
                int n2 = EqModSpellInfo.getSpellInfo(string, "SPELLLEVEL");
                string3 = n2 == 0 ? "0.5" : Integer.toString(n2);
            }
            string2 = string2.substring(0, n) + string3 + string2.substring(n + 11);
        }
        string2 = EqModCost.replaceCostSpellCost(string2, string);
        string2 = EqModCost.replaceCostSpellXPCost(string2, string);
        string2 = EqModCost.replaceCostCasterLevel(string2, string);
        string2 = EqModCost.replaceCostCharges(string2, string);
        string2 = EqModCost.replaceCostChoice(string2, string);
        return string2;
    }

    private static String replaceCostCasterLevel(String string, String string2) {
        String string3 = "";
        while (string.indexOf("%CASTERLEVEL") >= 0) {
            int n = string.indexOf("%CASTERLEVEL");
            if (string3.length() == 0) {
                PCClass pCClass;
                int n2 = EqModSpellInfo.getSpellInfo(string2, "CASTERLEVEL");
                string3 = Integer.toString(n2);
                String string4 = EqModSpellInfo.getSpellInfoString(string2, "CASTER");
                if (string4.length() != 0 && (pCClass = Globals.getContext().ref.silentlyGetConstructedCDOMObject(PCClass.class, string4)) != null) {
                    StringBuffer stringBuffer = new StringBuffer(200);
                    String string5 = pCClass.get(StringKey.ITEMCREATE);
                    if (string5 != null && string5.length() != 0) {
                        StringTokenizer stringTokenizer = new StringTokenizer(string5, "+-*/()", true);
                        if (stringTokenizer.countTokens() == 1) {
                            stringBuffer.append(n2).append('*').append(string5);
                        } else {
                            while (stringTokenizer.hasMoreTokens()) {
                                string5 = stringTokenizer.nextToken();
                                if (string5.equals("CL")) {
                                    stringBuffer.append(n2);
                                    continue;
                                }
                                stringBuffer.append(string5);
                            }
                        }
                        string3 = stringBuffer.toString();
                    }
                }
            }
            string = string.substring(0, n) + "(" + string3 + ")" + string.substring(n + 12);
        }
        return string;
    }

    private static String replaceCostCharges(String string, String string2) {
        String string3 = "";
        while (string.indexOf("%CHARGES") >= 0) {
            int n = string.indexOf("%CHARGES");
            if (string3.length() == 0) {
                string3 = Integer.toString(EqModSpellInfo.getSpellInfo(string2, s_CHARGES));
            }
            string = string.substring(0, n) + string3 + string.substring(n + 8);
        }
        return string;
    }

    private static String replaceCostSpellCost(String string, String string2) {
        String string3 = "";
        while (string.indexOf("%SPELLCOST") >= 0) {
            String string4;
            Spell spell;
            int n = string.indexOf("%SPELLCOST");
            if (string3.length() == 0 && (spell = Globals.getSpellKeyed(string4 = EqModSpellInfo.getSpellInfoString(string2, "SPELLNAME"))) != null) {
                string3 = spell.getSafe(ObjectKey.COST).toString();
            }
            string = string.substring(0, n) + string3 + string.substring(n + 10);
        }
        return string;
    }

    private static String replaceCostChoice(String string, String string2) {
        String string3 = "";
        while (string.indexOf("%CHOICE") >= 0) {
            int n = string.indexOf("%CHOICE");
            if (string3.length() == 0) {
                int n2 = string2.lastIndexOf(124);
                int n3 = 0;
                try {
                    n3 = Delta.parseInt(string2.substring(n2 + 1));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                string3 = Integer.toString(n3);
            }
            string = string.substring(0, n) + string3 + string.substring(n + 7);
        }
        return string;
    }

    private static String replaceCostSpellXPCost(String string, String string2) {
        String string3 = "";
        while (string.indexOf("%SPELLXPCOST") >= 0) {
            String string4;
            Spell spell;
            int n = string.indexOf("%SPELLXPCOST");
            if (string3.length() == 0 && (spell = Globals.getSpellKeyed(string4 = EqModSpellInfo.getSpellInfoString(string2, "SPELLNAME"))) != null) {
                string3 = Integer.toString(spell.getSafe(IntegerKey.XP_COST));
            }
            string = string.substring(0, n) + string3 + string.substring(n + 12);
        }
        return string;
    }
}

