/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.cdom.base.PersistentTransitionChoice;
import pcgen.cdom.base.TransitionChoice;
import pcgen.cdom.enumeration.AssociationListKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.Region;
import pcgen.cdom.enumeration.StringKey;
import pcgen.cdom.enumeration.Type;
import pcgen.core.Globals;
import pcgen.core.Kit;
import pcgen.core.PCStat;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.analysis.SkillRankControl;
import pcgen.core.bonus.Bonus;
import pcgen.core.bonus.BonusObj;
import pcgen.core.utils.CoreUtility;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Skill
extends PObject {
    public Iterator<Type> getSubtypeIterator() {
        List<Type> list = this.getSafeListFor(ListKey.TYPE);
        PCStat pCStat = this.get(ObjectKey.KEY_STAT);
        if (pCStat == null) {
            list.remove(Type.NONE);
        } else {
            list.remove(Type.getConstant(pCStat.getDisplayName()));
        }
        return list.iterator();
    }

    @Override
    public Skill clone() {
        Skill skill = null;
        try {
            skill = (Skill)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ShowMessageDelegate.showMessageDialog(cloneNotSupportedException.getMessage(), "PCGen", MessageType.ERROR);
        }
        return skill;
    }

    public double getSkillRankBonusTo(PlayerCharacter playerCharacter) {
        double d = playerCharacter.getTotalBonusTo("SKILLRANK", this.getKeyName());
        for (Type type : this.getTrueTypeList(false)) {
            d += playerCharacter.getTotalBonusTo("SKILLRANK", "TYPE." + type);
        }
        this.updateAdds(playerCharacter, d);
        return d;
    }

    private void updateAdds(PlayerCharacter playerCharacter, double d) {
        List<PersistentTransitionChoice<?>> list = this.getListFor(ListKey.ADD);
        if (list != null) {
            int n = 0;
            for (PersistentTransitionChoice<?> persistentTransitionChoice : list) {
                n += playerCharacter.getAssocCount(persistentTransitionChoice, AssociationListKey.ADD);
            }
            if (CoreUtility.doublesEqual(SkillRankControl.getRank(playerCharacter, this).doubleValue() + d, 0.0)) {
                if (n != 0) {
                    this.removeAdds(playerCharacter);
                }
            } else if (n == 0) {
                this.addAdds(playerCharacter);
            }
        }
    }

    @Override
    protected void globalChecks(boolean bl, PlayerCharacter playerCharacter) {
        playerCharacter.setDirty(true);
        for (TransitionChoice<Kit> transitionChoice : this.getSafeListFor(ListKey.KIT_CHOICE)) {
            transitionChoice.act(transitionChoice.driveChoice(playerCharacter), this, playerCharacter);
        }
        TransitionChoice<Region> transitionChoice = this.get(ObjectKey.REGION_CHOICE);
        if (transitionChoice != null) {
            transitionChoice.act(transitionChoice.driveChoice(playerCharacter), this, playerCharacter);
        }
        if (bl) {
            this.getChoices(this.getSafe(StringKey.CHOICE_STRING), playerCharacter);
        }
        this.activateBonuses(playerCharacter);
    }

    public String getKeyStatFromStats() {
        PCStat pCStat = this.get(ObjectKey.KEY_STAT);
        if (pCStat == null) {
            if (Globals.getGameModeHasPointPool()) {
                List<PCStat> list = this.getKeyStatList(null);
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl = false;
                for (PCStat pCStat2 : list) {
                    if (bl) {
                        stringBuilder.append('/');
                    }
                    stringBuilder.append(pCStat2.getAbb());
                }
                return stringBuilder.toString();
            }
            return "";
        }
        return pCStat.getAbb();
    }

    public List<PCStat> getKeyStatList(List<Type> list) {
        ArrayList<PCStat> arrayList = new ArrayList<PCStat>();
        if (Globals.getGameModeHasPointPool()) {
            for (Type type : this.getTrueTypeList(false)) {
                List<PCStat> list2 = SettingsHandler.getGame().getUnmodifiableStatList();
                for (int i = list2.size() - 1; i >= 0; --i) {
                    PCStat pCStat = list2.get(i);
                    List<BonusObj> list3 = Skill.getBonusListOfType(pCStat, Bonus.getBonusTypeFromName("SKILL"), "TYPE." + type);
                    if (list3.size() <= 0) continue;
                    for (int j = list3.size() - 1; j >= 0; --j) {
                        arrayList.add(pCStat);
                    }
                    if (list == null || list.contains(type)) continue;
                    list.add(type);
                }
            }
        }
        return arrayList;
    }

    private static List<BonusObj> getBonusListOfType(PCStat pCStat, int n, String string) {
        ArrayList<BonusObj> arrayList = new ArrayList<BonusObj>();
        for (BonusObj bonusObj : pCStat.getSafeListFor(ListKey.BONUS)) {
            if (bonusObj.getTypeOfBonusAsInt() != n) continue;
            if (bonusObj.getBonusInfoList().size() > 1) {
                StringTokenizer stringTokenizer = new StringTokenizer(bonusObj.getBonusInfo(), ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    if (!string2.equalsIgnoreCase(string)) continue;
                    arrayList.add(bonusObj);
                }
                continue;
            }
            if (!bonusObj.getBonusInfo().equalsIgnoreCase(string)) continue;
            arrayList.add(bonusObj);
        }
        return arrayList;
    }

    public String getKeyStatAbb() {
        PCStat pCStat = this.get(ObjectKey.KEY_STAT);
        return pCStat == null ? "" : pCStat.getAbb();
    }

    @Override
    public PObject getActiveEquivalent(PlayerCharacter playerCharacter) {
        return playerCharacter.getSkillKeyed(this.getKeyName());
    }
}

