/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CategorizedCDOMObject;
import pcgen.cdom.base.MasterListInterface;
import pcgen.cdom.reference.ReferenceManufacturer;
import pcgen.cdom.reference.TransparentCategorizedReferenceManufacturer;
import pcgen.cdom.reference.TransparentReferenceManufacturer;
import pcgen.core.AbilityCategory;
import pcgen.core.BioSet;
import pcgen.core.ClassType;
import pcgen.core.LevelInfo;
import pcgen.core.PCAlignment;
import pcgen.core.PCStat;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.PointBuyCost;
import pcgen.core.PointBuyMethod;
import pcgen.core.RuleCheck;
import pcgen.core.SettingsHandler;
import pcgen.core.SizeAdjustment;
import pcgen.core.SystemCollections;
import pcgen.core.UnitSet;
import pcgen.core.character.WieldCategory;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.system.GameModeRollMethod;
import pcgen.rules.context.ConsolidatedListCommitStrategy;
import pcgen.rules.context.GameReferenceContext;
import pcgen.rules.context.LoadContext;
import pcgen.rules.context.ReferenceContext;
import pcgen.rules.context.RuntimeLoadContext;
import pcgen.rules.context.RuntimeReferenceContext;
import pcgen.rules.context.TrackingReferenceContext;
import pcgen.util.ComparableComparator;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;
import pcgen.util.enumeration.Tab;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GameMode
implements Comparable<Object> {
    private static PObject eqSizePenalty = new PObject();
    private List<String> allowedModes;
    private List<String> bonusFeatLevels = new ArrayList<String>();
    private Map<String, String> bonusSpellMap = new HashMap<String, String>();
    private List<String> bonusStackList = new ArrayList<String>();
    private List<String> bonusStatLevels = new ArrayList<String>();
    private List<ClassType> classTypeList = new ArrayList<ClassType>();
    private List<String> defaultDataSetList = new ArrayList<String>();
    private List<String> defaultDeityList = new ArrayList<String>();
    private Map<String, Map<String, LevelInfo>> levelInfo = new HashMap<String, Map<String, LevelInfo>>();
    private List<String> loadStrings = new ArrayList<String>();
    private List<String> skillMultiplierLevels = new ArrayList<String>();
    private List<WieldCategory> wieldCategoryList = new ArrayList<WieldCategory>();
    private Map<String, List<String>> ACTypeAddMap = new HashMap<String, List<String>>();
    private Map<String, List<String>> ACTypeRemoveMap = new HashMap<String, List<String>>();
    private Map<String, String> damageDownMap = new HashMap<String, String>();
    private Map<String, String> damageUpMap = new HashMap<String, String>();
    private Map<String, String> plusCalcs;
    private Map<String, String> spellRangeMap = new HashMap<String, String>();
    private String acAbbrev = "";
    private String acName = "";
    private String alignmentName = "";
    private String althpAbbrev = "";
    private String althpName = "";
    private String babAbbrev = null;
    private String currencyUnit = "";
    private String currencyUnitAbbrev = "";
    private String damageResistance = "";
    private String defaultSpellBook = "Known Spells";
    private String defaultUnitSet = "Imperial";
    private UnitSet selectedUnitSet = null;
    private String displayName = null;
    private String displayVariable2Name = "";
    private String displayVariable2Text = "";
    private String displayVariable3Name = "";
    private String displayVariable3Text = "";
    private String displayVariableName = "";
    private String displayVariableText = "";
    private String folderName = "";
    private String hpAbbrev = "";
    private String hpName = "";
    private String levelUpMessage = "";
    private String menuEntry = "";
    private String menuToolTip = "";
    private String name = "";
    private String spellBaseDC = "0";
    private String wcStepsFormula = "";
    private String weaponCategories = "";
    private String weaponTypes = "";
    private String weaponReachFormula = "";
    private String rankModFormula = "";
    private String addWithMetamagic = "";
    private SortedMap<String, RuleCheck> ruleCheckMap = new TreeMap<String, RuleCheck>();
    private Map<Tab, TabInfo> tInfo = new HashMap<Tab, TabInfo>();
    private boolean allowAutoResize = false;
    private boolean bonusStatAllowsStack = false;
    private boolean showClassDefense;
    private int babAttCyc = 5;
    private int babMaxAtt = Integer.MAX_VALUE;
    private int babMaxLvl = Integer.MAX_VALUE;
    private int babMinVal = 1;
    private int checksMaxLvl = Integer.MAX_VALUE;
    private int displayOrder = Integer.MAX_VALUE;
    private List<PCStat> statList = new ArrayList<PCStat>();
    public String[] s_ATTRIBLONG;
    public String[] s_ATTRIBSHORT;
    private final List<PObject> checkList = new ArrayList<PObject>();
    private final List<PCAlignment> alignmentList = new ArrayList<PCAlignment>(15);
    private final List<String> schoolsList = new ArrayList<String>(20);
    private int skillCosts_Class = 1;
    private int skillCost_CrossClass = 2;
    private int skillCost_Exclusive = 0;
    private String pointPoolName = "";
    private String hpFormula = "";
    private int nonProfPenalty = -4;
    private double squareSize = 5.0;
    private int shortRangeDistance;
    private int rangePenalty;
    private List<GameModeRollMethod> rollingMethods = null;
    private int rollingMethodIndex = -1;
    private SortedMap<Integer, PointBuyCost> pointBuyStatCosts = null;
    private int[] abilityScoreCost = null;
    private List<PointBuyMethod> pointBuyMethods = null;
    private String purchaseMethodName = "";
    private int rollMethod = 0;
    private final List<SizeAdjustment> sizeAdjustmentList = new ArrayList<SizeAdjustment>(9);
    private final SizeAdjustment spareSize = new SizeAdjustment();
    private int allStatsValue = 10;
    private int statMin = 3;
    private int statMax = 18;
    private TreeMap<Integer, String> statDisplayText = null;
    private String statDisplayTextAppend = "+";
    private TreeMap<Integer, String> skillRankDisplayText = null;
    private boolean[] summaryTabStatColumnVisible = new boolean[]{true, true, true, true, true, true, true};
    private boolean[] skillTabColumnVisible = new boolean[]{true, true, true, true, true, true, true};
    private List<AbilityCategory> theAbilityCategories = new ArrayList<AbilityCategory>(5);
    private List<AbilityCategory> theLstAbilityCategories = new ArrayList<AbilityCategory>();
    private String thePreviewDir;
    private String theDefaultPreviewSheet;
    private int[] dieSizes;
    private int maxDieSize = 12;
    private int minDieSize = 4;
    private List<String> resizableTypeList = new ArrayList<String>();
    private Map<Class<?>, Set<String>> hiddenTypes = new HashMap();
    private List<String> xpTableNames = new ArrayList<String>();
    private String currXpTableName;
    private BioSet bioSet = new BioSet();
    private ConsolidatedListCommitStrategy masterLCS = new ConsolidatedListCommitStrategy();
    private LoadContext context = new RuntimeLoadContext(this.getRefContext(), this.masterLCS);
    private GameReferenceContext gameRefContext = new GameReferenceContext();
    private LoadContext modeContext = new RuntimeLoadContext(this.gameRefContext, this.masterLCS);
    private String defaultSourceTitle;

    public GameMode(String string) {
        this.name = string;
        this.folderName = string;
        this.thePreviewDir = string;
        this.theDefaultPreviewSheet = "preview.html";
        for (Tab tab : Tab.values()) {
            TabInfo tabInfo = new TabInfo();
            tabInfo.tabName = tab.label();
            this.tInfo.put(tab, tabInfo);
        }
    }

    public void setACAbbrev(String string) {
        this.acAbbrev = string;
    }

    public void setACText(String string) {
        this.acName = string;
    }

    public List<String> getACTypeAddString(String string) {
        if (this.ACTypeAddMap == null) {
            return new ArrayList<String>();
        }
        return this.ACTypeAddMap.get(string);
    }

    public List<String> getACTypeRemoveString(String string) {
        if (this.ACTypeRemoveMap == null) {
            return new ArrayList<String>();
        }
        return this.ACTypeRemoveMap.get(string);
    }

    public void setAlignmentText(String string) {
        this.alignmentName = string;
    }

    public void setAllowedModes(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|", false);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (this.allowedModes == null) {
                this.allowedModes = new ArrayList<String>();
            }
            this.allowedModes.add(string2);
        }
    }

    public void setAltHPAbbrev(String string) {
        this.althpAbbrev = string;
    }

    public void setAltHPText(String string) {
        this.althpName = string;
    }

    public void setAllowAutoResize(boolean bl) {
        this.allowAutoResize = bl;
    }

    public boolean getAllowAutoResize() {
        return this.allowAutoResize;
    }

    public void setBabAbbrev(String string) {
        this.babAbbrev = string;
    }

    public String getBabAbbrev() {
        return this.babAbbrev;
    }

    public void setBabMinVal(int n) {
        this.babMinVal = n;
    }

    public int getBabMinVal() {
        return this.babMinVal;
    }

    public void setBonusStatLevels(String string) {
        this.bonusStatLevels.add(string);
    }

    public void setChecksMaxLvl(int n) {
        this.checksMaxLvl = n;
    }

    public int getChecksMaxLvl() {
        return this.checksMaxLvl;
    }

    public ClassType getClassTypeByName(String string) {
        for (ClassType classType : this.classTypeList) {
            if (!classType.getName().equalsIgnoreCase(string)) continue;
            return classType;
        }
        return null;
    }

    public String getContextPath(Tab tab) {
        return this.tInfo.get((Object)((Object)tab)).contextPath;
    }

    public void setCurrencyUnit(String string) {
        this.currencyUnit = string;
    }

    public void setCurrencyUnitAbbrev(String string) {
        this.currencyUnitAbbrev = string;
    }

    public Map<String, String> getDamageDownMap() {
        return this.damageDownMap;
    }

    public void setDamageResistanceText(String string) {
        this.damageResistance = string;
    }

    public Map<String, String> getDamageUpMap() {
        return this.damageUpMap;
    }

    public void setDefaultSpellBook(String string) {
        this.defaultSpellBook = string;
    }

    public void setDefaultUnitSet(String string) {
        this.defaultUnitSet = string;
    }

    public String getDisplayName() {
        if (this.displayName == null) {
            return this.name;
        }
        return this.displayName;
    }

    public void setDisplayOrder(String string) {
        try {
            this.displayOrder = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            Logging.errorPrint("Will use default for displayOrder: " + this.displayOrder, numberFormatException);
        }
    }

    public void setEqSizePenaltyObj(PObject pObject) {
        eqSizePenalty = pObject;
    }

    public static PObject getEqSizePenaltyObj() {
        return eqSizePenalty;
    }

    public void setBonusFeatLevels(String string) {
        this.bonusFeatLevels.add(string);
    }

    public String getFolderName() {
        return this.folderName;
    }

    public void setHPAbbrev(String string) {
        this.hpAbbrev = string;
    }

    public void setHPText(String string) {
        this.hpName = string;
    }

    public void setRankModFormula(String string) {
        this.rankModFormula = string;
    }

    public Map<String, LevelInfo> getLevelInfo(String string) {
        return this.levelInfo.get(string);
    }

    public void addLevelInfo(String string, LevelInfo levelInfo) {
        Map<String, LevelInfo> map = this.levelInfo.get(string);
        if (map == null) {
            map = new HashMap<String, LevelInfo>();
            this.levelInfo.put(string, map);
        }
        map.put(levelInfo.getLevelString(), levelInfo);
    }

    public void setLevelUpMessage(String string) {
        this.levelUpMessage = string;
    }

    public String getLevelUpMessage() {
        return this.levelUpMessage;
    }

    public String getMenuEntry() {
        if (this.menuEntry == null) {
            return this.name;
        }
        return this.menuEntry;
    }

    public String getMenuToolTip() {
        if (this.menuToolTip == null) {
            return "";
        }
        return this.menuToolTip;
    }

    public void setModeName(String string) {
        this.menuEntry = string;
        this.displayName = string.replace("&", "");
    }

    public void setModeToolTip(String string) {
        this.menuToolTip = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getPlusCalculation(String string) {
        String string2 = null;
        if (this.plusCalcs != null) {
            string2 = this.plusCalcs.get(string.toUpperCase());
        }
        return string2;
    }

    public RuleCheck getRuleByKey(String string) {
        return (RuleCheck)this.ruleCheckMap.get(string);
    }

    public boolean getRuleCheck(String string) {
        if (this.ruleCheckMap.containsKey(string)) {
            RuleCheck ruleCheck = (RuleCheck)this.ruleCheckMap.get(string);
            return ruleCheck.getDefault();
        }
        return false;
    }

    public List<RuleCheck> getRuleCheckList() {
        return new ArrayList<RuleCheck>(this.ruleCheckMap.values());
    }

    public void setShortRangeDistance(int n) {
        this.shortRangeDistance = n;
    }

    public int getShortRangeDistance() {
        return this.shortRangeDistance;
    }

    public void setShowClassDefense(boolean bl) {
        this.showClassDefense = bl;
    }

    public void setSkillMultiplierLevels(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|", false);
        this.skillMultiplierLevels.clear();
        while (stringTokenizer.hasMoreTokens()) {
            this.skillMultiplierLevels.add(stringTokenizer.nextToken());
        }
    }

    public void setSpellBaseDC(String string) {
        this.spellBaseDC = string;
    }

    public String getSpellBaseDC() {
        return this.spellBaseDC;
    }

    public void setSpellRangeFormula(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|", false);
        if (stringTokenizer.countTokens() < 2) {
            return;
        }
        String string2 = stringTokenizer.nextToken().toUpperCase();
        String string3 = stringTokenizer.nextToken();
        this.spellRangeMap.put(string2, string3);
    }

    public String getSpellRangeFormula(String string) {
        String string2 = null;
        if (this.spellRangeMap != null) {
            string2 = this.spellRangeMap.get(string);
        }
        return string2;
    }

    public void setTabContext(Tab tab, String string) {
        this.tInfo.get((Object)((Object)tab)).contextPath = string;
    }

    public void setTabName(Tab tab, String string) {
        this.tInfo.get((Object)((Object)tab)).tabName = string;
    }

    public String getTabName(Tab tab) {
        String string = this.tInfo.get((Object)((Object)tab)).tabName;
        if (string.startsWith("in_")) {
            string = PropertyFactory.getString(string);
        }
        return string;
    }

    public String getSingularTabName(Tab tab) {
        String string = this.getTabName(tab);
        if (string.endsWith("s")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static Tab getTab(String string) {
        for (Tab tab : Tab.values()) {
            if (!string.equalsIgnoreCase(tab.toString())) continue;
            return tab;
        }
        return Tab.INVALID;
    }

    public void setBabAttCyc(int n) {
        this.babAttCyc = n;
    }

    public int getBabAttCyc() {
        return this.babAttCyc;
    }

    public void setBabMaxAtt(int n) {
        this.babMaxAtt = n;
    }

    public int getBabMaxAtt() {
        return this.babMaxAtt;
    }

    public void setBabMaxLvl(int n) {
        this.babMaxLvl = n;
    }

    public int getBabMaxLvl() {
        return this.babMaxLvl;
    }

    public boolean getTabShown(Tab tab) {
        return this.tInfo.get((Object)((Object)tab)).visible;
    }

    public void setTabVisible(Tab tab, boolean bl) {
        this.tInfo.get((Object)((Object)tab)).visible = bl;
    }

    public void setVariableDisplay2Name(String string) {
        this.displayVariable2Name = string;
    }

    public void setVariableDisplay2Text(String string) {
        this.displayVariable2Text = string;
    }

    public void setVariableDisplay3Name(String string) {
        this.displayVariable3Name = string;
    }

    public void setVariableDisplay3Text(String string) {
        this.displayVariable3Text = string;
    }

    public void setVariableDisplayName(String string) {
        this.displayVariableName = string;
    }

    public void setVariableDisplayText(String string) {
        this.displayVariableText = string;
    }

    public void setWCStepsFormula(String string) {
        this.wcStepsFormula = string;
    }

    public String getWCStepsFormula() {
        return this.wcStepsFormula;
    }

    public String getWeaponCategories() {
        return this.weaponCategories;
    }

    public String getWeaponTypes() {
        return this.weaponTypes;
    }

    public WieldCategory getWieldCategory(String string) {
        for (WieldCategory wieldCategory : this.wieldCategoryList) {
            if (!wieldCategory.getName().equals(string)) continue;
            return wieldCategory;
        }
        return null;
    }

    public String getWeaponReachFormula() {
        return this.weaponReachFormula;
    }

    public boolean isValidACType(String string) {
        if (this.ACTypeAddMap.containsKey(string)) {
            return true;
        }
        return this.ACTypeRemoveMap.containsKey(string);
    }

    public void addACType(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
        if (!stringTokenizer.hasMoreTokens()) {
            Logging.errorPrint("Empty tag in miscinfo.ACTYPE");
            return;
        }
        String string2 = stringTokenizer.nextToken();
        while (stringTokenizer.hasMoreTokens()) {
            List<String> list;
            String string3 = stringTokenizer.nextToken();
            if (string3.startsWith("ADD:")) {
                list = this.ACTypeAddMap.containsKey(string2) ? this.ACTypeAddMap.get(string2) : new ArrayList<String>();
                list.add(string3.substring(4));
                this.ACTypeAddMap.put(string2, list);
                continue;
            }
            if (string3.startsWith("REMOVE:")) {
                list = this.ACTypeRemoveMap.containsKey(string2) ? this.ACTypeRemoveMap.get(string2) : new ArrayList();
                list.add(string3.substring(7));
                this.ACTypeRemoveMap.put(string2, list);
                continue;
            }
            Logging.errorPrint("Incorrect tag in miscinfo.ACTYPE: " + string3);
        }
    }

    public void addClassType(String string) {
        if (".CLEAR".equals(string)) {
            this.classTypeList = null;
            return;
        }
        if (this.classTypeList == null) {
            this.classTypeList = new ArrayList<ClassType>();
        }
        ClassType classType = new ClassType();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
        classType.setName(stringTokenizer.nextToken());
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.startsWith("CRFORMULA:")) {
                classType.setCRFormula(string2.substring(10));
                continue;
            }
            if (string2.startsWith("XPPENALTY:")) {
                classType.setXPPenalty(string2.substring(10).equals("YES"));
                continue;
            }
            if (string2.startsWith("ISMONSTER:")) {
                classType.setMonster(string2.substring(10).equals("YES"));
                continue;
            }
            Logging.errorPrint("Incorrect tag in miscinfo.CLASSTYPE: " + string2);
        }
        this.classTypeList.add(classType);
    }

    public void addDefaultDataSet(String string) {
        if (this.defaultDataSetList == null) {
            this.defaultDataSetList = new ArrayList<String>();
        }
        this.defaultDataSetList.add(string);
    }

    public void clearDefaultDataSetList() {
        this.defaultDataSetList.clear();
    }

    public void addDeityList(String string) {
        if (".CLEAR".equals(string)) {
            this.defaultDeityList = null;
            return;
        }
        if (this.defaultDeityList == null) {
            this.defaultDeityList = new ArrayList<String>();
        }
        this.defaultDeityList.add(string);
    }

    public void addLoadString(String string) {
        this.loadStrings.add(string);
    }

    public void addPlusCalculation(String string) {
        int n = string.indexOf(124);
        if (n > 0) {
            if (this.plusCalcs == null) {
                this.plusCalcs = new HashMap<String, String>();
            }
            this.plusCalcs.put(string.substring(0, n).toUpperCase(), string.substring(n + 1));
        }
    }

    public void addRule(RuleCheck ruleCheck) {
        this.ruleCheckMap.put(ruleCheck.getKey(), ruleCheck);
    }

    public void addWeaponCategory(String string) {
        this.weaponCategories = this.weaponCategories + '|' + string;
    }

    public void addWeaponType(String string) {
        this.weaponTypes = this.weaponTypes + '|' + string;
    }

    public void addWieldCategory(WieldCategory wieldCategory) {
        this.wieldCategoryList.add(wieldCategory);
    }

    @Override
    public int compareTo(Object object) {
        if (object != null) {
            int n = ((GameMode)object).getDisplayOrder();
            if (n < this.displayOrder) {
                return 1;
            }
            if (n > this.displayOrder) {
                return -1;
            }
            return this.name.compareToIgnoreCase(((GameMode)object).name);
        }
        return 1;
    }

    public void setWeaponReachFormula(String string) {
        this.weaponReachFormula = string;
    }

    public boolean hasRuleCheck(String string) {
        return this.ruleCheckMap.containsKey(string);
    }

    String getACAbbrev() {
        return this.acAbbrev;
    }

    String getACText() {
        return this.acName;
    }

    String getAlignmentText() {
        return this.alignmentName;
    }

    public List<String> getAllowedModes() {
        if (this.allowedModes == null) {
            ArrayList<String> arrayList = new ArrayList<String>(1);
            arrayList.add(this.name);
            return arrayList;
        }
        return this.allowedModes;
    }

    String getAltHPAbbrev() {
        return this.althpAbbrev;
    }

    String getAltHPText() {
        return this.althpName;
    }

    List<String> getBonusFeatLevels() {
        return this.bonusFeatLevels;
    }

    List<String> getBonusStatLevels() {
        return this.bonusStatLevels;
    }

    String getCurrencyDisplay() {
        return this.currencyUnitAbbrev;
    }

    String getDamageResistanceText() {
        return this.damageResistance;
    }

    String getDefaultSpellBook() {
        return this.defaultSpellBook;
    }

    String getDefaultUnitSet() {
        return this.defaultUnitSet;
    }

    List<String> getDeityList() {
        return this.defaultDeityList;
    }

    public List<String> getDefaultDataSetList() {
        return this.defaultDataSetList;
    }

    int getDisplayOrder() {
        return this.displayOrder;
    }

    String getHPAbbrev() {
        return this.hpAbbrev;
    }

    String getHPText() {
        return this.hpName;
    }

    List<String> getLoadStrings() {
        return this.loadStrings;
    }

    String getLongCurrencyDisplay() {
        return this.currencyUnit;
    }

    String getRankModFormula() {
        return this.rankModFormula;
    }

    boolean getShowClassDefense() {
        return this.showClassDefense;
    }

    List<String> getSkillMultiplierLevels() {
        return this.skillMultiplierLevels;
    }

    String getVariableDisplay2Name() {
        return this.displayVariable2Name;
    }

    String getVariableDisplay2Text() {
        return this.displayVariable2Text;
    }

    String getVariableDisplay3Name() {
        return this.displayVariable3Name;
    }

    String getVariableDisplay3Text() {
        return this.displayVariable3Text;
    }

    String getVariableDisplayName() {
        return this.displayVariableName;
    }

    String getVariableDisplayText() {
        return this.displayVariableText;
    }

    public List<PCStat> getUnmodifiableStatList() {
        return Collections.unmodifiableList(this.statList);
    }

    public void addToStatList(PCStat pCStat) {
        this.statList.add(pCStat);
    }

    public void clearStatList() {
        this.statList.clear();
    }

    public void setAttribLong(String[] stringArray) {
        this.s_ATTRIBLONG = stringArray;
    }

    public void setAttribLong(int n, String string) {
        this.s_ATTRIBLONG[n] = string;
    }

    public void setAttribShort(String[] stringArray) {
        this.s_ATTRIBSHORT = stringArray;
    }

    public void setAttribShort(int n, String string) {
        this.s_ATTRIBSHORT[n] = string;
    }

    public int getStatFromAbbrev(String string) {
        if (this.s_ATTRIBSHORT != null) {
            for (int i = 0; i < this.s_ATTRIBSHORT.length; ++i) {
                if (!string.equalsIgnoreCase(this.s_ATTRIBSHORT[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public void addToCheckList(PObject pObject) {
        this.checkList.add(pObject);
    }

    public void clearCheckList() {
        this.checkList.clear();
    }

    public PObject getCheckNamed(String string) {
        int n = this.getIndexOfCheck(string);
        PObject pObject = n == -1 ? null : this.checkList.get(n);
        return pObject;
    }

    public int getIndexOfCheck(String string) {
        for (int i = 0; i < this.checkList.size(); ++i) {
            if (!this.checkList.get(i).toString().equalsIgnoreCase(string)) continue;
            return i;
        }
        return -1;
    }

    public List<PObject> getUnmodifiableCheckList() {
        return Collections.unmodifiableList(this.checkList);
    }

    public String getCheckKey(int n) {
        if (n < 0 || n >= this.checkList.size()) {
            return "";
        }
        return this.checkList.get(n).getKeyName();
    }

    public void addToAlignmentList(PCAlignment pCAlignment) {
        this.alignmentList.add(pCAlignment);
    }

    public void clearAlignmentList() {
        this.alignmentList.clear();
    }

    public PCAlignment getAlignmentAtIndex(int n) {
        PCAlignment pCAlignment = n < 0 || n >= this.alignmentList.size() ? null : this.alignmentList.get(n);
        return pCAlignment;
    }

    public String[] getAlignmentListStrings(boolean bl) {
        String[] stringArray = new String[this.alignmentList.size()];
        int n = 0;
        for (PCAlignment pCAlignment : this.alignmentList) {
            if (bl) {
                stringArray[n++] = pCAlignment.getDisplayName();
                continue;
            }
            stringArray[n++] = pCAlignment.getKeyName();
        }
        return stringArray;
    }

    public int getIndexOfAlignment(String string) {
        for (int i = 0; i < this.alignmentList.size(); ++i) {
            PCAlignment pCAlignment = this.alignmentList.get(i);
            if (!pCAlignment.getDisplayName().equalsIgnoreCase(string) && !pCAlignment.getKeyName().equalsIgnoreCase(string)) continue;
            return i;
        }
        return -1;
    }

    public PCAlignment getAlignment(String string) {
        for (PCAlignment pCAlignment : this.alignmentList) {
            if (!pCAlignment.getDisplayName().equalsIgnoreCase(string) && !pCAlignment.getKeyName().equalsIgnoreCase(string)) continue;
            return pCAlignment;
        }
        return null;
    }

    public String getLongAlignmentAtIndex(int n) {
        PCAlignment pCAlignment = this.getAlignmentAtIndex(n);
        String string = pCAlignment == null ? "" : pCAlignment.getDisplayName();
        return string;
    }

    public String getShortAlignmentAtIndex(int n) {
        PCAlignment pCAlignment = this.getAlignmentAtIndex(n);
        if (pCAlignment == null) {
            return "";
        }
        return pCAlignment.getKeyName();
    }

    public List<PCAlignment> getUnmodifiableAlignmentList() {
        return Collections.unmodifiableList(this.alignmentList);
    }

    public void setRangePenalty(int n) {
        this.rangePenalty = n;
    }

    public int getRangePenalty() {
        return this.rangePenalty;
    }

    public void setSkillCost_Class(int n) {
        this.skillCosts_Class = n;
    }

    public void setSkillCost_CrossClass(int n) {
        this.skillCost_CrossClass = n;
    }

    public void setSkillCost_Exclusive(int n) {
        this.skillCost_Exclusive = n;
    }

    public int getSkillCost_Class() {
        return this.skillCosts_Class;
    }

    public int getSkillCost_CrossClass() {
        return this.skillCost_CrossClass;
    }

    public int getSkillCost_Exclusive() {
        return this.skillCost_Exclusive;
    }

    public void setPointPoolName(String string) {
        this.pointPoolName = string;
    }

    public String getPointPoolName() {
        return this.pointPoolName;
    }

    public void setNonProfPenalty(int n) {
        this.nonProfPenalty = n;
    }

    public int getNonProfPenalty() {
        return this.nonProfPenalty;
    }

    public void setHPFormula(String string) {
        this.hpFormula = string;
    }

    public String getHPFormula() {
        return this.hpFormula;
    }

    public void setAddWithMetamagicMessage(String string) {
        this.addWithMetamagic = string;
    }

    public String getAddWithMetamagicMessage() {
        return this.addWithMetamagic;
    }

    public Map<String, String> getBonusSpellMap() {
        return this.bonusSpellMap;
    }

    public void setSquareSize(double d) {
        this.squareSize = d;
    }

    public double getSquareSize() {
        return this.squareSize;
    }

    public UnitSet getUnitSet() {
        return this.selectedUnitSet;
    }

    public boolean selectUnitSet(String string) {
        UnitSet unitSet = SystemCollections.getUnitSet(string, this.name);
        if (unitSet == null) {
            return false;
        }
        this.selectedUnitSet = unitSet;
        return true;
    }

    public boolean selectDefaultUnitSet() {
        UnitSet unitSet = SystemCollections.getUnitSetNamed(this.defaultUnitSet, this.name);
        if (unitSet == null) {
            return false;
        }
        this.selectedUnitSet = unitSet;
        return true;
    }

    public void addPointBuyStatCost(int n, int n2) {
        PointBuyCost pointBuyCost = new PointBuyCost(n);
        pointBuyCost.setStatCost(n2);
        this.addPointBuyStatCost(pointBuyCost);
    }

    public void addPointBuyStatCost(PointBuyCost pointBuyCost) {
        if (this.pointBuyStatCosts == null) {
            this.pointBuyStatCosts = new TreeMap(new ComparableComparator());
        }
        this.abilityScoreCost = null;
        this.pointBuyStatCosts.put(pointBuyCost.getStatValue(), pointBuyCost);
    }

    public void addPurchaseModeMethod(String string, String string2) {
        this.addPurchaseModeMethod(new PointBuyMethod(string, string2));
    }

    public void addPurchaseModeMethod(PointBuyMethod pointBuyMethod) {
        if (this.getPurchaseMethodByName(pointBuyMethod.getMethodName()) == null) {
            if (this.pointBuyMethods == null) {
                this.pointBuyMethods = new ArrayList<PointBuyMethod>();
            }
            this.pointBuyMethods.add(pointBuyMethod);
        }
    }

    public void clearPointBuyStatCosts() {
        this.pointBuyStatCosts = null;
        this.abilityScoreCost = null;
    }

    public SortedMap<Integer, PointBuyCost> getPointBuyStatCostMap() {
        return this.pointBuyStatCosts;
    }

    public void clearPurchaseModeMethods() {
        this.pointBuyMethods = null;
    }

    public PointBuyMethod getPurchaseMethodByName(String string) {
        if (this.pointBuyMethods != null) {
            for (PointBuyMethod pointBuyMethod : this.pointBuyMethods) {
                if (!pointBuyMethod.getMethodName().equalsIgnoreCase(string)) continue;
                return pointBuyMethod;
            }
        }
        return null;
    }

    public int getPurchaseMethodCount() {
        if (this.pointBuyMethods != null) {
            return this.pointBuyMethods.size();
        }
        return 0;
    }

    public void setPurchaseMethodName(String string) {
        if (string.length() != 0) {
            this.setRollMethod(2);
        }
        this.purchaseMethodName = string;
    }

    public int getPurchaseModeBaseStatScore(PlayerCharacter playerCharacter) {
        int n = this.getPurchaseScoreMin(playerCharacter);
        int n2 = this.getPurchaseScoreMax() - this.getPurchaseScoreMin() + 1;
        for (int i = 0; i < n2; ++i) {
            if (this.getAbilityScoreCost(i) != 0 || this.getPurchaseScoreMin() + i < n) continue;
            return this.getPurchaseScoreMin() + i;
        }
        if (this.getPurchaseScoreMin() == n && --n < this.statMin) {
            n = this.statMin;
        }
        return n;
    }

    public String getPurchaseModeMethodName() {
        if (!this.isPurchaseStatMode()) {
            return null;
        }
        return this.purchaseMethodName;
    }

    public String getPurchaseModeMethodPoolFormula() {
        if (!this.isPurchaseStatMode()) {
            return "-1";
        }
        return this.getPurchaseMethodByName(this.purchaseMethodName).getPointFormula();
    }

    public int getPurchaseScoreMax() {
        if (this.pointBuyStatCosts == null) {
            return -1;
        }
        return this.pointBuyStatCosts.lastKey();
    }

    public int getPurchaseScoreMax(PlayerCharacter playerCharacter) {
        if (playerCharacter == null) {
            return this.getPurchaseScoreMax();
        }
        int n = -1;
        if (this.pointBuyStatCosts != null) {
            boolean bl = false;
            for (Integer n2 : this.pointBuyStatCosts.keySet()) {
                PointBuyCost pointBuyCost = (PointBuyCost)this.pointBuyStatCosts.get(n2);
                if (!PrereqHandler.passesAll(pointBuyCost.getPreReqList(), playerCharacter, null)) {
                    if (!bl) continue;
                    break;
                }
                n = n2;
            }
        }
        return n;
    }

    public int getPurchaseScoreMin() {
        if (this.pointBuyStatCosts == null) {
            return -1;
        }
        return this.pointBuyStatCosts.firstKey();
    }

    public int getPurchaseScoreMin(PlayerCharacter playerCharacter) {
        if (playerCharacter == null) {
            return this.getPurchaseScoreMin();
        }
        int n = -1;
        if (this.pointBuyStatCosts != null) {
            for (int n2 : this.pointBuyStatCosts.keySet()) {
                PointBuyCost pointBuyCost = (PointBuyCost)this.pointBuyStatCosts.get(n2);
                if (!PrereqHandler.passesAll(pointBuyCost.getPreReqList(), playerCharacter, null)) continue;
                n = n2;
                break;
            }
        }
        return n;
    }

    public boolean isPurchaseStatMode() {
        if (this.pointBuyStatCosts == null || this.pointBuyStatCosts.size() == 0 || this.getRollMethod() != 2 || this.purchaseMethodName.length() == 0) {
            return false;
        }
        return this.getPurchaseMethodByName(this.purchaseMethodName) != null;
    }

    public PointBuyMethod getPurchaseMethod(int n) {
        if (this.pointBuyMethods == null || n > this.pointBuyMethods.size()) {
            return null;
        }
        return this.pointBuyMethods.get(n);
    }

    public void setRollMethod(int n) {
        this.rollMethod = n;
        if (n != 2) {
            this.setPurchaseMethodName("");
        }
    }

    public int getRollMethod() {
        return this.rollMethod;
    }

    public int[] getAbilityScoreCost() {
        if (!this.isPurchaseStatModeAllowed()) {
            return null;
        }
        if (this.abilityScoreCost != null) {
            return this.abilityScoreCost;
        }
        this.abilityScoreCost = new int[this.getPurchaseScoreMax() - this.getPurchaseScoreMin() + 1];
        int n = 0;
        int n2 = Integer.MIN_VALUE;
        int n3 = 0;
        for (int n4 : this.pointBuyStatCosts.keySet()) {
            int n5;
            if (n2 != Integer.MIN_VALUE && n2 + 1 != n4) {
                for (n5 = n2 + 1; n5 < n4; ++n5) {
                    this.abilityScoreCost[n++] = n3;
                }
            }
            n5 = ((PointBuyCost)this.pointBuyStatCosts.get(n4)).getStatCost();
            n2 = n4;
            n3 = n5;
            this.abilityScoreCost[n++] = n3;
        }
        return this.abilityScoreCost;
    }

    public int getAbilityScoreCost(int n) {
        int[] nArray = this.getAbilityScoreCost();
        if (nArray == null) {
            return 0;
        }
        return nArray[n];
    }

    public void setRollMethodExpressionByName(String string) {
        if (string.length() != 0) {
            this.rollingMethodIndex = this.findRollingMethodByName(string);
            if (this.rollingMethodIndex >= 0) {
                this.setRollMethod(3);
            } else {
                this.setRollMethod(0);
            }
        }
    }

    public String getRollMethodExpression() {
        GameModeRollMethod gameModeRollMethod = this.getRollingMethod(this.rollingMethodIndex);
        if (gameModeRollMethod != null) {
            return gameModeRollMethod.getMethodRoll();
        }
        return "";
    }

    public String getRollMethodExpressionName() {
        GameModeRollMethod gameModeRollMethod = this.getRollingMethod(this.rollingMethodIndex);
        if (gameModeRollMethod != null) {
            return gameModeRollMethod.getMethodName();
        }
        return "";
    }

    public boolean isPurchaseStatModeAllowed() {
        return this.pointBuyStatCosts != null && this.pointBuyStatCosts.size() != 0;
    }

    public void addToSizeAdjustmentList(SizeAdjustment sizeAdjustment) {
        if (!this.sizeAdjustmentList.contains(sizeAdjustment)) {
            this.sizeAdjustmentList.add(sizeAdjustment);
        }
    }

    public void clearSizeAdjustmentList() {
        this.sizeAdjustmentList.clear();
    }

    public SizeAdjustment getDefaultSizeAdjustment() {
        for (SizeAdjustment sizeAdjustment : this.sizeAdjustmentList) {
            if (!sizeAdjustment.isDefaultSize()) continue;
            return sizeAdjustment;
        }
        return null;
    }

    public SizeAdjustment getSizeAdjustmentAtIndex(int n) {
        SizeAdjustment sizeAdjustment = null;
        if (n >= 0 && n < this.sizeAdjustmentList.size()) {
            sizeAdjustment = this.sizeAdjustmentList.get(n);
        }
        return sizeAdjustment;
    }

    public int getSizeAdjustmentListSize() {
        return this.sizeAdjustmentList.size();
    }

    public List<SizeAdjustment> getUnmodifiableSizeAdjustmentList() {
        return Collections.unmodifiableList(this.sizeAdjustmentList);
    }

    public SizeAdjustment getSizeAdjustmentNamed(String string) {
        if (string.trim().length() == 0) {
            return this.spareSize;
        }
        for (SizeAdjustment sizeAdjustment : this.sizeAdjustmentList) {
            if (!sizeAdjustment.getDisplayName().equalsIgnoreCase(string) && !sizeAdjustment.getAbbreviation().equalsIgnoreCase(string)) continue;
            return sizeAdjustment;
        }
        return null;
    }

    public void setAllStatsValue(int n) {
        this.allStatsValue = n;
    }

    public int getAllStatsValue() {
        return this.allStatsValue;
    }

    public boolean addRollingMethod(String string, String string2) {
        boolean bl = false;
        if (".CLEAR".equals(string)) {
            this.rollingMethods = null;
            bl = true;
        } else if (string.endsWith(".CLEAR")) {
            int n = this.findRollingMethodByName(string);
            if (n >= 0) {
                this.rollingMethods.remove(n);
                bl = true;
            }
        } else {
            int n;
            if (this.rollingMethods == null) {
                this.rollingMethods = new ArrayList<GameModeRollMethod>();
            }
            if ((n = this.findRollingMethodByName(string)) < 0) {
                GameModeRollMethod gameModeRollMethod = new GameModeRollMethod(string, string2);
                this.rollingMethods.add(gameModeRollMethod);
                bl = true;
            }
        }
        return bl;
    }

    private int findRollingMethodByName(String string) {
        int n = 0;
        GameModeRollMethod gameModeRollMethod;
        while ((gameModeRollMethod = this.getRollingMethod(n)) != null) {
            if (string.equals(gameModeRollMethod.getMethodName())) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public GameModeRollMethod getRollingMethod(int n) {
        if (this.rollingMethods != null && n >= 0 && n < this.rollingMethods.size()) {
            return this.rollingMethods.get(n);
        }
        return null;
    }

    public GameModeRollMethod getCurrentRollingMethod() {
        return this.getRollingMethod(this.rollingMethodIndex);
    }

    public void setStatMin(int n) {
        this.statMin = n;
    }

    public int getStatMin() {
        return this.statMin;
    }

    public void setStatMax(int n) {
        this.statMax = n;
    }

    public int getStatMax() {
        return this.statMax;
    }

    public List<String> getUnmodifiableSchoolsList() {
        return Collections.unmodifiableList(this.schoolsList);
    }

    public void addToSchoolList(String string) {
        if (!this.schoolsList.contains(string)) {
            this.schoolsList.add(string);
        }
    }

    public void addStatDisplayText(int n, String string) {
        if (this.statDisplayText == null) {
            this.statDisplayText = new TreeMap(new ComparableComparator());
        }
        this.statDisplayText.put(n, string);
    }

    public String getStatDisplayText(int n) {
        String string;
        if (this.statDisplayText == null) {
            string = Integer.toString(n);
        } else {
            string = this.statDisplayText.get(n);
            if (string == null) {
                int n2 = this.statDisplayText.firstKey();
                if (n < n2) {
                    string = "???" + Integer.toString(n) + "???";
                } else {
                    int n3 = this.statDisplayText.lastKey();
                    string = this.getStatDisplayText(n3) + this.statDisplayTextAppend + this.getStatDisplayText(n - n3);
                }
            }
        }
        return string;
    }

    public void setSummaryTabStatColumnVisible(int n, boolean bl) {
        if (n >= 0 && n <= 7) {
            this.summaryTabStatColumnVisible[n] = bl;
        }
    }

    public boolean getSummaryTabStatColumnVisible(int n) {
        if (n >= 0 && n <= 7) {
            return this.summaryTabStatColumnVisible[n];
        }
        return true;
    }

    public boolean getSkillTabColumnVisible(int n) {
        if (n >= 0 && n < this.skillTabColumnVisible.length) {
            return this.skillTabColumnVisible[n];
        }
        return true;
    }

    public boolean hasSkillRankDisplayText() {
        return this.skillRankDisplayText != null;
    }

    public void addSkillRankDisplayText(int n, String string) {
        if (this.skillRankDisplayText == null) {
            this.skillRankDisplayText = new TreeMap(new ComparableComparator());
        }
        this.skillRankDisplayText.put(n, string);
    }

    public String getSkillRankDisplayText(int n) {
        String string;
        if (this.skillRankDisplayText == null) {
            string = Integer.toString(n);
        } else {
            string = this.skillRankDisplayText.get(n);
            if (string == null) {
                int n2 = this.skillRankDisplayText.firstKey();
                if (n < n2) {
                    string = "???" + Integer.toString(n) + "???";
                } else {
                    int n3 = this.skillRankDisplayText.lastKey();
                    string = this.getSkillRankDisplayText(n3) + this.statDisplayTextAppend + this.getSkillRankDisplayText(n - n3);
                }
            }
        }
        return string;
    }

    public void addToBonusStackList(String string) {
        if (!this.bonusStackList.contains(string)) {
            this.bonusStackList.add(string);
        }
    }

    public void clearBonusStacksList() {
        this.bonusStackList.clear();
    }

    public List<String> getUnmodifiableBonusStackList() {
        return Collections.unmodifiableList(this.bonusStackList);
    }

    public void addAbilityCategory(AbilityCategory abilityCategory) {
        this.theAbilityCategories.add(abilityCategory);
    }

    public void addLstAbilityCategory(AbilityCategory abilityCategory) {
        this.theLstAbilityCategories.add(abilityCategory);
    }

    public void clearLstAbilityCategories() {
        this.theLstAbilityCategories.clear();
    }

    public AbilityCategory getAbilityCategory(String string) {
        AbilityCategory abilityCategory = this.silentlyGetAbilityCategory(string);
        if (string == null || abilityCategory == null && string.length() > 0) {
            Logging.errorPrint("Attempt to fetch AbilityCategory: " + string + "... but it does not exist");
        }
        return abilityCategory;
    }

    public AbilityCategory silentlyGetAbilityCategory(String string) {
        for (AbilityCategory abilityCategory : this.getAllAbilityCategories()) {
            if (!abilityCategory.getKeyName().equalsIgnoreCase(string)) continue;
            return abilityCategory;
        }
        return null;
    }

    public Collection<AbilityCategory> getAllAbilityCategories() {
        if (!this.theAbilityCategories.contains(AbilityCategory.FEAT)) {
            this.theAbilityCategories.add(0, AbilityCategory.FEAT);
        }
        ArrayList<AbilityCategory> arrayList = new ArrayList<AbilityCategory>();
        arrayList.addAll(this.theAbilityCategories);
        arrayList.addAll(this.theLstAbilityCategories);
        return Collections.unmodifiableCollection(arrayList);
    }

    public Collection<AbilityCategory> getAllAbilityCatsForDisplayLoc(String string) {
        if (string == null) {
            return Collections.emptyList();
        }
        ArrayList<AbilityCategory> arrayList = new ArrayList<AbilityCategory>();
        for (AbilityCategory abilityCategory : this.getAllAbilityCategories()) {
            if (!string.equals(abilityCategory.getDisplayLocation())) continue;
            arrayList.add(abilityCategory);
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    public Collection<AbilityCategory> getAllAbilityCatsForKey(String string) {
        if (string == null) {
            return Collections.emptyList();
        }
        ArrayList<AbilityCategory> arrayList = new ArrayList<AbilityCategory>();
        for (AbilityCategory abilityCategory : this.getAllAbilityCategories()) {
            if (!string.equals(abilityCategory.getKeyName()) && !string.equals(abilityCategory.getAbilityCategory())) continue;
            arrayList.add(abilityCategory);
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    public void setPreviewDir(String string) {
        this.thePreviewDir = string;
    }

    public String getPreviewDir() {
        return this.thePreviewDir;
    }

    public void setDefaultPreviewSheet(String string) {
        this.theDefaultPreviewSheet = string;
    }

    public String getDefaultPreviewSheet() {
        return this.theDefaultPreviewSheet;
    }

    public void setDieSizes(String string) {
        Object object;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            object = ((String)object).trim();
            try {
                int n;
                if (((String)object).contains("MIN=")) {
                    String[] stringArray = ((String)object).split("MIN=");
                    String string2 = stringArray[1];
                    n = Integer.parseInt(string2);
                    this.setMinDieSize(n);
                    arrayList.add(n);
                    continue;
                }
                if (((String)object).contains("MAX=")) {
                    String[] stringArray = ((String)object).split("MAX=");
                    String string3 = stringArray[1];
                    n = Integer.parseInt(string3);
                    this.setMaxDieSize(n);
                    arrayList.add(n);
                    continue;
                }
                int n2 = Integer.parseInt((String)object);
                arrayList.add(n2);
            }
            catch (NumberFormatException numberFormatException) {
                Logging.errorPrint("Invalid integer value for DIESIZES: " + (String)object + ".  Original value: DIESIZES:" + string);
            }
        }
        if (arrayList.size() == 0) {
            return;
        }
        object = new int[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            object[i] = (Integer)arrayList.get(i);
        }
        arrayList = null;
        this.setDieSizes((int[])object);
    }

    public int getMaxDieSize() {
        return this.maxDieSize;
    }

    public void setMaxDieSize(int n) {
        this.maxDieSize = n;
    }

    public int getMinDieSize() {
        return this.minDieSize;
    }

    public void setMinDieSize(int n) {
        this.minDieSize = n;
    }

    public int[] getDieSizes() {
        return this.dieSizes;
    }

    public void setDieSizes(int[] nArray) {
        this.dieSizes = nArray;
    }

    public List<String> getResizableTypeList() {
        return Collections.unmodifiableList(this.resizableTypeList);
    }

    public void setResizableTypeList(List<String> list) {
        this.resizableTypeList = list;
    }

    public void clearLoadContext() {
        this.masterLCS = new ConsolidatedListCommitStrategy();
        ReferenceContext referenceContext = this.getRefContext();
        for (TransparentReferenceManufacturer<? extends CDOMObject> transparentReferenceManufacturer : this.gameRefContext.getAllManufacturers()) {
            this.resolveReferenceManufacturer(referenceContext, transparentReferenceManufacturer);
        }
        this.context = new RuntimeLoadContext(referenceContext, this.masterLCS);
    }

    private ReferenceContext getRefContext() {
        if (SettingsHandler.inputUnconstructedMessages()) {
            return new TrackingReferenceContext();
        }
        return new RuntimeReferenceContext();
    }

    private <T extends CDOMObject> void resolveReferenceManufacturer(ReferenceContext referenceContext, TransparentReferenceManufacturer<T> transparentReferenceManufacturer) {
        ReferenceManufacturer referenceManufacturer;
        Class clazz = transparentReferenceManufacturer.getReferenceClass();
        if (CategorizedCDOMObject.class.isAssignableFrom(clazz)) {
            String string = ((TransparentCategorizedReferenceManufacturer)transparentReferenceManufacturer).getCDOMCategory();
            referenceManufacturer = referenceContext.getManufacturer(clazz, string);
        } else {
            referenceManufacturer = referenceContext.getManufacturer(clazz);
        }
        transparentReferenceManufacturer.resolveUsing(referenceManufacturer);
    }

    public LoadContext getContext() {
        return this.context;
    }

    public LoadContext getModeContext() {
        return this.modeContext;
    }

    public MasterListInterface getMasterLists() {
        return this.masterLCS;
    }

    public void addHiddenType(Class<?> clazz, String string) {
        Set<String> set = this.hiddenTypes.get(clazz);
        if (set == null) {
            set = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            this.hiddenTypes.put(clazz, set);
        }
        set.add(string);
    }

    public boolean isTypeHidden(Class<?> clazz, String string) {
        Set<String> set = this.hiddenTypes.get(clazz);
        if (string != null && set != null) {
            return set.contains(string) || this.context.isTypeHidden(clazz, string);
        }
        return this.context.isTypeHidden(clazz, string);
    }

    public int sizeIndex(SizeAdjustment sizeAdjustment) {
        return this.sizeAdjustmentList.indexOf(sizeAdjustment);
    }

    public String getXpTableName() {
        if (this.currXpTableName == null || this.currXpTableName.equals("") || !this.xpTableNames.contains(this.currXpTableName)) {
            if (this.xpTableNames.isEmpty()) {
                this.xpTableNames.add("Default");
            }
            this.currXpTableName = this.xpTableNames.get(0);
        }
        return this.currXpTableName;
    }

    public void setXpTableName(String string) {
        this.currXpTableName = string;
    }

    public List<String> getAvailXpTableNames() {
        return this.xpTableNames;
    }

    public void setAvailXpTableNames(List<String> list) {
        this.xpTableNames = list;
    }

    public void addXpTable(String string) {
        this.xpTableNames.add(string);
    }

    public boolean isBonusStatAllowsStack() {
        return this.bonusStatAllowsStack;
    }

    public void setBonusStatAllowsStack(boolean bl) {
        this.bonusStatAllowsStack = bl;
    }

    public BioSet getBioSet() {
        return this.bioSet;
    }

    public void setBioSet(BioSet bioSet) {
        this.bioSet = bioSet;
    }

    public String toString() {
        return this.name;
    }

    public void setDefaultSourceTitle(String string) {
        this.defaultSourceTitle = string;
    }

    public String getDefaultSourceTitle() {
        return this.defaultSourceTitle;
    }

    private static class TabInfo {
        String tabName = "";
        String contextPath = "";
        boolean visible = true;

        private TabInfo() {
        }
    }
}

