/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.cdom.enumeration.FormulaKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.StringKey;
import pcgen.core.Ability;
import pcgen.core.Categorisable;
import pcgen.core.Equipment;
import pcgen.core.EquipmentModifier;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.Skill;
import pcgen.util.Delta;
import pcgen.util.Logging;
import pcgen.util.enumeration.Visibility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EquipmentChoice {
    private boolean allowDuplicates = false;
    private boolean noSign = false;
    private boolean bAdd = false;
    private boolean skipZero = false;
    private int minValue = 0;
    private int maxValue = 0;
    private int incValue = 1;
    private int maxSelect = 0;
    private int pool = 0;
    private String title = null;
    private List<String> availableList = new ArrayList<String>();

    public EquipmentChoice(boolean bl, int n) {
        this.bAdd = bl;
        this.pool = n;
    }

    EquipChoiceIterator getChoiceIterator(boolean bl) {
        List<String> list;
        if (bl && this.availableList.isEmpty()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("");
            return new EquipChoiceIterator(arrayList);
        }
        if (this.getMinValue() < this.getMaxValue()) {
            list = new ArrayList<String>();
            for (int i = 0; i < this.availableList.size(); ++i) {
                String string = this.availableList.get(i);
                if (string.indexOf(124) < 0) {
                    for (int j = this.getMinValue(); j <= this.getMaxValue(); j += this.getIncValue()) {
                        if (this.skipZero && j == 0) continue;
                        list.add(string + '|' + Delta.toString(j));
                    }
                    continue;
                }
                list.add(string);
            }
        } else {
            list = this.availableList;
        }
        return new EquipChoiceIterator(list);
    }

    final int getPool() {
        return this.pool;
    }

    final void setPool(int n) {
        this.pool = n;
    }

    public final boolean isBAdd() {
        return this.bAdd;
    }

    final void setBAdd(boolean bl) {
        this.bAdd = bl;
    }

    public final List<String> getAvailableList() {
        return this.availableList;
    }

    public final boolean isAllowDuplicates() {
        return this.allowDuplicates;
    }

    final void setAllowDuplicates(boolean bl) {
        this.allowDuplicates = bl;
    }

    public final int getIncValue() {
        return this.incValue;
    }

    final void setIncValue(int n) {
        this.incValue = n;
    }

    public final int getMaxSelect() {
        return this.maxSelect;
    }

    final void setMaxSelect(int n) {
        this.maxSelect = n;
    }

    public final int getMaxValue() {
        return this.maxValue;
    }

    final void setMaxValue(int n) {
        this.maxValue = n;
    }

    public final int getMinValue() {
        return this.minValue;
    }

    final void setMinValue(int n) {
        this.minValue = n;
    }

    final boolean isNoSign() {
        return this.noSign;
    }

    final void setNoSign(boolean bl) {
        this.noSign = bl;
    }

    public final String getTitle() {
        return this.title;
    }

    final void setTitle(String string) {
        this.title = string;
    }

    public void addSkills() {
        for (Skill skill : Globals.getContext().ref.getConstructedCDOMObjects(Skill.class)) {
            this.getAvailableList().add(skill.getKeyName());
        }
    }

    public void setMinValueFromString(String string) {
        try {
            this.setMinValue(Delta.parseInt(string.substring(4)));
        }
        catch (NumberFormatException numberFormatException) {
            Logging.errorPrint("Bad MIN= value: " + string);
        }
    }

    public void setMaxValueFromString(String string) {
        try {
            this.setMaxValue(Delta.parseInt(string.substring(4)));
        }
        catch (NumberFormatException numberFormatException) {
            Logging.errorPrint("Bad MAX= value: " + string);
        }
    }

    public void setIncrementValueFromString(String string) {
        try {
            this.setIncValue(Delta.parseInt(string.substring(10)));
            if (this.getIncValue() < 1) {
                this.setIncValue(1);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void addSelectableAbilities(String string, String string2) {
        Iterator<Categorisable> iterator = Globals.getAbilityKeyIterator(string2);
        while (iterator.hasNext()) {
            boolean bl;
            Ability ability = (Ability)iterator.next();
            boolean bl2 = bl = string.equalsIgnoreCase("ALL") || ability.isType(string);
            if (ability.getSafe(ObjectKey.VISIBILITY) != Visibility.DEFAULT || this.getAvailableList().contains(ability.getKeyName()) || !bl || ability.getSafe(StringKey.CHOICE_STRING).length() != 0) continue;
            this.getAvailableList().add(ability.getKeyName());
        }
    }

    public void addSelectableEquipment(String string) {
        for (Equipment equipment : Globals.getContext().ref.getConstructedCDOMObjects(Equipment.class)) {
            if (!equipment.isType(string) || this.getAvailableList().contains(equipment.getName())) continue;
            this.getAvailableList().add(equipment.getName());
        }
    }

    public void addSelectableSkills(String string) {
        for (Skill skill : Globals.getContext().ref.getConstructedCDOMObjects(Skill.class)) {
            if (!string.equalsIgnoreCase("ALL") && !skill.isType(string) || this.getAvailableList().contains(skill.getKeyName())) continue;
            this.getAvailableList().add(skill.getKeyName());
        }
    }

    public void addParentsExistingEquipmentModifiersToChooser(Equipment equipment, String string) {
        for (EquipmentModifier equipmentModifier : equipment.getEqModifierList(true)) {
            if (equipmentModifier.equals(this) || !equipmentModifier.getSafe(StringKey.CHOICE_STRING).startsWith(string)) continue;
            this.getAvailableList().addAll(equipment.getAssociationList(equipmentModifier));
        }
    }

    public void addChoicesByType(Equipment equipment, int n, int n2, String string, String string2, String string3) {
        String string4;
        if (n > 0 && this.getMaxSelect() == 0) {
            this.setPool(n - n2);
        }
        if ((string4 = string.substring(5)).startsWith("LASTCHOICE")) {
            this.addParentsExistingEquipmentModifiersToChooser(equipment, string2);
        } else if ("SKILL".equalsIgnoreCase(string2)) {
            this.addSelectableSkills(string4);
        } else if ("EQUIPMENT".equalsIgnoreCase(string2)) {
            this.addSelectableEquipment(string4);
        } else if ("ABILITY".equalsIgnoreCase(string2)) {
            this.addSelectableAbilities(string4, string3);
        } else if ("FEAT".equalsIgnoreCase(string2)) {
            this.addSelectableAbilities(string4, "FEAT");
        } else if ("EQTYPES".equalsIgnoreCase(string4)) {
            this.getAvailableList().addAll(Equipment.getEquipmentTypes());
        } else {
            Logging.errorPrint("Unknown option in CHOOSE '" + string + "'");
        }
    }

    public void addStats() {
        for (int i = 0; i < SettingsHandler.getGame().s_ATTRIBSHORT.length; ++i) {
            this.getAvailableList().add(SettingsHandler.getGame().s_ATTRIBSHORT[i]);
        }
    }

    public void adjustPool(int n, int n2) {
        if (n > 0 && this.getMaxSelect() > 0 && this.getMaxSelect() != Integer.MAX_VALUE) {
            this.setPool(this.getMaxSelect() - n2);
        }
    }

    public void constructFromChoiceString(String string, Equipment equipment, int n, int n2, boolean bl, PlayerCharacter playerCharacter) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|", false);
        while (!bl && stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (!string2.startsWith("TITLE=")) continue;
            this.setTitle(string2.substring(6));
        }
        int n3 = equipment.getSafe(FormulaKey.SELECT).resolve(equipment, true, playerCharacter, "").intValue();
        this.setMaxSelect(n3);
        String string3 = null;
        StringTokenizer stringTokenizer2 = new StringTokenizer(string, "|", false);
        boolean bl2 = false;
        boolean bl3 = false;
        String string4 = null;
        while (!bl && stringTokenizer2.hasMoreTokens()) {
            String string5 = stringTokenizer2.nextToken();
            if (string4 == null) {
                string4 = string5.equals("ABILITY") ? stringTokenizer2.nextToken() : "FEAT";
            }
            this.adjustPool(n, n2);
            if (string5.startsWith("TITLE=") || string5.startsWith("COUNT=")) continue;
            if (string3 == null) {
                string3 = string5;
                bl2 = string3.equals("STATBONUS");
                bl3 = string3.equals("SKILLBONUS");
                continue;
            }
            if (string5.startsWith("TYPE=") || string5.startsWith("TYPE.")) {
                if (string3.equals("SKILLBONUS") || string3.equals("SKILL")) {
                    bl3 = false;
                    this.addChoicesByType(equipment, n, n2, string5, "SKILL", "");
                    continue;
                }
                if (string3.equals("EQUIPMENT") || string3.equals("FEAT") || string3.equals("ABILITY")) {
                    this.addChoicesByType(equipment, n, n2, string5, string3, string4);
                    continue;
                }
                this.addChoicesByType(equipment, n, n2, string5, this.getTitle(), string4);
                continue;
            }
            if ("STAT".equals(string5)) {
                this.addStats();
                continue;
            }
            if ("SKILL".equals(string5) || string3.equals("SKILL") && "ANY".equals("SKILL")) {
                this.addSkills();
                continue;
            }
            if ("SKILL".equals(string5)) {
                this.addSkills();
                continue;
            }
            if ("SKIPZERO".equals(string5)) {
                this.skipZero = string3.equals("NUMBER");
                continue;
            }
            if ("MULTIPLE".equals(string5)) {
                this.setAllowDuplicates(true);
                continue;
            }
            if ("NOSIGN".equals(string5)) {
                this.setNoSign(true);
                continue;
            }
            if (string5.startsWith("MIN=")) {
                this.setMinValueFromString(string5);
                continue;
            }
            if (string5.startsWith("MAX=")) {
                this.setMaxValueFromString(string5);
                continue;
            }
            if (string5.startsWith("INCREMENT=")) {
                this.setIncrementValueFromString(string5);
                continue;
            }
            bl2 = false;
            bl3 = false;
            if (this.getAvailableList().contains(string5)) continue;
            this.getAvailableList().add(string5);
        }
        if (bl2) {
            this.addStats();
        } else if (bl3) {
            this.addSkills();
        }
        if (this.getTitle() == null) {
            this.setTitle(string3);
        }
        if (this.getMaxSelect() == Integer.MAX_VALUE) {
            this.setPool(this.getAvailableList().size() - n2);
            this.setBAdd(true);
        }
        if (this.getAvailableList().size() == 0 && this.getMinValue() < this.getMaxValue()) {
            for (int i = this.getMinValue(); i <= this.getMaxValue(); i += this.getIncValue()) {
                if (this.skipZero && i == 0) continue;
                if (this.isNoSign() && i >= 0) {
                    this.getAvailableList().add(Integer.toString(i));
                    continue;
                }
                this.getAvailableList().add(Delta.toString(i));
            }
            this.setMinValue(this.getMaxValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EquipChoiceIterator
    implements Iterator<String> {
        List<String> choiceList;
        int currPos;

        EquipChoiceIterator(List<String> list) {
            this.choiceList = list;
            this.currPos = 0;
        }

        @Override
        public boolean hasNext() {
            return this.currPos < this.choiceList.size();
        }

        @Override
        public String next() {
            return this.choiceList.get(this.currPos++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

