/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.io.BufferedWriter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pcgen.base.formula.Formula;
import pcgen.base.lang.StringUtil;
import pcgen.base.util.FixedStringList;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.Constants;
import pcgen.cdom.base.PrereqObject;
import pcgen.cdom.enumeration.AssociationListKey;
import pcgen.cdom.enumeration.EqModFormatCat;
import pcgen.cdom.enumeration.FormulaKey;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.StringKey;
import pcgen.cdom.enumeration.Type;
import pcgen.cdom.helper.Capacity;
import pcgen.cdom.inst.EquipmentHead;
import pcgen.cdom.list.AbilityList;
import pcgen.cdom.modifier.ChangeArmorType;
import pcgen.cdom.reference.CDOMDirectSingleRef;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.ArmorProf;
import pcgen.core.AssociationStore;
import pcgen.core.AssociationSupport;
import pcgen.core.EquipmentChoice;
import pcgen.core.EquipmentCollection;
import pcgen.core.EquipmentModifier;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.ShieldProf;
import pcgen.core.SizeAdjustment;
import pcgen.core.SpecialProperty;
import pcgen.core.VariableContainer;
import pcgen.core.VariableProcessorEq;
import pcgen.core.WeaponProf;
import pcgen.core.analysis.EqModCost;
import pcgen.core.analysis.EqModSpellInfo;
import pcgen.core.analysis.EquipmentChoiceDriver;
import pcgen.core.bonus.Bonus;
import pcgen.core.bonus.BonusObj;
import pcgen.core.character.WieldCategory;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.utils.CoreUtility;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.io.FileAccess;
import pcgen.util.BigDecimalHelper;
import pcgen.util.JEPResourceChecker;
import pcgen.util.Logging;
import pcgen.util.PJEP;
import pcgen.util.PjepPool;
import pcgen.util.PropertyFactory;
import pcgen.util.enumeration.Load;
import pcgen.util.enumeration.Visibility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Equipment
extends PObject
implements Serializable,
EquipmentCollection,
Comparable<Object>,
VariableContainer,
AssociationStore {
    private static final long serialVersionUID = 1L;
    private static final String EQMOD_WEIGHT = "_WEIGHTADD";
    private static final String EQMOD_DAMAGE = "_DAMAGE";
    public static final int EQUIPPED_NEITHER = 0;
    public static final String EQUIPPED_NEITHER_STR = PropertyFactory.getString("EquipLocation.Neither");
    public static final int EQUIPPED_PRIMARY = 1;
    public static final String EQUIPPED_PRIMARY_STR = PropertyFactory.getString("EquipLocation.Primary");
    public static final int EQUIPPED_SECONDARY = 2;
    public static final String EQUIPPED_SECONDARY_STR = PropertyFactory.getString("EquipLocation.Secondary");
    public static final int EQUIPPED_BOTH = 3;
    public static final String EQUIPPED_BOTH_STR = PropertyFactory.getString("EquipLocation.Both");
    public static final int EQUIPPED_TWO_HANDS = 4;
    public static final String EQUIPPED_TWO_HANDS_STR = PropertyFactory.getString("EquipLocation.TwoHands");
    public static final int EQUIPPED_TEMPBONUS = 5;
    public static final String EQUIPPED_TEMPBONUS_STR = PropertyFactory.getString("EquipLocation.TempBonus");
    public static final int CARRIED_NEITHER = 6;
    public static final String CARRIED_NEITHER_STR = PropertyFactory.getString("EquipLocation.Carried");
    public static final int CONTAINED = 7;
    public static final String CONTAINED_STR = PropertyFactory.getString("EquipLocation.Contained");
    public static final int NOT_CARRIED = 8;
    public static final String NOT_CARRIED_STR = PropertyFactory.getString("EquipLocation.NotCarried");
    private static final String[] LOCATION_STRING_LIST = new String[9];
    private static final SortedSet<String> S_EQUIPMENT_TYPES = new TreeSet<String>();
    private AssociationSupport assocSupt = new AssociationSupport();
    private BigDecimal costMod = BigDecimal.ZERO;
    private EquipmentCollection d_parent;
    private List<Equipment> d_containedEquipment = new ArrayList<Equipment>();
    private Float carried = Float.valueOf(0.0f);
    private int location = 8;
    private boolean equipped;
    private int numberEquipped;
    private boolean isOnlyNaturalWeapon;
    private Map<String, Float> d_childTypes = new HashMap<String, Float>();
    private String containerCapacityString = null;
    private String containerContentsString = "";
    private String appliedBonusName = "";
    private String bonusType;
    private String indexedUnderType = "";
    private String wholeItemName = "";
    private String modifiedName = "";
    private String moveString = "";
    private String noteString = "";
    private boolean automatic;
    private boolean bonusPrimary = true;
    private boolean calculatingCost;
    private boolean weightAlreadyUsed;
    private double qty;
    private int outputIndex;
    private int outputSubindex;
    private List<String> typeListCachePrimary;
    private List<String> typeListCacheSecondary;
    private boolean usePrimaryCache;
    private boolean useSecondaryCache;
    private boolean dirty;
    private String cachedNameWithoutCharges;
    private String cachedNameWithCharges;
    private Map<String, String> bonusMap;
    private boolean virtualItem;
    List<EquipmentHead> heads;

    public Equipment() {
        SizeAdjustment sizeAdjustment = SettingsHandler.getGame().getDefaultSizeAdjustment();
        if (sizeAdjustment != null) {
            this.put(ObjectKey.SIZE, sizeAdjustment);
        }
        this.heads = new ArrayList<EquipmentHead>();
    }

    public void setAppliedName(String string) {
        this.appliedBonusName = string;
    }

    public String getAppliedName() {
        if (this.appliedBonusName.length() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(" [").append(this.appliedBonusName).append("]");
            return stringBuffer.toString();
        }
        return "";
    }

    public boolean isAmmunition() {
        return this.isType("AMMUNITION");
    }

    public boolean isArmor() {
        return this.isType("ARMOR");
    }

    public boolean isDouble() {
        return this.isType("DOUBLE");
    }

    public boolean isEitherType(String string) {
        return this.isType(string, true) || this.isType(string, false);
    }

    public boolean isExtra() {
        return this.isType("EXTRA");
    }

    public boolean isHeavy() {
        return this.isType("HEAVY");
    }

    public boolean isMedium() {
        return this.isType("MEDIUM");
    }

    public boolean isLight() {
        return this.isType("LIGHT");
    }

    public boolean isMagic() {
        return this.isType("MAGIC");
    }

    public boolean isMelee() {
        return this.isType("MELEE");
    }

    public boolean isMonk() {
        return this.isType("MONK");
    }

    public boolean isNatural() {
        return this.isType("NATURAL");
    }

    public boolean isRanged() {
        return this.isType("RANGED");
    }

    public boolean isShield() {
        return this.isType("SHIELD");
    }

    public boolean isSuit() {
        return this.isType("SUIT");
    }

    public boolean isThrown() {
        return this.isType("THROWN");
    }

    @Override
    public String getType() {
        return this.getType(true);
    }

    @Override
    public boolean isType(String string) {
        return this.isType(string, true);
    }

    public boolean isType(String string, boolean bl) {
        if (!bl && !this.isDouble()) {
            return false;
        }
        List<String> list = this.typeList(bl);
        String string2 = string.startsWith("TYPE=") || string.startsWith("TYPE.") ? string.substring(5).toUpperCase() : string.toUpperCase();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
        if (stringTokenizer.hasMoreTokens()) {
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                boolean bl2 = false;
                if (list != null) {
                    for (String string4 : list) {
                        if (!string3.equalsIgnoreCase(string4)) continue;
                        bl2 = true;
                        break;
                    }
                }
                if (bl2) continue;
                return false;
            }
            return true;
        }
        return list.contains(string);
    }

    public boolean isUnarmed() {
        return this.isType("UNARMED");
    }

    public boolean isWeapon() {
        return this.isType("WEAPON");
    }

    boolean isMasterwork() {
        return this.isType("MASTERWORK");
    }

    public boolean typeStringContains(String string) {
        return this.isType(string);
    }

    public boolean isProjectile() {
        return this.isRanged() && !this.isThrown();
    }

    public static Collection<String> getEquipmentTypes() {
        return Globals.getContext().getTypes(Equipment.class);
    }

    @Override
    public List<BonusObj> getActiveBonuses(PlayerCharacter playerCharacter) {
        ArrayList<BonusObj> arrayList = new ArrayList<BonusObj>();
        for (BonusObj object2 : this.getRawBonusList(playerCharacter)) {
            if (!object2.isApplied()) continue;
            arrayList.add(object2);
        }
        List<EquipmentModifier> list = this.getEqModifierList(true);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            EquipmentModifier equipmentModifier = (EquipmentModifier)iterator.next();
            arrayList.addAll(equipmentModifier.getActiveBonuses(this, playerCharacter));
        }
        return arrayList;
    }

    public List<BonusObj> getBonusListOfType(PlayerCharacter playerCharacter, String string, String string2, boolean bl) {
        ArrayList<BonusObj> arrayList = new ArrayList<BonusObj>();
        arrayList.addAll(this.getBonusListOfType(playerCharacter, string, string2));
        for (EquipmentModifier equipmentModifier : this.getEqModifierList(bl)) {
            arrayList.addAll(equipmentModifier.getBonusListOfType(this, string, string2));
        }
        return arrayList;
    }

    public String getFumbleRange() {
        String string;
        for (EquipmentModifier equipmentModifier : this.getEqModifierList(true)) {
            string = equipmentModifier.get(StringKey.FUMBLE_RANGE);
            if (string == null) continue;
            return string;
        }
        for (EquipmentModifier equipmentModifier : this.getEqModifierList(false)) {
            string = equipmentModifier.get(StringKey.FUMBLE_RANGE);
            if (string == null) continue;
            return string;
        }
        String string2 = this.get(StringKey.FUMBLE_RANGE);
        return string2 == null ? "" : string2;
    }

    public boolean isAutomatic() {
        return this.automatic;
    }

    public void setAutomatic(boolean bl) {
        this.automatic = bl;
    }

    public String getBaseItemName() {
        CDOMSingleRef<Equipment> cDOMSingleRef = this.get(ObjectKey.BASE_ITEM);
        if (cDOMSingleRef == null) {
            return this.getKeyName();
        }
        return cDOMSingleRef.resolvesTo().getDisplayName();
    }

    public BigDecimal getCost(PlayerCharacter playerCharacter) {
        BigDecimal bigDecimal = BigDecimal.ZERO;
        if (this.isVirtual()) {
            return bigDecimal;
        }
        bigDecimal = bigDecimal.add(this.getPreSizingCostForHead(playerCharacter, true));
        bigDecimal = bigDecimal.add(this.getPreSizingCostForHead(playerCharacter, false));
        BigDecimal bigDecimal2 = this.get(ObjectKey.CURRENT_COST);
        if (bigDecimal2 == null) {
            bigDecimal2 = this.getSafe(ObjectKey.COST);
        }
        BigDecimal bigDecimal3 = bigDecimal2.add(bigDecimal);
        ArrayList<BigDecimal> arrayList = new ArrayList<BigDecimal>();
        this.calculatingCost = true;
        this.weightAlreadyUsed = false;
        EquipmentHeadCostSummary equipmentHeadCostSummary = this.getPostSizingCostForHead(playerCharacter, arrayList, true);
        BigDecimal bigDecimal4 = equipmentHeadCostSummary.nonDoubleCost;
        BigDecimal bigDecimal5 = equipmentHeadCostSummary.postSizeCost;
        int n = equipmentHeadCostSummary.headPlus;
        if (arrayList.size() > 1) {
            Collections.sort(arrayList);
        }
        EquipmentHeadCostSummary equipmentHeadCostSummary2 = this.getPostSizingCostForHead(playerCharacter, new ArrayList<BigDecimal>(), false);
        bigDecimal4 = bigDecimal4.add(equipmentHeadCostSummary2.nonDoubleCost);
        bigDecimal5 = bigDecimal5.add(equipmentHeadCostSummary2.postSizeCost);
        int n2 = equipmentHeadCostSummary2.headPlus;
        this.calculatingCost = false;
        bigDecimal5 = bigDecimal5.add(this.getCostFromPluses(n, n2));
        if (!(this.isAmmunition() || this.isArmor() || this.isShield() || this.isWeapon())) {
            if (!this.isMagicLimitedType()) {
                if (!this.ignoresCostDouble()) {
                    bigDecimal5 = bigDecimal5.subtract(bigDecimal4).multiply(new BigDecimal("2"));
                    bigDecimal5 = bigDecimal5.add(bigDecimal4);
                }
            } else {
                for (int i = arrayList.size() - 2; i >= 0; --i) {
                    bigDecimal5 = bigDecimal5.add((BigDecimal)arrayList.get(i));
                }
            }
        }
        return bigDecimal5.add(bigDecimal3).add(this.costMod);
    }

    private BigDecimal getPreSizingCostForHead(PlayerCharacter playerCharacter, boolean bl) {
        BigDecimal bigDecimal = BigDecimal.ZERO;
        EquipmentHead equipmentHead = this.getEquipmentHeadReference(bl ? 1 : 2);
        if (equipmentHead != null) {
            this.bonusPrimary = bl;
            for (EquipmentModifier equipmentModifier : equipmentHead.getSafeListFor(ListKey.EQMOD)) {
                int n = this.getSelectCorrectedAssociationCount(equipmentModifier);
                if (n < 1) {
                    n = 1;
                }
                Formula formula = equipmentModifier.getSafe(FormulaKey.BASECOST);
                Number number = formula.resolve(this, bl, playerCharacter, "");
                BigDecimal bigDecimal2 = new BigDecimal(number.toString());
                bigDecimal = bigDecimal.add(bigDecimal2.multiply(new BigDecimal(Integer.toString(this.getSafe(IntegerKey.BASE_QUANTITY) * n))));
                bigDecimal = bigDecimal.add(EqModCost.addItemCosts(equipmentModifier, playerCharacter, "ITEMCOST", this.getSafe(IntegerKey.BASE_QUANTITY) * n, this));
            }
        }
        return bigDecimal;
    }

    private EquipmentHeadCostSummary getPostSizingCostForHead(PlayerCharacter playerCharacter, List<BigDecimal> list, boolean bl) {
        EquipmentHeadCostSummary equipmentHeadCostSummary = new EquipmentHeadCostSummary();
        EquipmentHead equipmentHead = this.getEquipmentHeadReference(bl ? 1 : 2);
        if (equipmentHead != null) {
            for (EquipmentModifier equipmentModifier : equipmentHead.getSafeListFor(ListKey.EQMOD)) {
                BigDecimal bigDecimal;
                int n = this.getSelectCorrectedAssociationCount(equipmentModifier);
                if (n < 1) {
                    n = 1;
                }
                Formula formula = equipmentModifier.getSafe(FormulaKey.COST);
                String string = formula.toString();
                if (this.hasAssociations(equipmentModifier) && !string.equals(EqModCost.getCost(equipmentModifier, this.getFirstAssociation(equipmentModifier)))) {
                    bigDecimal = BigDecimal.ZERO;
                    for (String string2 : this.getAssociationList(equipmentModifier)) {
                        String string3 = this.calcEqModCost(playerCharacter, EqModCost.getCost(equipmentModifier, string2), bl);
                        BigDecimal bigDecimal2 = new BigDecimal(string3);
                        bigDecimal = bigDecimal.add(bigDecimal2);
                        if (!EqModCost.getCostDouble(equipmentModifier)) {
                            equipmentHeadCostSummary.nonDoubleCost = equipmentHeadCostSummary.nonDoubleCost.add(bigDecimal2);
                            continue;
                        }
                        list.add(bigDecimal2);
                    }
                    n = 1;
                } else {
                    String string4 = this.calcEqModCost(playerCharacter, formula.toString(), bl);
                    bigDecimal = new BigDecimal(string4);
                    if (!EqModCost.getCostDouble(equipmentModifier)) {
                        equipmentHeadCostSummary.nonDoubleCost = equipmentHeadCostSummary.nonDoubleCost.add(bigDecimal);
                    } else {
                        list.add(bigDecimal);
                    }
                }
                if (equipmentModifier.isType("BaseMaterial")) {
                    bigDecimal = bigDecimal.multiply(new BigDecimal(this.getSafe(IntegerKey.BASE_QUANTITY)));
                }
                equipmentHeadCostSummary.postSizeCost = equipmentHeadCostSummary.postSizeCost.add(bigDecimal);
                equipmentHeadCostSummary.headPlus += equipmentModifier.getSafe(IntegerKey.PLUS) * n;
            }
        }
        return equipmentHeadCostSummary;
    }

    private String calcEqModCost(PlayerCharacter playerCharacter, String string, boolean bl) {
        Pattern pattern = Pattern.compile("BASECOST");
        Matcher matcher = pattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer("(BASECOST/");
        stringBuffer.append(this.getSafe(IntegerKey.BASE_QUANTITY));
        stringBuffer.append(")");
        String string2 = matcher.replaceAll(stringBuffer.toString());
        String string3 = this.getVariableValue(string2, "", bl, playerCharacter).toString();
        return string3;
    }

    public void setCostMod(String string) {
        try {
            this.costMod = new BigDecimal(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.costMod = BigDecimal.ZERO;
        }
    }

    public void setCostMod(BigDecimal bigDecimal) {
        this.costMod = bigDecimal;
    }

    public BigDecimal getCostMod() {
        return this.costMod;
    }

    public EquipmentModifier getEqModifierKeyed(Object object, boolean bl) {
        List<EquipmentModifier> list = this.getEqModifierList(bl);
        for (EquipmentModifier equipmentModifier : list) {
            if (!equipmentModifier.getKeyName().equals(object)) continue;
            return equipmentModifier;
        }
        return null;
    }

    public List<EquipmentModifier> getEqModifierList(boolean bl) {
        return this.getEquipmentHead(bl ? 1 : 2).getSafeListFor(ListKey.EQMOD);
    }

    public void addToEqModifierList(EquipmentModifier equipmentModifier, boolean bl) {
        this.usePrimaryCache = false;
        this.getEquipmentHead(bl ? 1 : 2).addToListFor(ListKey.EQMOD, equipmentModifier);
        this.setDirty(true);
    }

    public int getHands(PlayerCharacter playerCharacter) {
        return this.getSlots(playerCharacter);
    }

    public static String getLocationName(int n) {
        if (n < 0 || n > LOCATION_STRING_LIST.length) {
            return LOCATION_STRING_LIST[0];
        }
        return LOCATION_STRING_LIST[n];
    }

    public static int getLocationNum(String string) {
        for (int i = 0; i < LOCATION_STRING_LIST.length; ++i) {
            if (!LOCATION_STRING_LIST[i].equals(string)) continue;
            return i;
        }
        if (string.equals("None")) {
            return 8;
        }
        if (string.startsWith(CONTAINED_STR)) {
            return 7;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 7;
        }
    }

    public String getInterestingDisplayString(PlayerCharacter playerCharacter) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getSpecialProperties(playerCharacter);
        if (string == null) {
            string = "";
        }
        for (BonusObj bonusObj : this.getActiveBonuses(playerCharacter)) {
            String string2 = bonusObj.toString();
            if (string2.length() <= 0 || string2.startsWith("EQM")) continue;
            if (stringBuffer.length() != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(string2);
        }
        if (string.length() != 0) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append('|');
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public void setIsEquipped(boolean bl, PlayerCharacter playerCharacter) {
        this.equipped = bl;
        if (this.equipped) {
            this.activateBonuses(playerCharacter);
        } else {
            this.deactivateBonuses(playerCharacter);
        }
    }

    public String getItemNameFromModifiers() {
        int n;
        String string;
        int n2;
        CDOMSingleRef<Equipment> cDOMSingleRef = this.get(ObjectKey.BASE_ITEM);
        if (cDOMSingleRef == null) {
            return this.getName();
        }
        EquipmentHead equipmentHead = this.getEquipmentHeadReference(1);
        List<Object> list = equipmentHead == null ? Collections.emptyList() : equipmentHead.getSafeListFor(ListKey.EQMOD);
        EquipmentHead equipmentHead2 = this.getEquipmentHeadReference(2);
        List<Object> list2 = equipmentHead2 == null ? Collections.emptyList() : equipmentHead2.getSafeListFor(ListKey.EQMOD);
        ArrayList<EquipmentModifier> arrayList = new ArrayList<EquipmentModifier>();
        List<EquipmentModifier>[] listArray = this.initSplitModList();
        List<EquipmentModifier>[] listArray2 = this.initSplitModList();
        List<EquipmentModifier>[] listArray3 = this.initSplitModList();
        Equipment equipment = cDOMSingleRef.resolvesTo();
        if (equipment != null) {
            list.removeAll(equipment.getEqModifierList(true));
            list2.removeAll(equipment.getEqModifierList(false));
        }
        Object object = list.iterator();
        while (object.hasNext()) {
            EquipmentModifier equipmentModifier = (EquipmentModifier)object.next();
            if (!equipmentModifier.getSafe(ObjectKey.VISIBILITY).equals((Object)Visibility.HIDDEN)) continue;
            object.remove();
        }
        Equipment.extractListFromCommon(arrayList, list);
        this.removeCommonFromList(list2, arrayList, "eqMod expected but not found: ");
        this.suppressMasterwork(arrayList);
        this.splitModListByFormatCat(arrayList, listArray3);
        this.splitModListByFormatCat(list, listArray);
        this.splitModListByFormatCat(list2, listArray2);
        object = new StringBuffer();
        int n3 = EqModFormatCat.FRONT.ordinal();
        ((StringBuffer)object).append(this.buildEqModDesc(listArray3[n3], listArray[n3], listArray2[n3]));
        if (((StringBuffer)object).length() > 0) {
            ((StringBuffer)object).append(' ');
        }
        if ((n2 = (string = this.getBaseItemName().trim()).indexOf(40)) >= 0) {
            ((StringBuffer)object).append(string.substring(0, n2 - 1).trim());
        } else {
            ((StringBuffer)object).append(string);
        }
        int n4 = EqModFormatCat.MIDDLE.ordinal();
        String string2 = this.buildEqModDesc(listArray3[n4], listArray[n4], listArray2[n4]);
        if (string2.length() > 0) {
            ((StringBuffer)object).append(' ').append(string2);
        }
        if (n2 >= 0) {
            ((StringBuffer)object).append(' ');
            ((StringBuffer)object).append(string.substring(n2));
        }
        if ((n = ((StringBuffer)object).toString().lastIndexOf(41)) >= 0) {
            ((StringBuffer)object).setLength(n);
            ((StringBuffer)object).append('/');
        } else {
            ((StringBuffer)object).append(" (");
        }
        SizeAdjustment sizeAdjustment = this.getSafe(ObjectKey.SIZE);
        if (!this.getSafe(ObjectKey.BASESIZE).equals(sizeAdjustment)) {
            ((StringBuffer)object).append(sizeAdjustment.getDisplayName());
            ((StringBuffer)object).append('/');
        }
        int n5 = EqModFormatCat.PARENS.ordinal();
        ((StringBuffer)object).append(this.buildEqModDesc(listArray3[n5], listArray[n5], listArray2[n5]));
        if (((StringBuffer)object).toString().endsWith("/") || ((StringBuffer)object).toString().endsWith(";")) {
            ((StringBuffer)object).setLength(((StringBuffer)object).length() - 1);
        }
        ((StringBuffer)object).append(')');
        int n6 = ((StringBuffer)object).toString().indexOf(" ()");
        if (n6 >= 0) {
            ((StringBuffer)object).setLength(n6);
        }
        return ((StringBuffer)object).toString();
    }

    private void suppressMasterwork(Collection<EquipmentModifier> collection) {
        EquipmentModifier equipmentModifier = null;
        for (EquipmentModifier cDOMObject : collection) {
            if (!"MASTERWORK".equalsIgnoreCase(cDOMObject.getDisplayName()) && !cDOMObject.isIType("Masterwork")) continue;
            equipmentModifier = cDOMObject;
            break;
        }
        if (equipmentModifier == null) {
            return;
        }
        for (EquipmentHead equipmentHead : this.heads) {
            if (Equipment.getMagicBonus(equipmentHead.getListFor(ListKey.EQMOD)) == null) continue;
            collection.remove(equipmentModifier);
            break;
        }
    }

    private String buildEqModDesc(List<EquipmentModifier> list, List<EquipmentModifier> list2, List<EquipmentModifier> list3) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getNameFromModifiers(list);
        String string2 = this.getNameFromModifiers(list2);
        String string3 = this.getNameFromModifiers(list3);
        if (list2.isEmpty() && list3.isEmpty()) {
            stringBuffer.append(string);
        } else if (!this.isDouble()) {
            stringBuffer.append(string2);
            if (!list2.isEmpty() && !list.isEmpty()) {
                stringBuffer.append('/');
            }
            stringBuffer.append(string);
        } else {
            if (string.length() != 0) {
                stringBuffer.append(string).append(';');
            }
            if (string2.length() != 0) {
                stringBuffer.append(string2);
            } else {
                stringBuffer.append('-');
            }
            stringBuffer.append(';');
            if (string3.length() != 0) {
                stringBuffer.append(string3);
            } else {
                stringBuffer.append('-');
            }
        }
        return stringBuffer.toString();
    }

    public void setLocation(int n) {
        if (n < 0 || n > 8) {
            String string = PropertyFactory.getFormattedString("EquipLocation.Unknown", n);
            ShowMessageDelegate.showMessageDialog(string, "PCGen", MessageType.INFORMATION);
            return;
        }
        if (n == 5) {
            this.location = n;
            this.equipped = true;
        } else if (n >= 0 && n <= 4) {
            this.location = n;
            this.equipped = true;
        } else if (n == 8) {
            this.location = 8;
            this.equipped = false;
        } else {
            this.location = 6;
            this.equipped = false;
        }
    }

    public int getLocation() {
        return this.location;
    }

    public int getMaxCharges() {
        for (EquipmentModifier equipmentModifier : this.getEqModifierList(true)) {
            Integer n = equipmentModifier.get(IntegerKey.MAX_CHARGES);
            if (n == null || n <= 0) continue;
            return n;
        }
        return 0;
    }

    public Integer getMaxDex(PlayerCharacter playerCharacter) {
        Integer n = this.getSafe(IntegerKey.MAX_DEX);
        if ((n = Integer.valueOf(n + (int)this.bonusTo(playerCharacter, "EQMARMOR", "MAXDEX", true))) > Constants.MAX_MAXDEX) {
            n = Constants.MAX_MAXDEX;
        }
        if (n < 0) {
            n = 0;
        }
        return n;
    }

    public int getMinCharges() {
        for (EquipmentModifier equipmentModifier : this.getEqModifierList(true)) {
            Integer n = equipmentModifier.get(IntegerKey.MIN_CHARGES);
            if (n == null) continue;
            return n;
        }
        return 0;
    }

    @Override
    public void setName(String string) {
        super.setName(string);
        this.setDirty(true);
    }

    public void setModifiedName(String string) {
        this.modifiedName = string;
        this.setDirty(true);
    }

    public void setMoveString(String string) {
        this.moveString = string;
    }

    @Override
    public String getName() {
        return this.toString();
    }

    public void setNote(String string) {
        this.noteString = string;
    }

    public String getNote() {
        return this.noteString;
    }

    public void setNumberCarried(Float f) {
        this.carried = f;
    }

    public void setNumberEquipped(int n) {
        this.numberEquipped = n;
        if (n > 0) {
            this.equipped = true;
        }
    }

    public int getNumberEquipped() {
        return this.numberEquipped;
    }

    public void setOnlyNaturalWeapon(boolean bl) {
        this.isOnlyNaturalWeapon = bl;
    }

    public boolean isOnlyNaturalWeapon() {
        return this.isOnlyNaturalWeapon;
    }

    public void setOutputIndex(int n) {
        this.outputIndex = n;
    }

    public int getOutputIndex() {
        return this.outputIndex;
    }

    public void setOutputSubindex(int n) {
        this.outputSubindex = n;
    }

    public int getOutputSubindex() {
        return this.outputSubindex;
    }

    @Override
    public void setParent(EquipmentCollection equipmentCollection) {
        this.d_parent = equipmentCollection;
    }

    @Override
    public EquipmentCollection getParent() {
        return this.d_parent;
    }

    public String getParentName() {
        Equipment equipment = (Equipment)this.getParent();
        if (equipment != null) {
            return equipment.toString();
        }
        if (this.isEquipped()) {
            return "Equipped";
        }
        if (this.numberCarried().intValue() > 0) {
            return "Carried";
        }
        return "";
    }

    public boolean isPreType(String string) {
        String string2 = string;
        if (string2.startsWith(".IF.TYPE=")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2.substring(9), ".");
            int n = string2.indexOf(".THEN.");
            if (n < 0) {
                return false;
            }
            String string3 = string2.substring(n + 6);
            int n2 = string3.indexOf(".ELSE.");
            String string4 = "";
            if (n2 >= 0) {
                string4 = string3.substring(n2 + 6);
                string3 = string3.substring(0, n2);
            }
            boolean bl = false;
            while (stringTokenizer.hasMoreTokens()) {
                String string5 = stringTokenizer.nextToken();
                if (!this.isType(string5, this.bonusPrimary)) continue;
                bl = true;
                break;
            }
            if ((string2 = bl ? string3 : string4).length() == 0) {
                return true;
            }
        }
        if (string2.startsWith("EQMODTYPE=") || string2.startsWith("EQMODTYPE.")) {
            string2 = string2.substring(10);
            for (EquipmentModifier equipmentModifier : this.getEqModifierList(this.bonusPrimary)) {
                if (!equipmentModifier.isType(string2)) continue;
                return true;
            }
            return false;
        }
        if (string2.startsWith("EQMOD=") || string2.startsWith("EQMOD.")) {
            return this.getEqModifierKeyed(string2 = string2.substring(6), this.bonusPrimary) != null;
        }
        return this.isType(string2, this.bonusPrimary);
    }

    public void setQty(String string) {
        try {
            this.setQty(Double.parseDouble(string));
        }
        catch (NumberFormatException numberFormatException) {
            this.qty = 0.0;
        }
    }

    public void setQty(Float f) {
        this.setQty(f.doubleValue());
    }

    public Float getQty() {
        return new Float(this.qty);
    }

    public int getRawCritRange(boolean bl) {
        String string;
        int n = this.getHeadInfo(bl ? 1 : 2, IntegerKey.CRIT_RANGE);
        if (n == 0 && (string = this.getWeaponInfo("CRITRANGE", bl)).length() != 0) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    public String getRawSpecialProperties() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (SpecialProperty specialProperty : this.getSafeListFor(ListKey.SPECIAL_PROPERTIES)) {
            if (!bl) {
                stringBuffer.append(", ");
            }
            bl = false;
            stringBuffer.append(specialProperty.getText());
        }
        return stringBuffer.toString();
    }

    public void setRemainingCharges(int n) {
        for (EquipmentModifier equipmentModifier : this.getEqModifierList(true)) {
            Integer n2 = equipmentModifier.get(IntegerKey.MIN_CHARGES);
            if (n2 == null || n2 <= 0) continue;
            EqModSpellInfo.setRemainingCharges(this, equipmentModifier, n);
        }
    }

    public int getRemainingCharges() {
        for (EquipmentModifier equipmentModifier : this.getEqModifierList(true)) {
            Integer n = equipmentModifier.get(IntegerKey.MIN_CHARGES);
            if (n == null || n <= 0) continue;
            return EqModSpellInfo.getRemainingCharges(this, equipmentModifier);
        }
        return -1;
    }

    public String getSimpleName() {
        return this.getDisplayName();
    }

    public String getSize() {
        return this.getSafe(ObjectKey.SIZE).getAbbreviation();
    }

    public int getSlots(PlayerCharacter playerCharacter) {
        int n = this.getSafe(IntegerKey.SLOTS);
        EquipmentHead equipmentHead = this.getEquipmentHeadReference(1);
        if (equipmentHead != null) {
            for (EquipmentModifier equipmentModifier : equipmentHead.getSafeListFor(ListKey.EQMOD)) {
                n += (int)equipmentModifier.bonusTo(playerCharacter, "EQM", "HANDS", this);
                n += (int)equipmentModifier.bonusTo(playerCharacter, "EQM", "SLOTS", this);
            }
        }
        if (n < 0) {
            n = 0;
        }
        return n;
    }

    @Override
    public String getDefaultSourceString() {
        if (this.isType("Custom")) {
            return PropertyFactory.getString("in_custom") + " - " + super.getDefaultSourceString();
        }
        return super.getDefaultSourceString();
    }

    public String getSpecialProperties(PlayerCharacter playerCharacter) {
        EquipmentHead equipmentHead = this.getEquipmentHeadReference(1);
        List<Object> list = equipmentHead == null ? Collections.emptyList() : equipmentHead.getSafeListFor(ListKey.EQMOD);
        EquipmentHead equipmentHead2 = this.getEquipmentHeadReference(2);
        List<Object> list2 = equipmentHead2 == null ? Collections.emptyList() : equipmentHead2.getSafeListFor(ListKey.EQMOD);
        ArrayList<EquipmentModifier> arrayList = new ArrayList<EquipmentModifier>();
        Equipment.extractListFromCommon(arrayList, list);
        this.removeCommonFromList(list2, arrayList, "SPROP: eqMod expected but not found: ");
        String string = StringUtil.join(this.getSpecialAbilityTimesList(this.getSpecialAbilityList(arrayList, playerCharacter)), ", ");
        String string2 = StringUtil.join(this.getSpecialAbilityTimesList(this.getSpecialAbilityList(list, playerCharacter)), ", ");
        String string3 = StringUtil.join(this.getSpecialAbilityTimesList(this.getSpecialAbilityList(list2, playerCharacter)), ", ");
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (SpecialProperty specialProperty : this.getSafeListFor(ListKey.SPECIAL_PROPERTIES)) {
            String string4 = specialProperty.getParsedText(playerCharacter, this);
            if ("".equals(string4)) continue;
            if (!bl) {
                stringBuffer.append(", ");
            }
            bl = false;
            stringBuffer.append(string4);
        }
        if (string.length() != 0) {
            if (!bl) {
                stringBuffer.append(", ");
            }
            bl = false;
            stringBuffer.append(string);
        }
        if (string2.length() != 0) {
            if (!bl) {
                stringBuffer.append(", ");
            }
            bl = false;
            if (this.isDouble()) {
                stringBuffer.append("Head1: ");
            }
            stringBuffer.append(string2);
        }
        if (this.isDouble() && string3.length() != 0) {
            if (!bl) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("Head2: ").append(string3);
        }
        return stringBuffer.toString();
    }

    public Equipment getUberParent() {
        if (this.getParent() == null) {
            return this;
        }
        Equipment equipment = (Equipment)this.getParent();
        while (equipment.getParent() != null) {
            equipment = (Equipment)equipment.getParent();
        }
        return equipment;
    }

    public int getUsedCharges() {
        for (EquipmentModifier equipmentModifier : this.getEqModifierList(true)) {
            Integer n = equipmentModifier.get(IntegerKey.MIN_CHARGES);
            if (n == null || n <= 0) continue;
            return EqModSpellInfo.getUsedCharges(this, equipmentModifier);
        }
        return -1;
    }

    @Override
    public Float getVariableValue(String string, String string2, PlayerCharacter playerCharacter) {
        return this.getVariableValue(string, string2, this.bonusPrimary, playerCharacter);
    }

    public Float getVariableValue(String string, String string2, boolean bl, PlayerCharacter playerCharacter) {
        VariableProcessorEq variableProcessorEq = new VariableProcessorEq(this, playerCharacter, bl);
        return variableProcessorEq.getVariableValue(null, string, string2, 0);
    }

    public boolean isVisible(EquipmentModifier equipmentModifier) {
        Visibility visibility = equipmentModifier.getSafe(ObjectKey.VISIBILITY);
        if (Visibility.QUALIFY.equals((Object)visibility)) {
            this.bonusPrimary = true;
            if (PrereqHandler.passesAll(equipmentModifier.getPrerequisiteList(), this, null)) {
                return true;
            }
            if (this.isDouble()) {
                this.bonusPrimary = false;
                return PrereqHandler.passesAll(equipmentModifier.getPrerequisiteList(), this, null);
            }
            return false;
        }
        return Visibility.DEFAULT.equals((Object)visibility);
    }

    public Float getWeight(PlayerCharacter playerCharacter) {
        if (this.isVirtual()) {
            return new Float(0.0);
        }
        return new Float(this.getWeightAsDouble(playerCharacter));
    }

    public BigDecimal getBaseWeight() {
        if (this.isVirtual()) {
            return BigDecimal.ZERO;
        }
        return this.getWeightInPounds().add(this.getSafe(ObjectKey.WEIGHT_MOD));
    }

    public double getWeightAsDouble(PlayerCharacter playerCharacter) {
        double d;
        if (this.isVirtual()) {
            return 0.0;
        }
        double d2 = this.bonusTo(playerCharacter, "EQM", "WEIGHTMULT", true);
        double d3 = this.getWeightInPounds().doubleValue();
        if (!CoreUtility.doublesEqual(d2, 0.0)) {
            d3 *= d2;
        }
        if (!CoreUtility.doublesEqual(d = this.bonusTo(playerCharacter, "EQM", "WEIGHTDIV", true), 0.0)) {
            d3 /= d;
        }
        d3 += this.bonusTo(playerCharacter, "EQM", "WEIGHTADD", true);
        return d3 += this.getSafe(ObjectKey.WEIGHT_MOD).doubleValue();
    }

    public String getWieldName() {
        WieldCategory wieldCategory = this.get(ObjectKey.WIELD);
        return wieldCategory == null ? "" : wieldCategory.getName();
    }

    public Integer acCheck(PlayerCharacter playerCharacter) {
        return Math.min(this.getSafe(IntegerKey.AC_CHECK) + (int)this.bonusTo(playerCharacter, "EQMARMOR", "ACCHECK", true), 0);
    }

    @Override
    public boolean acceptsChildren() {
        return this.get(ObjectKey.CONTAINER_WEIGHT_CAPACITY) != null;
    }

    private void addEqModifier(String string, boolean bl, boolean bl2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        String string2 = stringTokenizer.nextToken();
        EquipmentModifier equipmentModifier = this.getEqModifierKeyed(string2, bl);
        if (equipmentModifier == null) {
            if (string2.equals(EQMOD_WEIGHT)) {
                if (stringTokenizer.hasMoreTokens()) {
                    this.put(ObjectKey.WEIGHT_MOD, new BigDecimal(stringTokenizer.nextToken().replace(',', '.')));
                }
                return;
            }
            if (string2.equals(EQMOD_DAMAGE)) {
                if (stringTokenizer.hasMoreTokens()) {
                    this.put(StringKey.DAMAGE_OVERRIDE, stringTokenizer.nextToken());
                }
                return;
            }
            equipmentModifier = Globals.getContext().ref.silentlyGetConstructedCDOMObject(EquipmentModifier.class, string2);
            if (equipmentModifier == null) {
                Logging.errorPrint("Could not find EquipmentModifier: " + string2);
                return;
            }
            if (equipmentModifier.getSafe(StringKey.CHOICE_STRING).length() != 0) {
                equipmentModifier = equipmentModifier.clone();
            }
            this.addToEqModifierList(equipmentModifier, bl);
        }
        if (equipmentModifier.getSafe(StringKey.CHOICE_STRING).length() != 0) {
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                Integer n = equipmentModifier.get(IntegerKey.MIN_CHARGES);
                if (n != null && n > 0 || equipmentModifier.getSafe(StringKey.CHOICE_STRING).startsWith("EQBUILDER") && !bl2) {
                    this.removeAllAssociations(equipmentModifier);
                }
                this.addAssociation((CDOMObject)equipmentModifier, string3.replace('=', '|'));
            }
        }
    }

    public void addEqModifier(EquipmentModifier equipmentModifier, boolean bl, PlayerCharacter playerCharacter) {
        this.addEqModifier(equipmentModifier, bl, playerCharacter, null, null);
    }

    public void addEqModifier(EquipmentModifier equipmentModifier, boolean bl, PlayerCharacter playerCharacter, String string, EquipmentChoice equipmentChoice) {
        Object object;
        Object object2;
        boolean bl2 = false;
        if (playerCharacter != null && playerCharacter.isImporting()) {
            bl2 = true;
        }
        if (!bl2 && !this.canAddModifier(equipmentModifier, bl)) {
            return;
        }
        List<CDOMSingleRef<EquipmentModifier>> list = equipmentModifier.getListFor(ListKey.REPLACED_KEYS);
        EquipmentHead equipmentHead = this.getEquipmentHead(bl ? 1 : 2);
        if (list != null) {
            object2 = list.iterator();
            while (object2.hasNext()) {
                object = object2.next();
                EquipmentModifier equipmentModifier2 = ((CDOMSingleRef)object).resolvesTo();
                String string2 = equipmentModifier2.getKeyName();
                for (EquipmentModifier equipmentModifier3 : equipmentHead.getSafeListFor(ListKey.EQMOD)) {
                    if (!string2.equalsIgnoreCase(equipmentModifier3.getKeyName())) continue;
                    equipmentHead.removeFromListFor(ListKey.EQMOD, equipmentModifier3);
                    if (bl) {
                        this.usePrimaryCache = false;
                    } else {
                        this.useSecondaryCache = false;
                    }
                    this.setDirty(true);
                }
            }
        }
        if (equipmentModifier.isType("BaseMaterial")) {
            object2 = equipmentHead.getSafeListFor(ListKey.EQMOD).iterator();
            while (object2.hasNext()) {
                object = (EquipmentModifier)object2.next();
                if (!((PObject)object).isType("BaseMaterial")) continue;
                equipmentHead.removeFromListFor(ListKey.EQMOD, object);
                if (bl) {
                    this.usePrimaryCache = false;
                } else {
                    this.useSecondaryCache = false;
                }
                this.setDirty(true);
            }
        } else if (equipmentModifier.isType("MagicalEnhancement")) {
            object2 = equipmentHead.getSafeListFor(ListKey.EQMOD).iterator();
            while (object2.hasNext()) {
                object = (EquipmentModifier)object2.next();
                if (!((PObject)object).isType("MagicalEnhancement")) continue;
                equipmentHead.removeFromListFor(ListKey.EQMOD, object);
                if (bl) {
                    this.usePrimaryCache = false;
                    continue;
                }
                this.useSecondaryCache = false;
            }
        }
        if ((object2 = this.getEqModifierKeyed(equipmentModifier.getKeyName(), bl)) == null) {
            if (equipmentModifier.getSafe(StringKey.CHOICE_STRING).length() != 0) {
                object2 = equipmentModifier.clone();
                if (object2 == null) {
                    return;
                }
            } else {
                object2 = equipmentModifier;
            }
            equipmentHead.addToListFor(ListKey.EQMOD, object2);
            if (bl) {
                this.usePrimaryCache = false;
            } else {
                this.useSecondaryCache = false;
            }
        }
        if (!bl2) {
            boolean bl3 = false;
            if (string != null && string.length() > 0) {
                if (!equipmentModifier.getSafe(StringKey.CHOICE_STRING).startsWith("EQBUILDER.")) {
                    EquipmentChoiceDriver.setChoice(this, (EquipmentModifier)object2, string, equipmentChoice);
                    bl3 = !this.hasAssociations((CDOMObject)object2);
                }
            } else if (!EquipmentChoiceDriver.getChoice(1, this, (EquipmentModifier)object2, true, playerCharacter)) {
                bl3 = true;
            }
            if (bl3) {
                equipmentHead.removeFromListFor(ListKey.EQMOD, object2);
                if (bl) {
                    this.usePrimaryCache = false;
                } else {
                    this.useSecondaryCache = false;
                }
            }
        }
        this.setBase(playerCharacter);
    }

    public void addEqModifiers(String string, boolean bl) {
        this.addEqModifiers(string, bl, false);
    }

    public void addEqModifiers(String string, boolean bl, boolean bl2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equalsIgnoreCase("None")) continue;
            this.addEqModifier(string2, bl, bl2);
        }
    }

    public double bonusTo(PlayerCharacter playerCharacter, String string, String string2, boolean bl) {
        return this.bonusTo(playerCharacter, string, string2, this, bl);
    }

    public double bonusTo(PlayerCharacter playerCharacter, String string, String string2, Object object, boolean bl) {
        List<EquipmentModifier> list;
        StringBuffer stringBuffer = new StringBuffer(string.toUpperCase());
        stringBuffer.append('.');
        stringBuffer.append(string2.toUpperCase());
        stringBuffer.append('.');
        String string3 = stringBuffer.toString();
        for (String object2 : this.getBonusMap().keySet()) {
            if (!object2.startsWith(string3)) continue;
            this.putBonusMap(object2, "0");
        }
        this.bonusPrimary = bl;
        if (bl) {
            super.bonusTo(string, string2, this, playerCharacter);
            list = new ArrayList<EquipmentModifier>();
            for (BonusObj bonusObj : this.getTempBonusList()) {
                if (list.contains(bonusObj)) continue;
                list.add((EquipmentModifier)((Object)bonusObj));
            }
            super.bonusTo(string, string2, object, list, playerCharacter);
        }
        if (Globals.checkRule("SYS_35WP")) {
            list = GameMode.getEqSizePenaltyObj().getSafeListFor(ListKey.BONUS);
            super.bonusTo(string, string2, this, list, playerCharacter);
        }
        list = this.getEqModifierList(bl);
        for (EquipmentModifier equipmentModifier : list) {
            equipmentModifier.bonusTo(playerCharacter, string, string2, this);
        }
        double d = 0.0;
        for (String string4 : this.getBonusMap().keySet()) {
            if (!string4.startsWith(string3)) continue;
            d += (double)Float.parseFloat(this.getBonusMap().get(string4));
        }
        return d;
    }

    public int calcPlusForCosting() {
        int n = 0;
        for (EquipmentHead equipmentHead : this.heads) {
            for (EquipmentModifier equipmentModifier : equipmentHead.getSafeListFor(ListKey.EQMOD)) {
                int n2 = this.getSelectCorrectedAssociationCount(equipmentModifier);
                if (n2 < 1) {
                    n2 = 1;
                }
                n += n2 * equipmentModifier.getSafe(IntegerKey.PLUS);
            }
        }
        return n;
    }

    public int calcPlusForHead(boolean bl) {
        int n = 0;
        int n2 = bl ? 1 : 2;
        EquipmentHead equipmentHead = this.getEquipmentHeadReference(n2);
        if (equipmentHead == null) {
            return n;
        }
        for (EquipmentModifier equipmentModifier : equipmentHead.getSafeListFor(ListKey.EQMOD)) {
            int n3 = this.getSelectCorrectedAssociationCount(equipmentModifier);
            if (n3 < 1) {
                n3 = 1;
            }
            n += n3 * equipmentModifier.getSafe(IntegerKey.PLUS);
        }
        return n;
    }

    public boolean canAddModifier(PrereqObject prereqObject, boolean bl) {
        this.bonusPrimary = bl;
        return this.getSafe(ObjectKey.MOD_CONTROL).getModifiersAllowed() && PrereqHandler.passesAll(prereqObject.getPrerequisiteList(), this, null);
    }

    @Override
    public int canContain(PlayerCharacter playerCharacter, Object object) {
        if (object instanceof Equipment) {
            Equipment equipment = (Equipment)object;
            Float f = new Float(equipment.getWeightAsDouble(playerCharacter) * (double)equipment.numberCarried().floatValue());
            if (this.checkChildWeight(playerCharacter, f)) {
                if (this.checkContainerCapacity(equipment.eqTypeList(), equipment.numberCarried())) {
                    return 1;
                }
                return 4;
            }
            return 2;
        }
        return 0;
    }

    @Override
    public Equipment clone() {
        Equipment equipment = null;
        try {
            equipment = (Equipment)super.clone();
            equipment.heads = new ArrayList<EquipmentHead>();
            for (EquipmentHead equipmentHead : this.heads) {
                if (equipmentHead == null) {
                    equipment.heads.add(null);
                    continue;
                }
                equipment.heads.add((EquipmentHead)equipmentHead.clone());
            }
            if (this.bonusMap != null) {
                equipment.bonusMap = new HashMap<String, String>(this.bonusMap);
            }
            equipment.setMoveString(this.moveString());
            equipment.carried = this.carried;
            equipment.equipped = this.equipped;
            equipment.location = this.location;
            equipment.bonusType = this.bonusType;
            equipment.numberEquipped = this.numberEquipped;
            equipment.qty = this.qty;
            equipment.outputIndex = this.outputIndex;
            equipment.d_childTypes = new HashMap<String, Float>(this.d_childTypes);
            equipment.d_containedEquipment = new ArrayList<Equipment>(this.d_containedEquipment);
            equipment.assocSupt = this.assocSupt.clone();
            equipment.getEquipmentHead(1).removeListFor(ListKey.EQMOD);
            equipment.getEquipmentHead(2).removeListFor(ListKey.EQMOD);
            equipment.getEquipmentHead(1).addAllToListFor(ListKey.EQMOD, this.cloneEqModList(equipment, true));
            equipment.getEquipmentHead(2).addAllToListFor(ListKey.EQMOD, this.cloneEqModList(equipment, false));
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ShowMessageDelegate.showMessageDialog(cloneNotSupportedException.getMessage(), "PCGen", MessageType.ERROR);
        }
        return equipment;
    }

    @Override
    public int compareTo(Object object) {
        Equipment equipment = (Equipment)object;
        return this.getName().compareToIgnoreCase(equipment.getName());
    }

    public Integer eDR(PlayerCharacter playerCharacter) {
        return Math.max(0, this.getSafe(IntegerKey.EDR) + (int)this.bonusTo(playerCharacter, "EQMARMOR", "EDR", true));
    }

    @Override
    public boolean equals(Object object) {
        return object != null && object instanceof Equipment && (object == this || this.getName().equals(((Equipment)object).getName()));
    }

    public String formatSaveLine(char c, char c2) {
        String string;
        String string2;
        String string3;
        SizeAdjustment sizeAdjustment;
        Equipment equipment;
        StringBuffer stringBuffer = new StringBuffer(100);
        CDOMSingleRef<Equipment> cDOMSingleRef = this.get(ObjectKey.BASE_ITEM);
        if (cDOMSingleRef == null) {
            equipment = this;
            stringBuffer.append(this.getBaseItemName());
        } else {
            equipment = cDOMSingleRef.resolvesTo();
            stringBuffer.append(equipment);
            stringBuffer.append(c).append("NAME").append(c2).append(this.toString(false));
        }
        if (equipment == null) {
            return stringBuffer.toString();
        }
        if (!this.getKeyName().equals(this.getName())) {
            stringBuffer.append(c).append("KEY").append(c2).append(this.getKeyName());
        }
        if (!(sizeAdjustment = this.getSafe(ObjectKey.SIZE)).equals(equipment.getSafe(ObjectKey.SIZE))) {
            stringBuffer.append(c).append("SIZE").append(c2).append(sizeAdjustment.getAbbreviation());
        }
        if ((string3 = this.getEqModifierString(true)).length() > 0) {
            stringBuffer.append(c).append("EQMOD").append(c2).append(string3);
        }
        if ((string2 = this.getEqModifierString(false)).length() > 0) {
            stringBuffer.append(c).append("ALTEQMOD").append(c2).append(string2);
        }
        if ((string = this.getRawSpecialProperties()).length() > 0 && !string.equals(equipment.getRawSpecialProperties())) {
            stringBuffer.append(c).append("SPROP").append(c2).append(string);
        }
        if (!this.costMod.equals(BigDecimal.ZERO)) {
            stringBuffer.append(c).append("COSTMOD").append(c2).append(this.costMod.toString());
        }
        return stringBuffer.toString();
    }

    public boolean hasVFeats() {
        return this.hasListMods(AbilityList.getAbilityListReference(AbilityCategory.FEAT, Ability.Nature.VIRTUAL));
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public int indexOfChild(Object object) {
        if (!(object instanceof Equipment)) {
            return -1;
        }
        return this.getContainedEquipmentIndexOf((Equipment)object);
    }

    @Override
    public void insertChild(PlayerCharacter playerCharacter, Object object) {
        Float f;
        if (object == null) {
            return;
        }
        Equipment equipment = (Equipment)object;
        Float f2 = f = equipment.numberCarried();
        String string = this.pickChildType(equipment.eqTypeList(), f);
        if (this.containsChildType(string)) {
            f = Float.valueOf(this.getChildType(string).floatValue() + f.floatValue());
        }
        f2 = Float.valueOf(this.getChildType("Total").floatValue() + f2.floatValue());
        this.setChildType(string, f);
        this.setChildType("Total", f2);
        this.addContainedEquipment(equipment);
        equipment.setIndexedUnderType(string);
        equipment.setParent(this);
        this.updateContainerContentsString(playerCharacter);
        while (equipment.getParent() != null) {
            equipment = (Equipment)equipment.getParent();
            equipment.updateContainerContentsString(playerCharacter);
        }
    }

    public int itemDepth() {
        if (this.getParent() == null) {
            return 0;
        }
        int n = 1;
        Equipment equipment = (Equipment)this.getParent();
        while (equipment.getParent() != null) {
            equipment = (Equipment)equipment.getParent();
            ++n;
        }
        return n;
    }

    public void load(String string) {
        this.load(string, "\t", ":");
    }

    public void load(String string, String string2, String string3) {
        this.load(string, string2, string3, null);
    }

    public void load(String string, String string2, String string3, PlayerCharacter playerCharacter) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        int n = string3.length();
        SizeAdjustment sizeAdjustment = this.getSafe(ObjectKey.SIZE);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (string4.startsWith("NAME" + string3)) {
                this.setName(string4.substring(4 + n));
                continue;
            }
            if (string4.startsWith("KEY" + string3)) {
                this.put(StringKey.KEY_NAME, string4.substring(3 + n));
                continue;
            }
            if (string4.startsWith("SIZE" + string3)) {
                sizeAdjustment = SettingsHandler.getGame().getSizeAdjustmentNamed(string4.substring(4 + n));
                continue;
            }
            if (string4.startsWith("EQMOD" + string3)) {
                this.addEqModifiers(string4.substring(5 + n), true, true);
                continue;
            }
            if (string4.startsWith("ALTEQMOD" + string3)) {
                this.addEqModifiers(string4.substring(8 + n), false);
                continue;
            }
            if (string4.startsWith("SPROP" + string3)) {
                this.addToListFor(ListKey.SPECIAL_PROPERTIES, SpecialProperty.createFromLst(string4.substring(5 + n)));
                continue;
            }
            if (string4.startsWith("COSTMOD" + string3)) {
                this.setCostMod(string4.substring(7 + n));
                continue;
            }
            if (!string4.startsWith("WEIGHTMOD" + string3)) continue;
            this.put(ObjectKey.WEIGHT_MOD, new BigDecimal(string4.substring(9 + n)));
        }
        this.resizeItem(playerCharacter, sizeAdjustment);
    }

    public String longName() {
        return this.toString(true);
    }

    public boolean meetsPreReqs(PlayerCharacter playerCharacter) {
        return PrereqHandler.passesAll(this.getPrerequisiteList(), this, playerCharacter);
    }

    public String modifiedName() {
        return this.modifiedName;
    }

    public String moveString() {
        if (this.moveString.length() > 0) {
            Load load = this.isHeavy() ? Load.HEAVY : (this.isMedium() ? Load.MEDIUM : (this.isLight() ? Load.LIGHT : Load.OVERLOAD));
            StringTokenizer stringTokenizer = new StringTokenizer(this.moveString, ",");
            int n = -1;
            int n2 = stringTokenizer.countTokens();
            switch (n2) {
                case 2: {
                    n = 30;
                    break;
                }
                case 3: {
                    n = 60;
                    break;
                }
                default: {
                    n2 = -1;
                }
            }
            if (n2 > 0) {
                StringBuffer stringBuffer = new StringBuffer(this.moveString.length());
                for (int i = 0; i < n2; ++i) {
                    if (i != 0) {
                        stringBuffer.append(',');
                    }
                    stringBuffer.append(Globals.calcEncumberedMove(load, n, true));
                    n -= 10;
                }
                return stringBuffer.toString();
            }
        }
        return this.moveString;
    }

    public String nameItemFromModifiers(PlayerCharacter playerCharacter) {
        String string = this.getItemNameFromModifiers();
        this.cleanTypes(playerCharacter);
        this.setDefaultCrit(playerCharacter);
        this.setName(string);
        this.remove(StringKey.OUTPUT_NAME);
        return this.getName();
    }

    public Float numberCarried() {
        Equipment equipment;
        if (this.isEquipped() || equipment == null) {
            return this.carried;
        }
        for (equipment = (Equipment)this.getParent(); equipment != null; equipment = (Equipment)equipment.getParent()) {
            if (!equipment.isEquipped() && (equipment.getParent() != null || equipment.numberCarried().intValue() == 0)) continue;
            return this.carried;
        }
        return Float.valueOf(0.0f);
    }

    public double qty() {
        return this.qty;
    }

    public void removeChild(PlayerCharacter playerCharacter, Object object) {
        int n = this.indexOfChild(object);
        Equipment equipment = (Equipment)object;
        Float f = equipment.numberCarried();
        this.setChildType("Total", Float.valueOf(this.getChildType("Total").floatValue() - f.floatValue()));
        String string = equipment.isIndexedUnderType();
        this.setChildType(string, Float.valueOf(this.getChildType(string).floatValue() - f.floatValue()));
        equipment.setParent(null);
        this.removeContainedEquipment(n);
        this.updateContainerContentsString(playerCharacter);
        Equipment equipment2 = this;
        while (equipment2.getParent() != null) {
            equipment2 = (Equipment)equipment2.getParent();
            equipment2.updateContainerContentsString(playerCharacter);
        }
    }

    public void removeEqModifier(EquipmentModifier equipmentModifier, boolean bl, PlayerCharacter playerCharacter) {
        EquipmentModifier equipmentModifier2 = this.getEqModifierKeyed(equipmentModifier.getKeyName(), bl);
        if (equipmentModifier2 == null) {
            return;
        }
        if (!this.hasAssociations(equipmentModifier2) || !EquipmentChoiceDriver.getChoice(0, this, equipmentModifier2, false, playerCharacter)) {
            this.getEquipmentHead(bl ? 1 : 2).removeFromListFor(ListKey.EQMOD, equipmentModifier2);
            if (bl) {
                this.usePrimaryCache = false;
            } else {
                this.useSecondaryCache = false;
            }
            this.setDirty(true);
        }
    }

    public void removeEqModifiers(String string, boolean bl, PlayerCharacter playerCharacter) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equalsIgnoreCase("None")) continue;
            this.removeEqModifier(string2, bl, playerCharacter);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void resizeItem(PlayerCharacter playerCharacter, SizeAdjustment sizeAdjustment) {
        this.setBase(playerCharacter);
        int n = this.sizeInt();
        int n2 = Globals.sizeInt(sizeAdjustment);
        if (n2 != n) {
            BigDecimal bigDecimal;
            String string;
            void var6_8;
            this.put(ObjectKey.SIZE, sizeAdjustment);
            CDOMSingleRef<Equipment> cDOMSingleRef = this.get(ObjectKey.BASE_ITEM);
            if (cDOMSingleRef == null) {
                Equipment cloneable = this;
            } else {
                Equipment equipment = (Equipment)cDOMSingleRef.resolvesTo();
            }
            this.put(ObjectKey.CURRENT_COST, super.getCostAdjustedForSize(playerCharacter, sizeAdjustment));
            this.put(ObjectKey.WEIGHT, super.getWeightAdjustedForSize(playerCharacter, sizeAdjustment));
            this.adjustACForSize(playerCharacter, (Equipment)var6_8, sizeAdjustment);
            String string2 = super.getDamageAdjustedForSize(sizeAdjustment, true);
            if (string2 != null && string2.length() > 0) {
                this.getEquipmentHead(1).put(StringKey.DAMAGE, string2);
            }
            if ((string = super.getDamageAdjustedForSize(sizeAdjustment, false)) != null && string.length() > 0) {
                this.getEquipmentHead(2).put(StringKey.DAMAGE, string);
            }
            if ((bigDecimal = this.get(ObjectKey.CONTAINER_WEIGHT_CAPACITY)) != null) {
                List<Capacity> list;
                double d = 1.0;
                if (sizeAdjustment != null) {
                    d = sizeAdjustment.getBonusTo(playerCharacter, "ITEMCAPACITY", var6_8.typeList(), 1.0);
                }
                BigDecimal bigDecimal2 = new BigDecimal(d);
                if (!Capacity.UNLIMITED.equals(bigDecimal)) {
                    this.put(ObjectKey.CONTAINER_WEIGHT_CAPACITY, bigDecimal.multiply(bigDecimal2));
                }
                if ((list = this.removeListFor(ListKey.CAPACITY)) != null) {
                    for (Capacity capacity : list) {
                        BigDecimal bigDecimal3 = capacity.getCapacity();
                        if (!Capacity.UNLIMITED.equals(bigDecimal3)) {
                            bigDecimal3 = bigDecimal3.multiply(bigDecimal2);
                        }
                        this.addToListFor(ListKey.CAPACITY, new Capacity(capacity.getType(), bigDecimal3));
                    }
                }
                this.updateContainerCapacityString();
            }
        }
        if (this.hasPrerequisites()) {
            for (Prerequisite prerequisite : this.getPrerequisiteList()) {
                int n3;
                if (!"SIZE".equalsIgnoreCase(prerequisite.getKind()) || (n2 += (n3 = Globals.sizeInt(prerequisite.getOperand())) - n) < 0 || n2 > SettingsHandler.getGame().getSizeAdjustmentListSize() - 1) continue;
                prerequisite.setOperand(SettingsHandler.getGame().getSizeAdjustmentAtIndex(n2).getAbbreviation());
            }
        }
    }

    public int sizeInt() {
        return Globals.sizeInt(this.getSafe(ObjectKey.SIZE));
    }

    public Integer spellFailure(PlayerCharacter playerCharacter) {
        return Math.max(0, this.getSafe(IntegerKey.SPELL_FAILURE) + (int)this.bonusTo(playerCharacter, "EQMARMOR", "SPELLFAILURE", true));
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean bl) {
        if (this.isDirty() || this.cachedNameWithCharges == null && this.cachedNameWithoutCharges == null) {
            int n;
            StringBuffer stringBuffer = new StringBuffer(this.getDisplayName());
            if (this.modifiedName.length() > 0) {
                stringBuffer.append(" (").append(this.modifiedName).append(")");
            }
            this.cachedNameWithoutCharges = stringBuffer.toString();
            if (bl && (n = this.getRemainingCharges()) > 0 && n < this.getMaxCharges()) {
                stringBuffer.append("(").append(n).append(")");
            }
            this.cachedNameWithCharges = stringBuffer.toString();
            this.setDirty(false);
        }
        if (bl) {
            return this.cachedNameWithCharges;
        }
        return this.cachedNameWithoutCharges;
    }

    private boolean isDirty() {
        return this.dirty;
    }

    private void setDirty(boolean bl) {
        this.dirty = bl;
    }

    public String typeIndex(int n) {
        List<String> list = this.typeList();
        if (n < 0 || n >= list.size()) {
            return "";
        }
        return list.get(n);
    }

    public List<String> typeList() {
        return this.typeList(true);
    }

    public void updateContainerContentsString(PlayerCharacter playerCharacter) {
        StringBuffer stringBuffer = new StringBuffer(this.getChildCount() * 20);
        if (playerCharacter != null && this.acceptsChildren() && this.getContainedWeight(playerCharacter, true).floatValue() >= 0.0f) {
            stringBuffer.append(Globals.getGameModeUnitSet().displayWeightInUnitSet(this.getContainedWeight(playerCharacter, true).doubleValue())).append(Globals.getGameModeUnitSet().getWeightUnit());
        } else {
            stringBuffer.append("0.0 ");
            stringBuffer.append(Globals.getGameModeUnitSet().getWeightUnit());
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            Equipment equipment = (Equipment)this.getChild(i);
            if (!(equipment.getQty().floatValue() > 0.0f)) continue;
            stringBuffer.append(", ");
            stringBuffer.append(BigDecimalHelper.trimZeros(equipment.getQty().toString()));
            stringBuffer.append(" ");
            stringBuffer.append(equipment.getOutputName());
        }
        this.containerContentsString = stringBuffer.toString();
    }

    private void setDefaultCrit(PlayerCharacter playerCharacter) {
        if (this.isWeapon()) {
            if (playerCharacter != null && playerCharacter.getCritRange(this, true) == 0) {
                this.getEquipmentHead(1).put(IntegerKey.CRIT_RANGE, 1);
            }
            if (this.getCritMultiplier() == 0) {
                this.getEquipmentHead(1).put(IntegerKey.CRIT_MULT, 2);
            }
        }
    }

    public void setQty(double d) {
        this.qty = d;
    }

    static void clearEquipmentTypes() {
        S_EQUIPMENT_TYPES.clear();
    }

    String getType(boolean bl) {
        List<String> list = this.typeList(bl);
        int n = list.size();
        StringBuffer stringBuffer = new StringBuffer(n * 5);
        for (String string : list) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append('.');
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    boolean save(BufferedWriter bufferedWriter) {
        FileAccess.write(bufferedWriter, "BASEITEM:" + this.formatSaveLine('\t', ':'));
        FileAccess.newLine(bufferedWriter);
        return true;
    }

    public void setBase(PlayerCharacter playerCharacter) {
        Object object;
        if (this.get(ObjectKey.BASE_ITEM) == null && (object = Globals.getContext().ref.silentlyGetConstructedCDOMObject(Equipment.class, this.getKeyName())) != null) {
            this.put(ObjectKey.BASE_ITEM, CDOMDirectSingleRef.getRef(object));
        }
        if (this.hasConsolidatedProfName() && (object = this.get(ObjectKey.BASE_ITEM)) != null) {
            CDOMSingleRef<ShieldProf> cDOMSingleRef;
            CDOMSingleRef<ArmorProf> cDOMSingleRef2;
            Equipment equipment = (Equipment)((CDOMSingleRef)object).resolvesTo();
            CDOMSingleRef<WeaponProf> cDOMSingleRef3 = equipment.get(ObjectKey.WEAPON_PROF);
            if (cDOMSingleRef3 != null) {
                this.put(ObjectKey.WEAPON_PROF, cDOMSingleRef3);
            }
            if ((cDOMSingleRef2 = equipment.get(ObjectKey.ARMOR_PROF)) != null) {
                this.put(ObjectKey.ARMOR_PROF, cDOMSingleRef2);
            }
            if ((cDOMSingleRef = equipment.get(ObjectKey.SHIELD_PROF)) != null) {
                this.put(ObjectKey.SHIELD_PROF, cDOMSingleRef);
            }
        }
    }

    public boolean hasConsolidatedProfName() {
        if (this.isWeapon()) {
            return this.get(ObjectKey.WEAPON_PROF) != null;
        }
        if (this.isArmor()) {
            return this.get(ObjectKey.ARMOR_PROF) != null;
        }
        if (this.isShield()) {
            return this.get(ObjectKey.SHIELD_PROF) != null;
        }
        return false;
    }

    public String consolidatedProfName() {
        if (this.isWeapon()) {
            CDOMSingleRef<WeaponProf> cDOMSingleRef = this.get(ObjectKey.WEAPON_PROF);
            if (cDOMSingleRef != null) {
                return cDOMSingleRef.resolvesTo().getKeyName();
            }
        } else {
            if (this.isArmor()) {
                return this.getArmorProf().getKeyName();
            }
            if (this.isShield()) {
                return this.getShieldProf().getKeyName();
            }
        }
        return "";
    }

    private Float getChildType(String string) {
        return this.d_childTypes.get(string);
    }

    private int getContainedEquipmentIndexOf(Equipment equipment) {
        return this.d_containedEquipment.indexOf(equipment);
    }

    private BigDecimal getCostAdjustedForSize(PlayerCharacter playerCharacter, SizeAdjustment sizeAdjustment) {
        BigDecimal bigDecimal = this.getSafe(ObjectKey.COST);
        SizeAdjustment sizeAdjustment2 = this.get(ObjectKey.BASESIZE);
        if (sizeAdjustment2 == null) {
            sizeAdjustment2 = SettingsHandler.getGame().getDefaultSizeAdjustment();
        }
        if (sizeAdjustment == null || sizeAdjustment2 == null) {
            return bigDecimal;
        }
        double d = sizeAdjustment.getBonusTo(playerCharacter, "ITEMCOST", this.typeList(), 1.0);
        double d2 = sizeAdjustment2.getBonusTo(playerCharacter, "ITEMCOST", this.typeList(), 1.0);
        double d3 = d / d2;
        bigDecimal = bigDecimal.multiply(new BigDecimal(d3));
        return bigDecimal;
    }

    private String getEqModifierString(boolean bl) {
        List<EquipmentModifier> list = this.getEqModifierList(bl);
        StringBuffer stringBuffer = new StringBuffer(list.size() * 10);
        Object object = list.iterator();
        while (object.hasNext()) {
            EquipmentModifier equipmentModifier = object.next();
            if (stringBuffer.length() != 0) {
                stringBuffer.append('.');
            }
            stringBuffer.append(equipmentModifier.getKeyName());
            for (String string : this.getAssociationList(equipmentModifier)) {
                stringBuffer.append('|').append(string.replace('|', '='));
            }
        }
        if (bl && (object = this.get(ObjectKey.WEIGHT_MOD)) != null) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append('.');
            }
            stringBuffer.append(EQMOD_WEIGHT).append('|').append(((BigDecimal)object).toString().replace('.', ','));
        }
        if ((object = this.get(StringKey.DAMAGE_OVERRIDE)) != null) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append('.');
            }
            stringBuffer.append(EQMOD_DAMAGE).append('|').append(((String)object).replace('.', ','));
        }
        return stringBuffer.toString();
    }

    private void setIndexedUnderType(String string) {
        this.indexedUnderType = string;
    }

    private String isIndexedUnderType() {
        return this.indexedUnderType;
    }

    private static EquipmentModifier getMagicBonus(Iterable<EquipmentModifier> iterable) {
        if (iterable != null) {
            for (EquipmentModifier equipmentModifier : iterable) {
                if (!equipmentModifier.isType("MagicalEnhancement") && !equipmentModifier.isIType("Magic")) continue;
                return equipmentModifier;
            }
        }
        return null;
    }

    private String getNameFromModifiers(List<EquipmentModifier> list) {
        ArrayList<EquipmentModifier> arrayList = new ArrayList<EquipmentModifier>(list);
        Globals.sortPObjectList(arrayList);
        StringBuffer stringBuffer = new StringBuffer(70);
        for (EquipmentModifier equipmentModifier : arrayList) {
            String string = equipmentModifier.getSafe(ObjectKey.NAME_OPT).returnName(this, equipmentModifier);
            if (stringBuffer.length() > 0 && string.length() > 0) {
                stringBuffer.append('/');
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private List<String> getSpecialAbilityList(Iterable<EquipmentModifier> iterable, PlayerCharacter playerCharacter) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (EquipmentModifier equipmentModifier : iterable) {
            arrayList.addAll(equipmentModifier.getSpecialProperties(this, playerCharacter));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BigDecimal getCostFromPluses(int n, int n2) {
        if ((n != 0 || n2 != 0) && JEPResourceChecker.getMissingResourceCount() == 0) {
            PJEP pJEP = null;
            try {
                String string;
                String string2;
                pJEP = PjepPool.getInstance().aquire();
                pJEP.addVariable("PLUS", n);
                pJEP.addVariable("ALTPLUS", n2);
                pJEP.addVariable("BASECOST", this.getSafe(ObjectKey.COST).doubleValue());
                if (this.isAmmunition()) {
                    pJEP.addVariable("BASEQTY", this.getSafe(IntegerKey.BASE_QUANTITY));
                }
                BigDecimal bigDecimal = null;
                List<String> list = this.typeList();
                for (int i = 0; i < list.size(); ++i) {
                    string2 = list.get(i);
                    string = SettingsHandler.getGame().getPlusCalculation(string2);
                    if (string == null) continue;
                    BigDecimal bigDecimal2 = this.evaluateCost(pJEP, string);
                    if (bigDecimal != null && bigDecimal2.compareTo(bigDecimal) <= 1) continue;
                    bigDecimal = bigDecimal2;
                }
                if (bigDecimal != null) {
                    BigDecimal bigDecimal3 = bigDecimal;
                    return bigDecimal3;
                }
                string2 = "ANY";
                string = SettingsHandler.getGame().getPlusCalculation(string2);
                if (string != null) {
                    BigDecimal bigDecimal4 = this.evaluateCost(pJEP, string);
                    return bigDecimal4;
                }
            }
            finally {
                PjepPool.getInstance().release(pJEP);
            }
        }
        return BigDecimal.ZERO;
    }

    private boolean isMagicLimitedType() {
        boolean bl = false;
        if (this.isType("HEADGEAR") || this.isType("EYEGEAR") || this.isType("CAPE") || this.isType("AMULET") || this.isSuit() || this.isType("ROBE") || this.isType("SHIRT") || this.isType("BRACER") || this.isType("GLOVE") || this.isType("RING") || this.isType("BELT") || this.isType("BOOT")) {
            bl = true;
        }
        return bl;
    }

    private List<String> getSpecialAbilityTimesList(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int[] nArray = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            if (!arrayList.contains(string)) {
                arrayList.add(string);
                nArray[i] = 1;
                continue;
            }
            for (int j = 0; j < arrayList.size(); ++j) {
                String string2 = (String)arrayList.get(j);
                if (!string2.equals(string)) continue;
                int n = j;
                nArray[n] = nArray[n] + 1;
            }
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = (String)arrayList.get(i);
            if (nArray[i] > 1) {
                string = string + " (" + nArray[i] + ")";
            }
            arrayList2.add(string);
        }
        return arrayList2;
    }

    private BigDecimal getWeightAdjustedForSize(PlayerCharacter playerCharacter, SizeAdjustment sizeAdjustment) {
        if (this.isVirtual()) {
            return BigDecimal.ZERO;
        }
        SizeAdjustment sizeAdjustment2 = this.getSafe(ObjectKey.SIZE);
        if (sizeAdjustment == null || sizeAdjustment2 == null) {
            return this.getBaseWeight();
        }
        double d = sizeAdjustment.getBonusTo(playerCharacter, "ITEMWEIGHT", this.typeList(), 1.0) / sizeAdjustment2.getBonusTo(playerCharacter, "ITEMWEIGHT", this.typeList(), 1.0);
        return this.getBaseWeight().multiply(new BigDecimal(d));
    }

    private void addContainedEquipment(Equipment equipment) {
        this.d_containedEquipment.add(equipment);
    }

    private void adjustACForSize(PlayerCharacter playerCharacter, Equipment equipment, SizeAdjustment sizeAdjustment) {
        if (this.getRawBonusList(playerCharacter) != null && this.isArmor()) {
            int n;
            String string;
            double d = 1.0;
            SizeAdjustment sizeAdjustment2 = equipment.getSafe(ObjectKey.SIZE);
            if (sizeAdjustment != null && sizeAdjustment2 != null) {
                d = sizeAdjustment.getBonusTo(playerCharacter, "ACVALUE", equipment.typeList(), 1.0) / sizeAdjustment2.getBonusTo(playerCharacter, "ACVALUE", equipment.typeList(), 1.0);
            }
            List<BonusObj> list = equipment.getRawBonusList(playerCharacter);
            List<BonusObj> list2 = this.getRawBonusList(playerCharacter);
            for (int i = list2.size() - 1; i >= 0; --i) {
                BonusObj bonusObj = list2.get(i);
                string = bonusObj.toString();
                if (!string.startsWith("COMBAT|AC|") || (n = string.indexOf(124, 10)) <= 10) continue;
                this.removeFromListFor(ListKey.BONUS, bonusObj);
            }
            for (BonusObj bonusObj : list) {
                string = bonusObj.toString();
                if (!string.startsWith("COMBAT|AC|") || (n = string.indexOf(124, 10)) <= 10) continue;
                Integer n2 = Integer.valueOf(string.substring(10, n));
                n2 = new Float(n2.doubleValue() * d).intValue();
                BonusObj bonusObj2 = Bonus.newBonus(string = string.substring(0, 10) + n2.toString() + string.substring(n));
                if (bonusObj2 == null) continue;
                bonusObj2.setCreatorObject(this);
                this.addToListFor(ListKey.BONUS, bonusObj2);
            }
        }
    }

    private boolean checkChildWeight(PlayerCharacter playerCharacter, Float f) {
        BigDecimal bigDecimal = this.get(ObjectKey.CONTAINER_WEIGHT_CAPACITY);
        return bigDecimal != null && (Capacity.UNLIMITED.equals(bigDecimal) || (double)(f.floatValue() + this.getContainedWeight(playerCharacter).floatValue()) <= bigDecimal.doubleValue());
    }

    private boolean checkContainerCapacity(SortedSet<String> sortedSet, Float f) {
        return Capacity.ANY.equals(this.get(ObjectKey.TOTAL_CAPACITY)) || !"".equals(this.pickChildType(sortedSet, f));
    }

    private List<EquipmentModifier> cloneEqModList(Equipment equipment, boolean bl) {
        ArrayList<EquipmentModifier> arrayList = new ArrayList<EquipmentModifier>();
        for (EquipmentModifier equipmentModifier : this.getEqModifierList(bl)) {
            if (equipmentModifier.getSafe(StringKey.CHOICE_STRING).length() != 0) {
                EquipmentModifier equipmentModifier2 = equipmentModifier.clone();
                equipment.assocSupt.convertAssociations(equipmentModifier, equipmentModifier2);
                equipmentModifier = equipmentModifier2;
            }
            arrayList.add(equipmentModifier);
        }
        return arrayList;
    }

    private boolean containsChildType(String string) {
        return this.d_childTypes.containsKey(string);
    }

    private SortedSet<String> eqTypeList() {
        return new TreeSet<String>(this.typeList());
    }

    private static void extractListFromCommon(List<EquipmentModifier> list, List<EquipmentModifier> list2) {
        for (int i = list2.size() - 1; i >= 0; --i) {
            EquipmentModifier equipmentModifier = list2.get(i);
            if (!equipmentModifier.getSafe(ObjectKey.ASSIGN_TO_ALL).booleanValue()) continue;
            list.add(0, equipmentModifier);
            list2.remove(i);
        }
    }

    private void cleanTypes(PlayerCharacter playerCharacter) {
    }

    private BigDecimal evaluateCost(PJEP pJEP, String string) {
        Object object;
        pJEP.parseExpression(string);
        if (!pJEP.hasError() && (object = pJEP.getValueAsObject()) != null) {
            return new BigDecimal(object.toString());
        }
        Logging.errorPrint("Bad equipment cost expression: " + string);
        return BigDecimal.ZERO;
    }

    private boolean ignoresCostDouble() {
        boolean bl = false;
        if (this.isType("MANTLE") || this.isType("POTION") || this.isType("SCROLL") || this.isType("STAFF") || this.isType("WAND")) {
            bl = true;
        }
        return bl;
    }

    private String pickChildType(SortedSet<String> sortedSet, Float f) {
        Capacity capacity = this.get(ObjectKey.TOTAL_CAPACITY);
        BigDecimal bigDecimal = capacity.getCapacity();
        if (this.getChildType("Total") == null) {
            this.setChildType("Total", Float.valueOf(0.0f));
        }
        String string = "";
        if ((double)(this.getChildType("Total").floatValue() + f.floatValue()) <= bigDecimal.doubleValue()) {
            boolean bl = false;
            float f2 = this.containsChildType("Any") ? this.getChildType("Any").floatValue() : 0.0f;
            block0: for (Capacity capacity2 : this.getSafeListFor(ListKey.CAPACITY)) {
                String string2 = capacity2.getType();
                double d = capacity2.getCapacity().doubleValue();
                for (String string3 : sortedSet) {
                    if (string2.equalsIgnoreCase(string3)) {
                        if (!(this.containsChildType(string3) && (double)(this.getChildType(string3).floatValue() + f.floatValue()) <= d) && !((double)f.floatValue() <= d)) continue;
                        string = string3;
                        break block0;
                    }
                    if (!"Any".equalsIgnoreCase(string2) || !((double)(f2 + f.floatValue()) <= d)) continue;
                    bl = true;
                }
            }
            if ("".equals(string) && bl) {
                if (!this.containsChildType("Any")) {
                    this.setChildType("Any", Float.valueOf(0.0f));
                }
                string = "Any";
            }
        }
        return string;
    }

    private void removeCommonFromList(List<EquipmentModifier> list, List<EquipmentModifier> list2, String string) {
        for (int i = list.size() - 1; i >= 0; --i) {
            EquipmentModifier equipmentModifier = list.get(i);
            if (!equipmentModifier.getSafe(ObjectKey.ASSIGN_TO_ALL).booleanValue()) continue;
            int n = list2.indexOf(equipmentModifier);
            if (n >= 0) {
                list.remove(i);
                continue;
            }
            Logging.errorPrint(string + equipmentModifier.getDisplayName());
        }
    }

    private List<EquipmentModifier>[] initSplitModList() {
        List[] listArray = new List[EqModFormatCat.values().length];
        for (int i = 0; i < listArray.length; ++i) {
            listArray[i] = new ArrayList();
        }
        return listArray;
    }

    private void splitModListByFormatCat(List<EquipmentModifier> list, List<EquipmentModifier>[] listArray) {
        for (EquipmentModifier equipmentModifier : list) {
            int n = equipmentModifier.getSafe(ObjectKey.FORMAT).ordinal();
            listArray[n].add(equipmentModifier);
        }
    }

    private void removeContainedEquipment(int n) {
        this.d_containedEquipment.remove(n);
    }

    private void removeEqModifier(String string, boolean bl, PlayerCharacter playerCharacter) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        String string2 = stringTokenizer.nextToken();
        EquipmentModifier equipmentModifier = this.getEqModifierKeyed(string2, bl);
        if (equipmentModifier == null) {
            return;
        }
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().replace('=', '|');
            for (String string4 : this.getAssociationList(equipmentModifier)) {
                if (!string4.startsWith(string3)) continue;
                this.removeAssociation((CDOMObject)equipmentModifier, string4);
            }
        }
        if (!this.hasAssociations(equipmentModifier)) {
            this.removeEqModifier(equipmentModifier, bl, playerCharacter);
        }
    }

    private List<String> typeList(boolean bl) {
        if (bl && this.usePrimaryCache) {
            return this.typeListCachePrimary;
        }
        if (!bl && this.useSecondaryCache) {
            return this.typeListCacheSecondary;
        }
        List<Type> list = this.getEquipmentHead(2).getListFor(ListKey.TYPE);
        if (bl || list == null || list.isEmpty()) {
            list = this.getTrueTypeList(false);
        } else if (!this.isDouble()) {
            return new ArrayList<String>();
        }
        LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<String>();
        if (list != null) {
            for (Type comparable2 : list) {
                linkedHashSet.add(comparable2.getComparisonString());
            }
        }
        ArrayList arrayList2 = new ArrayList();
        EquipmentModifier equipmentModifier = this.getEqModifierKeyed("ADDTYPE", bl);
        if (equipmentModifier != null) {
            for (String string : this.getAssociationList(equipmentModifier)) {
                String string2 = string.toUpperCase();
                if (linkedHashSet.contains(string2)) continue;
                arrayList2.add(string2);
            }
        }
        List<EquipmentModifier> list2 = this.getEqModifierList(bl);
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            EquipmentModifier equipmentModifier2 = (EquipmentModifier)iterator.next();
            LinkedHashSet<String> linkedHashSet2 = new LinkedHashSet<String>(linkedHashSet);
            for (ChangeArmorType changeArmorType : equipmentModifier2.getSafeListFor(ListKey.ARMORTYPE)) {
                Object object = changeArmorType.applyModifier(linkedHashSet2);
                boolean bl2 = linkedHashSet2.size() != object.size() || object.equals(linkedHashSet2);
                linkedHashSet2 = new LinkedHashSet<String>((Collection<String>)object);
                if (bl2) continue;
                break;
            }
            ArrayList arrayList = new ArrayList(linkedHashSet);
            arrayList.removeAll(linkedHashSet2);
            arrayList2.removeAll(arrayList);
            linkedHashSet = linkedHashSet2;
            for (Object object : equipmentModifier2.getSafeListFor(ListKey.ITEM_TYPES)) {
                object = ((String)object).toUpperCase();
                if (linkedHashSet.contains("BOTH") && linkedHashSet.contains("MELEE") && ("RANGED".equals(object) || "THROWN".equals(object)) || linkedHashSet.contains(object) || arrayList2.contains(object)) continue;
                arrayList2.add(object);
            }
        }
        linkedHashSet.addAll(arrayList2);
        ArrayList<String> arrayList = new ArrayList<String>(linkedHashSet);
        int n = arrayList.indexOf("MAGIC");
        if (n > 0) {
            arrayList.remove(n);
            arrayList.add(0, "MAGIC");
        }
        if (bl) {
            this.typeListCachePrimary = arrayList;
            this.usePrimaryCache = true;
        } else {
            this.typeListCacheSecondary = arrayList;
            this.useSecondaryCache = true;
        }
        return arrayList;
    }

    private void updateContainerCapacityString() {
        List<Capacity> list;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        BigDecimal bigDecimal = this.get(ObjectKey.CONTAINER_WEIGHT_CAPACITY);
        if (bigDecimal != null && !Capacity.UNLIMITED.equals(bigDecimal)) {
            stringBuffer.append(bigDecimal).append(' ').append(Globals.getGameModeUnitSet().getWeightUnit());
            bl = true;
        }
        if ((list = this.getListFor(ListKey.CAPACITY)) != null) {
            for (Capacity capacity : list) {
                BigDecimal bigDecimal2;
                if (bl) {
                    stringBuffer.append(", ");
                    bl = false;
                }
                if (!Capacity.UNLIMITED.equals(bigDecimal2 = capacity.getCapacity())) {
                    stringBuffer.append(bigDecimal2).append(' ');
                    stringBuffer.append(capacity.getType());
                    bl = true;
                    continue;
                }
                if (capacity.getType() == null) continue;
                bl = true;
                stringBuffer.append(capacity.getType());
            }
        }
        this.containerCapacityString = stringBuffer.toString();
    }

    @Override
    public void activateBonuses(PlayerCharacter playerCharacter) {
        for (BonusObj bonusObj : this.getRawBonusList(playerCharacter)) {
            bonusObj.setApplied(false);
            if (PrereqHandler.passesAll(bonusObj.getPrerequisiteList(), this, playerCharacter)) {
                bonusObj.setApplied(true);
                continue;
            }
            bonusObj.setApplied(false);
        }
    }

    public boolean isCalculatingCost() {
        return this.calculatingCost;
    }

    public boolean isWeightAlreadyUsed() {
        return this.weightAlreadyUsed;
    }

    public BigDecimal getWeightInPounds() {
        return this.isVirtual() ? BigDecimal.ZERO : this.getSafe(ObjectKey.WEIGHT);
    }

    public void setWeightAlreadyUsed(boolean bl) {
        this.weightAlreadyUsed = bl;
    }

    public String getNonHeadedName() {
        if (this.wholeItemName == null || this.wholeItemName.length() == 0) {
            return this.getName();
        }
        return this.wholeItemName;
    }

    public String getWholeItemName() {
        return this.wholeItemName;
    }

    public void setWholeItemName(String string) {
        this.wholeItemName = string;
    }

    public String createKeyForAutoResize(String string) {
        if (string.length() < 1) {
            return this.getKeyName();
        }
        SizeAdjustment sizeAdjustment = SettingsHandler.getGame().getSizeAdjustmentNamed(string);
        if (sizeAdjustment == null) {
            return this.getKeyName();
        }
        String string2 = sizeAdjustment.getDisplayName();
        String string3 = string2.toUpperCase().substring(0, 1);
        String string4 = this.getKeyName();
        if (string4.startsWith("AUTOSIZE")) {
            int n = "AUTOSIZE".length();
            String string5 = string4.substring(n, n + 1).toUpperCase();
            if (string5.equals(string3)) {
                return string4;
            }
            string4 = string4.substring(n + 1);
        }
        return "AUTOSIZE" + string3 + string4;
    }

    public String createNameForAutoResize(String string) {
        if (string.length() < 1) {
            return this.getName();
        }
        SizeAdjustment sizeAdjustment = SettingsHandler.getGame().getSizeAdjustmentNamed(string);
        if (sizeAdjustment == null) {
            return this.getName();
        }
        String string2 = sizeAdjustment.getDisplayName();
        String string3 = this.getName();
        String string4 = string3.toUpperCase();
        SizeAdjustment sizeAdjustment2 = this.getSafe(ObjectKey.SIZE);
        String string5 = sizeAdjustment2.getDisplayName().toUpperCase();
        int n = string4.indexOf(string5);
        int n2 = n + string5.length();
        if (n > -1 && (string4.substring(n - 1).startsWith("(") || string4.substring(n - 1).startsWith("/")) && (string4.substring(n2).startsWith(")") || string4.substring(n2).startsWith("/"))) {
            return string3.substring(0, n) + string2 + string3.substring(n2);
        }
        return string3 + " (" + string2 + ")";
    }

    public void makeVirtual() {
        this.virtualItem = true;
    }

    private boolean isVirtual() {
        return this.virtualItem;
    }

    public String getCritMult() {
        return Equipment.multAsString(this.getCritMultiplier());
    }

    public String getAltCritMult() {
        return Equipment.multAsString(this.getAltCritMultiplier());
    }

    private static String multAsString(int n) {
        if (n == 0) {
            return "";
        }
        if (n < 0) {
            return "-";
        }
        return "x" + Integer.toString(n);
    }

    public int getCritMultiplier() {
        String string;
        int n = this.getHeadInfo(1, IntegerKey.CRIT_MULT);
        if (n == 0 && (string = this.getWeaponInfo("CRITMULT", true)).length() != 0) {
            n = Integer.parseInt(string);
        }
        return n;
    }

    public int getAltCritMultiplier() {
        String string;
        int n = this.getHeadInfo(2, IntegerKey.CRIT_MULT);
        if (n == 0 && (string = this.getWeaponInfo("CRITMULT", false)).length() != 0) {
            n = Integer.parseInt(string);
        }
        return n;
    }

    private int getHeadInfo(int n, IntegerKey integerKey) {
        EquipmentHead equipmentHead = this.getEquipmentHeadReference(n);
        return equipmentHead == null ? 0 : equipmentHead.getSafe(integerKey);
    }

    public boolean isFinessable(PlayerCharacter playerCharacter) {
        return this.isType("Finesseable") || this.getEffectiveWieldCategory(playerCharacter).isFinessable();
    }

    public boolean isWeaponLightForPC(PlayerCharacter playerCharacter) {
        if (playerCharacter == null || !this.isWeapon()) {
            return false;
        }
        WieldCategory wieldCategory = WieldCategory.findByName("Light");
        return wieldCategory.equals(this.getEffectiveWieldCategory(playerCharacter));
    }

    public boolean isWeaponOneHanded(PlayerCharacter playerCharacter) {
        if (playerCharacter == null && !this.isWeapon()) {
            return false;
        }
        return this.getEffectiveWieldCategory(playerCharacter).getHands() == 1;
    }

    public boolean isWeaponOutsizedForPC(PlayerCharacter playerCharacter) {
        if (playerCharacter == null || !this.isWeapon()) {
            return true;
        }
        WieldCategory wieldCategory = this.getEffectiveWieldCategory(playerCharacter);
        return wieldCategory.getHands() > 2 || wieldCategory.getHands() < 0;
    }

    public boolean isWeaponTooLargeForPC(PlayerCharacter playerCharacter) {
        if (playerCharacter == null || !this.isWeapon()) {
            return false;
        }
        return this.getEffectiveWieldCategory(playerCharacter).getHands() > 2;
    }

    public boolean isWeaponTwoHanded(PlayerCharacter playerCharacter) {
        if (playerCharacter == null || !this.isWeapon()) {
            return false;
        }
        return this.getEffectiveWieldCategory(playerCharacter).getHands() == 2;
    }

    public WieldCategory getEffectiveWieldCategory(PlayerCharacter playerCharacter) {
        int n;
        int n2;
        CDOMSingleRef<WeaponProf> cDOMSingleRef = this.get(ObjectKey.WEAPON_PROF);
        WeaponProf weaponProf = cDOMSingleRef == null ? null : cDOMSingleRef.resolvesTo();
        WieldCategory wieldCategory = this.get(ObjectKey.WIELD);
        if (wieldCategory != null && !Globals.checkRule("SIZEOBJ")) {
            wieldCategory = wieldCategory.adjustForSize(playerCharacter, this);
        } else {
            n2 = playerCharacter.sizeInt();
            if (weaponProf != null) {
                n2 = (int)((double)n2 + playerCharacter.getTotalBonusTo("WEAPONPROF=" + weaponProf.getKeyName(), "PCSIZE"));
            }
            wieldCategory = (n = wieldCategory != null && Globals.checkRule("SIZEOBJ") ? wieldCategory.getObjectSizeInt(this) - n2 : this.sizeInt() - n2) > 1 ? WieldCategory.findByName("TooLarge") : (n == 1 ? WieldCategory.findByName("TwoHanded") : (n == 0 ? WieldCategory.findByName("OneHanded") : WieldCategory.findByName("Light")));
        }
        n2 = 0;
        if (weaponProf != null) {
            n = weaponProf.getSafe(IntegerKey.HANDS);
            if (n == -1) {
                n = playerCharacter.sizeInt() > this.sizeInt() ? 1 : 2;
            }
            while (wieldCategory.getHands() < n) {
                wieldCategory = wieldCategory.getWieldCategoryStep(1);
            }
            String string = weaponProf.getKeyName();
            n2 += (int)playerCharacter.getTotalBonusTo("WEAPONPROF=" + string, "WIELDCATEGORY");
        }
        if ((n2 += (int)this.bonusTo(playerCharacter, "WEAPON", "WIELDCATEGORY", true)) == 0) {
            return wieldCategory;
        }
        return wieldCategory.getWieldCategoryStep(n2);
    }

    public Integer getACBonus(PlayerCharacter playerCharacter) {
        int n = (int)this.bonusTo(playerCharacter, "COMBAT", "AC", true);
        return n += (int)this.bonusTo(playerCharacter, "EQMARMOR", "ACBONUS", true);
    }

    public Integer getACMod(PlayerCharacter playerCharacter) {
        return (int)this.bonusTo(playerCharacter, "EQMARMOR", "AC", true) + (int)this.bonusTo(playerCharacter, "COMBAT", "AC", true);
    }

    public String getDamage(PlayerCharacter playerCharacter) {
        return this.getDamage(playerCharacter, true);
    }

    private String getDamage(PlayerCharacter playerCharacter, boolean bl) {
        Object object;
        int n = bl ? 1 : 2;
        EquipmentHead equipmentHead = this.getEquipmentHeadReference(n);
        if (equipmentHead == null) {
            return "";
        }
        Object object2 = equipmentHead.get(StringKey.DAMAGE);
        if (!this.isWeapon() || !bl && !this.isDouble()) {
            return object2 == null ? "" : object2;
        }
        if (bl && object2 == null) {
            object = this.getEquipmentHead(2);
            object2 = ((CDOMObject)object).get(StringKey.DAMAGE);
        }
        object = this.get(StringKey.DAMAGE_OVERRIDE);
        if (bl && object != null) {
            object2 = object;
        }
        if (object2 == null) {
            object2 = this.getWeaponInfo("DAMAGE", bl);
        }
        int n2 = this.sizeInt();
        int n3 = n2 + (int)this.bonusTo(playerCharacter, "EQMWEAPON", "DAMAGESIZE", bl);
        if ((n3 += (int)this.bonusTo(playerCharacter, "WEAPON", "DAMAGESIZE", bl)) < 0) {
            n3 = 0;
        } else if (n3 >= SettingsHandler.getGame().getSizeAdjustmentListSize() - 1) {
            n3 = SettingsHandler.getGame().getSizeAdjustmentListSize() - 1;
        }
        return this.adjustDamage((String)object2, SettingsHandler.getGame().getSizeAdjustmentAtIndex(n3));
    }

    public String getAltDamage(PlayerCharacter playerCharacter) {
        return this.getDamage(playerCharacter, false);
    }

    public int getBonusToDamage(PlayerCharacter playerCharacter, boolean bl) {
        return (int)this.bonusTo(playerCharacter, "WEAPON", "DAMAGE", bl);
    }

    public int getBonusToHit(PlayerCharacter playerCharacter, boolean bl) {
        return (int)this.bonusTo(playerCharacter, "WEAPON", "TOHIT", bl);
    }

    public void setCarried(Float f) {
        this.carried = f;
    }

    public Float getCarried() {
        return this.carried;
    }

    public boolean isEquipped() {
        return this.equipped;
    }

    public Object getChild(int n) {
        return this.getContainedEquipment(n);
    }

    @Override
    public int getChildCount() {
        return this.getContainedEquipmentCount();
    }

    public void setChildType(String string, Float f) {
        this.d_childTypes.put(string, f);
    }

    public Equipment getContainedByIndex(int n) {
        ArrayList<Equipment> arrayList = new ArrayList<Equipment>(this.getContents());
        if (arrayList.size() > 0 && n <= arrayList.size()) {
            return (Equipment)arrayList.get(n);
        }
        return null;
    }

    public Equipment getContainedEquipment(int n) {
        return this.d_containedEquipment.get(n);
    }

    public int getContainedEquipmentCount() {
        return this.d_containedEquipment.size();
    }

    public double getContainedValue(PlayerCharacter playerCharacter) {
        double d = 0.0;
        if (this.getChildCount() == 0) {
            return d;
        }
        for (int i = 0; i < this.getContainedEquipmentCount(); ++i) {
            Equipment equipment = this.getContainedEquipment(i);
            if (equipment.getContainedEquipmentCount() > 0) {
                d += equipment.getContainedValue(playerCharacter);
                continue;
            }
            d += (double)equipment.getCost(playerCharacter).floatValue();
        }
        return d;
    }

    public Float getContainedWeight(PlayerCharacter playerCharacter) {
        return this.getContainedWeight(playerCharacter, false);
    }

    public Float getBaseContainedWeight() {
        return this.getBaseContainedWeight(false);
    }

    public Float getBaseContainedWeight(boolean bl) {
        Float f = Float.valueOf(0.0f);
        if (this.getSafe(ObjectKey.CONTAINER_CONSTANT_WEIGHT).booleanValue() && !bl || this.getChildCount() == 0) {
            return f;
        }
        for (int i = 0; i < this.getContainedEquipmentCount(); ++i) {
            Equipment equipment = this.getContainedEquipment(i);
            f = equipment.getContainedEquipmentCount() > 0 ? Float.valueOf(f.floatValue() + equipment.getBaseWeight().floatValue() + equipment.getBaseContainedWeight().floatValue()) : Float.valueOf(f.floatValue() + equipment.getBaseWeight().floatValue() * equipment.getCarried().floatValue());
        }
        Integer n = this.get(IntegerKey.CONTAINER_REDUCE_WEIGHT);
        if (n != null && n != 0) {
            f = Float.valueOf(f.floatValue() * (n.floatValue() / 100.0f));
        }
        return f;
    }

    public Float getContainedWeight(PlayerCharacter playerCharacter, boolean bl) {
        Float f = Float.valueOf(0.0f);
        if (this.getSafe(ObjectKey.CONTAINER_CONSTANT_WEIGHT).booleanValue() && !bl || this.getChildCount() == 0) {
            return f;
        }
        for (int i = 0; i < this.getContainedEquipmentCount(); ++i) {
            Equipment equipment = this.getContainedEquipment(i);
            f = equipment.getContainedEquipmentCount() > 0 ? new Float((double)f.floatValue() + equipment.getWeightAsDouble(playerCharacter) + (double)equipment.getContainedWeight(playerCharacter).floatValue()) : new Float((double)f.floatValue() + equipment.getWeightAsDouble(playerCharacter) * (double)equipment.getCarried().floatValue());
        }
        Integer n = this.get(IntegerKey.CONTAINER_REDUCE_WEIGHT);
        if (n != null && n != 0) {
            f = Float.valueOf(f.floatValue() * (n.floatValue() / 100.0f));
        }
        return f;
    }

    public String getContainerByType(String string, String string2) {
        String string3;
        int n;
        ArrayList<Equipment> arrayList = new ArrayList<Equipment>(this.getContents());
        int n2 = 0;
        for (n = string.length() - 1; n > 0 && string.charAt(n) >= '0' && string.charAt(n) <= '9'; --n) {
            ++n2;
        }
        if (n2 > 0) {
            int n3 = string.length() - n2;
            string3 = string.substring(0, n3);
            n = Integer.parseInt(string.substring(n3));
        } else {
            string3 = string;
            n = -1;
        }
        for (Equipment equipment : arrayList) {
            if (equipment.isType(string3)) continue;
            arrayList.remove(equipment);
        }
        if (n < arrayList.size()) {
            if ("SPROP".equals(string2)) {
                return ((Equipment)arrayList.get(n)).getRawSpecialProperties();
            }
            return ((Equipment)arrayList.get(n)).getName();
        }
        return " ";
    }

    public String getContainerContentsString() {
        if (this.containerContentsString == null) {
            this.updateContainerContentsString(null);
        }
        return this.containerContentsString;
    }

    public Collection<Equipment> getContents() {
        ArrayList<Equipment> arrayList = new ArrayList<Equipment>();
        for (int i = 0; i < this.getContainedEquipmentCount(); ++i) {
            Equipment equipment = this.getContainedEquipment(i);
            if (!(equipment.getCarried().floatValue() > 0.0f)) continue;
            arrayList.add(equipment);
        }
        return arrayList;
    }

    public String getContainerCapacityString() {
        if (this.containerCapacityString == null) {
            this.updateContainerCapacityString();
        }
        return this.containerCapacityString;
    }

    public boolean isContainer() {
        return this.acceptsChildren();
    }

    public EquipmentHead getEquipmentHead(int n) {
        EquipmentHead equipmentHead;
        if (n <= 0) {
            throw new IndexOutOfBoundsException(Integer.toString(n));
        }
        int n2 = n - 1;
        int n3 = this.heads.size();
        if (n2 >= n3) {
            for (int i = 0; i < n2 - n3; ++i) {
                this.heads.add(null);
            }
            equipmentHead = new EquipmentHead(this, n);
            this.heads.add(equipmentHead);
        } else {
            equipmentHead = this.heads.get(n2);
            if (equipmentHead == null) {
                equipmentHead = new EquipmentHead(this, n);
                this.heads.set(n2, equipmentHead);
            }
        }
        return equipmentHead;
    }

    public EquipmentHead getEquipmentHeadReference(int n) {
        if (n <= 0) {
            throw new IndexOutOfBoundsException(Integer.toString(n));
        }
        if (n <= this.heads.size()) {
            return this.heads.get(n - 1);
        }
        return null;
    }

    private String adjustDamage(String string, SizeAdjustment sizeAdjustment) {
        if (string == null) {
            return null;
        }
        if (!"special".equalsIgnoreCase(string) && !"-".equals(string)) {
            return Globals.adjustDamage(string, this.getSize(), sizeAdjustment.getAbbreviation());
        }
        return string;
    }

    private String getDamageAdjustedForSize(SizeAdjustment sizeAdjustment, boolean bl) {
        int n = bl ? 1 : 2;
        EquipmentHead equipmentHead = this.getEquipmentHeadReference(n);
        if (equipmentHead == null) {
            return null;
        }
        String string = equipmentHead.get(StringKey.DAMAGE);
        if (!this.isWeapon() || !bl && !this.isDouble()) {
            return string;
        }
        if (string == null) {
            string = this.getWeaponInfo("DAMAGE", bl);
        }
        return this.adjustDamage(string, sizeAdjustment);
    }

    public Integer getRange(PlayerCharacter playerCharacter) {
        String string;
        int n = this.getSafe(IntegerKey.RANGE);
        if (n == 0 && (string = this.getWeaponInfo("RANGE", true)).length() != 0) {
            n = Integer.valueOf(string);
        }
        int n2 = n + (int)this.bonusTo(playerCharacter, "EQMWEAPON", "RANGEADD", true);
        int n3 = (int)this.bonusTo(playerCharacter, "EQMWEAPON", "RANGEMULT", true);
        double d = 1.0;
        if (n3 > 0) {
            d += (double)(n3 - 1);
        }
        int n4 = 0;
        if (playerCharacter != null) {
            if (this.isThrown()) {
                n2 += (int)playerCharacter.getTotalBonusTo("RANGEADD", "THROWN");
                n4 = (int)playerCharacter.getTotalBonusTo("POSTRANGEADD", "THROWN");
                d += (double)((int)playerCharacter.getTotalBonusTo("RANGEMULT", "THROWN")) / 100.0;
            } else if (this.isProjectile()) {
                n2 += (int)playerCharacter.getTotalBonusTo("RANGEADD", "PROJECTILE");
                n4 = (int)playerCharacter.getTotalBonusTo("POSTRANGEADD", "PROJECTILE");
                d += (double)((int)playerCharacter.getTotalBonusTo("RANGEMULT", "PROJECTILE")) / 100.0;
            }
        }
        n2 = (int)((double)n2 * d);
        if ((this.isRanged() || this.isThrown() || this.isProjectile()) && (n2 += n4) <= 0) {
            n2 = 10;
        }
        return n2;
    }

    String getWeaponInfo(String string, boolean bl) {
        String string2 = string + "|";
        EquipmentModifier equipmentModifier = this.getEqModifierKeyed("PCGENi_WEAPON", bl);
        if (equipmentModifier != null) {
            for (String string3 : this.getAssociationList(equipmentModifier)) {
                if (!string3.startsWith(string2)) continue;
                return string3.substring(string2.length());
            }
        }
        return "";
    }

    public ShieldProf getShieldProf() {
        if (this.isShield()) {
            CDOMSingleRef<ShieldProf> cDOMSingleRef = this.get(ObjectKey.SHIELD_PROF);
            if (cDOMSingleRef == null) {
                ShieldProf shieldProf = Globals.getContext().ref.silentlyGetConstructedCDOMObject(ShieldProf.class, this.getKeyName());
                if (shieldProf == null) {
                    return Globals.getContext().ref.constructCDOMObject(ShieldProf.class, this.getKeyName());
                }
                return shieldProf;
            }
            return cDOMSingleRef.resolvesTo();
        }
        return null;
    }

    public ArmorProf getArmorProf() {
        if (this.isArmor()) {
            CDOMSingleRef<ArmorProf> cDOMSingleRef = this.get(ObjectKey.ARMOR_PROF);
            if (cDOMSingleRef == null) {
                ArmorProf armorProf = Globals.getContext().ref.silentlyGetConstructedCDOMObject(ArmorProf.class, this.getKeyName());
                if (armorProf == null) {
                    return Globals.getContext().ref.constructCDOMObject(ArmorProf.class, this.getKeyName());
                }
                return armorProf;
            }
            return cDOMSingleRef.resolvesTo();
        }
        return null;
    }

    @Override
    public void addAssociation(CDOMObject cDOMObject, String string) {
        this.assocSupt.addAssoc(cDOMObject, AssociationListKey.CHOICES, new FixedStringList(string));
    }

    @Override
    public void addAssociation(CDOMObject cDOMObject, FixedStringList fixedStringList) {
        this.assocSupt.addAssoc(cDOMObject, AssociationListKey.CHOICES, fixedStringList);
    }

    @Override
    public boolean containsAssociated(CDOMObject cDOMObject, String string) {
        return this.containsAssociated(cDOMObject, new FixedStringList(string));
    }

    @Override
    public boolean containsAssociated(CDOMObject cDOMObject, FixedStringList fixedStringList) {
        List<FixedStringList> list = this.assocSupt.getAssocList(cDOMObject, AssociationListKey.CHOICES);
        if (list != null) {
            for (FixedStringList fixedStringList2 : list) {
                if (FixedStringList.CASE_INSENSITIVE_ORDER.compare(fixedStringList2, fixedStringList) != 0) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int getSelectCorrectedAssociationCount(CDOMObject cDOMObject) {
        Formula formula = cDOMObject.getSafe(FormulaKey.SELECT);
        int n = formula.resolve(this, true, null, "").intValue();
        return this.assocSupt.getAssocCount(cDOMObject, AssociationListKey.CHOICES) / n;
    }

    @Override
    public List<String> getAssociationList(CDOMObject cDOMObject) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<FixedStringList> list = this.assocSupt.getAssocList(cDOMObject, AssociationListKey.CHOICES);
        if (list != null) {
            for (FixedStringList fixedStringList : list) {
                String string = fixedStringList.get(0);
                if ("".equals(string)) {
                    arrayList.add(null);
                    continue;
                }
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    @Override
    public boolean hasAssociations(CDOMObject cDOMObject) {
        return this.assocSupt.hasAssocs((Object)cDOMObject, AssociationListKey.CHOICES);
    }

    @Override
    public List<String> removeAllAssociations(CDOMObject cDOMObject) {
        List<String> list = this.getAssociationList(cDOMObject);
        this.assocSupt.removeAllAssocs(cDOMObject, AssociationListKey.CHOICES);
        return list;
    }

    @Override
    public void removeAssociation(CDOMObject cDOMObject, String string) {
        this.assocSupt.removeAssoc(cDOMObject, AssociationListKey.CHOICES, new FixedStringList(string));
    }

    @Override
    public void removeAssociation(CDOMObject cDOMObject, FixedStringList fixedStringList) {
        this.assocSupt.removeAssoc(cDOMObject, AssociationListKey.CHOICES, fixedStringList);
    }

    @Override
    public int getDetailedAssociationCount(CDOMObject cDOMObject) {
        List<FixedStringList> list = this.assocSupt.getAssocList(cDOMObject, AssociationListKey.CHOICES);
        int n = 0;
        if (list != null) {
            for (FixedStringList fixedStringList : list) {
                n += fixedStringList.size();
            }
        }
        return n;
    }

    @Override
    public List<FixedStringList> getDetailedAssociations(CDOMObject cDOMObject) {
        List<FixedStringList> list = this.assocSupt.getAssocList(cDOMObject, AssociationListKey.CHOICES);
        if (list == null) {
            list = Collections.emptyList();
        }
        return list;
    }

    @Override
    public List<String> getExpandedAssociations(CDOMObject cDOMObject) {
        List<FixedStringList> list = this.assocSupt.getAssocList(cDOMObject, AssociationListKey.CHOICES);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list != null) {
            for (FixedStringList fixedStringList : list) {
                for (String string : fixedStringList) {
                    arrayList.add(string);
                }
            }
        }
        return arrayList;
    }

    @Override
    public String getFirstAssociation(CDOMObject cDOMObject) {
        return this.assocSupt.getAssocList(cDOMObject, AssociationListKey.CHOICES).get(0).get(0);
    }

    public Map<String, String> getBonusMap() {
        if (this.bonusMap == null) {
            this.bonusMap = new HashMap<String, String>();
        }
        return this.bonusMap;
    }

    public void putBonusMap(String string, String string2) {
        this.getBonusMap().put(string, string2);
    }

    void setBonusStackFor(double d, String string) {
        String string2;
        String string3;
        String string4;
        String string5 = string4 = string != null ? string.toUpperCase() : null;
        if (string4 != null) {
            string4 = string4.toUpperCase();
        }
        int n = -1;
        StringTokenizer stringTokenizer = new StringTokenizer(string4, ".");
        if (string4 != null && stringTokenizer.countTokens() >= 2) {
            stringTokenizer.nextToken();
            string3 = stringTokenizer.nextToken();
            string2 = null;
            if ("BASE".equals(string3)) {
                if (stringTokenizer.hasMoreTokens()) {
                    stringTokenizer.nextToken();
                }
                if (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                }
            } else if (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
            }
            if (string2 != null) {
                n = SettingsHandler.getGame().getUnmodifiableBonusStackList().indexOf(string2);
            }
            if (string2 == null) {
                n = 1;
            } else if ("NULL".equals(string2)) {
                n = 1;
            }
        }
        if (string4 != null && (string4.endsWith(".STACK") || string4.endsWith(".REPLACE"))) {
            n = 1;
        }
        if (d < 0.0) {
            n = 1;
        }
        if (n == -1) {
            string3 = this.getBonusMap().get(string4);
            if (string3 == null) {
                this.putBonusMap(string4, String.valueOf(d));
            } else {
                this.putBonusMap(string4, String.valueOf(Math.max(d, (double)Float.parseFloat(string3))));
            }
        } else {
            string3 = string4 == null ? "" : (string4.endsWith(".REPLACE.STACK") ? string4.substring(0, string4.length() - 6) : string4);
            string2 = this.getBonusMap().get(string3);
            if (string2 == null) {
                this.putBonusMap(string3, String.valueOf(d));
            } else {
                this.putBonusMap(string3, String.valueOf(d + (double)Float.parseFloat(string2)));
            }
        }
    }

    public void dumpTypeCache() {
        this.usePrimaryCache = false;
        this.useSecondaryCache = false;
    }

    public void addType(Type type) {
        this.addToListFor(ListKey.TYPE, type);
        this.dumpTypeCache();
    }

    public void removeType(Type type) {
        while (this.removeFromListFor(ListKey.TYPE, type)) {
        }
        this.dumpTypeCache();
    }

    static {
        Equipment.LOCATION_STRING_LIST[0] = EQUIPPED_NEITHER_STR;
        Equipment.LOCATION_STRING_LIST[1] = EQUIPPED_PRIMARY_STR;
        Equipment.LOCATION_STRING_LIST[2] = EQUIPPED_SECONDARY_STR;
        Equipment.LOCATION_STRING_LIST[3] = EQUIPPED_BOTH_STR;
        Equipment.LOCATION_STRING_LIST[4] = EQUIPPED_TWO_HANDS_STR;
        Equipment.LOCATION_STRING_LIST[5] = EQUIPPED_TEMPBONUS_STR;
        Equipment.LOCATION_STRING_LIST[6] = CARRIED_NEITHER_STR;
        Equipment.LOCATION_STRING_LIST[7] = CONTAINED_STR;
        Equipment.LOCATION_STRING_LIST[8] = NOT_CARRIED_STR;
    }

    private class EquipmentHeadCostSummary {
        BigDecimal postSizeCost = BigDecimal.ZERO;
        BigDecimal nonDoubleCost = BigDecimal.ZERO;
        int headPlus = 0;

        private EquipmentHeadCostSummary() {
        }
    }
}

