/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import pcgen.cdom.enumeration.VariableKey;
import pcgen.core.Ability;
import pcgen.core.Domain;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;

public final class CharacterDomain {
    public static final String PC_CLASS_TYPE = "PCClass";
    public static final String ABILITY_CLASS_TYPE = "Feat";
    private Domain domain;
    private String domainName = "";
    private String domainType = "";
    private boolean fromFeat;
    private boolean fromPCClass;
    private int level;

    public Domain setDomain(Domain domain, PlayerCharacter playerCharacter) {
        CharacterDomain.setSpecialAbilities(this.domain, false, playerCharacter);
        if (domain == null) {
            this.domain = null;
        } else {
            this.domain = domain.clone();
            CharacterDomain.setSpecialAbilities(this.domain, true, playerCharacter);
        }
        return this.domain;
    }

    public Domain getDomain() {
        return this.domain;
    }

    public String getDomainSourcePcgString() {
        StringBuffer stringBuffer = new StringBuffer(30);
        stringBuffer.append(this.domainType);
        stringBuffer.append('|');
        stringBuffer.append(this.domainName);
        if (this.level > 0) {
            stringBuffer.append('|');
            stringBuffer.append(this.level);
        }
        return stringBuffer.toString();
    }

    public boolean isFromFeat() {
        return this.fromFeat;
    }

    public void setFromPCClass(boolean bl) {
        this.fromPCClass = bl;
        this.domainType = PC_CLASS_TYPE;
    }

    public boolean isFromPCClass() {
        return this.fromPCClass;
    }

    public boolean isFromPCClass(String string) {
        if (this.fromPCClass) {
            return this.domainName.equalsIgnoreCase(string);
        }
        return false;
    }

    public void setObjectName(String string) {
        this.domainName = string;
    }

    public String getObjectName() {
        return this.domainName;
    }

    public String toString() {
        String string = "";
        if (this.domain != null) {
            Ability ability;
            StringBuffer stringBuffer = new StringBuffer(this.domain.getDisplayName());
            if (this.fromPCClass) {
                PCClass pCClass = Globals.getContext().ref.silentlyGetConstructedCDOMObject(PCClass.class, this.domainName);
                if (pCClass != null) {
                    stringBuffer.insert(0, pCClass.getDisplayName() + ":");
                }
            } else if (this.fromFeat && (ability = Globals.getAbilityKeyed("FEAT", this.domainName)) != null) {
                stringBuffer.insert(0, ability.getDisplayName() + ":");
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    boolean isDomainValidFor(PlayerCharacter playerCharacter) {
        boolean bl = false;
        if (this.domain == null) {
            bl = false;
        }
        if (this.fromPCClass) {
            PCClass pCClass = playerCharacter.getClassKeyed(this.domainName);
            boolean bl2 = bl = pCClass != null && pCClass.getLevel() >= this.level;
        }
        if (this.fromFeat) {
            bl = playerCharacter.hasRealFeat(Globals.getAbilityKeyed("FEAT", this.domainName)) || playerCharacter.hasFeatAutomatic(this.domainName) || playerCharacter.hasFeatVirtual(this.domainName);
        }
        return bl;
    }

    public void setLevel(int n) {
        this.level = n;
    }

    private static void setSpecialAbilities(Domain domain, boolean bl, PlayerCharacter playerCharacter) {
        PlayerCharacter playerCharacter2 = playerCharacter;
        if (playerCharacter2 != null && domain != null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("DOMAIN:").append(domain.getKeyName()).append('|').append(-9).append('|');
            for (VariableKey variableKey : domain.getVariableKeys()) {
                StringBuilder stringBuilder2 = new StringBuilder();
                stringBuilder2.append((CharSequence)stringBuilder).append(variableKey.toString()).append('|').append(domain.get(variableKey));
                if (bl) {
                    playerCharacter2.addVariable(stringBuilder2.toString());
                    continue;
                }
                playerCharacter2.removeVariable(stringBuilder2.toString());
            }
        }
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String string) {
        this.domainName = string;
    }

    public String getDomainType() {
        return this.domainType;
    }

    public void setDomainType(String string) {
        this.domainType = string;
        if (this.domainType.equalsIgnoreCase(PC_CLASS_TYPE)) {
            this.fromPCClass = true;
        } else if (this.domainType.equalsIgnoreCase(ABILITY_CLASS_TYPE)) {
            this.fromFeat = true;
        }
    }
}

