/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.reference;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.PrereqObject;
import pcgen.cdom.reference.CDOMGroupRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CDOMTypeRef<T extends PrereqObject>
extends CDOMGroupRef<T> {
    private List<T> referencedList = null;
    private final String[] types;

    public CDOMTypeRef(Class<T> clazz, String[] stringArray) {
        super(clazz, clazz.getSimpleName() + " " + Arrays.deepToString(stringArray));
        this.types = new String[stringArray.length];
        System.arraycopy(stringArray, 0, this.types, 0, stringArray.length);
    }

    @Override
    public String getLSTformat() {
        return "TYPE=" + StringUtil.join(this.types, ".");
    }

    @Override
    public boolean contains(T t) {
        if (this.referencedList == null) {
            throw new IllegalStateException("Cannot ask for contains: Reference has not been resolved");
        }
        return this.referencedList.contains(t);
    }

    public boolean equals(Object object) {
        if (object instanceof CDOMTypeRef) {
            CDOMTypeRef cDOMTypeRef = (CDOMTypeRef)object;
            return this.getReferenceClass().equals(cDOMTypeRef.getReferenceClass()) && this.getName().equals(cDOMTypeRef.getName()) && Arrays.deepEquals(this.types, cDOMTypeRef.types);
        }
        return false;
    }

    public int hashCode() {
        return this.getReferenceClass().hashCode() ^ this.getName().hashCode();
    }

    @Override
    public void addResolution(T t) {
        if (t.getClass().equals(this.getReferenceClass())) {
            if (this.referencedList == null) {
                this.referencedList = new ArrayList<T>();
            }
        } else {
            throw new IllegalArgumentException("Cannot resolve a " + this.getReferenceClass().getSimpleName() + " Reference to a " + t.getClass().getSimpleName());
        }
        this.referencedList.add(t);
    }

    @Override
    public int getObjectCount() {
        return this.referencedList == null ? 0 : this.referencedList.size();
    }

    @Override
    public Collection<T> getContainedObjects() {
        if (this.referencedList == null) {
            throw new IllegalStateException("Cannot ask for contained objects: Reference has not been resolved");
        }
        return Collections.unmodifiableList(this.referencedList);
    }
}

