/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.reference;

import java.util.Collection;
import java.util.Collections;
import pcgen.cdom.base.CategorizedCDOMObject;
import pcgen.cdom.base.Category;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.cdom.reference.CategorizedCDOMReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOMCategorizedSingleRef<T extends CategorizedCDOMObject<T>>
extends CDOMSingleRef<T>
implements CategorizedCDOMReference<T> {
    private T referencedObject = null;
    private final Category<T> category;

    public CDOMCategorizedSingleRef(Class<T> clazz, Category<T> category, String string) {
        super(clazz, string);
        if (category == null) {
            throw new IllegalArgumentException("Cannot built CDOMCategorizedSingleRef with null category");
        }
        this.category = category;
    }

    @Override
    public boolean contains(T t) {
        if (this.referencedObject == null) {
            throw new IllegalStateException("Cannot ask for contains: Reference has not been resolved");
        }
        return this.referencedObject.equals(t);
    }

    @Override
    public String getLSTformat() {
        return this.getName();
    }

    @Override
    public T resolvesTo() {
        if (this.referencedObject == null) {
            throw new IllegalStateException("Cannot ask for resolution: Reference has not been resolved");
        }
        return this.referencedObject;
    }

    public boolean equals(Object object) {
        if (object instanceof CDOMCategorizedSingleRef) {
            CDOMCategorizedSingleRef cDOMCategorizedSingleRef = (CDOMCategorizedSingleRef)object;
            return this.getReferenceClass().equals(cDOMCategorizedSingleRef.getReferenceClass()) && this.getName().equals(cDOMCategorizedSingleRef.getName()) && this.category.equals(cDOMCategorizedSingleRef.category);
        }
        return false;
    }

    public int hashCode() {
        return this.getReferenceClass().hashCode() ^ this.getName().hashCode();
    }

    @Override
    public Category<T> getCDOMCategory() {
        return this.category;
    }

    @Override
    public void addResolution(T t) {
        Category<T> category;
        if (this.referencedObject != null) {
            throw new IllegalStateException("Cannot resolve a Single Reference twice");
        }
        if (!t.getClass().equals(this.getReferenceClass())) {
            throw new IllegalArgumentException("Cannot resolve a " + this.getReferenceClass().getSimpleName() + " Reference to a " + t.getClass().getSimpleName());
        }
        if (!this.category.equals(t.getCDOMCategory()) && (category = this.category.getParentCategory()) != null && !category.equals(t.getCDOMCategory())) {
            throw new IllegalArgumentException("Cannot resolve " + this.getReferenceClass().getSimpleName() + " " + this.getName() + t.getCDOMCategory() + " Reference to category " + this.category);
        }
        this.referencedObject = t;
    }

    @Override
    public Collection<T> getContainedObjects() {
        return Collections.singleton(this.referencedObject);
    }
}

