/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.helper;

import java.util.StringTokenizer;
import pcgen.cdom.base.Category;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.Globals;
import pcgen.core.SettingsHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbilitySelection
implements Comparable<AbilitySelection> {
    private final Ability ability;
    private final Ability.Nature nature;
    private final String selection;

    public AbilitySelection(Ability ability, Ability.Nature nature) {
        if (ability.getSafe(ObjectKey.MULTIPLE_ALLOWED).booleanValue()) {
            throw new IllegalArgumentException("AbilitySelection with MULT:YES Ability must have choices");
        }
        this.ability = ability;
        this.nature = nature;
        this.selection = null;
    }

    public AbilitySelection(Ability ability, Ability.Nature nature, String string) {
        if (string != null && !ability.getSafe(ObjectKey.MULTIPLE_ALLOWED).booleanValue()) {
            throw new IllegalArgumentException("AbilitySelection with MULT:NO Ability must not have choices");
        }
        if (string == null && ability.getSafe(ObjectKey.MULTIPLE_ALLOWED).booleanValue()) {
            throw new IllegalArgumentException("AbilitySelection with MULT:YES Ability must have choices");
        }
        this.ability = ability;
        this.nature = nature;
        this.selection = string;
    }

    public String getAbilityKey() {
        return this.ability.getKeyName();
    }

    public Category<Ability> getAbilityCategory() {
        return this.ability.getCDOMCategory();
    }

    public String getFullAbilityKey() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.ability.getKeyName());
        if (this.selection != null && this.selection.length() > 0) {
            stringBuilder.append('(');
            stringBuilder.append(this.selection);
            stringBuilder.append(')');
        }
        return stringBuilder.toString();
    }

    public boolean containsAssociation(String string) {
        return string == null ? this.selection == null : string.equals(this.selection);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.ability.getDisplayName());
        if (this.selection != null && this.selection.length() > 0) {
            stringBuilder.append('(');
            stringBuilder.append(this.selection);
            stringBuilder.append(')');
        }
        return stringBuilder.toString();
    }

    public String getSelection() {
        return this.selection;
    }

    public String getPersistentFormat() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CATEGORY=");
        stringBuilder.append(this.ability.getCategory());
        stringBuilder.append('|');
        stringBuilder.append("NATURE=");
        stringBuilder.append((Object)this.nature);
        stringBuilder.append('|');
        stringBuilder.append(this.ability.getDisplayName());
        if (this.selection != null) {
            stringBuilder.append('|');
            stringBuilder.append(this.selection);
        }
        return stringBuilder.toString();
    }

    public static AbilitySelection getAbilitySelectionFromPersistentFormat(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        String string2 = stringTokenizer.nextToken();
        if (!string2.startsWith("CATEGORY=")) {
            throw new IllegalArgumentException("String in getAbilitySelectionFromPersistentFormat must start with CATEGORY=, found: " + string);
        }
        String string3 = string2.substring(9);
        AbilityCategory abilityCategory = SettingsHandler.getGame().getAbilityCategory(string3);
        if (abilityCategory == null) {
            throw new IllegalArgumentException("Category in getAbilitySelectionFromPersistentFormat must exist found: " + string3);
        }
        String string4 = stringTokenizer.nextToken();
        if (!string4.startsWith("NATURE=")) {
            throw new IllegalArgumentException("Second argument in String in getAbilitySelectionFromPersistentFormat must start with NATURE=, found: " + string);
        }
        String string5 = string4.substring(7);
        Ability.Nature nature = Ability.Nature.valueOf(string5);
        String string6 = stringTokenizer.nextToken();
        Ability ability = Globals.getContext().ref.silentlyGetConstructedCDOMObject(Ability.class, abilityCategory, string6);
        if (ability == null) {
            throw new IllegalArgumentException("Third argument in String in getAbilitySelectionFromPersistentFormat must be an Ability, but it was not found: " + string);
        }
        String string7 = null;
        if (stringTokenizer.hasMoreTokens()) {
            string7 = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            throw new IllegalArgumentException("String in getAbilitySelectionFromPersistentFormat must have 3 or 4 arguments, but found more: " + string);
        }
        return new AbilitySelection(ability, nature, string7);
    }

    public Ability.Nature getNature() {
        return this.nature;
    }

    public Ability getAbility() {
        return this.ability;
    }

    @Override
    public int compareTo(AbilitySelection abilitySelection) {
        int n = this.ability.compareTo(abilitySelection.ability);
        if (n != 0) {
            return n;
        }
        if (this.selection == null) {
            return abilitySelection.selection == null ? 0 : -1;
        }
        return abilitySelection.selection == null ? 1 : this.selection.compareToIgnoreCase(abilitySelection.selection);
    }
}

