/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.enumeration;

import java.util.Date;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.StringKey;
import pcgen.core.Campaign;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SourceFormat {
    SHORT{

        public String getField(CDOMObject cDOMObject) {
            return cDOMObject.get(StringKey.SOURCE_SHORT);
        }

        public String getPublisher(Campaign campaign) {
            return "";
        }

        public boolean allowsPage() {
            return true;
        }
    }
    ,
    MEDIUM{

        public String getField(CDOMObject cDOMObject) {
            return cDOMObject.get(StringKey.SOURCE_LONG);
        }

        public String getPublisher(Campaign campaign) {
            return "";
        }

        public boolean allowsPage() {
            return true;
        }
    }
    ,
    LONG{

        public String getField(CDOMObject cDOMObject) {
            return cDOMObject.get(StringKey.SOURCE_LONG);
        }

        public String getPublisher(Campaign campaign) {
            return campaign.getSafe(StringKey.PUB_NAME_LONG);
        }

        public boolean allowsPage() {
            return true;
        }
    }
    ,
    DATE{

        public String getField(CDOMObject cDOMObject) {
            Date date = cDOMObject.get(ObjectKey.SOURCE_DATE);
            return date == null ? null : date.toString();
        }

        public String getPublisher(Campaign campaign) {
            return "";
        }

        public boolean allowsPage() {
            return true;
        }
    }
    ,
    PAGE{

        public String getField(CDOMObject cDOMObject) {
            return cDOMObject.get(StringKey.SOURCE_PAGE);
        }

        public String getPublisher(Campaign campaign) {
            return "";
        }

        public boolean allowsPage() {
            return true;
        }
    }
    ,
    WEB{

        public String getField(CDOMObject cDOMObject) {
            return cDOMObject.get(StringKey.SOURCE_WEB);
        }

        public String getPublisher(Campaign campaign) {
            return campaign.getSafe(StringKey.PUB_NAME_WEB);
        }

        public boolean allowsPage() {
            return false;
        }
    };


    public abstract String getPublisher(Campaign var1);

    public abstract String getField(CDOMObject var1);

    public abstract boolean allowsPage();

    public static String formatShort(CDOMObject cDOMObject, int n) {
        Campaign campaign;
        String string = cDOMObject.get(StringKey.SOURCE_SHORT);
        if (string == null && (campaign = cDOMObject.get(ObjectKey.SOURCE_CAMPAIGN)) != null) {
            string = campaign.get(StringKey.SOURCE_SHORT);
        }
        if (string != null) {
            int n2 = Math.min(n, string.length());
            return string.substring(0, n2);
        }
        return "";
    }

    public static String getFormattedString(CDOMObject cDOMObject, SourceFormat sourceFormat, boolean bl) {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = sourceFormat.getField(cDOMObject);
        String string3 = null;
        Campaign campaign = cDOMObject.get(ObjectKey.SOURCE_CAMPAIGN);
        if (campaign != null) {
            string3 = sourceFormat.getPublisher(campaign);
            if (string2 == null) {
                string2 = sourceFormat.getField(campaign);
            }
        }
        if (string2 == null) {
            string2 = "";
        }
        if (string3 != null && string3.trim().length() > 0) {
            stringBuffer.append(string3);
            stringBuffer.append(" - ");
        }
        stringBuffer.append(string2);
        if (bl && sourceFormat.allowsPage() && (string = cDOMObject.get(StringKey.SOURCE_PAGE)) != null) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }
}

