/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import pcgen.base.formula.Formula;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.ChoiceActor;
import pcgen.cdom.base.ChoiceSet;
import pcgen.cdom.enumeration.AssociationListKey;
import pcgen.core.PlayerCharacter;
import pcgen.util.StringPClassUtil;
import pcgen.util.chooser.ChooserFactory;
import pcgen.util.chooser.ChooserInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransitionChoice<T> {
    private final ChoiceSet<? extends T> choices;
    private final Formula choiceCount;
    private String title;
    private boolean required = true;
    private ChoiceActor<T> choiceActor;
    private boolean allowStack = false;
    private Integer stackLimit = null;

    public TransitionChoice(ChoiceSet<? extends T> choiceSet, Formula formula) {
        this.choices = choiceSet;
        this.choiceCount = formula;
    }

    public ChoiceSet<? extends T> getChoices() {
        return this.choices;
    }

    public Formula getCount() {
        return this.choiceCount;
    }

    public boolean equals(Object object) {
        if (object instanceof TransitionChoice) {
            TransitionChoice transitionChoice = (TransitionChoice)object;
            return this.choiceCount.equals(transitionChoice.choiceCount) && this.choices.equals(transitionChoice.choices);
        }
        return false;
    }

    public int hashCode() {
        return this.choiceCount.hashCode() * 29 + this.choices.hashCode();
    }

    public Collection<? extends T> driveChoice(PlayerCharacter playerCharacter) {
        ChooserInterface chooserInterface = ChooserFactory.getChooserInstance();
        int n = this.choiceCount.resolve(playerCharacter, "").intValue();
        chooserInterface.setPoolFlag(this.required);
        if (n == Integer.MAX_VALUE) {
            chooserInterface.setPickAll(true);
        } else {
            chooserInterface.setTotalChoicesAvail(n);
        }
        if (this.title == null) {
            this.title = "Choose a " + StringPClassUtil.getStringFor(this.choices.getChoiceClass());
        }
        chooserInterface.setTitle(this.title);
        Set<T> set = this.choices.getSet(playerCharacter);
        HashSet<T> hashSet = new HashSet<T>();
        List<Object> list = playerCharacter.getAssocList(this, AssociationListKey.ADD);
        for (T t : set) {
            if (this.choiceActor != null && !this.choiceActor.allow(t, playerCharacter, this.allowStack)) continue;
            if (list != null && this.stackLimit != null && this.stackLimit > 0) {
                int n2 = 0;
                for (Object object : list) {
                    if (!object.equals(t)) continue;
                    ++n2;
                }
                if (this.stackLimit <= n2) continue;
            }
            hashSet.add(t);
        }
        if (chooserInterface.pickAll() || n == set.size()) {
            return hashSet;
        }
        chooserInterface.setAvailableList(new ArrayList(hashSet));
        chooserInterface.setVisible(true);
        return chooserInterface.getSelectedList();
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setRequired(boolean bl) {
        this.required = bl;
    }

    public void setChoiceActor(ChoiceActor<T> choiceActor) {
        this.choiceActor = choiceActor;
    }

    public void act(Collection<? extends T> collection, CDOMObject cDOMObject, PlayerCharacter playerCharacter) {
        if (this.choiceActor == null) {
            throw new IllegalStateException("Cannot act without a defined ChoiceActor");
        }
        for (T t : collection) {
            this.choiceActor.applyChoice(cDOMObject, t, playerCharacter);
            playerCharacter.addAssoc(this, AssociationListKey.ADD, t);
        }
    }

    public T castChoice(Object object) {
        return (T)object;
    }

    public void allowStack(boolean bl) {
        this.allowStack = bl;
    }

    public void setStackLimit(int n) {
        this.stackLimit = n;
    }

    public boolean allowsStacking() {
        return this.allowStack;
    }

    public int getStackLimit() {
        return this.stackLimit == null ? 0 : this.stackLimit;
    }

    public ChoiceActor<T> getChoiceActor() {
        return this.choiceActor;
    }
}

