/*
 * Decompiled with CFR 0.152.
 */
package pcgen.base.util;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import pcgen.base.util.RandomUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeightedCollection<E>
extends AbstractCollection<E> {
    private Collection<WeightedItem<E>> theData;

    public WeightedCollection() {
        this.theData = new ArrayList<WeightedItem<E>>();
    }

    public WeightedCollection(int n) {
        this.theData = new ArrayList<WeightedItem<E>>(n);
    }

    public WeightedCollection(Collection<? extends E> collection) {
        this();
        this.addAll(collection, 1);
    }

    public WeightedCollection(Comparator<? super E> comparator) {
        this.theData = comparator == null ? new ArrayList<WeightedItem<E>>() : new TreeSet<WeightedItem<E>>(new WeightedItemComparator<E>(comparator));
    }

    @Override
    public int size() {
        int n = 0;
        for (WeightedItem<E> weightedItem : this.theData) {
            n += weightedItem.getWeight();
        }
        return n;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        return this.addAll(collection, 1);
    }

    public final boolean add(E e, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Cannot items with weight < 0");
        }
        if (n == 0) {
            return false;
        }
        for (WeightedItem<E> weightedItem : this.theData) {
            E e2 = weightedItem.getElement();
            if ((e2 != null || e != null) && (e2 == null || !e2.equals(e))) continue;
            weightedItem.addWeight(n);
            return true;
        }
        return this.theData.add(new WeightedItem<E>(e, n));
    }

    @Override
    public boolean add(E e) {
        return this.add(e, 1);
    }

    public E getRandomValue() {
        int n = RandomUtil.getRandomInt(this.size());
        int n2 = 0;
        E e = null;
        for (WeightedItem<E> weightedItem : this.theData) {
            if ((n2 += weightedItem.getWeight()) <= n) continue;
            e = weightedItem.getElement();
            return e;
        }
        throw new IndexOutOfBoundsException(n + " >= " + n2);
    }

    @Override
    public Iterator<E> iterator() {
        return new WeightedIterator();
    }

    public Iterator<E> unweightedIterator() {
        return new UnweightedIterator();
    }

    @Override
    public boolean contains(Object object) {
        for (WeightedItem<E> weightedItem : this.theData) {
            E e = weightedItem.getElement();
            if ((e != null || object != null) && (e == null || !e.equals(object))) continue;
            return true;
        }
        return false;
    }

    public int getWeight(Object object) {
        for (WeightedItem<E> weightedItem : this.theData) {
            E e = weightedItem.getElement();
            if ((e != null || object != null) && (e == null || !e.equals(object))) continue;
            return ((WeightedItem)weightedItem).theWeight;
        }
        return 0;
    }

    @Override
    public boolean remove(Object object) {
        Iterator<WeightedItem<E>> iterator = this.theData.iterator();
        while (iterator.hasNext()) {
            WeightedItem<E> weightedItem = iterator.next();
            E e = weightedItem.getElement();
            if ((e != null || object != null) && (e == null || !e.equals(object))) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.theData.isEmpty();
    }

    @Override
    public void clear() {
        this.theData.clear();
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof WeightedCollection && ((Object)this.theData).equals(((WeightedCollection)object).theData);
    }

    @Override
    public int hashCode() {
        return ((Object)this.theData).hashCode();
    }

    @Override
    public String toString() {
        return "WeightedCollection: " + this.theData.toString();
    }

    public final boolean addAll(Collection<? extends E> collection, int n) {
        boolean bl = false;
        for (E e : collection) {
            bl |= this.add(e, n);
        }
        return bl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WeightedItemComparator<WICT>
    implements Comparator<WeightedItem<WICT>> {
        private final Comparator<? super WICT> delegateComparator;

        public WeightedItemComparator(Comparator<? super WICT> comparator) {
            this.delegateComparator = comparator;
        }

        @Override
        public int compare(WeightedItem<WICT> weightedItem, WeightedItem<WICT> weightedItem2) {
            return this.delegateComparator.compare(weightedItem.getElement(), weightedItem2.getElement());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UnweightedIterator
    implements Iterator<E> {
        private final Iterator<WeightedItem<E>> realIterator;

        private UnweightedIterator() {
            this.realIterator = WeightedCollection.this.theData.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.realIterator.hasNext();
        }

        @Override
        public E next() {
            return this.realIterator.next().getElement();
        }

        @Override
        public void remove() {
            this.realIterator.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class WeightedIterator
    implements Iterator<E> {
        private final Iterator<WeightedItem<E>> iter;
        private WeightedItem<E> currentEntry;
        private int currentReturned;

        WeightedIterator() {
            this.iter = WeightedCollection.this.theData.iterator();
            this.currentReturned = 0;
        }

        @Override
        public boolean hasNext() {
            if (this.currentEntry == null) {
                if (!this.iter.hasNext()) {
                    return false;
                }
                this.currentEntry = this.iter.next();
                this.currentReturned = 0;
            }
            if (this.currentReturned < this.currentEntry.theWeight) {
                return true;
            }
            return this.iter.hasNext();
        }

        @Override
        public E next() {
            if (this.currentEntry == null || this.currentReturned >= this.currentEntry.theWeight) {
                this.currentEntry = this.iter.next();
                this.currentReturned = 0;
            }
            ++this.currentReturned;
            return this.currentEntry.theElement;
        }

        @Override
        public void remove() {
            this.iter.remove();
            this.currentEntry = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class WeightedItem<T> {
        private final T theElement;
        private int theWeight;

        public WeightedItem(T t, int n) {
            this.theElement = t;
            this.theWeight = n;
        }

        public final T getElement() {
            return this.theElement;
        }

        public final int getWeight() {
            return this.theWeight;
        }

        public void addWeight(int n) {
            this.theWeight += n;
        }

        public int hashCode() {
            return this.theWeight * 29 + (this.theElement == null ? 0 : this.theElement.hashCode());
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object == this) {
                return true;
            }
            if (object instanceof WeightedItem) {
                WeightedItem weightedItem = (WeightedItem)object;
                return this.theWeight == weightedItem.theWeight && (this.theElement == null && weightedItem.theElement == null || this.theElement != null && this.theElement.equals(weightedItem.theElement));
            }
            return false;
        }

        public String toString() {
            return this.theElement + " (" + this.theWeight + ")";
        }
    }
}

