/*
 * Decompiled with CFR 0.152.
 */
package pcgen.base.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pcgen.base.util.GenericMapToList;
import pcgen.base.util.MapToList;
import pcgen.base.util.WrappedMapSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleKeyMapToList<K1, K2, V>
implements Cloneable {
    private final Class<? extends Map> firstClass;
    private final Class<? extends Map> secondClass;
    private Map<K1, MapToList<K2, V>> mtmtl;

    public DoubleKeyMapToList() {
        this.firstClass = HashMap.class;
        this.secondClass = this.firstClass;
        this.mtmtl = new HashMap<K1, MapToList<K2, V>>();
    }

    public DoubleKeyMapToList(Class<? extends Map> clazz, Class<? extends Map> clazz2) {
        if (clazz == null) {
            throw new IllegalArgumentException("First underlying Class cannot be null for DoubleKeyMapToList");
        }
        if (clazz2 == null) {
            throw new IllegalArgumentException("Second underlying Class cannot be null for DoubleKeyMapToList");
        }
        this.firstClass = clazz;
        this.secondClass = clazz2;
        this.mtmtl = this.createGlobalMap();
        GenericMapToList.getMapToList(this.secondClass);
    }

    public void addToListFor(K1 K1, K2 K2, V v) {
        this.getMapToListFor(K1).addToListFor(K2, v);
    }

    public void addAllToListFor(K1 K1, K2 K2, Collection<V> collection) {
        this.getMapToListFor(K1).addAllToListFor(K2, collection);
    }

    public void addAll(DoubleKeyMapToList<K1, K2, V> doubleKeyMapToList) {
        for (Map.Entry<K1, MapToList<K2, V>> entry : doubleKeyMapToList.mtmtl.entrySet()) {
            MapToList<K2, V> mapToList = this.getMapToListFor(entry.getKey());
            mapToList.addAllLists(entry.getValue());
        }
    }

    public List<V> getListFor(K1 K1, K2 K2) {
        MapToList<K2, V> mapToList = this.mtmtl.get(K1);
        if (mapToList == null) {
            return null;
        }
        return mapToList.getListFor(K2);
    }

    public boolean containsListFor(K1 K1) {
        return this.mtmtl.containsKey(K1);
    }

    public boolean containsListFor(K1 K1, K2 K2) {
        MapToList<K2, V> mapToList = this.mtmtl.get(K1);
        if (mapToList == null) {
            return false;
        }
        return mapToList.containsListFor(K2);
    }

    public MapToList<K2, V> removeListsFor(K1 K1) {
        return this.mtmtl.remove(K1);
    }

    public List<V> removeListFor(K1 K1, K2 K2) {
        MapToList<K2, V> mapToList = this.mtmtl.get(K1);
        if (mapToList == null) {
            return null;
        }
        List<V> list = mapToList.removeListFor(K2);
        if (mapToList.isEmpty()) {
            this.mtmtl.remove(K1);
        }
        return list;
    }

    public boolean removeFromListFor(K1 K1, K2 K2, V v) {
        MapToList<K2, V> mapToList = this.mtmtl.get(K1);
        if (mapToList == null) {
            return false;
        }
        boolean bl = mapToList.removeFromListFor(K2, v);
        if (bl && mapToList.isEmpty()) {
            this.mtmtl.remove(K1);
        }
        return bl;
    }

    public Set<K1> getKeySet() {
        return new WrappedMapSet<K1>(this.firstClass, this.mtmtl.keySet());
    }

    public Set<K2> getSecondaryKeySet(K1 K1) {
        MapToList<K2, V> mapToList = this.mtmtl.get(K1);
        if (mapToList == null) {
            return Collections.emptySet();
        }
        return mapToList.getKeySet();
    }

    public void clear() {
        this.mtmtl.clear();
    }

    public boolean isEmpty() {
        return this.mtmtl.isEmpty();
    }

    public int firstKeyCount() {
        return this.mtmtl.size();
    }

    public DoubleKeyMapToList<K1, K2, V> clone() throws CloneNotSupportedException {
        DoubleKeyMapToList doubleKeyMapToList = (DoubleKeyMapToList)super.clone();
        doubleKeyMapToList.mtmtl = this.createGlobalMap();
        for (K1 K1 : this.mtmtl.keySet()) {
            MapToList<K2, V> mapToList = this.mtmtl.get(K1);
            GenericMapToList<K2, V> genericMapToList = GenericMapToList.getMapToList(this.secondClass);
            genericMapToList.addAllLists(mapToList);
            doubleKeyMapToList.mtmtl.put(K1, genericMapToList);
        }
        return doubleKeyMapToList;
    }

    public boolean containsInList(K1 K1, K2 K2, V v) {
        return this.containsListFor(K1, K2) && this.mtmtl.get(K1).containsInList(K2, v);
    }

    public int sizeOfListFor(K1 K1, K2 K2) {
        MapToList<K2, V> mapToList = this.mtmtl.get(K1);
        return mapToList == null ? 0 : mapToList.sizeOfListFor(K2);
    }

    public int hashCode() {
        return ((Object)this.mtmtl).hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof DoubleKeyMapToList && ((Object)this.mtmtl).equals(((DoubleKeyMapToList)object).mtmtl);
    }

    private Map<K1, MapToList<K2, V>> createGlobalMap() {
        try {
            return this.firstClass.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException("Class for DoubleKeyMap must possess a zero-argument constructor", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("Class for DoubleKeyMap must possess a public zero-argument constructor", illegalAccessException);
        }
    }

    private MapToList<K2, V> getMapToListFor(K1 K1) {
        MapToList<K2, V> mapToList = this.mtmtl.get(K1);
        if (mapToList == null) {
            mapToList = GenericMapToList.getMapToList(this.secondClass);
            this.mtmtl.put(K1, mapToList);
        }
        return mapToList;
    }
}

