/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.test;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Point;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.logging.Logger;
import javax.swing.JFrame;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.domimpl.NodeImpl;
import org.lobobrowser.html.gui.HtmlPanel;
import org.lobobrowser.html.parser.DocumentBuilderImpl;
import org.lobobrowser.html.parser.InputSourceImpl;
import org.lobobrowser.html.renderer.DelayedPair;
import org.lobobrowser.html.renderer.FrameContext;
import org.lobobrowser.html.renderer.RBlock;
import org.lobobrowser.html.renderer.RenderableContainer;
import org.lobobrowser.html.renderer.RenderableSpot;
import org.lobobrowser.html.test.SimpleHtmlRendererContext;
import org.lobobrowser.html.test.SimpleUserAgentContext;
import org.lobobrowser.util.io.IORoutines;
import org.w3c.dom.Document;

public class MemoryTest {
    private static final Logger logger = Logger.getLogger(MemoryTest.class.getName());
    private static String TEST_URL = "file:c:\\temp\\html\\long.html";

    public static void main(String[] args) throws Exception {
        MemoryTest mt = new MemoryTest();
        mt.testRendererGUILoop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParserLoop() throws Exception {
        byte[] content;
        URL url = new URL(TEST_URL);
        URLConnection connection = url.openConnection();
        connection.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible;) Cobra/0.96.1+");
        connection.setRequestProperty("Cookie", "");
        if (connection instanceof HttpURLConnection) {
            HttpURLConnection hc = (HttpURLConnection)connection;
            hc.setInstanceFollowRedirects(true);
            int responseCode = hc.getResponseCode();
            logger.info("process(): HTTP response code: " + responseCode);
        }
        InputStream in = connection.getInputStream();
        try {
            content = IORoutines.load(in, 8192);
        }
        finally {
            in.close();
        }
        logger.info("Content size: " + content.length + " bytes.");
        SimpleUserAgentContext context = new SimpleUserAgentContext();
        DocumentBuilderImpl builder = new DocumentBuilderImpl(context);
        for (int i = 0; i < 200; ++i) {
            logger.info("Starting parse # " + i + ": freeMemory=" + Runtime.getRuntime().freeMemory());
            ByteArrayInputStream bin = new ByteArrayInputStream(content);
            Document document = builder.parse(new InputSourceImpl(bin, url.toExternalForm(), "ISO-8859-1"));
            logger.info("Finished parsing: freeMemory=" + Runtime.getRuntime().freeMemory() + ",document=" + document);
            document = null;
            System.gc();
            logger.info("After GC: freeMemory=" + Runtime.getRuntime().freeMemory());
            Thread.sleep(2L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRendererLoop() throws Exception {
        byte[] content;
        URL url = new URL(TEST_URL);
        URLConnection connection = url.openConnection();
        connection.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible;) Cobra/0.96.1+");
        connection.setRequestProperty("Cookie", "");
        if (connection instanceof HttpURLConnection) {
            HttpURLConnection hc = (HttpURLConnection)connection;
            hc.setInstanceFollowRedirects(true);
            int responseCode = hc.getResponseCode();
            logger.info("process(): HTTP response code: " + responseCode);
        }
        InputStream in = connection.getInputStream();
        try {
            content = IORoutines.load(in, 8192);
        }
        finally {
            in.close();
        }
        logger.info("Content size: " + content.length + " bytes.");
        SimpleUserAgentContext ucontext = new SimpleUserAgentContext();
        HtmlPanel panel = new HtmlPanel();
        final SimpleHtmlRendererContext rcontext = new SimpleHtmlRendererContext(panel);
        DocumentBuilderImpl builder = new DocumentBuilderImpl(ucontext, (HtmlRendererContext)rcontext);
        ByteArrayInputStream bin = new ByteArrayInputStream(content);
        final LocalFrameContext frameContext = new LocalFrameContext();
        final LocalRenderableContainer renderableContainer = new LocalRenderableContainer();
        for (int i = 0; i < 100; ++i) {
            logger.info("Starting parse # " + i + ": freeMemory=" + Runtime.getRuntime().freeMemory());
            bin = new ByteArrayInputStream(content);
            Document document = builder.parse(new InputSourceImpl(bin, url.toExternalForm(), "ISO-8859-1"));
            logger.info("Finished parsing: freeMemory=" + Runtime.getRuntime().freeMemory());
            final Document doc = document;
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    RBlock block = new RBlock((NodeImpl)((Object)doc), 0, rcontext.getUserAgentContext(), rcontext, frameContext, renderableContainer, 0);
                    block.layout(100, 100);
                }
            });
            Thread.sleep(50L);
            document = null;
            System.gc();
            logger.info("After GC: freeMemory=" + Runtime.getRuntime().freeMemory());
            Thread.sleep(2L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRendererGUILoop() throws Exception {
        byte[] content;
        URL url = new URL(TEST_URL);
        URLConnection connection = url.openConnection();
        connection.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible;) Cobra/0.96.1+");
        connection.setRequestProperty("Cookie", "");
        if (connection instanceof HttpURLConnection) {
            HttpURLConnection hc = (HttpURLConnection)connection;
            hc.setInstanceFollowRedirects(true);
            int responseCode = hc.getResponseCode();
            logger.info("process(): HTTP response code: " + responseCode);
        }
        InputStream in = connection.getInputStream();
        try {
            content = IORoutines.load(in, 8192);
        }
        finally {
            in.close();
        }
        logger.info("Content size: " + content.length + " bytes.");
        SimpleUserAgentContext ucontext = new SimpleUserAgentContext();
        HtmlPanel panel = new HtmlPanel();
        SimpleHtmlRendererContext rcontext = new SimpleHtmlRendererContext(panel);
        DocumentBuilderImpl builder = new DocumentBuilderImpl(ucontext, (HtmlRendererContext)rcontext);
        JFrame testFrame = new JFrame("Testing...");
        testFrame.setDefaultCloseOperation(3);
        testFrame.getContentPane().setLayout(new BorderLayout());
        testFrame.getContentPane().add((Component)panel, "Center");
        ByteArrayInputStream bin = new ByteArrayInputStream(content);
        testFrame.setSize(new Dimension(600, 400));
        testFrame.setVisible(true);
        for (int i = 0; i < 20; ++i) {
            logger.info("Starting parse # " + i + ": freeMemory=" + Runtime.getRuntime().freeMemory());
            bin = new ByteArrayInputStream(content);
            Document document = builder.parse(new InputSourceImpl(bin, url.toExternalForm(), "ISO-8859-1"));
            logger.info("Finished parsing: freeMemory=" + Runtime.getRuntime().freeMemory());
            panel.setDocument(document, rcontext);
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                }
            });
            Thread.sleep(3000L);
            panel.clearDocument();
            Thread.sleep(1000L);
            document = null;
            System.gc();
            logger.info("After GC: freeMemory=" + Runtime.getRuntime().freeMemory());
            Thread.sleep(2000L);
        }
    }

    private class LocalFrameContext
    implements FrameContext {
        private LocalFrameContext() {
        }

        public void expandSelection(RenderableSpot rpoint) {
        }

        public void resetSelection(RenderableSpot rpoint) {
        }

        public void delayedRelayout(NodeImpl node) {
        }
    }

    private class LocalRenderableContainer
    implements RenderableContainer {
        private LocalRenderableContainer() {
        }

        public void invalidateLayoutUpTree() {
        }

        public Component add(Component component) {
            return null;
        }

        public void remove(Component c) {
        }

        public Color getPaintedBackgroundColor() {
            return Color.BLACK;
        }

        public Insets getInsets() {
            return new Insets(0, 0, 0, 0);
        }

        public void repaint(int x, int y, int width, int height) {
        }

        public void relayout() {
        }

        public void updateAllWidgetBounds() {
        }

        public Point getGUIPoint(int clientX, int clientY) {
            return new Point(clientX, clientY);
        }

        public void focus() {
        }

        public void addDelayedPair(DelayedPair pair) {
        }

        public RenderableContainer getParentContainer() {
            return null;
        }

        public Collection getDelayedPairs() {
            return null;
        }

        public void clearDelayedPairs() {
        }
    }
}

