/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.SortedSet;
import java.util.TreeSet;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.domimpl.ModelNode;
import org.lobobrowser.html.renderer.BaseElementRenderable;
import org.lobobrowser.html.renderer.BoundableRenderable;
import org.lobobrowser.html.renderer.DelayedPair;
import org.lobobrowser.html.renderer.FrameContext;
import org.lobobrowser.html.renderer.PositionedRenderable;
import org.lobobrowser.html.renderer.RUIControl;
import org.lobobrowser.html.renderer.RenderableContainer;
import org.lobobrowser.html.renderer.RenderableSpot;
import org.lobobrowser.html.renderer.TableMatrix;
import org.lobobrowser.html.renderer.ZIndexComparator;

class RTable
extends BaseElementRenderable {
    private final TableMatrix tableMatrix;
    private SortedSet positionedRenderables;
    private int otherOrdinal;
    private volatile int lastAvailWidth = -1;
    private volatile int lastAvailHeight = -1;

    public RTable(HTMLElementImpl modelNode, UserAgentContext pcontext, HtmlRendererContext rcontext, FrameContext frameContext, RenderableContainer container) {
        super(container, modelNode, pcontext);
        this.tableMatrix = new TableMatrix(modelNode, pcontext, rcontext, frameContext, this, this);
    }

    public int getVAlign() {
        return 5;
    }

    protected void applyStyle() {
        super.applyStyle();
        Insets bi = this.borderInsets;
        if (bi == null) {
            HTMLElementImpl element = (HTMLElementImpl)this.modelNode;
            String borderText = element.getAttribute("border");
            int border = 0;
            if (borderText != null) {
                try {
                    border = Integer.parseInt(borderText);
                    if (border < 0) {
                        border = 0;
                    }
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            if (border > 0) {
                this.borderInsets = new Insets(border, border, border, border);
            }
        }
        if (this.borderTopColor == null && this.borderLeftColor == null) {
            this.borderTopColor = this.borderLeftColor = Color.LIGHT_GRAY;
        }
        if (this.borderBottomColor == null && this.borderRightColor == null) {
            this.borderBottomColor = this.borderRightColor = Color.DARK_GRAY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        try {
            this.prePaint(g);
            Dimension size = this.getSize();
            TableMatrix tm = this.tableMatrix;
            tm.paint(g, size);
            SortedSet prs = this.positionedRenderables;
            if (prs != null) {
                Iterator i = prs.iterator();
                while (i.hasNext()) {
                    PositionedRenderable pr = (PositionedRenderable)i.next();
                    BoundableRenderable r = pr.renderable;
                    r.paintTranslated(g);
                }
            }
        }
        finally {
            super.paint(g);
        }
    }

    public void doLayout(int availWidth, int availHeight, boolean expandWidth, boolean expandHeight) {
        if (availWidth != this.lastAvailWidth || availHeight != this.lastAvailHeight) {
            SortedSet prs = this.positionedRenderables;
            if (prs != null) {
                prs.clear();
            }
            this.otherOrdinal = 0;
            this.clearGUIComponents();
            this.clearDelayedPairs();
            this.applyStyle();
            this.lastAvailHeight = availHeight;
            this.lastAvailWidth = availWidth;
            TableMatrix tm = this.tableMatrix;
            Insets insets = this.getInsets(false, false);
            tm.reset(insets, availWidth, availHeight);
            tm.build(availWidth, availHeight);
            tm.doLayout(insets);
            this.width = tm.getTableWidth();
            this.height = tm.getTableHeight();
            Collection pairs = this.delayedPairs;
            if (pairs != null) {
                Iterator i = pairs.iterator();
                while (i.hasNext()) {
                    DelayedPair pair = (DelayedPair)i.next();
                    if (pair.targetParent != this) continue;
                    this.importDelayedPair(pair);
                }
            }
        }
        this.sendGUIComponentsToParent();
        this.sendDelayedPairsToParent();
    }

    public void invalidateLayoutLocal() {
        super.invalidateLayoutLocal();
        this.lastAvailHeight = -1;
        this.lastAvailWidth = -1;
    }

    public RenderableSpot getLowestRenderableSpot(int x, int y) {
        RenderableSpot rs;
        SortedSet prs = this.positionedRenderables;
        if (prs != null) {
            Iterator i = prs.iterator();
            while (i.hasNext()) {
                int childY;
                PositionedRenderable pr = (PositionedRenderable)i.next();
                BoundableRenderable r = pr.renderable;
                int childX = x - r.getX();
                RenderableSpot rs2 = r.getLowestRenderableSpot(childX, childY = y - r.getY());
                if (rs2 == null) continue;
                return rs2;
            }
        }
        if ((rs = this.tableMatrix.getLowestRenderableSpot(x, y)) != null) {
            return rs;
        }
        return new RenderableSpot(this, x, y);
    }

    public boolean onMouseClick(MouseEvent event, int x, int y) {
        SortedSet prs = this.positionedRenderables;
        if (prs != null) {
            Iterator i = prs.iterator();
            while (i.hasNext()) {
                int childY;
                int childX;
                PositionedRenderable pr = (PositionedRenderable)i.next();
                BoundableRenderable r = pr.renderable;
                Rectangle bounds = r.getBounds();
                if (!bounds.contains(x, y) || r.onMouseClick(event, childX = x - r.getX(), childY = y - r.getY())) continue;
                return false;
            }
        }
        return this.tableMatrix.onMouseClick(event, x, y);
    }

    public boolean onDoubleClick(MouseEvent event, int x, int y) {
        SortedSet prs = this.positionedRenderables;
        if (prs != null) {
            Iterator i = prs.iterator();
            while (i.hasNext()) {
                int childY;
                int childX;
                PositionedRenderable pr = (PositionedRenderable)i.next();
                BoundableRenderable r = pr.renderable;
                Rectangle bounds = r.getBounds();
                if (!bounds.contains(x, y) || r.onDoubleClick(event, childX = x - r.getX(), childY = y - r.getY())) continue;
                return false;
            }
        }
        return this.tableMatrix.onDoubleClick(event, x, y);
    }

    public boolean onMouseDisarmed(MouseEvent event) {
        return this.tableMatrix.onMouseDisarmed(event);
    }

    public boolean onMousePressed(MouseEvent event, int x, int y) {
        SortedSet prs = this.positionedRenderables;
        if (prs != null) {
            Iterator i = prs.iterator();
            while (i.hasNext()) {
                int childY;
                int childX;
                PositionedRenderable pr = (PositionedRenderable)i.next();
                BoundableRenderable r = pr.renderable;
                Rectangle bounds = r.getBounds();
                if (!bounds.contains(x, y) || r.onMousePressed(event, childX = x - r.getX(), childY = y - r.getY())) continue;
                return false;
            }
        }
        return this.tableMatrix.onMousePressed(event, x, y);
    }

    public boolean onMouseReleased(MouseEvent event, int x, int y) {
        SortedSet prs = this.positionedRenderables;
        if (prs != null) {
            Iterator i = prs.iterator();
            while (i.hasNext()) {
                int childY;
                int childX;
                PositionedRenderable pr = (PositionedRenderable)i.next();
                BoundableRenderable r = pr.renderable;
                Rectangle bounds = r.getBounds();
                if (!bounds.contains(x, y) || r.onMouseReleased(event, childX = x - r.getX(), childY = y - r.getY())) continue;
                return false;
            }
        }
        return this.tableMatrix.onMouseReleased(event, x, y);
    }

    public Iterator getRenderables() {
        SortedSet prs = this.positionedRenderables;
        if (prs != null) {
            LinkedList<BoundableRenderable> c = new LinkedList<BoundableRenderable>();
            Iterator i = prs.iterator();
            while (i.hasNext()) {
                PositionedRenderable pr = (PositionedRenderable)i.next();
                BoundableRenderable r = pr.renderable;
                c.add(r);
            }
            Iterator i2 = this.tableMatrix.getRenderables();
            while (i2.hasNext()) {
                c.add((BoundableRenderable)i2.next());
            }
            return c.iterator();
        }
        return this.tableMatrix.getRenderables();
    }

    public void repaint(ModelNode modelNode) {
    }

    public Color getPaintedBackgroundColor() {
        return this.container.getPaintedBackgroundColor();
    }

    private final void addPositionedRenderable(BoundableRenderable renderable, boolean verticalAlignable) {
        TreeSet<PositionedRenderable> others = this.positionedRenderables;
        if (others == null) {
            this.positionedRenderables = others = new TreeSet<PositionedRenderable>(new ZIndexComparator());
        }
        others.add(new PositionedRenderable(renderable, verticalAlignable, this.otherOrdinal++));
        renderable.setParent(this);
        if (renderable instanceof RUIControl) {
            this.container.add(((RUIControl)renderable).widget.getComponent());
        }
    }

    private void importDelayedPair(DelayedPair pair) {
        BoundableRenderable r = pair.child;
        r.setOrigin(pair.x, pair.y);
        this.addPositionedRenderable(r, false);
    }

    public String toString() {
        return "RTable[this=" + System.identityHashCode(this) + ",node=" + this.modelNode + "]";
    }
}

