/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import java.util.ArrayList;
import org.lobobrowser.html.domimpl.DescendentHTMLCollection;
import org.lobobrowser.html.domimpl.ElementFilter;
import org.lobobrowser.html.domimpl.HTMLAbstractUIElement;
import org.lobobrowser.html.style.CSS2PropertiesImpl;
import org.lobobrowser.html.style.HtmlLength;
import org.lobobrowser.html.style.HtmlValues;
import org.lobobrowser.html.style.RenderState;
import org.lobobrowser.html.style.TableRenderState;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.html2.HTMLCollection;
import org.w3c.dom.html2.HTMLElement;
import org.w3c.dom.html2.HTMLTableCaptionElement;
import org.w3c.dom.html2.HTMLTableElement;
import org.w3c.dom.html2.HTMLTableSectionElement;

public class HTMLTableElementImpl
extends HTMLAbstractUIElement
implements HTMLTableElement {
    private HTMLTableCaptionElement caption;
    private HTMLTableSectionElement thead;
    private HTMLTableSectionElement tfoot;

    public HTMLTableElementImpl() {
        super("TABLE");
    }

    public HTMLTableElementImpl(String name) {
        super(name);
    }

    public HTMLTableCaptionElement getCaption() {
        return this.caption;
    }

    public void setCaption(HTMLTableCaptionElement caption) throws DOMException {
        this.caption = caption;
    }

    public HTMLTableSectionElement getTHead() {
        return this.thead;
    }

    public void setTHead(HTMLTableSectionElement tHead) throws DOMException {
        this.thead = tHead;
    }

    public HTMLTableSectionElement getTFoot() {
        return this.tfoot;
    }

    public void setTFoot(HTMLTableSectionElement tFoot) throws DOMException {
        this.tfoot = tFoot;
    }

    public HTMLCollection getRows() {
        return new DescendentHTMLCollection(this, new ElementFilter("TR"));
    }

    public HTMLCollection getTBodies() {
        return new DescendentHTMLCollection(this, new ElementFilter("TBODY"));
    }

    public String getAlign() {
        return this.getAttribute("align");
    }

    public void setAlign(String align) {
        this.setAttribute("align", align);
    }

    public String getBgColor() {
        return this.getAttribute("bgcolor");
    }

    public void setBgColor(String bgColor) {
        this.setAttribute("bgcolor", bgColor);
    }

    public String getBorder() {
        return this.getAttribute("border");
    }

    public void setBorder(String border) {
        this.setAttribute("border", border);
    }

    public String getCellPadding() {
        return this.getAttribute("cellpadding");
    }

    public void setCellPadding(String cellPadding) {
        this.setAttribute("cellpadding", cellPadding);
    }

    public String getCellSpacing() {
        return this.getAttribute("cellspacing");
    }

    public void setCellSpacing(String cellSpacing) {
        this.setAttribute("cellspacing", cellSpacing);
    }

    public String getFrame() {
        return this.getAttribute("frame");
    }

    public void setFrame(String frame) {
        this.setAttribute("frame", frame);
    }

    public String getRules() {
        return this.getAttribute("rules");
    }

    public void setRules(String rules) {
        this.setAttribute("rules", rules);
    }

    public String getSummary() {
        return this.getAttribute("summary");
    }

    public void setSummary(String summary) {
        this.setAttribute("summary", summary);
    }

    public String getWidth() {
        return this.getAttribute("width");
    }

    public void setWidth(String width) {
        this.setAttribute("width", width);
    }

    public HtmlLength getHeightLength(int availHeight) {
        try {
            String heightText;
            CSS2PropertiesImpl props = this.getCurrentStyle();
            String string = heightText = props == null ? null : props.getHeight();
            if (heightText == null) {
                return new HtmlLength(this.getAttribute("height"));
            }
            return new HtmlLength(HtmlValues.getPixelSize(heightText, this.getRenderState(), 0, availHeight));
        }
        catch (Exception err) {
            return null;
        }
    }

    public HtmlLength getWidthLength(int availWidth) {
        try {
            String widthText;
            CSS2PropertiesImpl props = this.getCurrentStyle();
            String string = widthText = props == null ? null : props.getWidth();
            if (widthText == null) {
                return new HtmlLength(this.getAttribute("width"));
            }
            return new HtmlLength(HtmlValues.getPixelSize(widthText, this.getRenderState(), 0, availWidth));
        }
        catch (Exception err) {
            return null;
        }
    }

    public HTMLElement createTHead() {
        Document doc = this.document;
        return doc == null ? null : (HTMLElement)doc.createElement("thead");
    }

    public void deleteTHead() {
        this.removeChildren(new ElementFilter("THEAD"));
    }

    public HTMLElement createTFoot() {
        Document doc = this.document;
        return doc == null ? null : (HTMLElement)doc.createElement("tfoot");
    }

    public void deleteTFoot() {
        this.removeChildren(new ElementFilter("TFOOT"));
    }

    public HTMLElement createCaption() {
        Document doc = this.document;
        return doc == null ? null : (HTMLElement)doc.createElement("caption");
    }

    public void deleteCaption() {
        this.removeChildren(new ElementFilter("CAPTION"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTMLElement insertRow(int index) throws DOMException {
        Document doc = this.document;
        if (doc == null) {
            throw new DOMException(4, "Orphan element");
        }
        HTMLElement rowElement = (HTMLElement)doc.createElement("TR");
        Object object = this.treeLock;
        synchronized (object) {
            if (index == -1) {
                this.appendChild(rowElement);
                return rowElement;
            }
            ArrayList nl = this.nodeList;
            if (nl != null) {
                int size = nl.size();
                int trcount = 0;
                for (int i = 0; i < size; ++i) {
                    Node node = (Node)nl.get(i);
                    if (!"TR".equalsIgnoreCase(node.getNodeName())) continue;
                    if (trcount == index) {
                        this.insertAt(rowElement, i);
                        return rowElement;
                    }
                    ++trcount;
                }
            } else {
                this.appendChild(rowElement);
                return rowElement;
            }
        }
        throw new DOMException(1, "Index out of range");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRow(int index) throws DOMException {
        Object object = this.treeLock;
        synchronized (object) {
            ArrayList nl = this.nodeList;
            if (nl != null) {
                int size = nl.size();
                int trcount = 0;
                for (int i = 0; i < size; ++i) {
                    Node node = (Node)nl.get(i);
                    if (!"TR".equalsIgnoreCase(node.getNodeName())) continue;
                    if (trcount == index) {
                        this.removeChildAt(i);
                        return;
                    }
                    ++trcount;
                }
            }
        }
        throw new DOMException(1, "Index out of range");
    }

    protected RenderState createRenderState(RenderState prevRenderState) {
        return new TableRenderState(prevRenderState, this);
    }
}

