/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.lobobrowser.html.FormInput;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.domimpl.DescendentHTMLCollection;
import org.lobobrowser.html.domimpl.HTMLAbstractUIElement;
import org.lobobrowser.html.domimpl.HTMLBaseInputElement;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.domimpl.NodeFilter;
import org.lobobrowser.html.domimpl.NodeVisitor;
import org.lobobrowser.html.domimpl.StopVisitorException;
import org.lobobrowser.html.js.Executor;
import org.mozilla.javascript.Function;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.html2.HTMLCollection;
import org.w3c.dom.html2.HTMLFormElement;

public class HTMLFormElementImpl
extends HTMLAbstractUIElement
implements HTMLFormElement {
    private Function onsubmit;

    public HTMLFormElementImpl(String name) {
        super(name);
    }

    public HTMLFormElementImpl() {
        super("FORM");
    }

    public Object namedItem(final String name) {
        try {
            this.visit(new NodeVisitor(){

                public void visit(Node node) {
                    if (HTMLFormElementImpl.isInput(node) && name.equals(((Element)node).getAttribute("name"))) {
                        throw new StopVisitorException(node);
                    }
                }
            });
        }
        catch (StopVisitorException sve) {
            return sve.getTag();
        }
        return null;
    }

    public Object item(final int index) {
        try {
            this.visit(new NodeVisitor(){
                private int current = 0;

                public void visit(Node node) {
                    if (HTMLFormElementImpl.isInput(node)) {
                        if (this.current == index) {
                            throw new StopVisitorException(node);
                        }
                        ++this.current;
                    }
                }
            });
        }
        catch (StopVisitorException sve) {
            return sve.getTag();
        }
        return null;
    }

    public HTMLCollection getElements() {
        return new DescendentHTMLCollection(this, new InputFilter());
    }

    public int getLength() {
        return new DescendentHTMLCollection(this, new InputFilter()).getLength();
    }

    public String getName() {
        return this.getAttribute("name");
    }

    public void setName(String name) {
        this.setAttribute("name", name);
    }

    public String getAcceptCharset() {
        return this.getAttribute("acceptCharset");
    }

    public void setAcceptCharset(String acceptCharset) {
        this.setAttribute("acceptCharset", acceptCharset);
    }

    public String getAction() {
        return this.getAttribute("action");
    }

    public void setAction(String action) {
        this.setAttribute("action", action);
    }

    public String getEnctype() {
        return this.getAttribute("enctype");
    }

    public void setEnctype(String enctype) {
        this.setAttribute("enctype", enctype);
    }

    public String getMethod() {
        String method = this.getAttribute("method");
        if (method == null) {
            method = "GET";
        }
        return method;
    }

    public void setMethod(String method) {
        this.setAttribute("method", method);
    }

    public String getTarget() {
        return this.getAttribute("target");
    }

    public void setTarget(String target) {
        this.setAttribute("target", target);
    }

    public void submit() {
        this.submit(null);
    }

    public void setOnsubmit(Function value) {
        this.onsubmit = value;
    }

    public Function getOnsubmit() {
        return this.getEventFunction(this.onsubmit, "onsubmit");
    }

    public final void submit(FormInput[] extraFormInputs) {
        Function onsubmit = this.getOnsubmit();
        if (onsubmit != null && !Executor.executeFunction(this, onsubmit, null)) {
            return;
        }
        HtmlRendererContext context = this.getHtmlRendererContext();
        if (context != null) {
            final ArrayList<FormInput> formInputs = new ArrayList<FormInput>();
            if (extraFormInputs != null) {
                for (int i = 0; i < extraFormInputs.length; ++i) {
                    formInputs.add(extraFormInputs[i]);
                }
            }
            this.visit(new NodeVisitor(){

                public void visit(Node node) {
                    FormInput[] fis;
                    if (node instanceof HTMLElementImpl && (fis = ((HTMLElementImpl)node).getFormInputs()) != null) {
                        for (int i = 0; i < fis.length; ++i) {
                            FormInput fi = fis[i];
                            if (fi.getName() == null) {
                                throw new IllegalStateException("Form input does not have a name: " + node);
                            }
                            formInputs.add(fi);
                        }
                    }
                }
            });
            FormInput[] fia = formInputs.toArray(FormInput.EMPTY_ARRAY);
            String href = this.getAction();
            if (href == null) {
                href = this.getBaseURI();
            }
            try {
                URL url = this.getFullURL(href);
                context.submitForm(this.getMethod(), url, this.getTarget(), this.getEnctype(), fia);
            }
            catch (MalformedURLException mfu) {
                this.warn("submit()", mfu);
            }
        }
    }

    public void reset() {
        this.visit(new NodeVisitor(){

            public void visit(Node node) {
                if (node instanceof HTMLBaseInputElement) {
                    ((HTMLBaseInputElement)node).resetInput();
                }
            }
        });
    }

    static boolean isInput(Node node) {
        String name = node.getNodeName().toLowerCase();
        return name.equals("input") || name.equals("textarea") || name.equals("select");
    }

    private class InputFilter
    implements NodeFilter {
        private InputFilter() {
        }

        public boolean accept(Node node) {
            return HTMLFormElementImpl.isInput(node);
        }
    }
}

