/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import java.util.Map;
import org.lobobrowser.html.domimpl.NodeFilter;
import org.lobobrowser.html.domimpl.NodeImpl;
import org.lobobrowser.html.domimpl.NodeVisitor;
import org.lobobrowser.html.domimpl.StopVisitorException;
import org.lobobrowser.js.AbstractScriptableDelegate;
import org.w3c.dom.Node;
import org.w3c.dom.html2.HTMLCollection;

public class FilteredHTMLCollectionImpl
extends AbstractScriptableDelegate
implements HTMLCollection {
    private final Map sourceMap;
    private final NodeFilter filter;
    private final Object lock;
    private final NodeImpl rootNode;

    public FilteredHTMLCollectionImpl(NodeImpl rootNode, Map sourceMap, NodeFilter filter, Object lock) {
        this.sourceMap = sourceMap;
        this.filter = filter;
        this.lock = lock;
        this.rootNode = rootNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLength() {
        CounterNodeVisitor visitor = new CounterNodeVisitor();
        Object object = this.lock;
        synchronized (object) {
            this.rootNode.visitImpl(visitor);
            return visitor.getCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node item(final int index) {
        NodeVisitor visitor = new NodeVisitor(){
            private int counter = 0;

            public void visit(Node node) {
                if (FilteredHTMLCollectionImpl.this.filter.accept(node)) {
                    if (this.counter == index) {
                        throw new StopVisitorException(node);
                    }
                    ++this.counter;
                }
            }
        };
        Object object = this.lock;
        synchronized (object) {
            try {
                this.rootNode.visitImpl(visitor);
                return null;
            }
            catch (StopVisitorException sve) {
                return (Node)sve.getTag();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node namedItem(String name) {
        Object object = this.lock;
        synchronized (object) {
            Node node = (Node)this.sourceMap.get(name);
            if (node != null && this.filter.accept(node)) {
                return node;
            }
            return null;
        }
    }

    private class CounterNodeVisitor
    implements NodeVisitor {
        private int counter = 0;

        private CounterNodeVisitor() {
        }

        public void visit(Node node) {
            if (FilteredHTMLCollectionImpl.this.filter.accept(node)) {
                ++this.counter;
            }
        }

        public int getCount() {
            return this.counter;
        }
    }
}

