/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.pcclass;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import pcgen.base.lang.StringUtil;
import pcgen.base.util.TreeMapToList;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.content.KnownSpellIdentifier;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.reference.CDOMGroupRef;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.PCClass;
import pcgen.core.spell.Spell;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.TokenUtilities;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KnownspellsToken
extends AbstractToken
implements CDOMPrimaryToken<PCClass> {
    private static final Class<Spell> SPELL_CLASS = Spell.class;

    public String getTokenName() {
        return "KNOWNSPELLS";
    }

    public boolean parse(LoadContext loadContext, PCClass pCClass, String string) {
        if (this.isEmpty(string) || this.hasIllegalSeparator('|', string)) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        boolean bl = true;
        while (stringTokenizer.hasMoreTokens()) {
            String string2;
            String string3 = stringTokenizer.nextToken();
            if (".CLEARALL".equals(string3)) {
                if (!bl) {
                    Logging.errorPrint((String)("Non-sensical situation was encountered while parsing " + this.getTokenName() + ": When used, .CLEARALL must be the first argument"));
                    return false;
                }
                loadContext.getObjectContext().removeList((CDOMObject)pCClass, ListKey.KNOWN_SPELLS);
                continue;
            }
            if (this.hasIllegalSeparator(',', string3)) {
                return false;
            }
            StringTokenizer stringTokenizer2 = new StringTokenizer(string3, ",");
            Integer n = null;
            CDOMGroupRef cDOMGroupRef = null;
            while (stringTokenizer2.hasMoreTokens()) {
                string2 = stringTokenizer2.nextToken();
                if (string2.startsWith("LEVEL=")) {
                    if (n != null) {
                        Logging.errorPrint((String)("Cannot have more than one Level limit in " + this.getTokenName() + ": " + string));
                        return false;
                    }
                    try {
                        n = Integer.valueOf(string2.substring(6));
                    }
                    catch (NumberFormatException numberFormatException) {
                        Logging.errorPrint((String)("Invalid Number in " + this.getTokenName() + ": " + string));
                        Logging.errorPrint((String)"  Level must be an integer");
                        return false;
                    }
                } else {
                    if (cDOMGroupRef != null) {
                        Logging.errorPrint((String)("Cannot have more than one Type/Spell limit in " + this.getTokenName() + ": " + string));
                        return false;
                    }
                    cDOMGroupRef = TokenUtilities.getTypeOrPrimitive((LoadContext)loadContext, SPELL_CLASS, (String)string2);
                    if (cDOMGroupRef == null) {
                        Logging.errorPrint((String)("  encountered Invalid limit in " + this.getTokenName() + ": " + string));
                        return false;
                    }
                }
                bl = false;
            }
            if (cDOMGroupRef == null) {
                cDOMGroupRef = loadContext.ref.getCDOMAllReference(SPELL_CLASS);
            }
            string2 = new KnownSpellIdentifier((CDOMReference)cDOMGroupRef, n);
            loadContext.getObjectContext().addToList((CDOMObject)pCClass, ListKey.KNOWN_SPELLS, (Object)string2);
        }
        return true;
    }

    public String[] unparse(LoadContext loadContext, PCClass pCClass) {
        Collection collection;
        Changes changes = loadContext.getObjectContext().getListChanges((CDOMObject)pCClass, ListKey.KNOWN_SPELLS);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (changes.includesGlobalClear()) {
            arrayList.add(".CLEARALL");
        }
        if ((collection = changes.getRemoved()) != null && !collection.isEmpty()) {
            loadContext.addWriteMessage(this.getTokenName() + " does not support .CLEAR.");
            return null;
        }
        Collection collection2 = changes.getAdded();
        if (collection2 != null && !collection2.isEmpty()) {
            TreeMapToList treeMapToList = new TreeMapToList(ReferenceUtilities.REFERENCE_SORTER);
            for (KnownSpellIdentifier knownSpellIdentifier : collection2) {
                CDOMReference cDOMReference = knownSpellIdentifier.getSpellReference();
                Integer n = knownSpellIdentifier.getSpellLevel();
                treeMapToList.addToListFor((Object)cDOMReference, (Object)n);
            }
            for (KnownSpellIdentifier knownSpellIdentifier : treeMapToList.getKeySet()) {
                for (Integer n : treeMapToList.getListFor((Object)knownSpellIdentifier)) {
                    StringBuilder stringBuilder = new StringBuilder();
                    boolean bl = false;
                    String string = knownSpellIdentifier.getLSTformat();
                    if (!"ALL".equals(string)) {
                        stringBuilder.append(string);
                        bl = true;
                    }
                    if (n != null) {
                        if (bl) {
                            stringBuilder.append(',');
                        }
                        stringBuilder.append("LEVEL=").append(n);
                    }
                    arrayList.add(stringBuilder.toString());
                }
            }
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return new String[]{StringUtil.join(arrayList, (String)"|")};
    }

    public Class<PCClass> getTokenClass() {
        return PCClass.class;
    }
}

