/*
 * Decompiled with CFR 0.152.
 */
package plugin.dicebag.gui;

import gmgen.GMGenSystem;
import gmgen.io.SimpleFileFilter;
import java.awt.Component;
import java.io.File;
import java.util.StringTokenizer;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import pcgen.core.SettingsHandler;
import plugin.dicebag.gui.DiceBagModel;
import plugin.dicebag.gui.DiceBagPluginModel;
import plugin.dicebag.gui.DiceBagPluginView;

public class DiceBagPluginController {
    private DiceBagPluginModel theModel = new DiceBagPluginModel();
    private DiceBagPluginView theView = new DiceBagPluginView(this.theModel);

    public DiceBagPluginController() {
        this.openInitialBags();
    }

    public Component getComponent() {
        return this.theView.getMainComponent();
    }

    public static File chooseSaveFile(DiceBagModel diceBagModel) {
        String string;
        File file = null;
        JFileChooser jFileChooser = new JFileChooser();
        String[] stringArray = new String[]{"dbg"};
        SimpleFileFilter simpleFileFilter = new SimpleFileFilter(stringArray, "GMGen Dice Bag");
        jFileChooser.addChoosableFileFilter((FileFilter)simpleFileFilter);
        jFileChooser.setFileFilter((FileFilter)simpleFileFilter);
        if (diceBagModel.getFilePath() != null) {
            jFileChooser.setSelectedFile(new File(diceBagModel.getFilePath()));
        } else {
            string = SettingsHandler.getGMGenOption((String)"DiceBag.LastFile", (String)System.getProperty("user.dir"));
            jFileChooser.setCurrentDirectory(new File(string));
        }
        if (jFileChooser.showSaveDialog((Component)GMGenSystem.inst) == 0) {
            SettingsHandler.setGMGenOption((String)"DiceBag.LastFile", (String)jFileChooser.getSelectedFile().getParent());
            string = jFileChooser.getSelectedFile().getName();
            String string2 = jFileChooser.getSelectedFile().getParent();
            String string3 = "";
            if (string.indexOf(".dbg") < 0) {
                string3 = ".dbg";
            }
            file = new File(string2 + File.separator + string + string3);
        }
        return file;
    }

    public void fileNew() {
        this.theModel.addNewDicebag();
    }

    public boolean fileOpen() {
        String[] stringArray;
        boolean bl = false;
        String string = SettingsHandler.getGMGenOption((String)"DiceBag.LastFile", (String)System.getProperty("user.dir"));
        JFileChooser jFileChooser = new JFileChooser();
        if (string != null && (stringArray = new File(string)).exists()) {
            jFileChooser.setCurrentDirectory((File)stringArray);
        }
        stringArray = new String[]{"dbg"};
        SimpleFileFilter simpleFileFilter = new SimpleFileFilter(stringArray, "GMGen Dice Bag");
        jFileChooser.addChoosableFileFilter((FileFilter)simpleFileFilter);
        jFileChooser.setFileFilter((FileFilter)simpleFileFilter);
        if (jFileChooser.showOpenDialog((Component)GMGenSystem.inst) == 0) {
            this.openFile(jFileChooser.getSelectedFile());
            bl = true;
        }
        return bl;
    }

    public void openFile(File file) {
        SettingsHandler.setGMGenOption((String)"DiceBag.LastFile", (String)file.getParent());
        this.theModel.loadDiceBag(file);
    }

    public void fileSave() {
        File file;
        if (this.theModel.getActiveBag() != null && (file = DiceBagPluginController.chooseSaveFile(this.theModel.getActiveBag())) != null) {
            int n;
            if (file.exists() && (n = JOptionPane.showConfirmDialog(this.getComponent(), "File Exists, Overwrite?", "File Exists", 0, 3)) == 1) {
                return;
            }
            this.theModel.saveDiceBag(this.theModel.getActiveBag(), file);
        }
    }

    public void windowClosed() {
        this.theView.closeAll();
    }

    protected void openInitialBags() {
        String string = SettingsHandler.getGMGenOption((String)"DiceBagcloseFiles", (String)"");
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        boolean bl = true;
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            File file = new File(string2);
            if (file.exists() && string2.endsWith(".dbg")) {
                try {
                    this.theModel.loadDiceBag(file);
                    bl = false;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++n;
        }
        if (bl) {
            this.fileNew();
        }
    }
}

