/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.kit.prof;

import pcgen.core.kit.KitProf;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMSecondaryToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CountToken
extends AbstractToken
implements CDOMSecondaryToken<KitProf> {
    public String getTokenName() {
        return "COUNT";
    }

    public Class<KitProf> getTokenClass() {
        return KitProf.class;
    }

    public String getParentToken() {
        return "*KITTOKEN";
    }

    public boolean parse(LoadContext loadContext, KitProf kitProf, String string) {
        try {
            Integer n = Integer.valueOf(string);
            if (n <= 0) {
                Logging.errorPrint((String)(this.getTokenName() + " expected an integer > 0"));
                return false;
            }
            kitProf.setCount(n);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            Logging.errorPrint((String)(this.getTokenName() + " expected an integer.  Tag must be of the form: " + this.getTokenName() + ":<int>"));
            return false;
        }
    }

    public String[] unparse(LoadContext loadContext, KitProf kitProf) {
        Integer n = kitProf.getCount();
        if (n == null) {
            return null;
        }
        return new String[]{n.toString()};
    }
}

