/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.logging.Level;
import pcgen.base.formula.Formula;
import pcgen.base.lang.StringUtil;
import pcgen.base.util.DoubleKeyMap;
import pcgen.base.util.MapToList;
import pcgen.base.util.TripleKeyMap;
import pcgen.cdom.base.AssociatedPrereqObject;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.FormulaFactory;
import pcgen.cdom.enumeration.AssociationKey;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.spell.Spell;
import pcgen.rules.context.AssociatedChanges;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpellsLst
extends AbstractToken
implements CDOMPrimaryToken<CDOMObject> {
    public String getTokenName() {
        return "SPELLS";
    }

    public boolean parse(LoadContext loadContext, CDOMObject cDOMObject, String string) {
        return this.createSpellsList(loadContext, cDOMObject, string);
    }

    private boolean createSpellsList(LoadContext loadContext, CDOMObject cDOMObject, String string) {
        String string2;
        if (this.isEmpty(string) || this.hasIllegalSeparator('|', string)) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        String string3 = stringTokenizer.nextToken();
        String string4 = null;
        String string5 = null;
        String string6 = null;
        if (!stringTokenizer.hasMoreTokens()) {
            Logging.addParseMessage((Level)Logging.LST_ERROR, (String)(this.getTokenName() + ": minimally requires a Spell Name"));
            return false;
        }
        String string7 = stringTokenizer.nextToken();
        while (true) {
            if (string7.startsWith("TIMES=")) {
                if (string5 != null) {
                    Logging.addParseMessage((Level)Logging.LST_ERROR, (String)("Found two TIMES entries in " + this.getTokenName() + ": invalid: " + string));
                    return false;
                }
                string5 = string7.substring(6);
                if (string5.length() == 0) {
                    Logging.addParseMessage((Level)Logging.LST_ERROR, (String)("Error in Times in " + this.getTokenName() + ": argument was empty"));
                    return false;
                }
                if (!stringTokenizer.hasMoreTokens()) {
                    Logging.addParseMessage((Level)Logging.LST_ERROR, (String)(this.getTokenName() + ": minimally requires " + "a Spell Name (after TIMES=)"));
                    return false;
                }
                string7 = stringTokenizer.nextToken();
                continue;
            }
            if (string7.startsWith("TIMEUNIT=")) {
                if (string6 != null) {
                    Logging.addParseMessage((Level)Logging.LST_ERROR, (String)("Found two TIMEUNIT entries in " + this.getTokenName() + ": invalid: " + string));
                    return false;
                }
                string6 = string7.substring(9);
                if (string6.length() == 0) {
                    Logging.addParseMessage((Level)Logging.LST_ERROR, (String)("Error in TimeUnit in " + this.getTokenName() + ": argument was empty"));
                    return false;
                }
                if (!stringTokenizer.hasMoreTokens()) {
                    Logging.addParseMessage((Level)Logging.LST_ERROR, (String)(this.getTokenName() + ": minimally requires " + "a Spell Name (after TIMEUNIT=)"));
                    return false;
                }
                string7 = stringTokenizer.nextToken();
                continue;
            }
            if (!string7.startsWith("CASTERLEVEL=")) break;
            if (string4 != null) {
                Logging.addParseMessage((Level)Logging.LST_ERROR, (String)("Found two CASTERLEVEL entries in " + this.getTokenName() + ": invalid: " + string));
                return false;
            }
            string4 = string7.substring(12);
            if (string4.length() == 0) {
                Logging.addParseMessage((Level)Logging.LST_ERROR, (String)("Error in Caster Level in " + this.getTokenName() + ": argument was empty"));
                return false;
            }
            if (!stringTokenizer.hasMoreTokens()) {
                Logging.addParseMessage((Level)Logging.LST_ERROR, (String)(this.getTokenName() + ": minimally requires a " + "Spell Name (after CASTERLEVEL=)"));
                return false;
            }
            string7 = stringTokenizer.nextToken();
        }
        if (string5 == null) {
            string5 = "1";
        }
        if (string7.charAt(0) == ',') {
            Logging.addParseMessage((Level)Logging.LST_ERROR, (String)(this.getTokenName() + " Spell arguments may not start with , : " + string7));
            return false;
        }
        if (string7.charAt(string7.length() - 1) == ',') {
            Logging.addParseMessage((Level)Logging.LST_ERROR, (String)(this.getTokenName() + " Spell arguments may not end with , : " + string7));
            return false;
        }
        if (string7.indexOf(",,") != -1) {
            Logging.addParseMessage((Level)Logging.LST_ERROR, (String)(this.getTokenName() + " Spell arguments uses double separator ,, : " + string7));
            return false;
        }
        DoubleKeyMap doubleKeyMap = new DoubleKeyMap(LinkedHashMap.class, HashMap.class);
        do {
            int n;
            string2 = (n = string7.indexOf(44)) == -1 ? string7 : string7.substring(0, n);
            CDOMSingleRef cDOMSingleRef = loadContext.ref.getCDOMReference(Spell.class, string2);
            doubleKeyMap.put((Object)cDOMSingleRef, (Object)AssociationKey.CASTER_LEVEL, (Object)string4);
            doubleKeyMap.put((Object)cDOMSingleRef, (Object)AssociationKey.TIMES_PER_UNIT, (Object)FormulaFactory.getFormulaFor((String)string5));
            if (string6 != null) {
                doubleKeyMap.put((Object)cDOMSingleRef, (Object)AssociationKey.TIME_UNIT, (Object)string6);
            }
            doubleKeyMap.put((Object)cDOMSingleRef, (Object)AssociationKey.SPELLBOOK, (Object)string3);
            if (n != -1) {
                doubleKeyMap.put((Object)cDOMSingleRef, (Object)AssociationKey.DC_FORMULA, (Object)string7.substring(n + 1));
            }
            if (stringTokenizer.hasMoreTokens()) continue;
            this.finish(loadContext, cDOMObject, doubleKeyMap, null);
            return true;
        } while (!(string7 = stringTokenizer.nextToken()).startsWith("PRE") && !string7.startsWith("!PRE"));
        ArrayList<Prerequisite> arrayList = new ArrayList<Prerequisite>();
        while (true) {
            if ((string2 = this.getPrerequisite(string7)) == null) {
                Logging.addParseMessage((Level)Logging.LST_ERROR, (String)"   (Did you put spells after the PRExxx tags in SPELLS:?)");
                return false;
            }
            arrayList.add((Prerequisite)string2);
            if (!stringTokenizer.hasMoreTokens()) break;
            string7 = stringTokenizer.nextToken();
        }
        this.finish(loadContext, cDOMObject, doubleKeyMap, arrayList);
        return true;
    }

    public void finish(LoadContext loadContext, CDOMObject cDOMObject, DoubleKeyMap<CDOMReference<Spell>, AssociationKey<?>, Object> doubleKeyMap, List<Prerequisite> list) {
        for (CDOMReference cDOMReference : doubleKeyMap.getKeySet()) {
            AssociatedPrereqObject associatedPrereqObject = loadContext.getListContext().addToList(this.getTokenName(), cDOMObject, Spell.SPELLS, cDOMReference);
            for (AssociationKey associationKey : doubleKeyMap.getSecondaryKeySet((Object)cDOMReference)) {
                associatedPrereqObject.setAssociation(associationKey, doubleKeyMap.get((Object)cDOMReference, (Object)associationKey));
            }
            if (list == null) continue;
            for (Prerequisite prerequisite : list) {
                associatedPrereqObject.addPrerequisite(prerequisite);
            }
        }
    }

    public String[] unparse(LoadContext loadContext, CDOMObject cDOMObject) {
        CharSequence charSequence;
        AssociatedChanges associatedChanges = loadContext.getListContext().getChangesInList(this.getTokenName(), cDOMObject, Spell.SPELLS);
        MapToList mapToList = associatedChanges.getAddedAssociations();
        if (mapToList == null || mapToList.isEmpty()) {
            return null;
        }
        TripleKeyMap tripleKeyMap = new TripleKeyMap();
        for (Object object : mapToList.getKeySet()) {
            for (Object object2 : mapToList.getListFor(object)) {
                Map<AssociationKey, Object> map = new HashMap();
                charSequence = null;
                for (Object object3 : object2.getAssociationKeys()) {
                    if (AssociationKey.DC_FORMULA.equals(object3)) {
                        charSequence = (String)object2.getAssociation(AssociationKey.DC_FORMULA);
                        continue;
                    }
                    map.put((AssociationKey)object3, object2.getAssociation(object3));
                }
                tripleKeyMap.put(new HashSet(object2.getPrerequisiteList()), map, object, (Object)charSequence);
            }
        }
        TreeSet treeSet = new TreeSet();
        for (Object object : tripleKeyMap.getKeySet()) {
            for (Map<AssociationKey, Object> map : tripleKeyMap.getSecondaryKeySet(object)) {
                String string;
                Object object3;
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append(map.get(AssociationKey.SPELLBOOK));
                Formula formula = (Formula)AssociationKey.TIMES_PER_UNIT.cast(map.get(AssociationKey.TIMES_PER_UNIT));
                if (!FormulaFactory.ONE.equals(formula)) {
                    ((StringBuilder)charSequence).append("|").append("TIMES=").append(formula);
                }
                if ((object3 = (String)AssociationKey.TIME_UNIT.cast(map.get(AssociationKey.TIME_UNIT))) != null) {
                    ((StringBuilder)charSequence).append("|").append("TIMEUNIT=").append((String)object3);
                }
                if ((string = (String)AssociationKey.CASTER_LEVEL.cast(map.get(AssociationKey.CASTER_LEVEL))) != null) {
                    ((StringBuilder)charSequence).append("|").append("CASTERLEVEL=").append(string);
                }
                TreeSet<String> treeSet2 = new TreeSet<String>();
                for (CDOMReference cDOMReference : tripleKeyMap.getTertiaryKeySet(object, map)) {
                    String string2 = cDOMReference.getLSTformat();
                    String string3 = (String)tripleKeyMap.get(object, map, (Object)cDOMReference);
                    if (string3 != null) {
                        string2 = string2 + "," + string3;
                    }
                    treeSet2.add(string2);
                }
                ((StringBuilder)charSequence).append("|");
                ((StringBuilder)charSequence).append(StringUtil.join(treeSet2, (String)"|"));
                if (object != null && !object.isEmpty()) {
                    ((StringBuilder)charSequence).append("|");
                    ((StringBuilder)charSequence).append(this.getPrerequisiteString(loadContext, (Collection)object));
                }
                treeSet.add(((StringBuilder)charSequence).toString());
            }
        }
        return treeSet.toArray(new String[treeSet.size()]);
    }

    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }
}

