/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.equipment;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.logging.Level;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.helper.Capacity;
import pcgen.core.Equipment;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.util.BigDecimalHelper;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainsToken
extends AbstractToken
implements CDOMPrimaryToken<Equipment> {
    public String getTokenName() {
        return "CONTAINS";
    }

    public boolean parse(LoadContext loadContext, Equipment equipment, String string) {
        Object object;
        Object object2;
        int n;
        if (this.isEmpty(string) || this.hasIllegalSeparator('|', string)) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        loadContext.obj.removeList((CDOMObject)equipment, ListKey.CAPACITY);
        String string2 = stringTokenizer.nextToken();
        boolean bl = false;
        if (string2.charAt(0) == '*') {
            bl = true;
            loadContext.getObjectContext().put((CDOMObject)equipment, ObjectKey.CONTAINER_CONSTANT_WEIGHT, (Object)Boolean.TRUE);
            string2 = string2.substring(1);
        }
        if ((n = string2.indexOf(37)) != string2.lastIndexOf(37)) {
            Logging.addParseMessage((Level)Logging.LST_ERROR, (String)("Cannot have two weight reduction characters (indicated by %): " + string));
            return false;
        }
        if (n != -1) {
            if (bl) {
                Logging.addParseMessage((Level)Logging.LST_ERROR, (String)("Cannot have Constant Weight (indicated by *) and weight reduction (indicated by %): " + string));
                return false;
            }
            object2 = string2.substring(0, n);
            string2 = string2.substring(n + 1);
            try {
                loadContext.getObjectContext().put((CDOMObject)equipment, IntegerKey.CONTAINER_REDUCE_WEIGHT, Integer.valueOf((String)object2));
            }
            catch (NumberFormatException numberFormatException) {
                Logging.addParseMessage((Level)Logging.LST_ERROR, (String)("Weight Reduction (indicated by %) must be an integer: " + string));
                return false;
            }
        }
        if ("UNLIM".equals(string2)) {
            object2 = Capacity.UNLIMITED;
        } else {
            try {
                object2 = BigDecimalHelper.trimBigDecimal((BigDecimal)new BigDecimal(string2));
                if (BigDecimal.ZERO.compareTo((BigDecimal)object2) > 0) {
                    Logging.addParseMessage((Level)Logging.LST_ERROR, (String)("Weight Capacity must be >= 0: " + string2 + "\n  Use 'UNLIM' (not -1) for unlimited Count"));
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                Logging.addParseMessage((Level)Logging.LST_ERROR, (String)("Weight Capacity must be 'UNLIM or a number >= 0: " + string2));
                return false;
            }
        }
        loadContext.getObjectContext().put((CDOMObject)equipment, ObjectKey.CONTAINER_WEIGHT_CAPACITY, object2);
        Capacity capacity = null;
        boolean bl2 = true;
        if (!stringTokenizer.hasMoreTokens()) {
            bl2 = false;
            capacity = Capacity.ANY;
        }
        BigDecimal bigDecimal = BigDecimal.ZERO;
        while (stringTokenizer.hasMoreTokens()) {
            BigDecimal bigDecimal2;
            object = stringTokenizer.nextToken();
            int n2 = ((String)object).indexOf("=");
            if (n2 != ((String)object).lastIndexOf("=")) {
                return false;
            }
            if (n2 == -1) {
                bl2 = false;
                loadContext.getObjectContext().addToList((CDOMObject)equipment, ListKey.CAPACITY, (Object)new Capacity((String)object, Capacity.UNLIMITED));
                continue;
            }
            String string3 = ((String)object).substring(0, n2);
            String string4 = ((String)object).substring(n2 + 1);
            if ("UNLIM".equals(string4)) {
                bl2 = false;
                bigDecimal2 = Capacity.UNLIMITED;
            } else {
                try {
                    bigDecimal2 = BigDecimalHelper.trimBigDecimal((BigDecimal)new BigDecimal(string4));
                }
                catch (NumberFormatException numberFormatException) {
                    Logging.addParseMessage((Level)Logging.LST_ERROR, (String)("Item Number for " + string3 + " must be 'UNLIM' or a number > 0: " + string4));
                    return false;
                }
                if (BigDecimal.ZERO.compareTo(bigDecimal2) >= 0) {
                    Logging.addParseMessage((Level)Logging.LST_ERROR, (String)("Cannot have negative quantity of " + string3 + ": " + string));
                    return false;
                }
            }
            if (bl2) {
                bigDecimal = bigDecimal.add(bigDecimal2);
            }
            loadContext.getObjectContext().addToList((CDOMObject)equipment, ListKey.CAPACITY, (Object)new Capacity(string3, bigDecimal2));
        }
        if (capacity == null) {
            object = bl2 ? bigDecimal : Capacity.UNLIMITED;
            capacity = Capacity.getTotalCapacity((BigDecimal)object);
        }
        loadContext.getObjectContext().put((CDOMObject)equipment, ObjectKey.TOTAL_CAPACITY, (Object)capacity);
        return true;
    }

    public String[] unparse(LoadContext loadContext, Equipment equipment) {
        BigDecimal bigDecimal;
        Integer n;
        Changes changes = loadContext.getObjectContext().getListChanges((CDOMObject)equipment, ListKey.CAPACITY);
        Capacity capacity = (Capacity)loadContext.getObjectContext().getObject((CDOMObject)equipment, ObjectKey.TOTAL_CAPACITY);
        if (capacity == null && (changes == null || changes.isEmpty())) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        Boolean bl = (Boolean)loadContext.getObjectContext().getObject((CDOMObject)equipment, ObjectKey.CONTAINER_CONSTANT_WEIGHT);
        if (bl != null && bl.booleanValue()) {
            stringBuilder.append('*');
        }
        if ((n = loadContext.getObjectContext().getInteger((CDOMObject)equipment, IntegerKey.CONTAINER_REDUCE_WEIGHT)) != null) {
            stringBuilder.append(n).append('%');
        }
        if ((bigDecimal = (BigDecimal)loadContext.getObjectContext().getObject((CDOMObject)equipment, ObjectKey.CONTAINER_WEIGHT_CAPACITY)) == null) {
            return null;
        }
        if (Capacity.UNLIMITED.equals(bigDecimal)) {
            stringBuilder.append("UNLIM");
        } else {
            stringBuilder.append(bigDecimal);
        }
        Collection collection = changes.getAdded();
        if (collection == null && Capacity.UNLIMITED.equals(capacity.getCapacity())) {
            return new String[]{stringBuilder.toString()};
        }
        BigDecimal bigDecimal2 = BigDecimal.ZERO;
        boolean bl2 = true;
        for (Capacity capacity2 : collection) {
            String string = capacity2.getType();
            stringBuilder.append("|");
            BigDecimal bigDecimal3 = capacity2.getCapacity();
            stringBuilder.append(string);
            if (Capacity.UNLIMITED.equals(bigDecimal3)) {
                bl2 = false;
                continue;
            }
            if (bl2) {
                bigDecimal2 = bigDecimal2.add(bigDecimal3);
            }
            stringBuilder.append("=").append(bigDecimal3);
        }
        if (!bigDecimal2.equals(capacity.getCapacity()) && !Capacity.UNLIMITED.equals(capacity.getCapacity())) {
            stringBuilder.append("Total").append("=").append(capacity.getCapacity());
        }
        return new String[]{stringBuilder.toString()};
    }

    public Class<Equipment> getTokenClass() {
        return Equipment.class;
    }
}

