/*
 * Decompiled with CFR 0.152.
 */
package plugin.initiative.gui;

import gmgen.GMGenSystem;
import gmgen.plugin.PcgCombatant;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.DefaultFormatter;
import pcgen.core.RollingMethods;
import plugin.initiative.AttackModel;
import plugin.initiative.gui.AutoSizingColumnModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttackDialog
extends JDialog {
    private List<Integer> m_damageList = null;
    private List m_targetList = null;
    private AttackModel m_attack = null;
    private AttackTableModel m_tableModel = null;
    private JComboBox m_acTypeCombo;
    private JComboBox m_targets = null;
    private JComboBox m_targetsCombo;
    private JFormattedTextField m_field;
    private JLabel m_totalDamageLabel;
    private JTable m_table = null;
    private Vector m_combatants = null;
    private boolean m_subdual;
    private int m_totalDmg;

    public AttackDialog(AttackModel attackModel) {
        super((Frame)GMGenSystem.inst);
        this.m_attack = attackModel;
        this.initComponents();
    }

    public AttackDialog(AttackModel attackModel, Vector vector) {
        super((Frame)GMGenSystem.inst);
        this.m_attack = attackModel;
        if (vector != null) {
            this.m_combatants = (Vector)vector.clone();
        }
        this.initComponents();
    }

    public List<Integer> getDamageList() {
        return this.m_damageList;
    }

    public List getDamagedCombatants() {
        return this.m_targetList;
    }

    public boolean isSubdual() {
        return this.m_subdual;
    }

    public int getTotalDmg() {
        return this.m_totalDmg;
    }

    protected void handleAcTypeAction(ActionEvent actionEvent) {
        this.m_field.setValue(((PcgCombatant)this.m_targetsCombo.getSelectedItem()).getPC().calcACOfType(this.m_acTypeCombo.getSelectedItem().toString()));
        this.m_tableModel.setAcType(this.m_acTypeCombo.getSelectedItem().toString());
    }

    protected void handleCancel() {
        this.m_damageList = null;
        this.m_targetList = null;
        this.setVisible(false);
    }

    protected void handleOk() {
        this.m_damageList = new ArrayList<Integer>(this.m_tableModel.getRowCount());
        this.m_targetList = new ArrayList(this.m_tableModel.getRowCount());
        for (int i = 0; i < this.m_table.getRowCount(); ++i) {
            int n = this.m_tableModel.getIntAt(i, this.m_tableModel.columnFromKey("DMGTOT"));
            if (n <= 0) continue;
            this.m_damageList.add(n);
            Object object = this.m_tableModel.getValueAt(i, this.m_tableModel.columnFromKey("TARGET"));
            if (object == null || !(object instanceof PcgCombatant)) continue;
            this.m_targetList.add(object);
        }
        this.setVisible(false);
    }

    protected void handleSubdualAction(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JCheckBox) {
            this.m_subdual = ((JCheckBox)actionEvent.getSource()).isSelected();
        }
    }

    protected void handleTableUpdate(TableModelEvent tableModelEvent) {
        int n = this.m_tableModel.columnFromKey("DMGTOT");
        if (n == tableModelEvent.getColumn() || tableModelEvent.getColumn() == -1 || tableModelEvent.getType() == -1 || tableModelEvent.getType() == 1) {
            this.m_totalDmg = 0;
            for (int i = 0; i < this.m_table.getRowCount(); ++i) {
                this.m_totalDmg += this.m_tableModel.getIntAt(i, n);
            }
            this.m_totalDamageLabel.setText("<html>Total Damage: <b>" + this.m_totalDmg + "</b></html>");
        }
    }

    protected void handleTargetAction(ActionEvent actionEvent) {
        if (this.m_targetsCombo != null && this.m_targetsCombo.getSelectedItem() != null && this.m_targetsCombo.getSelectedItem() instanceof PcgCombatant) {
            PcgCombatant pcgCombatant = (PcgCombatant)this.m_targetsCombo.getSelectedItem();
            this.m_field.setValue(pcgCombatant.getPC().calcACOfType(this.m_acTypeCombo.getSelectedItem().toString()));
            this.m_tableModel.setTarget(pcgCombatant);
        }
    }

    protected void performRoll() {
        this.m_tableModel.rollAttacks();
    }

    private void initComponents() {
        this.setTitle("Attack: " + this.m_attack.toString());
        this.getContentPane().setLayout(new BorderLayout());
        this.m_attack.getBonusList();
        JPanel jPanel = new JPanel(new BorderLayout());
        this.getContentPane().add((Component)jPanel, "Center");
        AutoSizingColumnModel autoSizingColumnModel = new AutoSizingColumnModel();
        this.m_tableModel = new AttackTableModel();
        this.m_tableModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                AttackDialog.this.handleTableUpdate(tableModelEvent);
            }
        });
        this.m_table = new JTable(this.m_tableModel, autoSizingColumnModel);
        autoSizingColumnModel.referenceTable(this.m_table);
        this.m_table.setAutoResizeMode(0);
        this.m_table.setAutoCreateColumnsFromModel(true);
        this.m_table.setPreferredScrollableViewportSize(new Dimension(autoSizingColumnModel.getTotalPreferredWidth(), this.m_table.getRowHeight() * this.m_table.getRowCount()));
        jPanel.add((Component)new JScrollPane(this.m_table), "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(Box.createRigidArea(new Dimension(10, 0)));
        this.m_totalDamageLabel = new JLabel("<html>Total Damage: <b>0</b></html>");
        jPanel2.add(this.m_totalDamageLabel);
        jPanel2.add(Box.createRigidArea(new Dimension(10, 0)));
        JCheckBox jCheckBox = new JCheckBox("Damage is subdual?");
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttackDialog.this.handleSubdualAction(actionEvent);
            }
        });
        jPanel2.add(jCheckBox);
        jPanel2.add(Box.createRigidArea(new Dimension(10, 0)));
        JButton jButton = null;
        jButton = new JButton(new AbstractAction("Roll"){

            public void actionPerformed(ActionEvent actionEvent) {
                AttackDialog.this.performRoll();
            }
        });
        jPanel2.add(jButton);
        jPanel2.add(Box.createRigidArea(new Dimension(10, 0)));
        jButton = new JButton(new AbstractAction("Ok"){

            public void actionPerformed(ActionEvent actionEvent) {
                AttackDialog.this.handleOk();
            }
        });
        jPanel2.add(jButton);
        jPanel2.add(Box.createRigidArea(new Dimension(10, 0)));
        jButton = new JButton(new AbstractAction("Cancel"){

            public void actionPerformed(ActionEvent actionEvent) {
                AttackDialog.this.handleCancel();
            }
        });
        jPanel2.add(jButton);
        this.getContentPane().add((Component)jPanel2, "South");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        if (this.m_combatants != null && this.m_combatants.size() > 0) {
            this.m_targets = new JComboBox(this.m_combatants);
            this.m_table.setDefaultEditor(PcgCombatant.class, new DefaultCellEditor(this.m_targets));
            this.m_targetsCombo = new JComboBox(this.m_combatants);
            this.m_targetsCombo.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AttackDialog.this.handleTargetAction(actionEvent);
                }
            });
            jPanel3.add(new JLabel("Attack Character: "));
            jPanel3.add(this.m_targetsCombo);
            this.m_acTypeCombo = new JComboBox();
            this.m_acTypeCombo.addItem("Total");
            this.m_acTypeCombo.addItem("Flatfooted");
            this.m_acTypeCombo.addItem("Touch");
            this.m_acTypeCombo.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AttackDialog.this.handleAcTypeAction(actionEvent);
                }
            });
            jPanel3.add(new JLabel("Use AC Type: "));
            jPanel3.add(this.m_acTypeCombo);
        }
        DefaultFormatter defaultFormatter = new DefaultFormatter();
        defaultFormatter.setValueClass(Integer.class);
        defaultFormatter.setCommitsOnValidEdit(true);
        this.m_field = new JFormattedTextField(defaultFormatter);
        this.m_field.setFocusLostBehavior(1);
        this.m_field.setPreferredSize(new Dimension(40, this.m_field.getPreferredSize().height));
        this.m_field.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName() != null && propertyChangeEvent.getPropertyName().equals("value")) {
                    AttackDialog.this.m_tableModel.setArmorClass((Integer)AttackDialog.this.m_field.getValue());
                }
            }
        });
        jPanel3.add(new JLabel("AC"));
        jPanel3.add(this.m_field);
        this.m_field.setValue(15);
        this.handleTargetAction(null);
        this.getContentPane().add((Component)jPanel3, "North");
        this.pack();
        this.setLocationRelativeTo((Component)GMGenSystem.inst);
    }

    public class AttackTableModel
    extends DefaultTableModel {
        static final String COLUMN_KEY_BONUS = "BONUS";
        static final String COLUMN_KEY_FUDGE = "FUDGE";
        static final String COLUMN_KEY_INCREMENT = "INCREMENT";
        static final String COLUMN_KEY_RANGE = "RANGE";
        static final String COLUMN_KEY_ROLL = "ROLL";
        static final String COLUMN_KEY_TOTAL = "TOTAL";
        static final String COLUMN_KEY_CRITROLL = "CRITROLL";
        static final String COLUMN_KEY_CRITTOTAL = "CRITTOTAL";
        static final String COLUMN_KEY_HIT = "HIT";
        static final String COLUMN_KEY_CRIT = "CRIT";
        static final String COLUMN_KEY_DMG = "DMG";
        static final String COLUMN_KEY_DMGTOT = "DMGTOT";
        static final String COLUMN_KEY_TARGET = "TARGET";
        static final String COLUMN_KEY_AC = "ARMORCLASS";
        static final int COLUMN_INDEX_NAME = 0;
        static final int COLUMN_INDEX_CLASS = 1;
        static final int COLUMN_INDEX_DEFAULT = 2;
        static final int COLUMN_INDEX_EDITABLE = 3;
        static final int COLUMN_INDEX_KEY = 4;
        private String m_acType = "Total";
        private Object[][] columns = new Object[][]{{"Bonus", Integer.class, null, Boolean.FALSE, "BONUS"}, {"Fudge", Integer.class, 0, Boolean.TRUE, "FUDGE"}, {"Increment", Integer.class, AttackDialog.access$400(AttackDialog.this).getRangeAsInt(), Boolean.FALSE, "INCREMENT"}, {"Range", Integer.class, null, Boolean.TRUE, "RANGE"}, {"Roll", Integer.class, null, Boolean.FALSE, "ROLL"}, {"Total", Integer.class, null, Boolean.FALSE, "TOTAL"}, {"Target", PcgCombatant.class, null, Boolean.TRUE, "TARGET"}, {"AC", Integer.class, null, Boolean.TRUE, "ARMORCLASS"}, {"Crit Roll", Integer.class, null, Boolean.FALSE, "CRITROLL"}, {"Crit Total", Integer.class, null, Boolean.FALSE, "CRITTOTAL"}, {"Hit", Boolean.class, Boolean.FALSE, Boolean.TRUE, "HIT"}, {"Crit", Boolean.class, Boolean.FALSE, Boolean.TRUE, "CRIT"}, {"Dmg", String.class, null, Boolean.TRUE, "DMG"}, {"Dmg Tot", Integer.class, null, Boolean.TRUE, "DMGTOT"}};

        public AttackTableModel() {
            int n;
            int[] nArray = AttackDialog.this.m_attack.getBonusList();
            Vector<Object> vector = new Vector<Object>(this.columns.length);
            vector.setSize(vector.capacity());
            for (n = 0; n < this.columns.length; ++n) {
                this.addColumn(this.columns[n][0]);
                vector.add(n, this.columns[n][2]);
            }
            for (n = 0; n < nArray.length; ++n) {
                vector.set(this.columnFromKey(COLUMN_KEY_BONUS), nArray[n]);
                vector.set(this.columnFromKey(COLUMN_KEY_DMG), AttackDialog.this.m_attack.getDamage(n));
                this.addRow((Vector)vector.clone());
            }
        }

        public void setAcType(String string) {
            this.m_acType = string;
            for (int i = 0; i < this.getRowCount(); ++i) {
                this.recalcRow(i, this.columnFromKey(COLUMN_KEY_TARGET));
            }
        }

        public void setArmorClass(int n) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                this.setValueAt(n, i, this.columnFromKey(COLUMN_KEY_AC));
            }
        }

        public boolean isCellEditable(int n, int n2) {
            return (Boolean)this.columns[n2][3];
        }

        public Class getColumnClass(int n) {
            return (Class)this.columns[n][1];
        }

        public void setTarget(PcgCombatant pcgCombatant) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                this.setValueAt(pcgCombatant, i, this.columnFromKey(COLUMN_KEY_TARGET));
            }
        }

        public void setValueAt(Object object, int n, int n2) {
            super.setValueAt(object, n, n2);
            this.recalcRow(n, n2);
        }

        public void rollAttacks() {
            for (int i = 0; i < this.getRowCount(); ++i) {
                this.rollAttack(i);
            }
        }

        private int getIntAt(int n, int n2) {
            int n3 = 0;
            if (this.getValueAt(n, n2) != null && this.getValueAt(n, n2) instanceof Integer) {
                n3 = (Integer)this.getValueAt(n, n2);
            }
            return n3;
        }

        private int columnFromKey(String string) {
            int n = -1;
            for (int i = 0; i < this.columns.length; ++i) {
                if (!this.columns[i][4].equals(string)) continue;
                n = i;
                break;
            }
            return n;
        }

        private void recalcRow(int n, int n2) {
            int n3;
            int n4;
            int n5 = 0;
            int n6 = this.getIntAt(n, this.columnFromKey(COLUMN_KEY_BONUS)) + this.getIntAt(n, this.columnFromKey(COLUMN_KEY_FUDGE));
            if (this.getIntAt(n, this.columnFromKey(COLUMN_KEY_INCREMENT)) > 0 && this.getIntAt(n, this.columnFromKey(COLUMN_KEY_RANGE)) > 0) {
                n6 += (int)Math.floor((double)this.getIntAt(n, this.columnFromKey(COLUMN_KEY_RANGE)) / (double)this.getIntAt(n, this.columnFromKey(COLUMN_KEY_INCREMENT))) * -2;
            }
            n5 = (n4 = this.getIntAt(n, this.columnFromKey(COLUMN_KEY_ROLL))) == 1 || n4 == 0 ? n4 : n4 + n6;
            if (n2 == this.columnFromKey(COLUMN_KEY_BONUS) || n2 == this.columnFromKey(COLUMN_KEY_FUDGE) || n2 == this.columnFromKey(COLUMN_KEY_INCREMENT) || n2 == this.columnFromKey(COLUMN_KEY_RANGE) || n2 == this.columnFromKey(COLUMN_KEY_ROLL)) {
                this.setValueAt(n5, n, this.columnFromKey(COLUMN_KEY_TOTAL));
            }
            if (n2 == this.columnFromKey(COLUMN_KEY_TARGET) && this.getValueAt(n, this.columnFromKey(COLUMN_KEY_TARGET)) instanceof PcgCombatant) {
                this.setValueAt(((PcgCombatant)this.getValueAt(n, this.columnFromKey(COLUMN_KEY_TARGET))).getPC().calcACOfType(this.m_acType), n, this.columnFromKey(COLUMN_KEY_AC));
            }
            if (n2 == this.columnFromKey(COLUMN_KEY_TOTAL) || n2 == this.columnFromKey(COLUMN_KEY_AC)) {
                if (n5 >= this.getIntAt(n, this.columnFromKey(COLUMN_KEY_AC)) || this.getIntAt(n, this.columnFromKey(COLUMN_KEY_ROLL)) >= 20) {
                    this.setValueAt(Boolean.TRUE, n, this.columnFromKey(COLUMN_KEY_HIT));
                } else {
                    this.setValueAt(Boolean.FALSE, n, this.columnFromKey(COLUMN_KEY_HIT));
                }
            }
            if (n2 == this.columnFromKey(COLUMN_KEY_CRITROLL) || n2 == this.columnFromKey(COLUMN_KEY_AC)) {
                n3 = 0;
                if (this.getIntAt(n, this.columnFromKey(COLUMN_KEY_CRITROLL)) > 1) {
                    n3 = this.getIntAt(n, this.columnFromKey(COLUMN_KEY_CRITROLL)) + n6;
                    this.setValueAt(n3, n, this.columnFromKey(COLUMN_KEY_CRITTOTAL));
                } else {
                    this.setValueAt(null, n, this.columnFromKey(COLUMN_KEY_CRITTOTAL));
                }
                if (n3 > this.getIntAt(n, this.columnFromKey(COLUMN_KEY_AC)) || this.getIntAt(n, this.columnFromKey(COLUMN_KEY_CRITROLL)) >= 20) {
                    this.setValueAt(Boolean.TRUE, n, this.columnFromKey(COLUMN_KEY_CRIT));
                } else {
                    this.setValueAt(Boolean.FALSE, n, this.columnFromKey(COLUMN_KEY_CRIT));
                }
            }
            if (n2 == this.columnFromKey(COLUMN_KEY_HIT) || n2 == this.columnFromKey(COLUMN_KEY_CRIT)) {
                if (((Boolean)this.getValueAt(n, this.columnFromKey(COLUMN_KEY_HIT))).booleanValue()) {
                    n3 = 1;
                    String string = (String)this.getValueAt(n, this.columnFromKey(COLUMN_KEY_DMG));
                    if (string.indexOf("/") >= 0) {
                        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
                        Object[] objectArray = new String[stringTokenizer.countTokens()];
                        int n7 = 0;
                        while (stringTokenizer.hasMoreTokens()) {
                            objectArray[n7] = stringTokenizer.nextToken();
                            ++n7;
                        }
                        string = (String)JOptionPane.showInputDialog(AttackDialog.this, "This weapon appears to have more than one possible damage die listed.  Please choose one:", "Multiple Damage Dice", 3, null, objectArray, objectArray[1]);
                        this.setValueAt(string, n, this.columnFromKey(COLUMN_KEY_DMG));
                    }
                    if (((Boolean)this.getValueAt(n, this.columnFromKey(COLUMN_KEY_CRIT))).booleanValue()) {
                        n3 = Integer.parseInt(AttackDialog.this.m_attack.getCritMultiple(n));
                    }
                    int n8 = 0;
                    for (int i = 0; i < n3; ++i) {
                        n8 += RollingMethods.roll((String)string);
                    }
                    this.setValueAt(n8, n, this.columnFromKey(COLUMN_KEY_DMGTOT));
                } else {
                    this.setValueAt(null, n, this.columnFromKey(COLUMN_KEY_DMGTOT));
                }
            }
        }

        private void rollAttack(int n) {
            this.setValueAt(RollingMethods.roll((String)"1d20"), n, this.columnFromKey(COLUMN_KEY_ROLL));
            if (this.getIntAt(n, this.columnFromKey(COLUMN_KEY_ROLL)) >= AttackDialog.this.m_attack.getCritRangeMin(n) && ((Boolean)this.getValueAt(n, this.columnFromKey(COLUMN_KEY_HIT))).booleanValue()) {
                this.setValueAt(RollingMethods.roll((String)"1d20"), n, this.columnFromKey(COLUMN_KEY_CRITROLL));
            } else {
                this.setValueAt(null, n, this.columnFromKey(COLUMN_KEY_CRITROLL));
            }
        }
    }
}

