/*
 * Decompiled with CFR 0.152.
 */
package plugin.network.gui;

import gmgen.gui.PreferencesPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import pcgen.core.SettingsHandler;
import plugin.network.NetworkModel;

public class PreferencesNetworkingPanel
extends PreferencesPanel {
    private NetworkModel model;
    private JPanel serverPanel;
    private JPanel clientPanel;
    private JTextField serverPort;
    private JTextField userName;

    public PreferencesNetworkingPanel(NetworkModel networkModel) {
        this.initComponents();
        this.model = networkModel;
        this.initPreferences();
    }

    public void setPortNumber(int n) {
        this.serverPort.setText(Integer.toString(n));
    }

    public int getPortNumber() {
        int n = 80;
        try {
            n = Integer.parseInt(this.serverPort.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    public void setUserName(String string) {
        this.userName.setText(string);
    }

    public String getUserName() {
        return this.userName.getText();
    }

    public void applyPreferences() {
        SettingsHandler.setGMGenOption((String)"Network.port", (int)this.getPortNumber());
        SettingsHandler.setGMGenOption((String)"Network.username", (String)this.getUserName());
        this.model.applyPrefs();
    }

    public void initPreferences() {
        this.setPortNumber(SettingsHandler.getGMGenOption((String)"Network.port", (int)80));
        this.setUserName(SettingsHandler.getGMGenOption((String)"Network.username", (String)"Player"));
    }

    public String toString() {
        return "Network";
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.serverPort = new JTextField();
        this.userName = new JTextField();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        this.serverPanel = new JPanel();
        this.serverPanel.setLayout(new BoxLayout(this.serverPanel, 1));
        this.serverPanel.setBorder(new TitledBorder("Server"));
        JLabel jLabel = new JLabel();
        jLabel.setText("Port");
        this.serverPort.setPreferredSize(new Dimension(35, 21));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0));
        jPanel3.add(jLabel);
        jPanel3.add(this.serverPort);
        this.serverPanel.add(jPanel3);
        jPanel2.add(this.serverPanel);
        this.clientPanel = new JPanel();
        this.clientPanel.setLayout(new BoxLayout(this.clientPanel, 1));
        this.clientPanel.setBorder(new TitledBorder("Client"));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("User Name");
        this.userName.setPreferredSize(new Dimension(100, 21));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(0));
        jPanel4.add(jLabel2);
        jPanel4.add(this.userName);
        this.clientPanel.add(jPanel4);
        jPanel2.add(this.clientPanel);
        jPanel.add((Component)jPanel2, "North");
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(jPanel);
        this.add(jScrollPane, "Center");
    }
}

