/*
 * Decompiled with CFR 0.152.
 */
package plugin.network;

import gmgen.GMGenSystemView;
import gmgen.gui.PreferencesPanel;
import gmgen.pluginmgr.GMBComponent;
import gmgen.pluginmgr.GMBMessage;
import gmgen.pluginmgr.GMBPlugin;
import gmgen.pluginmgr.GMBus;
import gmgen.pluginmgr.messages.CombatRequestMessage;
import gmgen.pluginmgr.messages.CombatantUpdatedMessage;
import gmgen.pluginmgr.messages.PreferencesPanelAddMessage;
import gmgen.pluginmgr.messages.StateChangedMessage;
import gmgen.pluginmgr.messages.TabAddMessage;
import gmgen.pluginmgr.messages.ToolMenuItemAddMessage;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.filechooser.FileFilter;
import pcgen.core.SettingsHandler;
import pcgen.gui.utils.TabbedPaneUtilities;
import plugin.network.NetworkModel;
import plugin.network.gui.NetworkView;
import plugin.network.gui.PreferencesNetworkingPanel;

public class NetworkPlugin
extends GMBPlugin {
    public static final String LOG_NAME = "Network";
    private String name = "Network";
    private String version = "01.00.99.01.00";
    private NetworkModel model;
    private JMenuItem netToolsItem = new JMenuItem();

    public FileFilter[] getFileTypes() {
        return null;
    }

    public void start() {
        this.model = new NetworkModel();
        GMBus.send((GMBMessage)new TabAddMessage((GMBComponent)this, this.name, (Component)this.model.getView(), this.getPluginSystem()));
        this.initMenus();
        GMBus.send((GMBMessage)new PreferencesPanelAddMessage((GMBComponent)this, this.name, (PreferencesPanel)new PreferencesNetworkingPanel(this.model)));
    }

    public String getPluginSystem() {
        return SettingsHandler.getGMGenOption((String)"Network.System", (String)"GMGen");
    }

    public int getPluginLoadOrder() {
        return SettingsHandler.getGMGenOption((String)"Network.LoadOrder", (int)60);
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public void handleMessage(GMBMessage gMBMessage) {
        if (gMBMessage instanceof CombatRequestMessage) {
            this.handleCombatRequestMessage((CombatRequestMessage)gMBMessage);
        } else if (gMBMessage instanceof StateChangedMessage) {
            this.handleStateChangedMessage((StateChangedMessage)gMBMessage);
        } else if (gMBMessage instanceof CombatantUpdatedMessage) {
            this.handleCombatantUpdatedMessage((CombatantUpdatedMessage)gMBMessage);
        }
    }

    private void handleStateChangedMessage(StateChangedMessage stateChangedMessage) {
        if (this.isActive()) {
            this.netToolsItem.setEnabled(false);
            if (this.model.getCombat() == null) {
                GMBus.send((GMBMessage)new CombatRequestMessage((GMBComponent)this));
            }
            try {
                GMGenSystemView.getTabPane().setIconAt(GMGenSystemView.getTabPane().indexOfTab(this.name), null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.model.clearIcon();
            this.model.refresh();
        } else {
            this.netToolsItem.setEnabled(true);
        }
    }

    private void handleCombatRequestMessage(CombatRequestMessage combatRequestMessage) {
        if (combatRequestMessage.getSource() == this) {
            this.model.setCombat(combatRequestMessage.getCombat());
        }
        this.model.refresh();
    }

    private void handleCombatantUpdatedMessage(CombatantUpdatedMessage combatantUpdatedMessage) {
        this.model.combatantUpdated(combatantUpdatedMessage.getCombatant());
    }

    public boolean isActive() {
        JTabbedPane jTabbedPane = TabbedPaneUtilities.getTabbedPaneFor((Component)this.model.getView());
        return jTabbedPane != null && JOptionPane.getFrameForComponent(jTabbedPane).isFocused() && jTabbedPane.getSelectedComponent().equals(this.model.getView());
    }

    public void toolMenuItem(ActionEvent actionEvent) {
        JTabbedPane jTabbedPane = GMGenSystemView.getTabPane();
        for (int i = 0; i < jTabbedPane.getTabCount(); ++i) {
            if (!(jTabbedPane.getComponentAt(i) instanceof NetworkView)) continue;
            jTabbedPane.setSelectedIndex(i);
        }
    }

    private void initMenus() {
        this.netToolsItem.setMnemonic('N');
        this.netToolsItem.setText(LOG_NAME);
        this.netToolsItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NetworkPlugin.this.toolMenuItem(actionEvent);
            }
        });
        GMBus.send((GMBMessage)new ToolMenuItemAddMessage((GMBComponent)this, this.netToolsItem));
    }
}

