/*
 * Decompiled with CFR 0.152.
 */
package plugin.network;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.util.StringTokenizer;
import pcgen.core.SettingsHandler;
import pcgen.util.Logging;
import plugin.network.NetworkModel;

public class NetworkClient {
    private String user = "Client";
    private NetworkModel model;
    private Socket sock;
    private BufferedReader is;
    private PrintStream os;

    public NetworkClient(NetworkModel networkModel) {
        this.model = networkModel;
        this.user = SettingsHandler.getGMGenOption((String)"Network.username", (String)"Player");
    }

    public void startClient() {
        String string = this.model.getView().getServerAddressTextField().getText();
        int n = SettingsHandler.getGMGenOption((String)"Network.port", (int)80);
        this.model.getView().setConnectionText("Client Status", "Attempting to connect to " + string + ":" + n);
        try {
            this.sock = new Socket(string, n);
            this.is = new BufferedReader(new InputStreamReader(this.sock.getInputStream(), "UTF-8"));
            this.os = new PrintStream((OutputStream)new BufferedOutputStream(this.sock.getOutputStream()), true, "UTF-8");
            new Handler(this.is).start();
            this.sendUserMessage(this.user);
            this.model.getView().setConnectionText("Client Status", "Connected to " + string + ":" + n);
            SettingsHandler.setGMGenOption((String)"Network.ipAddress", (String)string);
            this.model.refresh();
        }
        catch (Exception exception) {
            this.model.getView().setConnectionText("Server Error", exception.getMessage());
            this.model.resetClient();
        }
    }

    public String getUser() {
        return this.user;
    }

    public void sendIM(String string, String string2) {
        this.sendMessage("IM", string + "|" + string2);
    }

    public void sendBroadcast(String string) {
        this.sendMessage("Broadcast", string);
    }

    public void sendUserMessage(String string) {
        this.sendMessage("User", string);
    }

    public void sendLogMessage(String string, String string2) {
        this.sendMessage("Log", string + "|" + string2);
    }

    public void sendExitMessage() {
        this.sendMessage("Exit", "");
    }

    public void sendPcgMessage(String string, String string2) {
        this.sendMessage("Pcg", string + ":" + string2);
    }

    private synchronized void sendMessage(String string, String string2) {
        this.os.print(string + ": " + string2 + "\r\n");
        this.os.flush();
    }

    private void handleRemoveUserMessage(String string) {
        this.model.removeUser(string);
    }

    private void handleAddUserMessage(String string) {
        if (!string.equals(this.user)) {
            this.model.addUser(string);
        }
    }

    private void handlePcgMessage(String string, Socket socket) {
        int n = string.indexOf(":");
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        this.model.handleServerPcgMessage(string2, string3, socket);
    }

    private void handleLogMessage(String string, String string2) {
        String string3 = "";
        String string4 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
        if (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            string4 = stringTokenizer.nextToken();
        }
        this.model.log(string, string3, string4);
    }

    private void handleIMMessage(String string) {
        String string2 = "";
        String string3 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
        }
        this.model.log(string2, string3);
    }

    private void handleBroadcastMessage(String string) {
        String string2 = "";
        String string3 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
        }
        this.model.log(string2, "BROADCAST", string3);
    }

    private String handleMessage(String string, Socket socket) {
        String string2 = "";
        if (string.startsWith("Pcg:")) {
            this.handlePcgMessage(string.substring(5), socket);
        } else if (string.startsWith("RemoveUser:")) {
            this.handleRemoveUserMessage(string.substring(12));
        } else if (string.startsWith("AddUser:")) {
            this.handleAddUserMessage(string.substring(9));
        } else if (string.startsWith("Log:")) {
            this.handleLogMessage("Server", string.substring(5));
        } else if (string.startsWith("IM:")) {
            this.handleIMMessage(string.substring(4));
        } else if (string.startsWith("Broadcast:")) {
            this.handleBroadcastMessage(string.substring(11));
        } else if (string.startsWith("Exit:")) {
            this.sendExitMessage();
        } else {
            string2 = "Return: " + string;
        }
        return string2;
    }

    protected class Handler
    extends Thread {
        BufferedReader inputStream;

        public Handler(BufferedReader bufferedReader) {
            this.inputStream = bufferedReader;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                String string;
                while ((string = this.inputStream.readLine()) != null) {
                    String string2 = "";
                    Logging.debugPrint((String)("Network message from Server: " + string));
                    try {
                        string2 = NetworkClient.this.handleMessage(string, NetworkClient.this.sock);
                        if (string2.equals("")) continue;
                        NetworkClient.this.os.print(string2 + "\r\n");
                        NetworkClient.this.os.flush();
                    }
                    catch (Exception exception) {
                        if (!exception.getMessage().equals("")) {
                            NetworkClient.this.os.print("Error: " + exception.getMessage());
                            NetworkClient.this.os.flush();
                        }
                        break;
                    }
                }
            }
            catch (Exception exception) {
                return;
            }
            NetworkClient.this.model.resetClient();
        }
    }
}

