/*
 * Decompiled with CFR 0.152.
 */
package plugin.charactersheet.gui;

import gmgen.gui.GridBoxLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.LineBorder;
import plugin.charactersheet.gui.CharacterPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DualListPane
extends JPanel {
    private Map<String, String> map = new HashMap<String, String>();
    private JPanel jPanel1;
    private JPanel listPane;
    private JLabel title;

    public DualListPane() {
        this.initComponents();
        this.setLocalColor();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.title = new JLabel();
        this.listPane = new JPanel();
        this.setLayout(new BoxLayout(this, 1));
        this.jPanel1.setLayout(new FlowLayout(1, 1, 0));
        this.title.setFont(new Font("Dialog", 1, 14));
        this.title.setText(" ");
        this.jPanel1.add(this.title);
        this.add(this.jPanel1);
        this.listPane.setLayout((LayoutManager)new GridBoxLayout(0, 1));
        this.add(this.listPane);
    }

    public void setColor() {
        this.setLocalColor();
        this.refresh();
    }

    public void setLocalColor() {
        this.setBackground(CharacterPanel.white);
        this.jPanel1.setBackground(CharacterPanel.header);
        this.jPanel1.setBorder(new LineBorder(CharacterPanel.border));
        this.listPane.setBackground(CharacterPanel.white);
        this.listPane.setBorder(new LineBorder(CharacterPanel.border));
    }

    public void setMap(String string, Map<String, String> map) {
        this.map = map;
        this.title.setText(string);
        this.setVisible(false);
        this.refresh();
    }

    public void refresh() {
        if (this.map.size() > 0) {
            this.setVisible(true);
            this.listPane.removeAll();
            int n = 0;
            for (Map.Entry<String, String> entry : this.map.entrySet()) {
                Color color = n % 2 == 0 ? CharacterPanel.bodyLight : CharacterPanel.bodyMedLight;
                this.addLine(entry.getKey(), entry.getValue(), color);
                ++n;
            }
        } else {
            this.setVisible(false);
        }
    }

    private void addLine(String string, String string2, Color color) {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setBackground(color);
        jTextArea.setFont(new Font("Dialog", 1, 11));
        jTextArea.setText(string);
        this.listPane.add(jTextArea);
        if (!string2.equals("")) {
            JTextArea jTextArea2 = new JTextArea();
            jTextArea2.setLineWrap(true);
            jTextArea2.setWrapStyleWord(true);
            jTextArea2.setBackground(color);
            jTextArea2.setFont(new Font("Dialog", 0, 10));
            jTextArea2.setText(string2);
            this.listPane.add(jTextArea2);
        }
    }

    public void destruct() {
    }
}

