/*
 * Decompiled with CFR 0.152.
 */
package plugin.charactersheet.gui;

import gmgen.gui.ScrollablePanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pcgen.cdom.enumeration.AssociationListKey;
import pcgen.core.Globals;
import pcgen.core.NoteItem;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.gui.panes.FlippingSplitPane;
import plugin.charactersheet.gui.ClassSpellLevelPane;
import plugin.charactersheet.gui.NotesPanel;
import plugin.charactersheet.gui.Page1Panel;
import plugin.charactersheet.gui.Page2Panel;
import plugin.charactersheet.gui.SelectPanel;
import plugin.charactersheet.gui.SpellPage;

public class CharacterPanel
extends FlippingSplitPane {
    private PlayerCharacter pc;
    private Page1Panel page1;
    private Page2Panel page2;
    private ScrollablePanel page1layout;
    private ScrollablePanel page2layout;
    private List<SpellPage> spellPaneList;
    private NotesPanel notesPanel;
    private SelectPanel selectPanel;
    private FlippingSplitPane rightSidePane;
    private Properties pcProperties;
    private int serial = 0;
    private boolean readyForRefresh = false;
    private boolean systemRefresh = true;
    public static final int BLUE = 0;
    public static final int LIGHTBLUE = 1;
    public static final int GREEN = 2;
    public static final int LIGHTGREEN = 3;
    public static final int RED = 4;
    public static final int LIGHTRED = 5;
    public static final int YELLOW = 6;
    public static final int LIGHTYELLOW = 7;
    public static final int GREY = 8;
    public static final int LIGHTGREY = 9;
    private JTabbedPane mainTabs;
    public static Color black = new Color(0, 0, 0);
    public static Color darkGrey = new Color(102, 102, 102);
    public static Color lightGrey = new Color(204, 204, 204);
    public static Color white = new Color(255, 255, 255);
    public static Color border = new Color(85, 85, 136);
    public static Color header = new Color(153, 153, 187);
    public static Color bodyDark = new Color(170, 170, 204);
    public static Color bodyMedDark = new Color(187, 187, 238);
    public static Color bodyMedLight = new Color(204, 204, 238);
    public static Color bodyLight = new Color(238, 238, 255);

    public CharacterPanel() {
        this.initComponents();
        this.initPrefs();
        this.setLocalColor();
    }

    public JComponent getView() {
        return this;
    }

    private void initComponents() {
        this.mainTabs = new JTabbedPane();
        this.setOneTouchExpandable(true);
        this.mainTabs.setTabPlacement(2);
        this.mainTabs.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                CharacterPanel.this.mainTabsStateChanged();
            }
        });
        this.setLeftComponent(this.mainTabs);
        this.rightSidePane = new FlippingSplitPane(0);
        this.setRightComponent((Component)this.rightSidePane);
        this.setResizeWeight(0.1);
    }

    private void mainTabsStateChanged() {
        this.refresh();
    }

    private void initPrefs() {
        this.setDividerLocation(SettingsHandler.getGMGenOption((String)"CharacterSheet.DividerLocation", (int)2000));
    }

    public void flushPrefs() {
        SettingsHandler.setGMGenOption((String)"CharacterSheet.DividerLocation", (int)this.getDividerLocation());
        if (this.notesPanel != null) {
            this.notesPanel.flushPrefs();
        }
    }

    public void setPc(PlayerCharacter playerCharacter) {
        if (this.pc != playerCharacter) {
            this.pc = playerCharacter;
            this.serial = 0;
            this.generateTabs(true);
            this.readyForRefresh = true;
            this.refresh();
        }
    }

    public synchronized void generateTabs(boolean bl) {
        Object object;
        if (bl) {
            this.mainTabs.removeAll();
            if (this.page1 == null) {
                this.page1 = new Page1Panel();
                this.page1layout = new ScrollablePanel(20);
            }
            if (this.page2 == null) {
                this.page2 = new Page2Panel();
                this.page2layout = new ScrollablePanel(20);
            }
            if (this.rightSidePane == null) {
                this.rightSidePane = new FlippingSplitPane(0);
            }
            if (this.notesPanel == null) {
                this.notesPanel = new NotesPanel();
            }
            if (this.selectPanel == null) {
                this.selectPanel = new SelectPanel(this);
            }
            if (this.spellPaneList != null) {
                for (SpellPage spellPage : this.spellPaneList) {
                    spellPage.destruct();
                }
                this.spellPaneList.clear();
            } else {
                this.spellPaneList = new ArrayList<SpellPage>();
            }
            this.pcProperties = new Properties();
            Globals.setCurrentPC((PlayerCharacter)this.pc);
            this.populatePcProperties();
            this.notesPanel.setPc(this.pc, this.pcProperties);
            try {
                this.selectPanel.setPc(this.pc);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setRightComponent((Component)this.rightSidePane);
            this.rightSidePane.setTopComponent((Component)((Object)this.notesPanel));
            this.rightSidePane.setBottomComponent((Component)this.selectPanel);
            this.page1.setPc(this.pc, this.pcProperties);
            this.page1layout.setLayout((LayoutManager)new FlowLayout(0, 5, 5));
            this.page1layout.add((Component)this.page1);
            this.mainTabs.add("Page 1", new JScrollPane((Component)this.page1layout));
            ((JScrollPane)this.mainTabs.getSelectedComponent()).getViewport().setViewPosition(new Point(0, 0));
            this.page2.setPc(this.pc, this.pcProperties);
            this.page2layout.setLayout((LayoutManager)new FlowLayout(0, 5, 5));
            this.page2layout.add((Component)this.page2);
            this.mainTabs.add("Page 2", new JScrollPane((Component)this.page2layout));
        }
        List list = this.pc.getSpellClassList();
        for (int i = 0; i < list.size(); ++i) {
            object = list.get(i);
            if (!(object instanceof PCClass)) continue;
            PCClass pCClass = (PCClass)object;
            String string = pCClass.getDisplayClassName();
            int n = pCClass.getHighestLevelSpell(this.pc);
            for (int j = 0; j <= n; ++j) {
                pCClass.getCastForLevel(j, Globals.getDefaultSpellBook(), this.pc);
                pCClass.getKnownForLevel(j, this.pc);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(string).append(' ').append(j);
                String string2 = stringBuffer.toString();
                int n2 = this.pc.getCharacterSpells((PObject)pCClass, null, Globals.getDefaultSpellBook(), j).size();
                if (this.mainTabs.indexOfTab(string2) == -1) {
                    if (n2 <= 0) continue;
                    SpellPage spellPage = new SpellPage(20);
                    spellPage.setPc(this.pc, this.pcProperties, pCClass, j);
                    this.mainTabs.add(string2, new JScrollPane((Component)((Object)spellPage)));
                    this.spellPaneList.add(spellPage);
                    spellPage.refresh();
                    continue;
                }
                if (n2 != 0) continue;
                this.mainTabs.remove(this.mainTabs.indexOfTab(string2));
            }
        }
        String string = this.pc.getRace().getDisplayName();
        if (this.pc.hasAssocs((Object)this.pc.getRace(), AssociationListKey.CHARACTER_SPELLS) && this.mainTabs.indexOfTab(string) == -1) {
            object = new SpellPage(20);
            ((SpellPage)((Object)object)).setPc(this.pc, this.pcProperties);
            this.mainTabs.add(string, new JScrollPane((Component)object));
            this.spellPaneList.add((SpellPage)((Object)object));
            ((SpellPage)((Object)object)).refresh();
        }
    }

    public void setSystemRefresh(boolean bl) {
        this.systemRefresh = bl;
    }

    public void refresh() {
        this.flushPrefs();
        if (this.readyForRefresh) {
            new Refresher().start();
        }
    }

    public void forceRefresh() {
        new Refresher().start();
    }

    public PlayerCharacter getPc() {
        return this.pc;
    }

    private void populatePcProperties() {
        for (NoteItem noteItem : this.pc.getNotesList()) {
            if (!noteItem.getName().equals("Hidden")) continue;
            try {
                this.pcProperties.load(new ByteArrayInputStream(noteItem.getValue().getBytes()));
            }
            catch (IOException iOException) {
                System.out.println("The impossible happened");
            }
            return;
        }
    }

    public void updateProperties() {
        if (this.page1 != null) {
            this.page1.updateProperties();
            this.page2.updateProperties();
            for (SpellPage spellPage : this.spellPaneList) {
                spellPage.updateProperties();
            }
            this.notesPanel.updateProperties();
        }
    }

    public void save() {
        this.updateProperties();
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.pcProperties.store(byteArrayOutputStream, "Character Sheet Plugin Properties");
            NoteItem noteItem = null;
            int n = 0;
            for (NoteItem noteItem2 : this.pc.getNotesList()) {
                if (noteItem2.getId() > n) {
                    n = noteItem2.getId();
                }
                if (!noteItem2.getName().equals("Hidden")) continue;
                noteItem = noteItem2;
            }
            if (noteItem != null) {
                noteItem.setValue(byteArrayOutputStream.toString());
            } else {
                noteItem = new NoteItem(++n, -1, "Hidden", byteArrayOutputStream.toString());
                this.pc.addNotesItem(noteItem);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setColor() {
        this.setLocalColor();
        if (this.page1 != null) {
            this.page1.setColor();
            this.page2.setColor();
            for (SpellPage spellPage : this.spellPaneList) {
                spellPage.setColor();
            }
        }
    }

    public void setLocalColor() {
        if (this.page1layout != null) {
            this.page1layout.setBackground(white);
            this.page2layout.setBackground(white);
        }
    }

    public static void setColorBlue() {
        black = new Color(0, 0, 0);
        darkGrey = new Color(102, 102, 102);
        lightGrey = new Color(204, 204, 204);
        white = new Color(255, 255, 255);
        border = new Color(85, 85, 136);
        header = new Color(153, 153, 187);
        bodyDark = new Color(170, 170, 204);
        bodyMedDark = new Color(187, 187, 238);
        bodyMedLight = new Color(204, 204, 238);
        bodyLight = new Color(238, 238, 255);
    }

    public static void setColorLightBlue() {
        black = new Color(0, 0, 0);
        darkGrey = new Color(102, 102, 102);
        lightGrey = new Color(204, 204, 204);
        white = new Color(255, 255, 255);
        border = new Color(85, 85, 136);
        header = new Color(187, 187, 238);
        bodyDark = new Color(187, 187, 238);
        bodyMedDark = new Color(204, 204, 255);
        bodyMedLight = new Color(238, 238, 255);
        bodyLight = new Color(255, 255, 255);
    }

    public static void setColorGreen() {
        black = new Color(0, 0, 0);
        darkGrey = new Color(102, 102, 102);
        lightGrey = new Color(204, 204, 204);
        white = new Color(255, 255, 255);
        border = new Color(85, 136, 85);
        header = new Color(153, 187, 153);
        bodyDark = new Color(170, 204, 170);
        bodyMedDark = new Color(187, 238, 187);
        bodyMedLight = new Color(204, 238, 204);
        bodyLight = new Color(238, 255, 238);
    }

    public static void setColorLightGreen() {
        black = new Color(0, 0, 0);
        darkGrey = new Color(102, 102, 102);
        lightGrey = new Color(204, 204, 204);
        white = new Color(255, 255, 255);
        border = new Color(0, 136, 0);
        header = new Color(68, 204, 68);
        bodyDark = new Color(68, 204, 68);
        bodyMedDark = new Color(204, 255, 204);
        bodyMedLight = new Color(238, 255, 238);
        bodyLight = new Color(255, 255, 255);
    }

    public static void setColorRed() {
        black = new Color(0, 0, 0);
        darkGrey = new Color(102, 102, 102);
        lightGrey = new Color(204, 204, 204);
        white = new Color(255, 255, 255);
        border = new Color(163, 85, 85);
        header = new Color(187, 153, 153);
        bodyDark = new Color(204, 170, 170);
        bodyMedDark = new Color(238, 187, 187);
        bodyMedLight = new Color(238, 204, 204);
        bodyLight = new Color(255, 238, 238);
    }

    public static void setColorLightRed() {
        black = new Color(0, 0, 0);
        darkGrey = new Color(102, 102, 102);
        lightGrey = new Color(204, 204, 204);
        white = new Color(255, 255, 255);
        border = new Color(163, 0, 0);
        header = new Color(204, 0, 0);
        bodyDark = new Color(204, 0, 0);
        bodyMedDark = new Color(255, 204, 204);
        bodyMedLight = new Color(255, 238, 238);
        bodyLight = new Color(255, 255, 255);
    }

    public static void setColorYellow() {
        black = new Color(0, 0, 0);
        darkGrey = new Color(102, 102, 102);
        lightGrey = new Color(204, 204, 204);
        white = new Color(255, 255, 255);
        border = new Color(136, 136, 85);
        header = new Color(187, 187, 153);
        bodyDark = new Color(204, 204, 170);
        bodyMedDark = new Color(221, 221, 187);
        bodyMedLight = new Color(238, 238, 204);
        bodyLight = new Color(255, 255, 221);
    }

    public static void setColorLightYellow() {
        black = new Color(0, 0, 0);
        darkGrey = new Color(102, 102, 102);
        lightGrey = new Color(204, 204, 204);
        white = new Color(255, 255, 255);
        border = new Color(136, 136, 85);
        header = new Color(238, 238, 187);
        bodyDark = new Color(238, 238, 187);
        bodyMedDark = new Color(255, 255, 204);
        bodyMedLight = new Color(255, 255, 238);
        bodyLight = new Color(255, 255, 255);
    }

    public static void setColorGrey() {
        black = new Color(0, 0, 0);
        darkGrey = new Color(102, 102, 102);
        lightGrey = new Color(204, 204, 204);
        white = new Color(255, 255, 255);
        border = new Color(0, 0, 0);
        header = new Color(153, 153, 153);
        bodyDark = new Color(204, 204, 204);
        bodyMedDark = new Color(204, 204, 204);
        bodyMedLight = new Color(204, 204, 204);
        bodyLight = new Color(255, 255, 255);
    }

    public static void setColorLightGrey() {
        black = new Color(0, 0, 0);
        darkGrey = new Color(102, 102, 102);
        lightGrey = new Color(204, 204, 204);
        white = new Color(255, 255, 255);
        border = new Color(0, 0, 0);
        header = new Color(255, 255, 255);
        bodyDark = new Color(255, 255, 255);
        bodyMedDark = new Color(204, 204, 204);
        bodyMedLight = new Color(204, 204, 204);
        bodyLight = new Color(255, 255, 255);
    }

    private class Refresher
    extends Thread {
        private Refresher() {
        }

        public void run() {
            this.refresh();
        }

        private void refresh() {
            if (CharacterPanel.this.systemRefresh) {
                Globals.setCurrentPC((PlayerCharacter)CharacterPanel.this.pc);
                CharacterPanel.this.updateProperties();
                CharacterPanel.this.pc.preparePCForOutput();
                if (CharacterPanel.this.mainTabs.getTabCount() > 0 && CharacterPanel.this.mainTabs.getSelectedIndex() > -1) {
                    String string = CharacterPanel.this.mainTabs.getTitleAt(CharacterPanel.this.mainTabs.getSelectedIndex());
                    JViewport jViewport = ((JScrollPane)CharacterPanel.this.mainTabs.getSelectedComponent()).getViewport();
                    ScrollablePanel scrollablePanel = (ScrollablePanel)jViewport.getView();
                    Component component = scrollablePanel.getComponent(0);
                    jViewport.setViewPosition(new Point(0, 0));
                    if (string.equals("Page 1")) {
                        CharacterPanel.this.page1.refresh();
                    } else if (string.equals("Page 2")) {
                        CharacterPanel.this.page2.refresh();
                    } else if (component instanceof ClassSpellLevelPane) {
                        ClassSpellLevelPane classSpellLevelPane = (ClassSpellLevelPane)component;
                        classSpellLevelPane.refresh();
                    }
                }
                if (CharacterPanel.this.serial < CharacterPanel.this.pc.getSerial()) {
                    CharacterPanel.this.generateTabs(false);
                    CharacterPanel.this.page1.refresh();
                    CharacterPanel.this.notesPanel.refresh();
                    CharacterPanel.this.selectPanel.refresh();
                    CharacterPanel.this.serial = CharacterPanel.this.pc.getSerial();
                }
            }
            CharacterPanel.this.initPrefs();
            CharacterPanel.this.mainTabs.repaint();
        }
    }
}

