/*
 * Decompiled with CFR 0.152.
 */
package plugin.charactersheet;

import gmgen.GMGenSystemView;
import gmgen.gui.PreferencesPanel;
import gmgen.pluginmgr.GMBComponent;
import gmgen.pluginmgr.GMBMessage;
import gmgen.pluginmgr.GMBPlugin;
import gmgen.pluginmgr.GMBus;
import gmgen.pluginmgr.messages.PCClosedMessage;
import gmgen.pluginmgr.messages.PCLoadedMessage;
import gmgen.pluginmgr.messages.PauseRefreshMessage;
import gmgen.pluginmgr.messages.PreferencesPanelAddMessage;
import gmgen.pluginmgr.messages.ResumeRefreshMessage;
import gmgen.pluginmgr.messages.SavePCGNotificationMessage;
import gmgen.pluginmgr.messages.StateChangedMessage;
import gmgen.pluginmgr.messages.TabAddMessage;
import gmgen.pluginmgr.messages.ToolMenuItemAddMessage;
import gmgen.pluginmgr.messages.WindowClosedMessage;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.filechooser.FileFilter;
import pcgen.core.SettingsHandler;
import pcgen.gui.utils.TabbedPaneUtilities;
import plugin.charactersheet.CharacterSheetModel;
import plugin.charactersheet.gui.PreferencesDisplayPanel;

public class CharacterSheetPlugin
extends GMBPlugin {
    public static final String LOG_NAME = "CharacterSheet";
    private JMenuItem csToolsItem = new JMenuItem();
    private String name = "Character Sheet";
    private String version = "00.00.00.01";
    private CharacterSheetModel model;

    public void start() {
        this.model = new CharacterSheetModel();
        GMBus.send((GMBMessage)new PreferencesPanelAddMessage((GMBComponent)this, this.name, (PreferencesPanel)new PreferencesDisplayPanel(this.model)));
        if (this.getPluginSystem().equals("PCGen")) {
            GMBus.send((GMBMessage)new TabAddMessage((GMBComponent)this, this.name, this.model.getInfoPanel(), this.getPluginSystem()));
        } else {
            GMBus.send((GMBMessage)new TabAddMessage((GMBComponent)this, this.name, this.model.getComponent(), this.getPluginSystem()));
        }
        this.initMenus();
    }

    public FileFilter[] getFileTypes() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getPluginSystem() {
        return SettingsHandler.getGMGenOption((String)"CharacterSheet.System", (String)"GMGen");
    }

    public int getPluginLoadOrder() {
        return SettingsHandler.getGMGenOption((String)"CharacterSheet.LoadOrder", (int)10);
    }

    public void handleMessage(GMBMessage gMBMessage) {
        if (this.getPluginSystem().equals("GMGen")) {
            if (gMBMessage instanceof StateChangedMessage) {
                this.handleStateChangedMessage((StateChangedMessage)gMBMessage);
            } else if (gMBMessage instanceof PCLoadedMessage) {
                this.handlePCLoadedMessage((PCLoadedMessage)gMBMessage);
            } else if (gMBMessage instanceof PCClosedMessage) {
                this.handlePCClosedMessage((PCClosedMessage)gMBMessage);
            } else if (gMBMessage instanceof SavePCGNotificationMessage) {
                this.handleSavePCGNotificationMessage((SavePCGNotificationMessage)gMBMessage);
            } else if (gMBMessage instanceof WindowClosedMessage) {
                this.handleWindowClosedMessage((WindowClosedMessage)gMBMessage);
            }
        } else if (gMBMessage instanceof PauseRefreshMessage) {
            this.handlePauseRefreshMessage((PauseRefreshMessage)gMBMessage);
        } else if (gMBMessage instanceof ResumeRefreshMessage) {
            this.handleResumeRefreshMessage((ResumeRefreshMessage)gMBMessage);
        }
    }

    public void toolMenuItem(ActionEvent actionEvent) {
        JTabbedPane jTabbedPane = GMGenSystemView.getTabPane();
        for (int i = 0; i < jTabbedPane.getTabCount(); ++i) {
            if (!jTabbedPane.getComponentAt(i).equals(this.model.getComponent())) continue;
            jTabbedPane.setSelectedIndex(i);
        }
    }

    private void handleStateChangedMessage(StateChangedMessage stateChangedMessage) {
        if (this.isActive()) {
            this.csToolsItem.setEnabled(false);
            this.model.refresh();
        } else {
            this.csToolsItem.setEnabled(true);
        }
    }

    public void handlePCLoadedMessage(PCLoadedMessage pCLoadedMessage) {
        if (!pCLoadedMessage.isIgnored((GMBComponent)this)) {
            this.model.addPc(pCLoadedMessage.getPC());
        }
    }

    public void handlePCClosedMessage(PCClosedMessage pCClosedMessage) {
        this.model.removePc(pCClosedMessage.getPC());
    }

    public void handleSavePCGNotificationMessage(SavePCGNotificationMessage savePCGNotificationMessage) {
        this.model.savePc(savePCGNotificationMessage.getPC());
    }

    public void handleWindowClosedMessage(WindowClosedMessage windowClosedMessage) {
        this.model.closeWindow();
    }

    private void handlePauseRefreshMessage(PauseRefreshMessage pauseRefreshMessage) {
        this.model.setRefresh(false);
    }

    private void handleResumeRefreshMessage(ResumeRefreshMessage resumeRefreshMessage) {
        this.model.setRefresh(true);
    }

    public boolean isActive() {
        JTabbedPane jTabbedPane = TabbedPaneUtilities.getTabbedPaneFor((Component)this.model.getComponent());
        return jTabbedPane != null && JOptionPane.getFrameForComponent(jTabbedPane).isFocused() && jTabbedPane.getSelectedComponent().equals(this.model.getComponent());
    }

    public void initMenus() {
        this.csToolsItem.setMnemonic('S');
        this.csToolsItem.setText("Character Sheet");
        this.csToolsItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CharacterSheetPlugin.this.toolMenuItem(actionEvent);
            }
        });
        GMBus.send((GMBMessage)new ToolMenuItemAddMessage((GMBComponent)this, this.csToolsItem));
    }
}

