/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.equipment;

import java.util.logging.Level;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.inst.EquipmentHead;
import pcgen.core.Equipment;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AltcritrangeToken
implements CDOMPrimaryToken<Equipment> {
    public String getTokenName() {
        return "ALTCRITRANGE";
    }

    public boolean parse(LoadContext loadContext, Equipment equipment, String string) {
        try {
            Integer n = Integer.valueOf(string);
            if (n < 0) {
                Logging.log((Level)Logging.LST_ERROR, (String)(this.getTokenName() + " cannot be < 0"));
                return false;
            }
            loadContext.getObjectContext().put((CDOMObject)equipment.getEquipmentHead(2), IntegerKey.CRIT_RANGE, n);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            Logging.deprecationPrint((String)(this.getTokenName() + " expected " + "an integer.  " + "Tag should be of the form: " + this.getTokenName() + ":<int>"));
            Logging.deprecationPrint((String)"   ...Assuming Zero");
            loadContext.getObjectContext().put((CDOMObject)equipment.getEquipmentHead(2), IntegerKey.CRIT_RANGE, Integer.valueOf(0));
            return true;
        }
    }

    public String[] unparse(LoadContext loadContext, Equipment equipment) {
        EquipmentHead equipmentHead = equipment.getEquipmentHeadReference(2);
        if (equipmentHead == null) {
            return null;
        }
        Integer n = loadContext.getObjectContext().getInteger((CDOMObject)equipmentHead, IntegerKey.CRIT_RANGE);
        if (n == null) {
            return null;
        }
        return new String[]{n.toString()};
    }

    public Class<Equipment> getTokenClass() {
        return Equipment.class;
    }
}

