/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.pcclass;

import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.core.PCClass;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaxlevelToken
implements CDOMPrimaryToken<PCClass> {
    public String getTokenName() {
        return "MAXLEVEL";
    }

    public boolean parse(LoadContext loadContext, PCClass pCClass, String string) {
        Integer n;
        if ("NOLIMIT".equalsIgnoreCase(string)) {
            n = -1;
        } else {
            try {
                n = Integer.valueOf(string);
                if (n <= 0) {
                    Logging.errorPrint((String)("Value less than 1 is not valid for " + this.getTokenName() + ": " + string));
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                Logging.errorPrint((String)("Value was not a number for " + this.getTokenName() + ": " + string));
                return false;
            }
        }
        loadContext.getObjectContext().put((CDOMObject)pCClass, IntegerKey.LEVEL_LIMIT, n);
        return true;
    }

    public String[] unparse(LoadContext loadContext, PCClass pCClass) {
        Integer n = loadContext.getObjectContext().getInteger((CDOMObject)pCClass, IntegerKey.LEVEL_LIMIT);
        if (n == null) {
            return null;
        }
        String string = n.toString();
        if (n.equals(-1)) {
            string = "NOLIMIT";
        } else if (n <= 0) {
            loadContext.addWriteMessage(this.getTokenName() + " must be an integer > 0");
            return null;
        }
        return new String[]{string};
    }

    public Class<PCClass> getTokenClass() {
        return PCClass.class;
    }
}

