/*
 * Decompiled with CFR 0.152.
 */
package plugin.exporttokens;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pcgen.core.PlayerCharacter;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.Token;

public class TextToken
extends Token {
    public static final String TOKENNAME = "TEXT";

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String string, PlayerCharacter playerCharacter, ExportHandler exportHandler) {
        String string2 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        stringTokenizer.nextToken();
        String string3 = "";
        StringBuffer stringBuffer = new StringBuffer();
        if (stringTokenizer.hasMoreElements()) {
            string3 = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreElements()) {
            stringBuffer.append(stringTokenizer.nextToken());
        }
        while (stringTokenizer.hasMoreElements()) {
            stringBuffer.append(".").append(stringTokenizer.nextToken());
        }
        StringWriter stringWriter = new StringWriter();
        BufferedWriter bufferedWriter = new BufferedWriter(stringWriter);
        exportHandler.replaceToken(stringBuffer.toString(), bufferedWriter, playerCharacter);
        try {
            bufferedWriter.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        string2 = stringWriter.getBuffer().toString();
        if (string3.equalsIgnoreCase("UPPER") || string3.equalsIgnoreCase("UPPERCASE")) {
            string2 = string2.toUpperCase();
        } else if (string3.equalsIgnoreCase("LOWER") || string3.equalsIgnoreCase("LOWERCASE")) {
            string2 = string2.toLowerCase();
        } else if (string3.equalsIgnoreCase("SENTENCE") || string3.equalsIgnoreCase("SENTENCECASE")) {
            string2 = this.changeToSentenceCase(string2);
        } else if (string3.equalsIgnoreCase("TITLE") || string3.equalsIgnoreCase("TITLECASE")) {
            string2 = this.changeToTitleCase(string2);
        } else if (string3.equalsIgnoreCase("NUMSUFFIX")) {
            string2 = this.buildNumSuffix(string2);
        }
        return string2;
    }

    private String changeToSentenceCase(String string) {
        String string2 = string.toLowerCase();
        String[] stringArray = string2.split("\\.");
        StringBuffer stringBuffer = new StringBuffer(string.length());
        Pattern pattern = Pattern.compile("\\s*");
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(".");
            }
            if (stringArray[i].trim().length() > 0) {
                Matcher matcher = pattern.matcher(stringArray[i]);
                int n = 0;
                if (matcher.find()) {
                    n = matcher.end();
                }
                if (n > 0) {
                    stringBuffer.append(stringArray[i].substring(0, n));
                }
                stringBuffer.append(stringArray[i].substring(n, n + 1).toUpperCase());
                stringBuffer.append(stringArray[i].substring(n + 1));
                continue;
            }
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    private String changeToTitleCase(String string) {
        String string2 = string.toLowerCase();
        char[] cArray = string2.toCharArray();
        StringBuffer stringBuffer = new StringBuffer(string.length());
        boolean bl = true;
        for (int i = 0; i < cArray.length; ++i) {
            boolean bl2;
            char c = cArray[i];
            boolean bl3 = bl2 = c == ' ' || c == '\t' || c == '\n' || c == '\f' || c == '\r';
            if (bl && !bl2) {
                stringBuffer.append(Character.toUpperCase(c));
                bl = false;
                continue;
            }
            bl = bl2;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private String buildNumSuffix(String string) {
        String string2 = "";
        int n = 0;
        try {
            n = new BigDecimal(string).intValue();
        }
        catch (Exception exception) {
            return "";
        }
        string2 = n % 10 == 1 && n % 100 != 11 ? "st" : (n % 10 == 2 && n % 100 != 12 ? "nd" : (n % 10 == 3 && n % 100 != 13 ? "rd" : "th"));
        return string2;
    }

    public boolean isEncoded() {
        return false;
    }
}

