/*
 * Decompiled with CFR 0.152.
 */
package pcgen.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashMapToList<K, V> {
    private final Map<K, List<V>> mapToList = new HashMap<K, List<V>>();

    public void initializeListFor(K k) {
        if (k == null) {
            throw new NullPointerException("Key in MapToList cannot be null");
        }
        if (this.mapToList.containsKey(k)) {
            throw new IllegalArgumentException("Cannot re-initialize key: " + k);
        }
        this.mapToList.put(k, new ArrayList());
    }

    public void addToListFor(K k, V v) {
        if (!this.containsListFor(k)) {
            this.initializeListFor(k);
        }
        this.mapToList.get(k).add(v);
    }

    public void addAllToListFor(K k, List<V> list) {
        if (list == null) {
            return;
        }
        if (!this.containsListFor(k)) {
            this.initializeListFor(k);
        }
        this.mapToList.get(k).addAll(list);
    }

    public void addAllLists(HashMapToList<K, V> hashMapToList) {
        for (K k : hashMapToList.getKeySet()) {
            this.addAllToListFor(k, hashMapToList.mapToList.get(k));
        }
    }

    public boolean containsListFor(K k) {
        return this.mapToList.containsKey(k);
    }

    public boolean containsInList(K k, V v) {
        return this.containsListFor(k) && this.mapToList.get(k).contains(v);
    }

    public int sizeOfListFor(K k) {
        List<V> list = this.mapToList.get(k);
        if (list == null) {
            return 0;
        }
        return list.size();
    }

    public List<V> getListFor(K k) {
        List<V> list = this.mapToList.get(k);
        return list == null ? null : new ArrayList<V>(list);
    }

    public boolean removeFromListFor(K k, V v) {
        if (!this.containsListFor(k)) {
            return false;
        }
        return this.mapToList.get(k).remove(v);
    }

    public List<V> removeListFor(K k) {
        return this.mapToList.remove(k);
    }

    public boolean isEmpty() {
        return this.mapToList.isEmpty();
    }

    public int size() {
        return this.mapToList.size();
    }

    public Set<K> getKeySet() {
        return new HashSet<K>(this.mapToList.keySet());
    }

    public V getElementInList(K k, int n) {
        List<V> list = this.mapToList.get(k);
        return list == null ? null : (V)list.get(n);
    }
}

