/*
 * Decompiled with CFR 0.152.
 */
package pcgen.util;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.ParseException;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class DecimalNumberField
extends JTextField {
    private static final long serialVersionUID = 8756733358669554185L;
    private DecimalFormat doubleFormatter;
    private Toolkit toolkit = Toolkit.getDefaultToolkit();
    private boolean allowSign = false;
    private double lastVal;

    public DecimalNumberField(double d, int n) {
        super(n);
        this.doubleFormatter = new DecimalFormat();
        this.doubleFormatter.setParseIntegerOnly(false);
        this.setValue(d);
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    DecimalNumberField.this.lastVal = DecimalNumberField.this.doubleFormatter.parse(DecimalNumberField.this.getText()).floatValue();
                }
                catch (ParseException parseException) {
                    DecimalNumberField.this.setText(DecimalNumberField.this.doubleFormatter.format(DecimalNumberField.this.lastVal));
                    DecimalNumberField.this.toolkit.beep();
                }
            }
        });
    }

    public final void setValue(double d) {
        this.lastVal = d;
        this.setText(this.doubleFormatter.format(d));
    }

    public double getValue() {
        double d;
        try {
            this.lastVal = d = this.doubleFormatter.parse(this.getText()).doubleValue();
        }
        catch (ParseException parseException) {
            d = this.lastVal;
            this.setText(this.doubleFormatter.format(this.lastVal));
            this.toolkit.beep();
        }
        return d;
    }

    protected Document createDefaultModel() {
        return new DecimalNumberDocument();
    }

    private class DecimalNumberDocument
    extends PlainDocument {
        private DecimalNumberDocument() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            char[] cArray = string.toCharArray();
            char[] cArray2 = new char[cArray.length];
            int n2 = 0;
            String string2 = "";
            try {
                string2 = this.getText(0, this.getLength());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            boolean bl = string2.indexOf(46) >= 0;
            boolean bl2 = string2.indexOf(45) >= 0;
            for (int i = 0; i < cArray2.length; ++i) {
                char c = cArray[i];
                if (!DecimalNumberField.this.allowSign && c == '-') {
                    DecimalNumberField.this.toolkit.beep();
                    continue;
                }
                if (c == '-' && i + n == 0) {
                    if (!bl2) {
                        cArray2[n2++] = c;
                        continue;
                    }
                    DecimalNumberField.this.toolkit.beep();
                    continue;
                }
                if (bl2 && i + n == 0) {
                    DecimalNumberField.this.toolkit.beep();
                    continue;
                }
                if (c == '.' && !bl) {
                    bl = true;
                    cArray2[n2++] = c;
                    continue;
                }
                if (Character.isDigit(c)) {
                    cArray2[n2++] = c;
                    continue;
                }
                DecimalNumberField.this.toolkit.beep();
            }
            super.insertString(n, new String(cArray2, 0, n2), attributeSet);
        }
    }
}

