/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst.output.prereq;

import java.io.StringWriter;
import java.io.Writer;
import pcgen.core.PObject;
import pcgen.core.prereq.Prerequisite;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.output.prereq.PrerequisiteWriterFactory;
import pcgen.persistence.lst.output.prereq.PrerequisiteWriterInterface;

public class PrerequisiteWriter {
    public void write(Writer writer, Prerequisite prerequisite) throws PersistenceLayerException {
        PrerequisiteWriterFactory prerequisiteWriterFactory = PrerequisiteWriterFactory.getInstance();
        PrerequisiteWriterInterface prerequisiteWriterInterface = prerequisiteWriterFactory.getWriter(prerequisite.getKind());
        if (prerequisiteWriterInterface == null) {
            throw new PersistenceLayerException("Can not find a Writer for prerequisites fo kind: " + prerequisite.getKind());
        }
        prerequisiteWriterInterface.write(writer, prerequisite);
    }

    public static String prereqsToString(PObject pObject) {
        if (pObject.hasPreReqs()) {
            PrerequisiteWriter prerequisiteWriter = new PrerequisiteWriter();
            StringWriter stringWriter = new StringWriter();
            for (Prerequisite prerequisite : pObject.getPreReqList()) {
                try {
                    stringWriter.write(9);
                    prerequisiteWriter.write(stringWriter, prerequisite);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return stringWriter.toString();
        }
        return "";
    }
}

