/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.util.Map;
import java.util.StringTokenizer;
import pcgen.core.PObject;
import pcgen.core.SubClass;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.persistence.lst.LstToken;
import pcgen.persistence.lst.LstUtils;
import pcgen.persistence.lst.PCClassLoader;
import pcgen.persistence.lst.SubClassLstToken;
import pcgen.persistence.lst.TokenStore;
import pcgen.util.Logging;

public final class SubClassLoader {
    private static PCClassLoader classLoader = new PCClassLoader();

    private SubClassLoader() {
    }

    public static PObject parseLine(PObject pObject, String string, CampaignSourceEntry campaignSourceEntry) throws PersistenceLayerException {
        SubClass subClass = (SubClass)pObject;
        if (subClass == null) {
            return subClass;
        }
        if (!string.startsWith("SUBCLASS:")) {
            return subClass;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
        Map<String, LstToken> map = TokenStore.inst().getTokenMap(SubClassLstToken.class);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            int n = string2.indexOf(58);
            String string3 = "";
            try {
                string3 = string2.substring(0, n);
            }
            catch (Exception exception) {
                // empty catch block
            }
            SubClassLstToken subClassLstToken = (SubClassLstToken)map.get(string3);
            if (subClassLstToken != null) {
                String string4 = string2.substring(n + 1).trim();
                LstUtils.deprecationCheck(subClassLstToken, subClass, string4);
                if (subClassLstToken.parse(subClass, string4)) continue;
                Logging.errorPrint("Error parsing ability " + subClass.getDisplayName() + ':' + campaignSourceEntry.getURI() + ':' + string2 + "\"");
                continue;
            }
            classLoader.parseLine(subClass, string2, campaignSourceEntry);
        }
        return subClass;
    }
}

